/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.examquestion.service.imple;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exam.examquestion.model.ExamQuestionKnowledge;
import com.peak.app.exam.examquestion.model.ExamQuestionQb;
import com.peak.app.exam.examquestion.service.IExamQuestionKnowledgeService;
import com.peak.app.exam.examquestion.service.IExamQuestionQbService;
import com.peak.app.exam.examquestion.service.IExamQuestionService;
import com.peak.app.exam.examquestion.vo.ExamQuestionQuery;
import com.peak.app.exampro.examquestion.dao.IExamProQuestionDao;
import com.peak.app.exampro.examquestion.service.IExamProQuestionService;
import com.peak.framework.common.BaseService;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ExamProQuestionService
extends BaseService<ExamQuestion, Long, ExamQuestionQuery>
implements IExamProQuestionService {
    private IExamQuestionService examQuestionService;
    private IExamQuestionQbService examQuestionQbService;
    private IExamQuestionKnowledgeService examQuestionKnowledgeService;
    private IExamProQuestionDao examProQuestionDao;

    public void setExamProQuestionDao(IExamProQuestionDao examProQuestionDao) {
        this.examProQuestionDao = examProQuestionDao;
    }

    public void setExamQuestionService(IExamQuestionService examQuestionService) {
        this.examQuestionService = examQuestionService;
    }

    public void setExamQuestionQbService(IExamQuestionQbService examQuestionQbService) {
        this.examQuestionQbService = examQuestionQbService;
    }

    public void setExamQuestionKnowledgeService(IExamQuestionKnowledgeService examQuestionKnowledgeService) {
        this.examQuestionKnowledgeService = examQuestionKnowledgeService;
    }

    public IEntityDao<ExamQuestion, Long, ExamQuestionQuery> getEntityDao() {
        return null;
    }

    @Override
    public void txInsertQuestion(ExamQuestion q, Long[] qbankIds, Long[] knowledgeIds) throws Exception {
        int i;
        Date now = new Date();
        this.examQuestionService.insert(q);
        for (i = 0; qbankIds != null && i < qbankIds.length; ++i) {
            ExamQuestionQb qb = new ExamQuestionQb();
            qb.setQqbId(IPrimaryKey.DEFAULT.getSequence("EXAM_QUESTION_QB"));
            qb.setQuesBankId(qbankIds[i]);
            qb.setQuestionId(q.getQuestionId());
            qb.setCreateDate(now);
            this.examQuestionQbService.insert(qb);
        }
        for (i = 0; knowledgeIds != null && i < knowledgeIds.length; ++i) {
            ExamQuestionKnowledge k = new ExamQuestionKnowledge();
            k.setPkId(IPrimaryKey.DEFAULT.getSequence("EXAM_QUESTION_KNOWLEDGE"));
            k.setKnowledgeId(knowledgeIds[i]);
            k.setQuestionId(q.getQuestionId());
            this.examQuestionKnowledgeService.insert(k);
        }
    }

    @Override
    public int countSameQuestion(String content, Long qtypeId, List<Long> qbankIds) {
        return this.examProQuestionDao.countSameQuestion(content, qtypeId, qbankIds);
    }

    @Override
    public List<ExamQuestion> findAllByPaperId(Long paperId) {
        return this.examProQuestionDao.findAllByPaperId(paperId);
    }

    @Override
    public List<ExamQuestion> findChildrenByParentId(Long complexQuestionId) {
        return this.examProQuestionDao.findChildrenByParentId(complexQuestionId);
    }

    @Override
    public List<ExamQuestion> findRandomQuestions(ExamQuestionQuery query) {
        return this.examProQuestionDao.findRandomQuestions(query);
    }

    @Override
    public List<ExamQuestion> findDistinctKnowledges(ExamQuestionQuery query) {
        return this.examProQuestionDao.findDistinctKnowledges(query);
    }
}

