/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.util;

import com.peak.app.exam.examquestion.model.ExamQuestion;
import com.peak.app.exampro.exampaper.model.AbstractBaseQuestion;
import com.peak.app.exampro.exampaper.model.Choice;
import com.peak.app.exampro.exampaper.model.ComplexQuestion;
import com.peak.app.exampro.exampaper.model.FillQuestion;
import com.peak.app.exampro.exampaper.model.IndefiniteChoiceQuestion;
import com.peak.app.exampro.exampaper.model.MatchQuestion;
import com.peak.app.exampro.exampaper.model.MultipleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.RandomComp;
import com.peak.app.exampro.exampaper.model.SingleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.TextQuestion;
import com.peak.app.exampro.exampaper.model.YesNoQuestion;
import com.peak.app.exampro.util.QuestionConvert;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public abstract class BaseQuestionConvert {
    private static RandomComp randomComp = new RandomComp();

    public static AbstractBaseQuestion convert(ExamQuestion q) {
        return BaseQuestionConvert.convert(q, false);
    }

    public static AbstractBaseQuestion convert(ExamQuestion q, boolean withCorrectAnswer) {
        switch ((int)(q.getTypeId() % 100L)) {
            case 1: {
                return QuestionConvert.toSingleChoiceQuestion(q, false, withCorrectAnswer);
            }
            case 2: {
                return QuestionConvert.toMultipleChoiceQuestion(q, false, withCorrectAnswer);
            }
            case 10: {
                return QuestionConvert.toIndefiniteChoiceQuestion(q, false, withCorrectAnswer);
            }
            case 3: {
                return QuestionConvert.toYesNoQuestion(q, withCorrectAnswer);
            }
            case 4: {
                return QuestionConvert.toFillQuestion(q, withCorrectAnswer);
            }
            case 6: {
                return QuestionConvert.toMatchQuestion(q, withCorrectAnswer);
            }
            case 5: {
                return QuestionConvert.toTextQuestion(q, withCorrectAnswer);
            }
        }
        return null;
    }

    private static void setFields(AbstractBaseQuestion question, ExamQuestion q, boolean withCorrectAnswer) {
        question.setKnowledgeId(q.getKnowledgeId());
        question.setKnowledge(q.getKnowledge());
        if (withCorrectAnswer) {
            question.setCorrectAnswer(q.getAnswer());
        }
    }

    public static ComplexQuestion toComplexQuestion(ExamQuestion q) {
        ComplexQuestion complexq = new ComplexQuestion(q.getQuestionId(), q.getContent());
        BaseQuestionConvert.setFields(complexq, q, false);
        return complexq;
    }

    public static FillQuestion toFillQuestion(ExamQuestion q) {
        return BaseQuestionConvert.toFillQuestion(q, false);
    }

    public static FillQuestion toFillQuestion(ExamQuestion q, boolean withCorrectAnswer) {
        FillQuestion fill = new FillQuestion(q.getQuestionId(), q.getContent());
        fill.setScore(q.getScore());
        String fillAnswer = q.getAnswer() + "";
        fillAnswer = fillAnswer.replaceAll("\n", "").replaceAll("\r", "");
        int blankNum = JSONArray.fromObject((Object)fillAnswer).size();
        fill.setBlanks(new String[blankNum]);
        fill.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(fill, q, withCorrectAnswer);
        return fill;
    }

    public static MatchQuestion toMatchQuestion(ExamQuestion q) {
        return BaseQuestionConvert.toMatchQuestion(q, false);
    }

    public static MatchQuestion toMatchQuestion(ExamQuestion q, boolean withCorrectAnswer) {
        MatchQuestion matchq = new MatchQuestion(q.getQuestionId(), q.getContent());
        matchq.setScore(q.getScore());
        matchq.setChoiceABCs(new ArrayList<Choice>());
        matchq.setChoice123s(new ArrayList<Choice>());
        String options = q.getOptions();
        if (options != null && options.length() > 0) {
            Choice c;
            JSONObject jObj;
            int i;
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            JSONArray abcs = tmp.getJSONArray(0);
            JSONArray numbers = tmp.getJSONArray(1);
            for (i = 0; i < abcs.size(); ++i) {
                jObj = abcs.getJSONObject(i);
                c = new Choice(jObj.getString("title"), i);
                matchq.getChoiceABCs().add(c);
            }
            for (i = 0; i < numbers.size(); ++i) {
                jObj = numbers.getJSONObject(i);
                c = new Choice(jObj.getString("title"), i);
                matchq.getChoice123s().add(c);
            }
        }
        matchq.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(matchq, q, withCorrectAnswer);
        return matchq;
    }

    public static SingleChoiceQuestion toSingleChoiceQuestion(ExamQuestion q, boolean disorderChoice) {
        return BaseQuestionConvert.toSingleChoiceQuestion(q, disorderChoice, false);
    }

    public static SingleChoiceQuestion toSingleChoiceQuestion(ExamQuestion q, boolean disorderChoice, boolean withCorrectAnswer) {
        SingleChoiceQuestion sc = new SingleChoiceQuestion(q.getQuestionId(), q.getContent());
        sc.setChoices(new ArrayList<Choice>());
        String options = q.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i + 1);
                sc.getChoices().add(c);
            }
        }
        sc.setScore(q.getScore());
        if (disorderChoice) {
            Collections.sort(sc.getChoices(), randomComp);
        }
        sc.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(sc, q, withCorrectAnswer);
        return sc;
    }

    public static MultipleChoiceQuestion toMultipleChoiceQuestion(ExamQuestion q, boolean disorderChoice) {
        return BaseQuestionConvert.toMultipleChoiceQuestion(q, disorderChoice, false);
    }

    public static MultipleChoiceQuestion toMultipleChoiceQuestion(ExamQuestion q, boolean disorderChoice, boolean withCorrectAnswer) {
        MultipleChoiceQuestion mc = new MultipleChoiceQuestion(q.getQuestionId(), q.getContent());
        mc.setChoices(new ArrayList<Choice>());
        String options = q.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i);
                mc.getChoices().add(c);
            }
        }
        mc.setScore(q.getScore());
        if (disorderChoice) {
            Collections.sort(mc.getChoices(), randomComp);
        }
        mc.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(mc, q, withCorrectAnswer);
        return mc;
    }

    public static YesNoQuestion toYesNoQuestion(ExamQuestion q) {
        return BaseQuestionConvert.toYesNoQuestion(q, false);
    }

    public static YesNoQuestion toYesNoQuestion(ExamQuestion q, boolean withCorrectAnswer) {
        YesNoQuestion yesno = new YesNoQuestion(q.getQuestionId(), q.getContent());
        yesno.setChoices(new ArrayList<Choice>());
        String options = q.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i + 1);
                yesno.getChoices().add(c);
            }
        }
        yesno.setScore(q.getScore());
        yesno.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(yesno, q, withCorrectAnswer);
        return yesno;
    }

    public static IndefiniteChoiceQuestion toIndefiniteChoiceQuestion(ExamQuestion q, boolean disorderChoice) {
        return BaseQuestionConvert.toIndefiniteChoiceQuestion(q, disorderChoice, false);
    }

    public static IndefiniteChoiceQuestion toIndefiniteChoiceQuestion(ExamQuestion q, boolean disorderChoice, boolean withCorrectAnswer) {
        IndefiniteChoiceQuestion ic = new IndefiniteChoiceQuestion(q.getQuestionId(), q.getContent());
        ic.setChoices(new ArrayList<Choice>());
        String options = q.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i);
                ic.getChoices().add(c);
            }
        }
        ic.setScore(q.getScore());
        if (disorderChoice) {
            Collections.sort(ic.getChoices(), randomComp);
        }
        ic.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(ic, q, withCorrectAnswer);
        return ic;
    }

    public static TextQuestion toTextQuestion(ExamQuestion q) {
        return BaseQuestionConvert.toTextQuestion(q, false);
    }

    public static TextQuestion toTextQuestion(ExamQuestion q, boolean withCorrectAnswer) {
        TextQuestion textq = new TextQuestion(q.getQuestionId(), q.getContent());
        textq.setScore(q.getScore());
        textq.setAnswerTime(q.getAnswerTime());
        BaseQuestionConvert.setFields(textq, q, withCorrectAnswer);
        return textq;
    }
}

