/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.util;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProgressUtil {
    private static ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private static Map<String, Integer[]> mapProgress = new ConcurrentHashMap<String, Integer[]>();
    private static Map<String, Date> mapProgressTime = new ConcurrentHashMap<String, Date>();

    public static void clear(String key) {
        if (key == null) {
            return;
        }
        mapProgress.remove(key);
    }

    public static Integer getProgressInt(String key) {
        if (key == null) {
            return null;
        }
        Integer[] ary = mapProgress.get(key);
        if (ary == null) {
            return null;
        }
        int currentNum = ary[0];
        int totalNum = ary[1];
        int currentTaskNo = ary[2];
        int totalTaskNum = ary[3];
        if (totalTaskNum == 1) {
            return ProgressUtil.taskPercent(currentNum, totalNum);
        }
        int taskPercent = ProgressUtil.taskPercent(currentNum, totalNum);
        if (taskPercent == 100 && currentTaskNo == totalTaskNum - 1) {
            return 100;
        }
        return currentTaskNo * 100 / totalTaskNum + taskPercent / totalTaskNum;
    }

    private static int taskPercent(int currentNum, int totalNum) {
        if (totalNum < 0) {
            return 0;
        }
        if (totalNum == 0) {
            return 100;
        }
        return currentNum * 100 / totalNum;
    }

    public static void addCurrentNum(String key, int addNum) {
        if (key == null) {
            return;
        }
        Integer[] ary = mapProgress.get(key);
        if (ary == null) {
            return;
        }
        ary[0] = ary[0] + addNum;
        ProgressUtil.update(key, ary[0], ary[1], ary[2], ary[3]);
    }

    public static void update(String key, int currentNum, int totalNum) {
        if (key != null) {
            Integer[] ary = mapProgress.get(key);
            if (ary == null) {
                ProgressUtil.update(key, currentNum, totalNum, 0, 1);
            } else {
                ProgressUtil.update(key, currentNum, totalNum, ary[2], ary[3]);
            }
        }
        ProgressUtil.clearOld();
    }

    public static void update(String key, int currentNum, int totalNum, int currentTaskNo, int totalTaskNum) {
        if (key != null) {
            mapProgress.put(key, new Integer[]{currentNum, totalNum, currentTaskNo, totalTaskNum});
            mapProgressTime.put(key, new Date());
        }
        ProgressUtil.clearOld();
    }

    private static void clearOld() {
        singleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                HashSet<String> old = new HashSet<String>();
                for (String k : mapProgressTime.keySet()) {
                    Date d = (Date)mapProgressTime.get(k);
                    long spent = System.currentTimeMillis() - d.getTime();
                    if (spent <= 21600000L) continue;
                    old.add(k);
                }
                Iterator iterOld = old.iterator();
                while (iterOld.hasNext()) {
                    ProgressUtil.clear((String)iterOld.next());
                }
            }
        });
    }
}

