/*
 * Decompiled with CFR 0.152.
 */
package com.peak.app.exampro.util;

import com.peak.app.exam.exampaper.model.ExamPaperQuestion;
import com.peak.app.exampro.exampaper.model.AbstractBaseQuestion;
import com.peak.app.exampro.exampaper.model.Choice;
import com.peak.app.exampro.exampaper.model.ComplexQuestion;
import com.peak.app.exampro.exampaper.model.FillQuestion;
import com.peak.app.exampro.exampaper.model.IndefiniteChoiceQuestion;
import com.peak.app.exampro.exampaper.model.MatchQuestion;
import com.peak.app.exampro.exampaper.model.MultipleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.RandomComp;
import com.peak.app.exampro.exampaper.model.SingleChoiceQuestion;
import com.peak.app.exampro.exampaper.model.TextQuestion;
import com.peak.app.exampro.exampaper.model.YesNoQuestion;
import com.peak.app.exampro.util.BaseQuestionConvert;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class QuestionConvert
extends BaseQuestionConvert {
    private static RandomComp randomComp = new RandomComp();

    private static void setFields(AbstractBaseQuestion question, ExamPaperQuestion pq, boolean withCorrectAnswer) {
        question.setMediaFilePath(pq.getMediaFilePath());
        if (question.getMediaFilePath() == null || question.getMediaFilePath().trim().isEmpty()) {
            question.setMediaPlayCount(0);
        } else if (pq.getPlayCount() == null) {
            question.setMediaPlayCount(0);
        } else if (pq.getPlayCount() > 0) {
            question.setMediaPlayCount(pq.getPlayCount());
        } else {
            question.setMediaPlayCount(999);
        }
        if (withCorrectAnswer) {
            question.setCorrectAnswer(pq.getAnswer());
        }
    }

    public static ComplexQuestion toComplexQuestion(ExamPaperQuestion pq) {
        ComplexQuestion complexq = new ComplexQuestion(pq.getQuestionId(), pq.getContent());
        QuestionConvert.setFields(complexq, pq, false);
        return complexq;
    }

    public static FillQuestion toFillQuestion(ExamPaperQuestion pq) {
        return QuestionConvert.toFillQuestion(pq, false);
    }

    public static FillQuestion toFillQuestion(ExamPaperQuestion pq, boolean withCorrectAnswer) {
        FillQuestion fill = new FillQuestion(pq.getQuestionId(), pq.getContent());
        fill.setScore(pq.getScore());
        String fillAnswer = pq.getAnswer() + "";
        fillAnswer = fillAnswer.replaceAll("\n", "").replaceAll("\r", "");
        int blankNum = JSONArray.fromObject((Object)fillAnswer).size();
        fill.setBlanks(new String[blankNum]);
        fill.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(fill, pq, withCorrectAnswer);
        return fill;
    }

    public static MatchQuestion toMatchQuestion(ExamPaperQuestion pq) {
        return QuestionConvert.toMatchQuestion(pq, false);
    }

    public static MatchQuestion toMatchQuestion(ExamPaperQuestion pq, boolean withCorrectAnswer) {
        MatchQuestion matchq = new MatchQuestion(pq.getQuestionId(), pq.getContent());
        matchq.setScore(pq.getScore());
        matchq.setChoiceABCs(new ArrayList<Choice>());
        matchq.setChoice123s(new ArrayList<Choice>());
        String options = pq.getOptions();
        if (options != null && options.length() > 0) {
            Choice c;
            JSONObject jObj;
            int i;
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            JSONArray abcs = tmp.getJSONArray(0);
            JSONArray numbers = tmp.getJSONArray(1);
            for (i = 0; i < abcs.size(); ++i) {
                jObj = abcs.getJSONObject(i);
                c = new Choice(jObj.getString("title"), i);
                matchq.getChoiceABCs().add(c);
            }
            for (i = 0; i < numbers.size(); ++i) {
                jObj = numbers.getJSONObject(i);
                c = new Choice(jObj.getString("title"), i);
                matchq.getChoice123s().add(c);
            }
        }
        matchq.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(matchq, pq, withCorrectAnswer);
        return matchq;
    }

    public static SingleChoiceQuestion toSingleChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice) {
        return QuestionConvert.toSingleChoiceQuestion(pq, disorderChoice, false);
    }

    public static SingleChoiceQuestion toSingleChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice, boolean withCorrectAnswer) {
        SingleChoiceQuestion sc = new SingleChoiceQuestion(pq.getQuestionId(), pq.getContent());
        sc.setChoices(new ArrayList<Choice>());
        String options = pq.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i + 1);
                sc.getChoices().add(c);
            }
        }
        sc.setScore(pq.getScore());
        if (disorderChoice) {
            Collections.sort(sc.getChoices(), randomComp);
        }
        sc.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(sc, pq, withCorrectAnswer);
        return sc;
    }

    public static MultipleChoiceQuestion toMultipleChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice) {
        return QuestionConvert.toMultipleChoiceQuestion(pq, disorderChoice, false);
    }

    public static MultipleChoiceQuestion toMultipleChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice, boolean withCorrectAnswer) {
        MultipleChoiceQuestion mc = new MultipleChoiceQuestion(pq.getQuestionId(), pq.getContent());
        mc.setChoices(new ArrayList<Choice>());
        String options = pq.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i);
                mc.getChoices().add(c);
            }
        }
        mc.setScore(pq.getScore());
        if (disorderChoice) {
            Collections.sort(mc.getChoices(), randomComp);
        }
        mc.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(mc, pq, withCorrectAnswer);
        return mc;
    }

    public static YesNoQuestion toYesNoQuestion(ExamPaperQuestion pq) {
        return QuestionConvert.toYesNoQuestion(pq, false);
    }

    public static YesNoQuestion toYesNoQuestion(ExamPaperQuestion pq, boolean withCorrectAnswer) {
        YesNoQuestion yesno = new YesNoQuestion(pq.getQuestionId(), pq.getContent());
        yesno.setChoices(new ArrayList<Choice>());
        String options = pq.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i + 1);
                yesno.getChoices().add(c);
            }
        }
        yesno.setScore(pq.getScore());
        yesno.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(yesno, pq, withCorrectAnswer);
        return yesno;
    }

    public static IndefiniteChoiceQuestion toIndefiniteChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice) {
        return QuestionConvert.toIndefiniteChoiceQuestion(pq, disorderChoice, false);
    }

    public static IndefiniteChoiceQuestion toIndefiniteChoiceQuestion(ExamPaperQuestion pq, boolean disorderChoice, boolean withCorrectAnswer) {
        IndefiniteChoiceQuestion ic = new IndefiniteChoiceQuestion(pq.getQuestionId(), pq.getContent());
        ic.setChoices(new ArrayList<Choice>());
        String options = pq.getOptions();
        if (options != null && options.length() > 0) {
            options = options.replaceAll("\n", "<br/>").replaceAll("\r", "<br/>");
            JSONArray tmp = JSONArray.fromObject((Object)options);
            for (int i = 0; i < tmp.size(); ++i) {
                JSONObject jObj = tmp.getJSONObject(i);
                Choice c = new Choice(jObj.getString("title"), i);
                ic.getChoices().add(c);
            }
        }
        ic.setScore(pq.getScore());
        if (disorderChoice) {
            Collections.sort(ic.getChoices(), randomComp);
        }
        ic.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(ic, pq, withCorrectAnswer);
        return ic;
    }

    public static TextQuestion toTextQuestion(ExamPaperQuestion pq) {
        return QuestionConvert.toTextQuestion(pq, false);
    }

    public static TextQuestion toTextQuestion(ExamPaperQuestion pq, boolean withCorrectAnswer) {
        TextQuestion textq = new TextQuestion(pq.getQuestionId(), pq.getContent());
        textq.setScore(pq.getScore());
        textq.setAnswerTime(pq.getAnswerTime());
        QuestionConvert.setFields(textq, pq, withCorrectAnswer);
        return textq;
    }
}

