/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.exam.report.bo;

import com.peak.common.util.ListUtil;
import com.peak.mng.exam.report.bo.ExamTotalReportKnowledgeSpiderAxleBO;
import com.peak.mng.exam.report.bo.ExamTotalReportKnowledgeSpiderBO;
import com.peak.prd.base.bo.PageBO;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.examcategory.vo.ExamKnowledgeDimensionVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiModel(value="\u96f7\u8fbe\u56fe-\u67e5\u8be2BO")
public class ExamTotalReportKnowledgeSpiderQueryBO
extends PageBO {
    private static final Logger log = LoggerFactory.getLogger(ExamTotalReportKnowledgeSpiderQueryBO.class);
    @ApiModelProperty(value="\u6240\u5c5e\u8003\u8bd5ids--\u524d\u7aef\u5fc5\u586b")
    @NotEmpty
    private List<Long> arrangeIds;
    @ApiModelProperty(value="\u8003\u751fids--\u7a7a\u8868\u793a\u67e5\u8be2\u67e5\u8be2\u5168\u90e8\u8003\u751f")
    private List<Long> userIds;
    private List<ExamTotalReportKnowledgeSpiderBO> spiderBOs;

    public void setDimensionInfo(List<ExamKnowledgeDimensionVO> dimList, boolean byAllDim, boolean byEveryDim) {
        if (ListUtil.isNullorEmpty(dimList)) {
            return;
        }
        this.spiderBOs = new ArrayList<ExamTotalReportKnowledgeSpiderBO>();
        if (byAllDim) {
            ExamTotalReportKnowledgeSpiderBO spiderBO = new ExamTotalReportKnowledgeSpiderBO("\u5168\u90e8\u7ef4\u5ea6");
            ArrayList<ExamTotalReportKnowledgeSpiderAxleBO> axleList = new ArrayList<ExamTotalReportKnowledgeSpiderAxleBO>();
            for (ExamKnowledgeDimensionVO dim : dimList) {
                ExamTotalReportKnowledgeSpiderAxleBO axle = new ExamTotalReportKnowledgeSpiderAxleBO(dim.getTitle(), dim.getKnowledgeIds());
                axleList.add(axle);
            }
            spiderBO.setAxleList(axleList);
            this.spiderBOs.add(spiderBO);
        }
        if (byEveryDim) {
            for (ExamKnowledgeDimensionVO dim : dimList) {
                List<ExamCategoryItemVO> knowledgeVOs = dim.getKnowledgeVOs();
                if (ListUtil.isNullorEmpty(knowledgeVOs)) continue;
                ExamTotalReportKnowledgeSpiderBO spiderBO = new ExamTotalReportKnowledgeSpiderBO(dim.getTitle());
                ArrayList<ExamTotalReportKnowledgeSpiderAxleBO> axleList = new ArrayList<ExamTotalReportKnowledgeSpiderAxleBO>();
                for (ExamCategoryItemVO knowVO : knowledgeVOs) {
                    ExamTotalReportKnowledgeSpiderAxleBO axle = new ExamTotalReportKnowledgeSpiderAxleBO(knowVO.getTitle(), Arrays.asList(knowVO.getItemId()));
                    axleList.add(axle);
                }
                spiderBO.setAxleList(axleList);
                this.spiderBOs.add(spiderBO);
            }
        }
        if (log.isDebugEnabled()) {
            int listSize = this.spiderBOs.size();
            for (int i = 0; i < listSize; ++i) {
                log.debug("spiderBO[" + (i + 1) + "/" + listSize + "]==>{}", (Object)this.spiderBOs.get(i).toDebugString());
            }
        }
    }

    public List<Long> getAllKnowledgeIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (ListUtil.isNullorEmpty(this.spiderBOs)) {
            return ids;
        }
        for (ExamTotalReportKnowledgeSpiderBO spiderBO : this.spiderBOs) {
            List<Long> spiderKnowledgeIds = spiderBO.getAllKnowledgeIds();
            if (ListUtil.isNullorEmpty(spiderKnowledgeIds)) continue;
            ids.addAll(spiderKnowledgeIds);
        }
        return ids;
    }

    public List<Long> getAllKnowledgeIdDistinctList() {
        Set<Long> knowSet = this.getAllKnowledgeIdSet();
        return knowSet.stream().collect(Collectors.toList());
    }

    public Set<Long> getAllKnowledgeIdSet() {
        HashSet<Long> ret = new HashSet<Long>();
        List<Long> list = this.getAllKnowledgeIds();
        ret.addAll(list);
        return ret;
    }

    public List<Long> getArrangeIds() {
        return this.arrangeIds;
    }

    public List<Long> getUserIds() {
        return this.userIds;
    }

    public List<ExamTotalReportKnowledgeSpiderBO> getSpiderBOs() {
        return this.spiderBOs;
    }

    public void setArrangeIds(List<Long> arrangeIds) {
        this.arrangeIds = arrangeIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public void setSpiderBOs(List<ExamTotalReportKnowledgeSpiderBO> spiderBOs) {
        this.spiderBOs = spiderBOs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExamTotalReportKnowledgeSpiderQueryBO)) {
            return false;
        }
        ExamTotalReportKnowledgeSpiderQueryBO other = (ExamTotalReportKnowledgeSpiderQueryBO)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<Long> this$arrangeIds = this.getArrangeIds();
        List<Long> other$arrangeIds = other.getArrangeIds();
        if (this$arrangeIds == null ? other$arrangeIds != null : !((Object)this$arrangeIds).equals(other$arrangeIds)) {
            return false;
        }
        List<Long> this$userIds = this.getUserIds();
        List<Long> other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds)) {
            return false;
        }
        List<ExamTotalReportKnowledgeSpiderBO> this$spiderBOs = this.getSpiderBOs();
        List<ExamTotalReportKnowledgeSpiderBO> other$spiderBOs = other.getSpiderBOs();
        return !(this$spiderBOs == null ? other$spiderBOs != null : !((Object)this$spiderBOs).equals(other$spiderBOs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExamTotalReportKnowledgeSpiderQueryBO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Long> $arrangeIds = this.getArrangeIds();
        result = result * 59 + ($arrangeIds == null ? 43 : ((Object)$arrangeIds).hashCode());
        List<Long> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        List<ExamTotalReportKnowledgeSpiderBO> $spiderBOs = this.getSpiderBOs();
        result = result * 59 + ($spiderBOs == null ? 43 : ((Object)$spiderBOs).hashCode());
        return result;
    }

    public String toString() {
        return "ExamTotalReportKnowledgeSpiderQueryBO(arrangeIds=" + this.getArrangeIds() + ", userIds=" + this.getUserIds() + ", spiderBOs=" + this.getSpiderBOs() + ")";
    }
}

