/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.exam.report.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.report.service.IExamTotalReportExpService;
import com.peak.prd.base.annotation.AsynExport;
import com.peak.prd.base.bo.PageBO;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import com.peak.tools.easyexcel.util.ExcelWriteUtil;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamTotalReportExpService
extends PrdBaseService
implements IExamTotalReportExpService {
    private static final Logger log = LoggerFactory.getLogger(ExamTotalReportExpService.class);
    private static final int PAGE_SIZE = 200;
    private static final int MAX_PAGE_NO = 100000;

    public IEntityDao getEntityDao() {
        return null;
    }

    @Override
    @AsynExport
    public <BO, VO> ExportInfoVO asyncExportList(BO queryBO, Class<VO> clazz, Function<BO, List<VO>> listFunction, String sheetName) {
        ExportInfoVO exportInfoVO;
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(clazz);
        long totalCount = -1L;
        long startms = System.currentTimeMillis();
        boolean hasErr = false;
        try {
            List<VO> voList = listFunction.apply(queryBO);
            if (voList != null) {
                totalCount = voList.size();
                excelWriteUtil.excelWrite(sheetName, voList);
            }
            exportInfoVO = this.finishExp(excelWriteUtil);
        }
        catch (Exception ex) {
            try {
                log.error("-export-error-", (Throwable)ex);
                hasErr = true;
                throw ex;
            }
            catch (Throwable throwable) {
                ExportInfoVO exportInfoVO2 = this.finishExp(excelWriteUtil);
                log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO2.getFilepath()});
                return exportInfoVO2;
            }
        }
        log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO.getFilepath()});
        return exportInfoVO;
    }

    @Override
    @AsynExport
    public <BO extends PageBO, VO> ExportInfoVO asyncExportPaging(BO queryBO, Class<VO> clazz, Function<BO, Paging<VO>> pagingFunction, String sheetName) {
        ExportInfoVO exportInfoVO;
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(clazz);
        queryBO.setPageSize(200);
        long totalCount = -1L;
        long startms = System.currentTimeMillis();
        boolean hasErr = false;
        try {
            for (int pageNo = 1; pageNo <= 100000; ++pageNo) {
                queryBO.setPageNumber(pageNo);
                Paging<VO> paging = pagingFunction.apply(queryBO);
                if (pageNo == 1) {
                    totalCount = paging.getTotalCount();
                }
                if (log.isDebugEnabled()) {
                    log.debug("exportPaging {}, totalCount:{}, currPageNo:{}", new Object[]{sheetName, paging.getTotalCount(), pageNo});
                }
                if (paging.isListNullOrEmpty()) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("empty pageNo:{}, pageSize:{}, break loop, {}", new Object[]{pageNo, queryBO.getPageSize(), sheetName});
                    break;
                }
                excelWriteUtil.excelWrite(sheetName, paging.getList());
            }
            exportInfoVO = this.finishExp(excelWriteUtil);
        }
        catch (Exception ex) {
            try {
                log.error("-export-error-", (Throwable)ex);
                hasErr = true;
                throw ex;
            }
            catch (Throwable throwable) {
                ExportInfoVO exportInfoVO2 = this.finishExp(excelWriteUtil);
                log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO2.getFilepath()});
                return exportInfoVO2;
            }
        }
        log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO.getFilepath()});
        return exportInfoVO;
    }

    @Override
    @AsynExport
    public <BO extends PageBO, VO> ExportInfoVO asyncExportPaging(BO queryBO, Class<VO> clazz, long totalCount, Function<BO, List> listFunction, String sheetName) {
        ExportInfoVO exportInfoVO;
        ExcelWriteUtil excelWriteUtil = new ExcelWriteUtil(clazz);
        queryBO.setPageSize(200);
        long startms = System.currentTimeMillis();
        boolean hasErr = false;
        try {
            for (int pageNo = 1; pageNo <= 100000; ++pageNo) {
                queryBO.setPageNumber(pageNo);
                List dataList = listFunction.apply(queryBO);
                if (dataList == null || dataList.isEmpty()) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("empty pageNo:{}, pageSize:{}, break loop, {}", new Object[]{pageNo, queryBO.getPageSize(), sheetName});
                    break;
                }
                if (clazz.getName().equals(dataList.get(0).getClass().getName())) {
                    excelWriteUtil.excelWrite(sheetName, dataList);
                } else {
                    excelWriteUtil.excelWrite(sheetName, ConvertUtil.convert((List)dataList, clazz));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("exportPaging {}, totalCount:{}, currPageNo:{}, currList:{}", new Object[]{sheetName, totalCount, pageNo, dataList.size()});
            }
            exportInfoVO = this.finishExp(excelWriteUtil);
        }
        catch (Exception ex) {
            try {
                log.error("-export-error-", (Throwable)ex);
                hasErr = true;
                throw ex;
            }
            catch (Throwable throwable) {
                ExportInfoVO exportInfoVO2 = this.finishExp(excelWriteUtil);
                log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO2.getFilepath()});
                return exportInfoVO2;
            }
        }
        log.info("export finish [{}] {}, totalCount:{}, totalSpentms:{}, filepath:{}", new Object[]{!hasErr ? "OK" : "ERR", sheetName, totalCount, System.currentTimeMillis() - startms, exportInfoVO.getFilepath()});
        return exportInfoVO;
    }

    private ExportInfoVO finishExp(ExcelWriteUtil excelWriteUtil) {
        excelWriteUtil.finishWrite();
        ExportInfoVO exportInfoVO = new ExportInfoVO();
        String excelWritePath = excelWriteUtil.getExcelWritePath();
        exportInfoVO.setFilepath(excelWritePath);
        return exportInfoVO;
    }
}

