/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.exam.report.service.imple;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.CommonUtil;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.JsonUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.report.bo.ExamResultChangeQueryBO;
import com.peak.mng.exam.report.bo.ExamTotalReportBO;
import com.peak.mng.exam.report.bo.ExamTotalReportKnowledgeSpiderAxleBO;
import com.peak.mng.exam.report.bo.ExamTotalReportKnowledgeSpiderBO;
import com.peak.mng.exam.report.bo.ExamTotalReportKnowledgeSpiderQueryBO;
import com.peak.mng.exam.report.dao.IExamTotalReportPlusDao;
import com.peak.mng.exam.report.service.IExamTotalReportPlusService;
import com.peak.mng.exam.report.vo.ExamResultChangeFinishVO;
import com.peak.mng.exam.report.vo.ExamResultChangeVO;
import com.peak.mng.exam.report.vo.ExamTotalReportKnowledgeSpiderAxleBean;
import com.peak.mng.exam.report.vo.ExamTotalReportKnowledgeSpiderAxleVO;
import com.peak.mng.exam.report.vo.ExamTotalReportKnowledgeSpiderVO;
import com.peak.mng.exam.report.vo.ExamTotalReportKnowledgeVO;
import com.peak.mng.exam.report.vo.ExamTotalReportOrgVO;
import com.peak.mng.exam.report.vo.ExamTotalReportQuery;
import com.peak.mng.exam.report.vo.ExamTotalReportQuesVO;
import com.peak.mng.exam.report.vo.ExamTotalReportScoreRangeVO;
import com.peak.mng.exam.report.vo.ExamTotalReportSumVO;
import com.peak.mng.exam.report.vo.ExamTotalReportUserKnowledgeSpiderGroupVO;
import com.peak.mng.exam.report.vo.ExamTotalReportUserVO;
import com.peak.mng.exam.report.vo.ExamTotalReportVO;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.IOssService;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.config.AppCommonConfig;
import com.peak.prd.exam.examarrange.service.IExamArrangePaperPlusService;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeSeriesTypeVO;
import com.peak.prd.exam.examcategory.service.IExamCategoryItemPlusService;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.examcategory.vo.ExamQuestionknowledgeVO;
import com.peak.prd.exam.exampaper.model.ExamPaper;
import com.peak.prd.exam.exampaper.service.IExamPaperPlusService;
import com.peak.prd.exam.exampaper.service.IExamPaperTypePlusService;
import com.peak.prd.exam.examquestion.bo.ExamQuestionknowledgeQueryBO;
import com.peak.prd.exam.examquestion.service.IExamQuestionKnowledgePlusService;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examquestiontype.vo.ExamQuestiontypeVO;
import com.peak.prd.exam.examscoreinterval.service.IExamScoreintervalPlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPlusService;
import com.peak.prd.exam.examuser.service.IExamUserPlusService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class ExamTotalReportPlusService
extends PrdBaseService
implements IExamTotalReportPlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamTotalReportPlusService.class);
    @Resource
    private IExamTotalReportPlusDao examTotalReportPlusDao;
    @Resource
    private IExamArrangePlusService examArrangePlusService;
    @Resource
    private IExamArrangePaperPlusService examArrangePaperPlusService;
    @Resource
    private IExamPaperPlusService examPaperPlusService;
    @Resource
    private IExamScoreintervalPlusService examScoreintervalPlusService;
    @Resource
    private IExamPaperTypePlusService examPaperTypePlusService;
    @Resource
    private IExamQuestiontypePlusService examQuestiontypePlusService;
    @Resource
    private IExamQuestionKnowledgePlusService examQuestionKnowledgePlusService;
    @Resource
    private IExamUserPlusService examUserPlusService;
    @Resource
    private IExamCategoryItemPlusService examCategoryItemPlusService;

    @Override
    public ApiResult checkExamTotalReportBO(ExamTotalReportBO bo) {
        ExamArrangeSeriesTypeVO arrangeSeriesTypeVO = this.examArrangePlusService.getExamArrangeSeriesTypeVO(bo.getArrangeIds());
        if (arrangeSeriesTypeVO.isEmpty()) {
            return ApiResult.errMsg((String)"\u81f3\u5c11\u9700\u8981\u9009\u62e91\u4e2a\u8003\u8bd5");
        }
        if (arrangeSeriesTypeVO.isMix()) {
            return ApiResult.errMsg((String)"\u591a\u573a\u6b21\u8003\u8bd5\u548c\u5e38\u89c4\u5355\u573a\u6b21\u8003\u8bd5\uff0c\u4e0d\u80fd\u540c\u65f6\u9009\u62e9");
        }
        if (arrangeSeriesTypeVO.getSeriesExamIds() != null && arrangeSeriesTypeVO.getSeriesExamIds().size() > 1) {
            return ApiResult.errMsg((String)"\u591a\u573a\u6b21\u8003\u8bd5\u53ea\u5141\u8bb8\u5355\u9009");
        }
        if (arrangeSeriesTypeVO.getSeriesExamIdsByPhaseExamIds() != null && arrangeSeriesTypeVO.getSeriesExamIdsByPhaseExamIds().size() > 1) {
            return ApiResult.errMsg((String)"\u4e0d\u53ef\u4ee5\u8de8\u8d8a\u591a\u573a\u6b21\u8003\u8bd5\u7edf\u8ba1\u5176\u4e0b\u7684\u9636\u6bb5\u8003\u8bd5");
        }
        Long seriesId = null;
        if (arrangeSeriesTypeVO.getSeriesExamIds() != null && arrangeSeriesTypeVO.getSeriesExamIds().size() == 1) {
            seriesId = arrangeSeriesTypeVO.getSeriesExamIds().get(0);
            List<Long> allPhaseContentIds = ((IExamSeriesPlusService)SpringUtil.getBean(IExamSeriesPlusService.class)).getAllPhaseContentIds(seriesId);
            bo.setArrangeIds(allPhaseContentIds);
        } else if (!ListUtil.isNullorEmpty(arrangeSeriesTypeVO.getSeriesExamIdsByPhaseExamIds())) {
            seriesId = arrangeSeriesTypeVO.getSeriesExamIdsByPhaseExamIds().get(0);
        }
        boolean bSeriesAndUnifyExam = this.examArrangePlusService.isSeriesAndUnifyExam(seriesId);
        bo.setUnifySeriesId(bSeriesAndUnifyExam ? seriesId : null);
        return ApiResult.okData(null);
    }

    @Override
    public List<ExamTotalReportVO> getSummaryList(ExamTotalReportBO examTotalReportBO) {
        if (ListUtil.isNullorEmpty(examTotalReportBO.getArrangeIds())) {
            return null;
        }
        List examArranges = this.examArrangePlusService.getByIds(examTotalReportBO.getArrangeIds());
        List reportVOs = ConvertUtil.convert((List)examArranges, ExamTotalReportVO.class);
        if (ListUtil.isNullorEmpty((List)reportVOs)) {
            return null;
        }
        for (ExamTotalReportVO reportVO : reportVOs) {
            ExamTotalReportQuery query = new ExamTotalReportQuery();
            query.setArrangeIds(Arrays.asList(reportVO.getArrangeId()));
            query.setPassmark(reportVO.getPassmark());
            query.setOrgId(examTotalReportBO.getOrgId());
            query.setUnifySeriesId(examTotalReportBO.getUnifySeriesId());
            ExamTotalReportVO attendUserVO = this.examTotalReportPlusDao.getSummaryNum(query);
            if (attendUserVO == null) {
                attendUserVO = new ExamTotalReportVO();
                attendUserVO.setShouldAttendUserNum(0);
                attendUserVO.setActualAttendUserNum(0);
            }
            reportVO.setShouldAttendUserNum(attendUserVO.getShouldAttendUserNum());
            reportVO.setActualAttendUserNum(attendUserVO.getActualAttendUserNum());
            reportVO.setPassUserNum(attendUserVO.getPassUserNum());
            reportVO.setMaxMark(attendUserVO.getMaxMark());
            reportVO.setMinMark(attendUserVO.getMinMark());
            reportVO.setSumMark(attendUserVO.getSumMark());
            reportVO.setMaxReplySeconds(attendUserVO.getMaxReplySeconds());
            reportVO.setMinReplySeconds(attendUserVO.getMinReplySeconds());
            reportVO.setSumReplySeconds(attendUserVO.getSumReplySeconds());
            reportVO.setScoredUserNum(attendUserVO.getScoredUserNum());
        }
        Iterator iterator = reportVOs.iterator();
        while (iterator.hasNext()) {
            ExamTotalReportVO reportVO;
            Integer examFullmark = this.getExamFullmark((reportVO = (ExamTotalReportVO)((Object)iterator.next())).getArrangeId());
            reportVO.setFullmark(examFullmark == null ? null : Double.valueOf(examFullmark.doubleValue()));
        }
        return reportVOs;
    }

    @Override
    public List<ExamTotalReportOrgVO> getOrgList(ExamTotalReportBO examTotalReportBO) {
        List<Long> arrangeIds = examTotalReportBO.getArrangeIds();
        ExamTotalReportQuery examTotalReportQuery = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamTotalReportQuery.class);
        int totalNum = 0;
        Integer totalFullmark = 0;
        for (Long arrangeId : arrangeIds) {
            Integer examFullmark = this.getExamFullmark(arrangeId);
            if (examFullmark == null) continue;
            ++totalNum;
            totalFullmark = totalFullmark + examFullmark;
        }
        Double avgFullmark = totalNum == 0 ? null : Double.valueOf(totalFullmark.doubleValue() / (double)totalNum);
        List<ExamTotalReportOrgVO> listByDirect = this.examTotalReportPlusDao.getByDirectOrg(examTotalReportQuery);
        List<ExamTotalReportOrgVO> list = this.examTotalReportPlusDao.getOrgList(examTotalReportQuery);
        if (list == null) {
            list = listByDirect;
        } else if (listByDirect != null && listByDirect.size() > 0) {
            list.addAll(0, listByDirect);
        }
        if (!ListUtil.isNullorEmpty(list)) {
            for (ExamTotalReportOrgVO vo : list) {
                vo.setFullmark(avgFullmark);
                vo.setParentOrgId(examTotalReportBO.getOrgId());
            }
        }
        return list;
    }

    @Override
    public Paging<ExamTotalReportUserVO> getUserPaging(ExamTotalReportBO examTotalReportBO) {
        ExamTotalReportQuery examTotalReportQuery = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamTotalReportQuery.class);
        Paging<ExamTotalReportUserVO> paging = this.examTotalReportPlusDao.getUserPaging(examTotalReportQuery);
        if (paging.isListNullOrEmpty()) {
            return paging;
        }
        List list = paging.getList();
        OrgUtil.setOrgFullname((List)list, ExamTotalReportUserVO::getDeptId, ExamTotalReportUserVO::setOrgFullname);
        return paging;
    }

    @Override
    public List<ExamTotalReportScoreRangeVO> getScoreRangeList(ExamTotalReportBO examTotalReportBO) {
        if (examTotalReportBO.getScoreDomainId() == null) {
            log.warn("score domainId empty");
            return null;
        }
        List<ExamTotalReportVO> summaryList = this.getSummaryList(examTotalReportBO);
        ExamTotalReportSumVO examTotalReportSumVO = new ExamTotalReportSumVO(summaryList);
        ExamTotalReportVO summary = examTotalReportSumVO.getSummary();
        Integer actualAttendUserNum = summary == null ? null : summary.getActualAttendUserNum();
        ExamTotalReportQuery examTotalReportQuery = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamTotalReportQuery.class);
        examTotalReportQuery.setDomainId(examTotalReportBO.getScoreDomainId());
        List<ExamTotalReportScoreRangeVO> scoreRangeVOs = this.examTotalReportPlusDao.getScoreRangeList(examTotalReportQuery);
        if (!ListUtil.isNullorEmpty(scoreRangeVOs)) {
            scoreRangeVOs.get(0).setIncludeEnd(true);
            for (ExamTotalReportScoreRangeVO vo : scoreRangeVOs) {
                vo.setActualAttendUserNum(actualAttendUserNum);
            }
        }
        return scoreRangeVOs;
    }

    @Override
    public Paging<ExamTotalReportQuesVO> getQuesPaging(ExamTotalReportBO examTotalReportBO) {
        List<Long> paperIds = this.getStuPaperIdsByArranges(examTotalReportBO.getArrangeIds());
        List<Long> questiontypeIds = this.getQuestiontypeIdsExcludeComplex();
        if (ListUtil.isNullorEmpty(paperIds)) {
            return new Paging(examTotalReportBO.getPageNumber(), examTotalReportBO.getPageSize());
        }
        ExamTotalReportQuery examTotalReportQuery = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamTotalReportQuery.class);
        examTotalReportQuery.setPaperIds(paperIds);
        examTotalReportQuery.setTypeIds(questiontypeIds);
        Paging<ExamTotalReportQuesVO> paging = this.examTotalReportPlusDao.getQuesPaging(examTotalReportQuery);
        if (paging.isListNullOrEmpty()) {
            return paging;
        }
        List voList = paging.getList();
        List questionIds = IdUtil.getIds((List)voList, e -> e.getQuestionId());
        Map<Long, List<ExamCategoryItemVO>> knowledgeMap = this.examQuestionKnowledgePlusService.getKnowledges(questionIds);
        if (knowledgeMap != null) {
            for (int i = 0; i < voList.size(); ++i) {
                ExamTotalReportQuesVO vo2 = (ExamTotalReportQuesVO)((Object)voList.get(i));
                List<ExamCategoryItemVO> knows = knowledgeMap.get(vo2.getQuestionId());
                vo2.setKnowledgeList(knows);
            }
        }
        examTotalReportQuery.setQuestionIds(questionIds);
        List<ExamTotalReportQuesVO> quesReplyList = this.examTotalReportPlusDao.getQuesReplyList(examTotalReportQuery);
        List quesReplyVOList = ConvertUtil.refact((List)voList, quesReplyList, (vo, qr) -> vo.getQuestionId().equals(qr.getQuestionId()));
        for (int i = 0; i < voList.size(); ++i) {
            ExamTotalReportQuesVO vo1 = (ExamTotalReportQuesVO)((Object)voList.get(i));
            ExamTotalReportQuesVO vo2 = (ExamTotalReportQuesVO)((Object)quesReplyVOList.get(i));
            if (vo2 != null) {
                vo1.setPersonNum(vo2.getPersonNum());
                vo1.setCorrectPersonNum(vo2.getCorrectPersonNum());
                vo1.setSumPersonScore(vo2.getSumPersonScore());
            }
            String typename = this.examQuestiontypePlusService.getTypename(vo1.getTypeId());
            vo1.setTypename(typename);
            if (vo1.getParentQuesTypeId() == null || vo1.getParentQuesTypeId() == 0L) continue;
            String parentTypename = this.examQuestiontypePlusService.getTypename(vo1.getParentQuesTypeId());
            vo1.setParentTypename(parentTypename);
        }
        return paging;
    }

    @Override
    public Paging<ExamTotalReportKnowledgeVO> getKnowledgePaging(ExamTotalReportBO examTotalReportBO) {
        ExamQuestionknowledgeQueryBO queryBO = (ExamQuestionknowledgeQueryBO)((Object)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamQuestionknowledgeQueryBO.class));
        List<Long> paperIds = this.getStuPaperIdsByArranges(examTotalReportBO.getArrangeIds());
        queryBO.setPaperIds(paperIds);
        Paging ret = new Paging();
        Paging<ExamQuestionknowledgeVO> paging = this.examQuestionKnowledgePlusService.getKnowledgesByPaperIds(queryBO);
        if (paging == null || paging.isListNullOrEmpty()) {
            return ret;
        }
        List list = ConvertUtil.convert((List)paging.getList(), ExamTotalReportKnowledgeVO.class);
        ret.setPageNumber(paging.getPageNumber());
        ret.setPageSize(paging.getPageSize());
        ret.setTotalCount(paging.getTotalCount());
        ret.setList(list);
        List knowledgeIds = IdUtil.getIds((List)list, e -> e.getItemId());
        ExamTotalReportQuery examTotalReportQuery = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)examTotalReportBO), ExamTotalReportQuery.class);
        examTotalReportQuery.setPaperIds(paperIds);
        examTotalReportQuery.setKnowledgeIds(knowledgeIds);
        examTotalReportQuery.setSubjectiveTypeIds(this.examQuestiontypePlusService.getAllSubjectiveTypeIds(false));
        List<ExamTotalReportKnowledgeVO> knowledgeQuesList = this.examTotalReportPlusDao.getKnowledgeQuesList(examTotalReportQuery);
        List knowledgeQuesVOList = ConvertUtil.refact((List)list, knowledgeQuesList, (know, kq) -> know.getItemId().equals(kq.getItemId()));
        List<ExamTotalReportKnowledgeVO> knowledgeQuesReplyList = this.examTotalReportPlusDao.getKnowledgeQuesReplyList(examTotalReportQuery);
        List knowledgeQuesReplyVOList = ConvertUtil.refact((List)list, knowledgeQuesReplyList, (know, kq) -> know.getItemId().equals(kq.getItemId()));
        for (int i = 0; i < list.size(); ++i) {
            ExamTotalReportKnowledgeVO vo1 = (ExamTotalReportKnowledgeVO)((Object)list.get(i));
            ExamTotalReportKnowledgeVO vo2 = (ExamTotalReportKnowledgeVO)((Object)knowledgeQuesVOList.get(i));
            ExamTotalReportKnowledgeVO vo3 = (ExamTotalReportKnowledgeVO)((Object)knowledgeQuesReplyVOList.get(i));
            if (vo2 != null) {
                vo1.setTotalQuesNum(vo2.getTotalQuesNum());
                vo1.setTotalSubjectiveQuesNum(vo2.getTotalSubjectiveQuesNum());
            }
            if (vo3 == null) continue;
            vo1.setTotalPersonNum(vo3.getTotalPersonNum());
            vo1.setCorrectPersonNum(vo3.getCorrectPersonNum());
            vo1.setSumQuesScore(vo3.getSumQuesScore());
            vo1.setSumPersonScore(vo3.getSumPersonScore());
        }
        return ret;
    }

    @Override
    public Paging<ExamQuestionknowledgeVO> getKnowledgePagingByExamId(Long arrangeId, int pageNo, int pageSize) {
        if (arrangeId == null) {
            return null;
        }
        List<Long> paperIds = this.getStuPaperIdsByArranges(Arrays.asList(arrangeId));
        ExamQuestionknowledgeQueryBO queryBO = new ExamQuestionknowledgeQueryBO(pageNo, pageSize);
        queryBO.setPaperIds(paperIds);
        Paging<ExamQuestionknowledgeVO> paging = this.examQuestionKnowledgePlusService.getKnowledgesByPaperIds(queryBO);
        return paging;
    }

    @Override
    public List<ExamTotalReportUserKnowledgeSpiderGroupVO> getUserKnowledgeSpiderGroupVOList(ExamTotalReportKnowledgeSpiderQueryBO queryBO) {
        ArrayList<ExamTotalReportUserKnowledgeSpiderGroupVO> ret = new ArrayList<ExamTotalReportUserKnowledgeSpiderGroupVO>();
        List<Long> arrangeIds = queryBO.getArrangeIds();
        List<ExamTotalReportKnowledgeSpiderBO> spiderBOs = queryBO.getSpiderBOs();
        List<Long> userIds = queryBO.getUserIds();
        if (userIds == null) {
            userIds = this.examUserPlusService.getAttendedDistinctUserListByArrangeIds(arrangeIds, queryBO.getPageNumber(), queryBO.getPageSize());
        }
        if (ListUtil.isNullorEmpty(arrangeIds) || ListUtil.isNullorEmpty(userIds) || ListUtil.isNullorEmpty(spiderBOs)) {
            return null;
        }
        List<Long> knowledgeIdDistinctList = queryBO.getAllKnowledgeIdDistinctList();
        List<ExamTotalReportKnowledgeVO> allKnowledgeSpiderList = this.getKnowledgeSpiderList(arrangeIds, knowledgeIdDistinctList, null);
        List<ExamTotalReportKnowledgeVO> stuKnowledgeSpiderList = this.getKnowledgeSpiderList(arrangeIds, knowledgeIdDistinctList, userIds);
        ArrayList<List<ExamTotalReportKnowledgeSpiderAxleBean>> avgBeanListBySpiders = new ArrayList<List<ExamTotalReportKnowledgeSpiderAxleBean>>();
        for (ExamTotalReportKnowledgeSpiderBO spiderBO : spiderBOs) {
            avgBeanListBySpiders.add(this.getAxleBeans(spiderBO, allKnowledgeSpiderList));
        }
        for (int i = 0; i < userIds.size(); ++i) {
            Long uid = userIds.get(i);
            ExamTotalReportUserKnowledgeSpiderGroupVO userSpiderGroupVO = new ExamTotalReportUserKnowledgeSpiderGroupVO(uid, new ArrayList<ExamTotalReportKnowledgeSpiderVO>());
            List<ExamTotalReportKnowledgeVO> myList = stuKnowledgeSpiderList.stream().filter(e -> uid.equals(e.getUserId())).collect(Collectors.toList());
            int pos = 0;
            for (ExamTotalReportKnowledgeSpiderBO spiderBO : spiderBOs) {
                List<ExamTotalReportKnowledgeSpiderAxleBO> axleList = spiderBO.getAxleList();
                ExamTotalReportKnowledgeSpiderVO spiderVO = new ExamTotalReportKnowledgeSpiderVO(uid);
                spiderVO.setTitle(spiderBO.getTitle());
                List<ExamTotalReportKnowledgeSpiderAxleBean> myBeansBySpider = this.getAxleBeans(spiderBO, myList);
                List avgBeansBySpider = (List)avgBeanListBySpiders.get(pos);
                ArrayList<ExamTotalReportKnowledgeSpiderAxleVO> spiderAxleVOList = new ArrayList<ExamTotalReportKnowledgeSpiderAxleVO>();
                for (int k = 0; k < axleList.size(); ++k) {
                    ExamTotalReportKnowledgeSpiderAxleBean itemAverage = (ExamTotalReportKnowledgeSpiderAxleBean)avgBeansBySpider.get(k);
                    ExamTotalReportKnowledgeSpiderAxleBean itemUser = myBeansBySpider.get(k);
                    ExamTotalReportKnowledgeSpiderAxleVO spiderAxleItem = new ExamTotalReportKnowledgeSpiderAxleVO(itemAverage, itemUser);
                    spiderAxleItem.setKnowledgeIds(axleList.get(k).getKnowledgeIds());
                    String knowledgeTitle = axleList.get(k).getTitle();
                    spiderAxleItem.setTitle(knowledgeTitle);
                    spiderAxleVOList.add(spiderAxleItem);
                }
                spiderVO.setAxles(spiderAxleVOList);
                userSpiderGroupVO.getSpiderVOs().add(spiderVO);
                ++pos;
            }
            ret.add(userSpiderGroupVO);
        }
        UserCoreUtil.setUserProperties(ret, ExamTotalReportUserKnowledgeSpiderGroupVO::getUserId, (BiConsumer[])new BiConsumer[]{(vo, u) -> {
            vo.setUsercode(u.getUsercode());
            vo.setRealname(u.getName());
        }});
        return ret;
    }

    @Override
    public boolean expExamResultChangeVOs(ExamResultChangeQueryBO queryBO) throws IOException {
        Object list;
        ExamTotalReportQuery query = (ExamTotalReportQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamTotalReportQuery.class);
        int PAGESIZE = 200;
        String SPLIT = ",";
        query.getPage().setPageSize(PAGESIZE);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String filePrefix = "exam_score_" + sdf.format(new Date(query.getReaddateExclude().getTime() - 86400000L));
        String dataFilename = filePrefix + ".txt";
        String finishFilename = filePrefix + "_finish.txt";
        String resourceDirByEndSlash = CommonUtil.formatByEndSlash((String)AppPathUtil.getResourceLocalPath());
        String subDir = "exam/result/change";
        String subDirByEndSlash = subDir + "/";
        String fullPathname = resourceDirByEndSlash + subDirByEndSlash + dataFilename;
        String fullFinishPathname = resourceDirByEndSlash + subDirByEndSlash + finishFilename;
        File dir = new File(resourceDirByEndSlash + subDir);
        if (!dir.exists()) {
            dir.mkdirs();
            log.info("\u521b\u5efa\u76ee\u5f55\uff1a{}", (Object)(resourceDirByEndSlash + subDir));
        }
        long startMs = System.currentTimeMillis();
        long totalRows = 0L;
        long totalSpentms = 0L;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullPathname, false), "UTF-8"));){
            writer.write("");
            writer.flush();
        }
        for (int pageNo = 1; pageNo < 100000; ++pageNo) {
            query.getPage().setPageNumber(pageNo);
            list = this.examTotalReportPlusDao.findList(query, "getExamResultChangeVOs", ExamResultChangeVO.class);
            if (ListUtil.isNullorEmpty((List)list)) break;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullPathname, true), "UTF-8"));){
                for (int i = 0; i < list.size(); ++i) {
                    ExamResultChangeVO vo = (ExamResultChangeVO)list.get(i);
                    StringBuilder sb = new StringBuilder();
                    sb.append(vo.getArrangeId()).append(SPLIT).append((vo.getArrangeTitle() + "").replace(SPLIT, "")).append(SPLIT).append(vo.getBiztype() == null ? "" : vo.getBiztype()).append(SPLIT).append(vo.getUsercode()).append(SPLIT).append(vo.getExternalname() == null ? "" : vo.getExternalname().replace(SPLIT, "")).append(SPLIT).append(vo.getSubmitdate_yyyyMMddHHmmss());
                    writer.write(sb.append("\n").toString());
                    ++totalRows;
                }
                writer.flush();
                continue;
            }
        }
        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullFinishPathname), "UTF-8"));
        list = null;
        try {
            totalSpentms = System.currentTimeMillis() - startMs;
            ExamResultChangeFinishVO finishVO = new ExamResultChangeFinishVO();
            finishVO.setTotalRows(totalRows);
            finishVO.setTotalSpentms(totalSpentms);
            finishVO.setFinishDate(new Date());
            writer.write(JsonUtil.objectToJson((Object)finishVO));
            ((Writer)writer).flush();
        }
        catch (Throwable finishVO) {
            list = finishVO;
            throw finishVO;
        }
        finally {
            if (writer != null) {
                if (list != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Throwable finishVO) {
                        ((Throwable)list).addSuppressed(finishVO);
                    }
                } else {
                    ((Writer)writer).close();
                }
            }
        }
        log.info("\u51c6\u5907\u4e0a\u4f20\u5230OSS...{}, totalRows:{}, totalSpentms:{}", new Object[]{subDirByEndSlash + dataFilename, totalRows, totalSpentms});
        AppCommonConfig config = (AppCommonConfig)SpringUtil.getBean(AppCommonConfig.class);
        IOssService ossService = (IOssService)SpringUtil.getBean((String)config.getOssServiceName());
        Boolean b1 = ossService.uploadFile(AppPathUtil.getResourceLocalPath(), subDirByEndSlash + dataFilename);
        Boolean b2 = ossService.uploadFile(AppPathUtil.getResourceLocalPath(), subDirByEndSlash + finishFilename);
        log.info("upload OSS result: b1:{}, b2: {}", (Object)b1, (Object)b2);
        return b1 != null && b2 != null && b1 != false && b2 != false;
    }

    @Cacheable
    public String getKnowledgeTitle(List<Long> ids) {
        if (ListUtil.isNullorEmpty(ids)) {
            return "";
        }
        List items = this.examCategoryItemPlusService.getByIds(ids);
        if (ListUtil.isNullorEmpty((List)items)) {
            return "";
        }
        List names = items.stream().map(e -> e.getTitle()).collect(Collectors.toList());
        return String.join((CharSequence)",", names);
    }

    private List<ExamTotalReportKnowledgeSpiderAxleBean> getAxleBeans(ExamTotalReportKnowledgeSpiderBO spiderBO, List<ExamTotalReportKnowledgeVO> knowledgeVOList) {
        ArrayList<ExamTotalReportKnowledgeSpiderAxleBean> axleBeans = new ArrayList<ExamTotalReportKnowledgeSpiderAxleBean>();
        List<ExamTotalReportKnowledgeSpiderAxleBO> axleList = spiderBO.getAxleList();
        if (ListUtil.isNullorEmpty(axleList)) {
            return axleBeans;
        }
        for (ExamTotalReportKnowledgeSpiderAxleBO axleBO : axleList) {
            List<Long> knowledgeIdsByAxle = axleBO.getKnowledgeIds();
            if (ListUtil.isNullorEmpty(knowledgeIdsByAxle) || ListUtil.isNullorEmpty(knowledgeVOList)) {
                axleBeans.add(new ExamTotalReportKnowledgeSpiderAxleBean(null));
                continue;
            }
            HashSet<Long> setKnowledgeIdsByAxle = new HashSet<Long>(knowledgeIdsByAxle);
            List<ExamTotalReportKnowledgeVO> axleData = knowledgeVOList.stream().filter(e -> setKnowledgeIdsByAxle.contains(e.getKnowledgeId())).collect(Collectors.toList());
            ExamTotalReportKnowledgeSpiderAxleBean bean = new ExamTotalReportKnowledgeSpiderAxleBean(axleData);
            axleBeans.add(bean);
        }
        return axleBeans;
    }

    private List<ExamTotalReportKnowledgeVO> getKnowledgeSpiderList(List<Long> arrangeIds, List<Long> knowledgeIds, List<Long> userIds) {
        if (ListUtil.isNullorEmpty(arrangeIds) || ListUtil.isNullorEmpty(knowledgeIds)) {
            return null;
        }
        ExamTotalReportQuery query = new ExamTotalReportQuery(1, 10000);
        query.setArrangeIds(arrangeIds);
        query.setKnowledgeIds(knowledgeIds);
        query.setUserIds(userIds);
        List<ExamTotalReportKnowledgeVO> knowledgeQuesReplyList = this.examTotalReportPlusDao.getKnowledgeQuesReplyList(query);
        return knowledgeQuesReplyList;
    }

    private List<Long> getStuPaperIdsByArranges(List<Long> arrangeIds) {
        ArrayList<Long> paperIds = new ArrayList<Long>();
        for (Long arrangeId : arrangeIds) {
            List<Long> stuPaperIdsByArrange = this.examArrangePaperPlusService.getStuPaperIdsByArrange(arrangeId);
            if (ListUtil.isNullorEmpty(stuPaperIdsByArrange)) continue;
            paperIds.addAll(stuPaperIdsByArrange);
        }
        return ListUtil.removeDuplicate(paperIds);
    }

    private List<Long> getQuestiontypeIdsExcludeComplex() {
        List<Long> complexTypeIds = this.examQuestiontypePlusService.getCachedAllComplexTypeIdsIncludeInvalid();
        List<ExamQuestiontypeVO> allTypes = this.examQuestiontypePlusService.getCachedAllTypesExcludeInvalid();
        List<Long> wantTypeIds = allTypes.stream().filter(e -> !complexTypeIds.contains(e.getTypeId())).map(e -> e.getTypeId()).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug("\u590d\u6742\u9898\u578b: {}", (Object)IdUtil.getIdStrs(complexTypeIds, (String)",", e -> e));
            log.debug("\u5168\u90e8\u9898\u578b: {}", (Object)IdUtil.getIdStrs(allTypes, (String)",", e -> e.getTypeId()));
            log.debug("\u7b5b\u9009\u540e\u9898\u578b: {}", (Object)IdUtil.getIdStrs(wantTypeIds, (String)",", e -> e));
        }
        return wantTypeIds;
    }

    private Integer getExamFullmark(Long arrangeId) {
        List<Long> stuPaperIdsByArrange = this.examArrangePaperPlusService.getStuPaperIdsByArrange(arrangeId);
        if (ListUtil.isNullorEmpty(stuPaperIdsByArrange)) {
            return null;
        }
        Long paperId = stuPaperIdsByArrange.get(0);
        ExamPaper examPaper = (ExamPaper)this.examPaperPlusService.getById(paperId);
        if (examPaper == null) {
            return null;
        }
        return examPaper.getFullmark();
    }

    public IEntityDao getEntityDao() {
        return this.examTotalReportPlusDao;
    }
}

