/*
 * Decompiled with CFR 0.152.
 */
package com.peak.mng.exam.report.util;

import com.peak.common.util.ListUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ExamTotalReportUtil {
    public static String getPercentString(Number n1, Number n2) {
        if (n2 == null || n2.intValue() <= 0) {
            return null;
        }
        if (n1 == null) {
            return "0%";
        }
        double d = n1.doubleValue() / n2.doubleValue();
        return new DecimalFormat("#.##").format(d * 100.0) + "%";
    }

    public static Double formatDouble(Double d) {
        if (d == null) {
            return null;
        }
        String str = new DecimalFormat("#.##").format(d);
        return Double.valueOf(str);
    }

    public static void createZip(String zipFileFullname, List<String> inputSources) throws IOException {
        if (ListUtil.isNullorEmpty(inputSources)) {
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(zipFileFullname);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        for (String inputsource : inputSources) {
            FileInputStream fileInputStream = new FileInputStream(inputsource);
            ZipEntry entry = new ZipEntry(Paths.get(inputsource, new String[0]).getFileName().toString());
            zipOutputStream.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                zipOutputStream.write(buffer, 0, bytesRead);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
        zipOutputStream.close();
        fileOutputStream.close();
    }
}

