/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.datajoblog.service.imple;

import com.peak.common.util.RedisService;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.exam.datajoblog.dao.IExamDatajobLogPlusDao;
import com.peak.prd.exam.datajoblog.model.ExamDatajobLog;
import com.peak.prd.exam.datajoblog.service.IExamDatajobLogPlusService;
import com.peak.prd.exam.datajoblog.vo.ExamDatajobLogQuery;
import java.net.InetAddress;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamDatajobLogPlusService
extends PrdBaseService<ExamDatajobLog, Long, ExamDatajobLogQuery>
implements IExamDatajobLogPlusService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ExamDatajobLogPlusService.class);
    @Autowired
    private PrdExamConfig prdExamConfig;
    @Autowired
    private RedisService redisService;
    private IExamDatajobLogPlusDao examDatajobLogPlusDao;
    private String serverInfo;
    private Boolean supportLog;

    public void setExamDatajobLogPlusDao(IExamDatajobLogPlusDao dao) {
        this.examDatajobLogPlusDao = dao;
    }

    public IExamDatajobLogPlusDao getExamDatajobLogPlusDao() {
        return this.examDatajobLogPlusDao;
    }

    public IEntityDao<ExamDatajobLog, Long, ExamDatajobLogQuery> getEntityDao() {
        return this.examDatajobLogPlusDao;
    }

    private boolean canLog() {
        return this.supportLog != null && this.supportLog != false;
    }

    public void afterPropertiesSet() throws Exception {
        this.serverInfo = InetAddress.getLocalHost().getHostAddress();
        if (this.supportLog == null) {
            try {
                this.examDatajobLogPlusDao.getById(1L);
                log.info("===Exam_DataJob_LOG exists===");
                this.supportLog = Boolean.TRUE;
            }
            catch (Exception ex) {
                this.supportLog = Boolean.FALSE;
                log.error("===Exam_DataJob_LOG not exists?===" + ex.getMessage());
            }
        }
        try {
            this.logStart();
        }
        catch (Exception ex) {
            log.error("logStart error:", (Throwable)ex);
        }
    }

    @Override
    public ExamDatajobLog newInstance(String loglevel) {
        ExamDatajobLog model = new ExamDatajobLog();
        model.setLogId(this.getRedisPkeyId());
        model.setLoglevel(loglevel);
        model.setServerinfo(this.serverInfo);
        model.setServeruuId(this.prdExamConfig.getUuid());
        model.setCreatedate(new Date());
        model.setDeletable(1);
        return model;
    }

    @Override
    public int insertLog(String logcontent, String loglevel) {
        if (!this.canLog()) {
            return 0;
        }
        ExamDatajobLog model = this.newInstance(loglevel);
        model.setLogcontent(logcontent);
        return this.insert((BaseEntity)model);
    }

    @Override
    public int insertLog(ExamDatajobLog model) {
        if (!this.canLog()) {
            return 0;
        }
        return this.examDatajobLogPlusDao.insert((BaseEntity)model);
    }

    @Override
    public int deleteOld(Date beforeDate) {
        if (!this.canLog()) {
            return 0;
        }
        return this.examDatajobLogPlusDao.deleteOld(beforeDate);
    }

    private void logStart() {
        if (!this.canLog()) {
            return;
        }
        ProtectionDomain pd = this.getClass().getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        String clazzLocation = "" + cs.getLocation();
        ExamDatajobLog model = this.newInstance("START");
        StringBuilder sb = new StringBuilder("\u5e94\u7528\u542f\u52a8");
        sb.append("[").append(clazzLocation).append("]");
        sb.append("[enterway:").append(this.prdExamConfig.getEnterway()).append(", env:").append(this.prdExamConfig.getEnv()).append(", prj:").append(this.prdExamConfig.getPrj()).append(", messageQ:").append(this.prdExamConfig.getMessageQ()).append(", loadrunner:").append(this.prdExamConfig.getLoadrunner()).append("]");
        model.setLogcontent(sb.toString());
        this.insert((BaseEntity)model);
    }

    private Long getRedisPkeyId() {
        String redisKey = "peak:pkey:exam_datajob_log";
        this.redisService.setnx(redisKey, System.currentTimeMillis() + "");
        return this.redisService.increment(redisKey, 1L);
    }
}

