/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examarrange.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examarrange.bo.ExamArrangePaperQueryBO;
import com.peak.mng.exam.exampaper.vo.ExamPaperVO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.enums.ExamPapermethodEnum;
import com.peak.prd.exam.examarrange.dao.IExamArrangePaperPlusDao;
import com.peak.prd.exam.examarrange.model.ExamArrangePaper;
import com.peak.prd.exam.examarrange.service.IExamArrangePaperPlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangePaperQuery;
import com.peak.prd.exam.examarrange.vo.ExamArrangePaperVO;
import com.peak.prd.exam.exampaper.service.IExamPaperPlusService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamArrangePaperPlusService
extends PrdBaseService<ExamArrangePaper, Long, ExamArrangePaperQuery>
implements IExamArrangePaperPlusService {
    private IExamArrangePaperPlusDao examArrangePaperPlusDao;
    @Autowired
    private IExamPaperPlusService examPaperPlusService;

    public void setExamArrangePaperPlusDao(IExamArrangePaperPlusDao dao) {
        this.examArrangePaperPlusDao = dao;
    }

    public IExamArrangePaperPlusDao getExamArrangePaperPlusDao() {
        return this.examArrangePaperPlusDao;
    }

    public IEntityDao<ExamArrangePaper, Long, ExamArrangePaperQuery> getEntityDao() {
        return this.examArrangePaperPlusDao;
    }

    @Override
    public List<ExamArrangePaperVO> findVOList(ExamArrangePaperQueryBO queryBO) {
        if (queryBO == null || queryBO.getArrangeId() == null) {
            return null;
        }
        ExamArrangePaperQuery examArrangePaperQuery = (ExamArrangePaperQuery)ConvertUtil.convert((Object)queryBO, ExamArrangePaperQuery.class);
        examArrangePaperQuery.getPage().setSortColumns("createdate desc");
        examArrangePaperQuery.setGenerated(false);
        List models = this.findAll(examArrangePaperQuery);
        List vos = ConvertUtil.convert((List)models, ExamArrangePaperVO.class);
        UserCoreUtil.setUserRealname((List)vos, ExamArrangePaperVO::getCreatorId, ExamArrangePaperVO::setCreatorName);
        this.examPaperPlusService.setPaperProperties(vos, ExamArrangePaperVO::getPaperId, (e, p) -> e.setPaperTitle(p.getTitle()), (e, p) -> e.setCreatebyarrangeId(p.getCreatebyarrangeId()));
        return vos;
    }

    @Override
    public List<ExamPaperVO> getStuPaperList(ExamArrangePaperQueryBO queryBO) {
        if (queryBO == null || queryBO.getArrangeId() == null) {
            return null;
        }
        List<Long> paperIds = this.getStuPaperIdsByArrange(queryBO.getArrangeId());
        if (ListUtil.isNullorEmpty(paperIds)) {
            return null;
        }
        List examPapers = this.examPaperPlusService.getByIds(paperIds);
        List vos = ConvertUtil.convert((List)examPapers, ExamPaperVO.class);
        return vos;
    }

    @Override
    public void deleteByArrangeId(Long arrangeId) {
        this.examArrangePaperPlusDao.deleteByArrangeId(arrangeId);
    }

    @Override
    public void deleteNotFixedByArrangeId(Long arrangeId) {
        this.examArrangePaperPlusDao.deleteNotFixedByArrangeId(arrangeId);
    }

    @Override
    public List<ExamArrangeNumVO> groupArrangePaperNums(List<Long> arrangeIds) {
        if (CollectionUtils.isEmpty(arrangeIds)) {
            return null;
        }
        return this.examArrangePaperPlusDao.groupArrangePaperNums(arrangeIds);
    }

    @Override
    public List<Long> getStuPaperIdsByArrange(Long arrangeId) {
        return this.getPaperIdsByArrange(arrangeId, false);
    }

    @Override
    public List<Long> getOriginPaperIdsByArrange(Long arrangeId) {
        return this.getPaperIdsByArrange(arrangeId, true);
    }

    @Override
    public boolean isFixPaper(Long arrangeId) {
        if (arrangeId == null) {
            return false;
        }
        ExamArrangePaperQuery examArrangePaperQuery = new ExamArrangePaperQuery();
        examArrangePaperQuery.setArrangeId(arrangeId);
        List examArrangePapers = this.findAll(examArrangePaperQuery);
        if (examArrangePapers == null || examArrangePapers.isEmpty()) {
            return false;
        }
        int fixedNum = 0;
        int otherNum = 0;
        for (ExamArrangePaper ap : examArrangePapers) {
            if (ap.getPapertype() == null || ap.getPaperId() == null) continue;
            int paperType = ap.getPapertype();
            if (paperType == ExamPapermethodEnum.PAPERMETHOD_Fixed.getIndex()) {
                ++fixedNum;
                continue;
            }
            ++otherNum;
        }
        return fixedNum > 0 && otherNum == 0;
    }

    @Override
    public int getPaperUsedCount(Long paperId) {
        return this.examArrangePaperPlusDao.getPaperUsedCount(paperId);
    }

    private List<Long> getPaperIdsByArrange(Long arrangeId, boolean isOrigin) {
        if (arrangeId == null) {
            return null;
        }
        ExamArrangePaperQuery examArrangePaperQuery = new ExamArrangePaperQuery();
        examArrangePaperQuery.setColumns("paperId, papertype");
        examArrangePaperQuery.setArrangeId(arrangeId);
        examArrangePaperQuery.getPage().setSortColumns("paperId");
        List examArrangePapers = this.findAll(examArrangePaperQuery);
        if (examArrangePapers == null || examArrangePapers.isEmpty()) {
            return null;
        }
        ArrayList<Long> paperIds = new ArrayList<Long>();
        for (ExamArrangePaper ap : examArrangePapers) {
            if (ap.getPapertype() == null || ap.getPaperId() == null) continue;
            int paperType = ap.getPapertype();
            if (paperType == ExamPapermethodEnum.PAPERMETHOD_Fixed.getIndex()) {
                paperIds.add(ap.getPaperId());
                continue;
            }
            if (isOrigin) {
                if (paperType == ExamPapermethodEnum.PAPERMETHOD_Gen.getIndex()) continue;
                paperIds.add(ap.getPaperId());
                continue;
            }
            if (paperType != ExamPapermethodEnum.PAPERMETHOD_Gen.getIndex()) continue;
            paperIds.add(ap.getPaperId());
        }
        return paperIds;
    }
}

