/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examarrange.service.imple;

import com.alibaba.fastjson2.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.RedisService;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.examplus.service.IExamplusService;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examarrange.bo.ExamArrangeBO;
import com.peak.mng.exam.examarrange.bo.ExamArrangeQueryBO;
import com.peak.mng.exam.examarrange.bo.ExamRefArrangeQueryBO;
import com.peak.mng.exam.examseries.bo.ExamSeriesPhasecontentQueryBO;
import com.peak.prd.appsecurity.org.util.OrgCoreUtil;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.enroll.enroll.service.IEnrollEnrollPlusService;
import com.peak.prd.enroll.enroll.vo.EnrollEnrollVO;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.enums.ExamAgentEnum;
import com.peak.prd.enums.ExamMethodEnum;
import com.peak.prd.enums.ExamResourceRelationEnum;
import com.peak.prd.enums.ExamResponseStatusEnum;
import com.peak.prd.enums.ExamSeriesTypeEnum;
import com.peak.prd.enums.ExamTchReadTypeEnum;
import com.peak.prd.exam.bean.PrdExamCounter;
import com.peak.prd.exam.common.vo.UserMiniVO;
import com.peak.prd.exam.examarrange.bo.ExamArrangeBusinessQueryBO;
import com.peak.prd.exam.examarrange.bo.ExamArrangeCopyBO;
import com.peak.prd.exam.examarrange.bo.ExamStuQueryBO;
import com.peak.prd.exam.examarrange.dao.IExamArrangePlusDao;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.model.ExamArrangeManager;
import com.peak.prd.exam.examarrange.model.ExamArrangePaper;
import com.peak.prd.exam.examarrange.service.IExamArrangeManagerPlusService;
import com.peak.prd.exam.examarrange.service.IExamArrangePaperPlusService;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.util.ExamArrangeUtil;
import com.peak.prd.exam.examarrange.util.ExamBranchUtil;
import com.peak.prd.exam.examarrange.vo.ExamArrangeBusinessMngVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeManagerQuery;
import com.peak.prd.exam.examarrange.vo.ExamArrangeMngVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangePaperQuery;
import com.peak.prd.exam.examarrange.vo.ExamArrangeQuery;
import com.peak.prd.exam.examarrange.vo.ExamArrangeSeriesTypeVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeUpdateChangeVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeVO;
import com.peak.prd.exam.examarrange.vo.ExamStatVO;
import com.peak.prd.exam.examarrange.vo.LessonExamArrangeVO;
import com.peak.prd.exam.examarrange.vo.MyExamArrangeVO;
import com.peak.prd.exam.examarrangerelation.model.ExamArrangeRelation;
import com.peak.prd.exam.examarrangerelation.service.IExamArrangeRelationPlusService;
import com.peak.prd.exam.examarrangerelation.vo.ExamArrangeRelationQuery;
import com.peak.prd.exam.examdocuments.model.ExamDocuments;
import com.peak.prd.exam.examdocuments.model.ExamDocumentsState;
import com.peak.prd.exam.examdocuments.service.IExamDocumentsPlusService;
import com.peak.prd.exam.examdocuments.service.IExamDocumentsStatePlusService;
import com.peak.prd.exam.examdocuments.vo.ExamDocumentsQuery;
import com.peak.prd.exam.examdocuments.vo.ExamDocumentsStateQuery;
import com.peak.prd.exam.examquestion.bo.ExamQuestionDoubtQueryBO;
import com.peak.prd.exam.examquestion.service.IExamQuestionDoubtPlusService;
import com.peak.prd.exam.examresourcerelation.model.ExamResourceRelation;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationVO;
import com.peak.prd.exam.examresult.bo.PassUserQueryBO;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.examseries.model.ExamSeriesPhase;
import com.peak.prd.exam.examseries.model.ExamSeriesPhasecontent;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasecontentPlusService;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseMngVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentMngVO;
import com.peak.prd.exam.examsubject.vo.ExamSubjectVO;
import com.peak.prd.exam.examuser.service.IExamUserPlusService;
import com.peak.prd.exception.DataAuthException;
import com.peak.prd.messageq.util.MessageQHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CacheConfig(cacheNames={"exam"})
public class ExamArrangePlusService
extends PrdBaseService<ExamArrange, Long, ExamArrangeQuery>
implements IExamArrangePlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamArrangePlusService.class);
    @Autowired
    private IExamResourceRelationPlusService examResourceRelationPlusService;
    @Autowired
    private IExamArrangeManagerPlusService examArrangeManagerPlusService;
    @Autowired
    private PrdExamConfig prdExamConfig;
    private IExamArrangePlusDao examArrangePlusDao;
    @Autowired
    private IExamResultPlusService examResultPlusService;
    @Autowired
    private IExamArrangeRelationPlusService examArrangeRelationPlusService;
    @Autowired
    private IExamDocumentsPlusService examDocumentsPlusService;
    @Autowired
    private IExamDocumentsStatePlusService examDocumentsStatePlusService;
    @Autowired
    private IExamArrangePaperPlusService examArrangePaperPlusService;
    @Autowired
    private IExamUserPlusService examUserPlusService;
    private int _cachedAlluserExamCount = -1;
    private long _cachedAlluserExamCount_ts = 0L;
    public static final String CLEAR_CACHE_REDIS_KEY_PREFIX = "exam:cacheInvalid:exam";

    public void setExamArrangePlusDao(IExamArrangePlusDao dao) {
        this.examArrangePlusDao = dao;
    }

    public IExamArrangePlusDao getExamArrangePlusDao() {
        return this.examArrangePlusDao;
    }

    public IEntityDao<ExamArrange, Long, ExamArrangeQuery> getEntityDao() {
        return this.examArrangePlusDao;
    }

    @Override
    public ExamArrange safeFindById(Long arrangeId) {
        try {
            return (ExamArrange)this.findById(arrangeId);
        }
        catch (Exception ex) {
            log.error("examArrangePlusService.findById(" + arrangeId + ") error: " + ex.getMessage());
            this._safeCounter();
            return (ExamArrange)this.getById(arrangeId);
        }
    }

    @Override
    public List<ExamArrange> safeFindByIds(List<Long> arrangeIds) {
        try {
            return this.findByIds(arrangeIds);
        }
        catch (Exception ex) {
            log.error("examArrangePlusService.findByIds(" + arrangeIds + ") error: " + ex.getMessage());
            this._safeCounter();
            return this.getByIds(arrangeIds);
        }
    }

    private void _safeCounter() {
        try {
            PrdExamCounter.getInstance().findByIdErrorNum.incrementAndGet();
            PrdExamCounter.getInstance().findByIdErrorDate = new Date();
        }
        catch (Exception ex) {
            log.error("_safeCounter error:", (Throwable)ex);
        }
    }

    @Override
    public List<MyExamArrangeVO> getMyAllList(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        return this.getMyList("all", examStuQueryBO, userId, isMobile, prj);
    }

    @Override
    public long getMyAllCount(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        if (userId == null) {
            return 0L;
        }
        ExamArrangeQuery query = this.getMyQuery("all", examStuQueryBO, userId, isMobile, prj);
        return this.examArrangePlusDao.count(query, "getMyList.count");
    }

    @Override
    public long getMyIngCount(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        if (userId == null) {
            return 0L;
        }
        ExamArrangeQuery query = this.getMyQuery("ing", examStuQueryBO, userId, isMobile, prj);
        return this.examArrangePlusDao.count(query, "getMyList.count");
    }

    @Override
    public long getMyEndCount(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        if (userId == null) {
            return 0L;
        }
        ExamArrangeQuery query = this.getMyQuery("end", examStuQueryBO, userId, isMobile, prj);
        return this.examArrangePlusDao.count(query, "getMyList.count");
    }

    @Override
    public List<MyExamArrangeVO> getMyIngList(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        return this.getMyList("ing", examStuQueryBO, userId, isMobile, prj);
    }

    @Override
    public List<MyExamArrangeVO> getMyEndList(ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        return this.getMyList("end", examStuQueryBO, userId, isMobile, prj);
    }

    @Override
    public ApiResult<Paging<MyExamArrangeVO>> getMyPaging(ExamStuQueryBO examQueryBO, Long userId, boolean isMobile, String prj, boolean needCount) {
        int pageNumber = examQueryBO.getPageNumber();
        int pageSize = examQueryBO.getPageSize();
        List<MyExamArrangeVO> vos = null;
        vos = examQueryBO.getScopeInt() == 2 ? this.getMyIngList(examQueryBO, userId, isMobile, prj) : (examQueryBO.getScopeInt() == 3 ? this.getMyEndList(examQueryBO, userId, isMobile, prj) : this.getMyAllList(examQueryBO, userId, isMobile, prj));
        Long totalCount = null;
        if (needCount) {
            int dataSize = vos == null ? 0 : vos.size();
            Long l = totalCount = dataSize < pageSize ? Long.valueOf(dataSize) : null;
            if (totalCount == null) {
                totalCount = examQueryBO.getScopeInt() == 2 ? Long.valueOf(this.getMyIngCount(examQueryBO, userId, isMobile, prj)) : (examQueryBO.getScopeInt() == 3 ? Long.valueOf(this.getMyEndCount(examQueryBO, userId, isMobile, prj)) : Long.valueOf(this.getMyAllCount(examQueryBO, userId, isMobile, prj)));
            }
        }
        if (!needCount) {
            totalCount = vos == null ? 0L : (long)vos.size();
        }
        Paging paging = new Paging(pageNumber, pageSize);
        paging.setTotalCount(totalCount.longValue());
        paging.setList(vos);
        return ApiResult.okData((Object)paging);
    }

    @Override
    public List<MyExamArrangeVO> getMyList(List<Long> examIds, Long userId) {
        if (examIds == null || examIds.isEmpty() || userId == null) {
            return null;
        }
        List exams = this.examArrangePlusDao.getByIds(examIds);
        return this.getMyVOList(exams, userId);
    }

    @Override
    public ExamArrange getByRef(String refObjIds, int refObjType) {
        return ((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).getByRef(refObjIds, refObjType, true);
    }

    private ExamArrangeQuery getMyQuery(String type, ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        Date now = new Date();
        ExamArrangeQuery query = (ExamArrangeQuery)ConvertUtil.convert((Object)((Object)examStuQueryBO), ExamArrangeQuery.class);
        query.setUserId(userId);
        query.setRefobjtype(0);
        query.setStatus(1);
        query.setExcludeExammethod(ExamMethodEnum.METHOD_OFFLINE.getValue());
        if ("ing".equals(type)) {
            query.setEndtimeBegin(now);
        } else if ("end".equals(type)) {
            query.setEndtimeEnd(now);
        }
        if (isMobile) {
            query.setSupportAgents(Arrays.asList(ExamAgentEnum.EXAM_AGENT_MOBILE.getValue(), ExamAgentEnum.EXAM_AGENT_PCMOBILE.getValue()));
        } else {
            query.setSupportAgents(Arrays.asList(ExamAgentEnum.EXAM_AGENT_PC.getValue(), ExamAgentEnum.EXAM_AGENT_PCMOBILE.getValue()));
        }
        query.setPrj(prj);
        query.setSupportSeriesExam(this.prdExamConfig.getSupportSeriesExam());
        query.setSupportAlluserExam(this.getCachedAlluserExamCount() != 0);
        if ("spdb".equals(prj) && query.getEnterway() != null && query.getEnterway() == 5) {
            query.setDomainId(null);
            query.setPrj(null);
            query.setExamseriestype(null);
            query.setExamseriestypeList(null);
            query.setSpdbBeisen(true);
        }
        if (query.isQuick()) {
            query.setSupportSeriesExam(0);
        }
        if (query.getSupportSeriesExam() != null && query.getSupportSeriesExam() == 1) {
            query.getPage().setSortColumns("ea__.begintime desc, ea__.arrangeId");
        } else {
            query.getPage().setSortColumns("ea.begintime desc, ea.arrangeId");
        }
        if (examStuQueryBO.getBranchRootId() != null) {
            List<Long> stuBranchDomainIds = ExamBranchUtil.getStuBranchDomainIds(examStuQueryBO.getBranchRootId(), userId);
            query.setArrangeDomainIds(stuBranchDomainIds);
            if (log.isDebugEnabled()) {
                log.debug("branchRootId:" + examStuQueryBO.getBranchRootId() + ", stuBranchDomainIds:" + stuBranchDomainIds);
            }
        }
        return query;
    }

    private List<MyExamArrangeVO> getMyList(String type, ExamStuQueryBO examStuQueryBO, Long userId, boolean isMobile, String prj) {
        if (userId == null) {
            return null;
        }
        ExamArrangeQuery query = this.getMyQuery(type, examStuQueryBO, userId, isMobile, prj);
        List exams = this.examArrangePlusDao.findList(query, "getMyList");
        return this.getMyVOList(exams, userId, prj);
    }

    @Override
    public List<MyExamArrangeVO> getMyVOList(List<ExamArrange> exams, Long userId) {
        return this.getMyVOList(exams, userId, null);
    }

    private List<MyExamArrangeVO> getMyVOList(List<ExamArrange> exams, Long userId, String prj) {
        for (int i = 0; exams != null && i < exams.size(); ++i) {
            ExamArrange exam = exams.get(i);
            Integer ctm = exam.getCaltimemethod();
            if (ctm == null || ctm != 0 || exam.getPaperanswertime() == null) continue;
            exam.setEndtime(new Date(exam.getBegintime().getTime() + (long)(exam.getPaperanswertime() * 60000)));
        }
        List<MyExamArrangeVO> vos = ExamArrangeUtil.convert(exams, MyExamArrangeVO.class);
        List results = this.examResultPlusService.getUserExamResultList(userId, IdUtil.getIds(vos, vo -> vo.getArrangeId()), false);
        results = ConvertUtil.refact(vos, results, (vo, r) -> vo.getArrangeId().equals(r.getArrangeId()));
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            MyExamArrangeVO vo2 = vos.get(i);
            vo2.setExamnotes(null);
            ExamArrangeUtil.setPropertiesByExamResult(vo2, (ExamResult)results.get(i));
        }
        if ("spdb".equals(prj)) {
            OrgCoreUtil.setOrgName(vos, ExamArrangeVO::getSponsorId, ExamArrangeVO::setSponsorName);
        }
        return vos;
    }

    private ExamArrange innerGetByRef(String refObjIds, int refObjType) {
        if (refObjIds == null || refObjIds.isEmpty()) {
            return null;
        }
        ExamArrangeQuery query = new ExamArrangeQuery();
        query.setEqualRefobjids(refObjIds);
        query.setRefobjtype(refObjType);
        return (ExamArrange)this.examArrangePlusDao.findOne(query);
    }

    @CacheEvict(key="'ExamArrangePlusService:getByRef:' + #refObjIds + '_' + #refObjType")
    public void _clearCache_getByRef(String refObjIds, int refObjType) {
        log.info("_clearCache_getByRef({}, {}) called", (Object)refObjIds, (Object)refObjType);
    }

    @Override
    @Cacheable(key="'ExamArrangePlusService:getByRef:' + #refObjIds + '_' + #refObjType", condition="#cacheable")
    public ExamArrange getByRef(String refObjIds, int refObjType, boolean cacheable) {
        if (refObjIds == null || refObjIds.isEmpty()) {
            return null;
        }
        ExamArrange examArrange = this.innerGetByRef(refObjIds, refObjType);
        if (examArrange == null) {
            Long id0 = null;
            id0 = refObjIds.indexOf(",") > 0 ? Long.valueOf(refObjIds.split(",")[0]) : Long.valueOf(refObjIds);
            ExamArrangeRelationQuery earQuery = new ExamArrangeRelationQuery();
            earQuery.setResourceId(id0);
            earQuery.setResourcetype(refObjType);
            earQuery.getPage().setSortColumns("EARID");
            List earList = this.examArrangeRelationPlusService.findAll(earQuery);
            for (int j = 0; earList != null && j < earList.size() && (examArrange = (ExamArrange)this.getById(((ExamArrangeRelation)earList.get(j)).getArrangeId())) == null; ++j) {
            }
        }
        return examArrange;
    }

    @Override
    public List<ExamArrange> getListByRef(String[] refObjIdArray, Integer[] refObjTypeArray) {
        return ((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).getListByRef(refObjIdArray, refObjTypeArray, true);
    }

    @Override
    @Cacheable(key="'refs:' + #refIdAry + '_' + #refTypeAry", condition="#cacheable")
    public List<ExamArrange> getListByRef(String[] refIdAry, Integer[] refTypeAry, boolean cacheable) {
        ArrayList<ExamArrange> exams = new ArrayList<ExamArrange>();
        HashSet<Long> idSet = new HashSet<Long>();
        for (int i = 0; refTypeAry != null && i < refTypeAry.length; ++i) {
            ExamArrange examArrange = this.getByRef(refIdAry[i], refTypeAry[i], false);
            if (examArrange == null || idSet.contains(examArrange.getArrangeId())) continue;
            idSet.add(examArrange.getArrangeId());
            exams.add(examArrange);
        }
        idSet.clear();
        return exams;
    }

    @Override
    public Paging<ExamArrangeBusinessMngVO> getListByBusiness(ExamArrangeBusinessQueryBO examArrangeBusinessQueryBO) {
        if (!examArrangeBusinessQueryBO.isValid()) {
            return null;
        }
        ExamArrangeQuery examArrangeQuery = (ExamArrangeQuery)ConvertUtil.convert((Object)((Object)examArrangeBusinessQueryBO), ExamArrangeQuery.class);
        examArrangeQuery.getPage().setSortColumns("ea.CREATEDATE DESC");
        Paging paging = this.examArrangePlusDao.findPaging(examArrangeQuery, ExamArrangeBusinessMngVO.class);
        List list = paging.getList();
        if (ListUtil.isNullorEmpty((List)list)) {
            return paging;
        }
        for (ExamArrangeBusinessMngVO vo : list) {
            PassUserQueryBO passUserQueryBO = new PassUserQueryBO();
            passUserQueryBO.setArrangeIds(Arrays.asList(vo.getArrangeId()));
            long passNum = this.examResultPlusService.getPassUserCountByAnyExam(passUserQueryBO);
            vo.setPassNum(passNum);
            long attendUserCountByAnyExam = this.examResultPlusService.getAttendUserCountByAnyExam(passUserQueryBO);
            vo.setAttendNum(attendUserCountByAnyExam);
        }
        return paging;
    }

    @Override
    public int getNotFinishedExamCount(Long userId, List<Long> examIds) {
        if (userId == null || examIds == null || examIds.isEmpty()) {
            return 0;
        }
        return this.examArrangePlusDao.getNotFinishedExamCount(userId, examIds);
    }

    @Override
    public ExamStatVO getExamStatVO(Long arrangeId) {
        return this.examArrangePlusDao.getExamStatVO(arrangeId);
    }

    @Override
    public List<MyExamArrangeVO> getUserYearVOList(Long userId, Integer year, Integer pageNumber, Integer pageSize) {
        if (userId == null) {
            return null;
        }
        ExamArrangeQuery query = new ExamArrangeQuery(pageNumber, pageSize);
        query.setUserId(userId);
        query.setBegintimeBegin(this.getDateByYear(year));
        query.setBegintimeEnd(this.getDateByYear(year + 1));
        query.getPage().setSortColumns("r.enterdate desc");
        List exams = this.examArrangePlusDao.findList(query, "getUserYearVOList");
        return this.getMyVOList(exams, userId);
    }

    private Date getDateByYear(Integer year) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        try {
            return sdf.parse(year.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getUserYearVOCount(Long userId, Integer year) {
        ExamArrangeQuery query = new ExamArrangeQuery(1, 1);
        query.setUserId(userId);
        query.setBegintimeBegin(this.getDateByYear(year));
        query.setBegintimeEnd(this.getDateByYear(year + 1));
        return this.examArrangePlusDao.getUserYearVOCount(query);
    }

    @Override
    public ExamSubjectVO getExamSubjectVO(Long arrangeId) {
        return this.examArrangePlusDao.getExamSubjectVO(arrangeId);
    }

    @Override
    @Cacheable(key="'ExamArrangePlusService:getCacheExamSubjectVO:' + #arrangeId")
    public ExamSubjectVO getCacheExamSubjectVO(Long arrangeId) {
        return this.getExamSubjectVO(arrangeId);
    }

    @Override
    public Paging<ExamArrangeMngVO> findVOPaging(ExamArrangeQueryBO bo, String prj) {
        return this.findVOPaging(bo, null, prj);
    }

    @Override
    public Paging<ExamArrangeMngVO> findVOPagingByResultBranch(ExamArrangeQueryBO bo, String prj) {
        return this.findVOPaging(bo, null, true, prj);
    }

    @Override
    public Paging<ExamArrangeMngVO> findVOPaging(ExamArrangeQueryBO bo, Long manangerId, String prj) {
        return this.findVOPaging(bo, manangerId, null, prj);
    }

    private Paging<ExamArrangeMngVO> findVOPaging(ExamArrangeQueryBO bo, Long manangerId, Boolean isResultBranch, String prj) {
        Date now = new Date();
        if (("spdb".equals(prj) || this.prdExamConfig.getSupportSeriesExam() == 1) && ListUtil.isNullorEmpty(bo.getExamseriestypeList())) {
            bo.setExamseriestypeList(Arrays.asList(ExamSeriesTypeEnum.TYPE_NORMAL.getValue(), ExamSeriesTypeEnum.TYPE_SERIES.getValue()));
        }
        ExamArrangeQuery query = new ExamArrangeQuery(bo.getPageNumber(), bo.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)bo), (Object)query);
        query.setDomainId(bo.getDomainId());
        query.setDomainIdIncSub(bo.isDomainIdIncSub());
        if (bo.getRefobjtype() == null) {
            query.setRefobjtype(0);
        } else if (bo.getRefobjtype() == -1) {
            query.setRefobjtype(null);
        }
        if (bo.getScopeInt() == 2) {
            query.setEndtimeBegin(now);
        } else if (bo.getScopeInt() == 3) {
            query.setEndtimeEnd(now);
        }
        query.getPage().setSortColumns("ea.createdate desc");
        query.setPrj(prj);
        query.setManagerId(manangerId);
        query.setResultBranch(isResultBranch);
        query = (ExamArrangeQuery)this.findPage(query);
        List<ExamArrangeMngVO> vos = this.toMngVOs(query.getPage().getResult());
        Paging paging = new Paging(query.getPage(), vos);
        if (paging != null && paging.getList() != null) {
            for (int i = 0; i < paging.getList().size(); ++i) {
                if (((ExamArrangeMngVO)paging.getList().get(i)).getExamseriestype() != null) continue;
                ((ExamArrangeMngVO)paging.getList().get(i)).setExamseriestype(ExamSeriesTypeEnum.TYPE_NORMAL.getValue());
            }
        }
        return paging;
    }

    @Override
    public List<ExamArrangeMngVO> findMngVOs(ExamRefArrangeQueryBO refArrangeQueryBO) {
        if (refArrangeQueryBO == null || !refArrangeQueryBO.isValid()) {
            return null;
        }
        if (!ListUtil.isNullorEmpty(refArrangeQueryBO.getArrangeIds())) {
            return this.findMngVOs(refArrangeQueryBO.getArrangeIds());
        }
        ExamArrangeQueryBO arrangeQueryBO = (ExamArrangeQueryBO)((Object)ConvertUtil.convert((Object)refArrangeQueryBO, ExamArrangeQueryBO.class));
        Paging<ExamArrangeMngVO> paging = this.findVOPaging(arrangeQueryBO, null);
        return paging.getList();
    }

    @Override
    public List<ExamArrangeMngVO> findMngVOs(List<Long> arrangeIds) {
        if (arrangeIds == null) {
            return null;
        }
        if (arrangeIds.isEmpty()) {
            return new ArrayList<ExamArrangeMngVO>();
        }
        List list = this.getByIds(arrangeIds);
        List<ExamArrangeMngVO> vos = this.toMngVOs(list);
        return vos;
    }

    private List<ExamArrangeMngVO> toMngVOs(List<ExamArrange> arranges) {
        List arrangeIds = IdUtil.getIds(arranges, e -> e.getArrangeId());
        List vos = ConvertUtil.convert(arranges, ExamArrangeMngVO.class);
        UserCoreUtil.setUserRealname((List)vos, ExamArrangeMngVO::getCreatorId, ExamArrangeMngVO::setCreatorName);
        OrgUtil.setOrgName((List)vos, ExamArrangeMngVO::getDomainId, ExamArrangeMngVO::setDomainName);
        OrgUtil.setOrgName((List)vos, ExamArrangeMngVO::getSponsorId, ExamArrangeMngVO::setSponsorName);
        this.fetchSubjectInfo(vos);
        List<ExamArrangeNumVO> paperNums = this.examArrangePaperPlusService.groupArrangePaperNums(arrangeIds);
        List<ExamArrangeNumVO> userNums = this.examUserPlusService.groupArrangeUserNums(arrangeIds);
        List<ExamArrangeNumVO> doubtNums = null;
        if ("huaneng".equals(this.prdExamConfig.getPrj())) {
            ExamQuestionDoubtQueryBO examQuestionDoubtQueryBO = new ExamQuestionDoubtQueryBO();
            examQuestionDoubtQueryBO.setArrangeIds(arrangeIds);
            examQuestionDoubtQueryBO.setAdminstatus(0);
            doubtNums = ((IExamQuestionDoubtPlusService)SpringUtil.getBean(IExamQuestionDoubtPlusService.class)).groupArrangeQuestionDoubtNums(examQuestionDoubtQueryBO);
        }
        block0: for (int i = 0; vos != null && i < vos.size(); ++i) {
            ExamArrangeNumVO numVO;
            int j;
            ExamArrangeMngVO vo = (ExamArrangeMngVO)vos.get(i);
            vo.setIsSetPaper(0);
            vo.setIsSetUser(0);
            for (j = 0; paperNums != null && j < paperNums.size(); ++j) {
                numVO = paperNums.get(j);
                if (!vo.getArrangeId().equals(numVO.getArrangeId())) continue;
                vo.setIsSetPaper(numVO.isPositiveNum() ? 1 : 0);
                break;
            }
            for (j = 0; userNums != null && j < userNums.size(); ++j) {
                numVO = userNums.get(j);
                if (!vo.getArrangeId().equals(numVO.getArrangeId())) continue;
                vo.setIsSetUser(numVO.isPositiveNum() ? 1 : 0);
                break;
            }
            for (j = 0; doubtNums != null && j < doubtNums.size(); ++j) {
                numVO = doubtNums.get(j);
                if (!vo.getArrangeId().equals(numVO.getArrangeId())) continue;
                vo.setQuestionDoubtUnreadNum(numVO.getNumInteger());
                continue block0;
            }
        }
        return vos;
    }

    @Override
    public Long insert(Long creatorId, Long domainId, ExamArrangeBO bo) {
        ExamArrange examArrange = new ExamArrange();
        this.doProcessBO(bo);
        ConvertUtil.copyProperties((Object)bo, (Object)examArrange);
        examArrange.setArrangeId(IdUtil.getSequence((String)"EXAM_ARRANGE"));
        examArrange.setGkey(IdUtil.getGkey());
        examArrange.setStatus(0);
        examArrange.setCreatorId(creatorId);
        examArrange.setCreatedate(new Date());
        examArrange.setDomainId(domainId);
        examArrange.setExammethod(bo.getExammethod() == null ? Integer.valueOf(1) : bo.getExammethod());
        if (examArrange.getRefobjtype() == null) {
            examArrange.setRefobjtype(0);
        }
        if (bo.getExamseriestype() == null) {
            examArrange.setExamseriestype(0);
        }
        if (this.prdExamConfig.isPrj("spdb")) {
            examArrange.setSingletime(0);
            examArrange.setCanenterfor(1);
            examArrange.setAnswertype(2);
            examArrange.setPassmarkoffline(60);
        }
        examArrange.setTchreadtype(bo.getTchreadtypeInt());
        this.insert((BaseEntity)examArrange);
        this.saveSubject(examArrange.getArrangeId(), bo.getSubjectId(), creatorId);
        this.saveManagers(examArrange.getArrangeId(), creatorId, domainId, bo.getManagers());
        return examArrange.getArrangeId();
    }

    @Override
    public ExamArrangeUpdateChangeVO update(Long userId, Long domainId, ExamArrangeBO bo) {
        boolean isHzbankPrj;
        ExamArrangeUpdateChangeVO changeVO = new ExamArrangeUpdateChangeVO();
        changeVO.setOldExamArrange((ExamArrange)this.getById(bo.getArrangeId()));
        ExamArrange examArrange = (ExamArrange)this.getById(bo.getArrangeId());
        if (examArrange == null) {
            return changeVO;
        }
        int oldTchreadtype = ExamTchReadTypeEnum.getTchreadtypeInt(examArrange.getTchreadtype());
        if (examArrange.getExamseriestype() == null) {
            examArrange.setExamseriestype(0);
        }
        bo.setEnterway(examArrange.getEnterway());
        bo.setExamseriestype(examArrange.getExamseriestype());
        this.doProcessBO(bo);
        examArrange.setModifierId(userId);
        examArrange.setModifydate(new Date());
        ConvertUtil.copyProperties((Object)bo, (Object)examArrange);
        if (examArrange.getTchreadtype() == null) {
            examArrange.setTchreadtype(bo.getTchreadtypeInt());
        }
        if (isHzbankPrj = "hzbank".equals(this.prdExamConfig.getPrj())) {
            examArrange.setTchreadtype(oldTchreadtype);
        }
        int affectRows = this.update(examArrange);
        changeVO.setAffectRows(affectRows);
        this.saveSubject(examArrange.getArrangeId(), bo.getSubjectId(), userId);
        this.saveManagers(examArrange.getArrangeId(), userId, domainId, bo.getManagers());
        ((ExamArrangePlusService)SpringUtil.getBean(ExamArrangePlusService.class)).clearCache(examArrange.getArrangeId());
        changeVO.setNewExamArrange((ExamArrange)this.getById(bo.getArrangeId()));
        return changeVO;
    }

    @Override
    public ExamArrangeUpdateChangeVO updateExamArrange(ExamArrange examArrange) {
        return this.updateExamArrange(examArrange, false);
    }

    @Override
    public ExamArrangeUpdateChangeVO updateSelectiveExamArrange(ExamArrange examArrange) {
        return this.updateExamArrange(examArrange, true);
    }

    private ExamArrangeUpdateChangeVO updateExamArrange(ExamArrange examArrange, boolean isUpdateSelective) {
        ExamArrangeUpdateChangeVO changeVO = new ExamArrangeUpdateChangeVO();
        if (examArrange == null || examArrange.getArrangeId() == null) {
            return changeVO;
        }
        changeVO.setOldExamArrange((ExamArrange)this.getById(examArrange.getArrangeId()));
        int affectRows = isUpdateSelective ? this.updateSelective(examArrange) : this.update(examArrange);
        changeVO.setAffectRows(affectRows);
        changeVO.setNewExamArrange((ExamArrange)this.getById(examArrange.getArrangeId()));
        return changeVO;
    }

    private void doProcessBO(ExamArrangeBO bo) {
        if (bo.getCaltimemethod() != null && bo.getCaltimemethod() == 0 && bo.getBegintime() != null && bo.getPaperanswertime() != null) {
            bo.setEndtime(new Date(bo.getBegintime().getTime() + (long)(bo.getPaperanswertime() * 60 * 1000)));
        }
    }

    private void saveManagers(Long arrangeId, Long currUserId, Long currMngDomainId, List<Long> manageUserIds) {
        if (arrangeId == null) {
            return;
        }
        Date now = new Date();
        ExamArrangeManagerQuery query = new ExamArrangeManagerQuery();
        query.setArrangeId(arrangeId);
        List oldArrangeManagers = this.examArrangeManagerPlusService.findAll(query);
        List oldUserIds = IdUtil.getIds((List)oldArrangeManagers, e -> e.getUserId());
        for (int i = 0; oldArrangeManagers != null && i < oldArrangeManagers.size(); ++i) {
            Long oldUserId = ((ExamArrangeManager)oldArrangeManagers.get(i)).getUserId();
            if (oldUserId != null && manageUserIds != null && manageUserIds.contains(oldUserId)) continue;
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("arrangeId", arrangeId);
            map.put("userId", oldUserId);
            this.examArrangeManagerPlusService.deleteById(map);
        }
        ArrayList<ExamArrangeManager> list = new ArrayList<ExamArrangeManager>();
        for (int i = 0; manageUserIds != null && i < manageUserIds.size(); ++i) {
            boolean notExisted;
            ExamArrangeManager sr = new ExamArrangeManager(arrangeId, manageUserIds.get(i));
            sr.setCreatedate(now);
            boolean bl = notExisted = oldUserIds == null || oldUserIds.isEmpty() || !oldUserIds.contains(manageUserIds.get(i));
            if (!notExisted) continue;
            list.add(sr);
        }
        if (!list.isEmpty()) {
            this.examArrangeManagerPlusService.insertBatch(list);
        }
    }

    @Override
    public ExamArrangeMngVO getExamArrangeMngVO(Long arrangeId) {
        ExamArrange model = (ExamArrange)this.getById(arrangeId);
        if (model == null) {
            return null;
        }
        ExamArrangeMngVO vo = this.findMngVOs(Arrays.asList(arrangeId)).get(0);
        List<ExamArrangeMngVO> vos = Arrays.asList(vo);
        OrgUtil.setOrgName(vos, ExamArrangeMngVO::getSponsorId, ExamArrangeMngVO::setSponsorName);
        ExamArrangeManagerQuery maintainerQuery = new ExamArrangeManagerQuery();
        maintainerQuery.setArrangeId(arrangeId);
        List maintainerModels = this.examArrangeManagerPlusService.findAll(maintainerQuery);
        List maintainers = ConvertUtil.convert((List)maintainerModels, UserMiniVO.class);
        UserCoreUtil.setUserRealname((List)maintainers, UserMiniVO::getUserId, UserMiniVO::setRealname);
        vo.setManagers(maintainers);
        return vo;
    }

    private void fetchSubjectInfo(List<ExamArrangeMngVO> vos) {
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery();
        examResourceRelationQuery.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_EXAM.getValue());
        examResourceRelationQuery.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_SUBJECT.getValue());
        examResourceRelationQuery.getPage().setPageSize(100);
        List arrangeIds = IdUtil.getIds(vos, e -> e.getArrangeId());
        examResourceRelationQuery.setExamresourceIds(arrangeIds);
        List errVOs = CollectionUtils.isEmpty((Collection)arrangeIds) ? null : this.examResourceRelationPlusService.getPrdEntityDao().findList((IQuery)examResourceRelationQuery, "findVOAll", ExamResourceRelationVO.class);
        List sortedErrVOs = ConvertUtil.refact((List)arrangeIds, errVOs, (p, r) -> r == null ? false : p.equals(r.getExamresourceId()));
        ConvertUtil.setProperties(vos, (List)sortedErrVOs, (v, r) -> v.setSubjectId(r == null ? null : r.getResourceId()));
        ConvertUtil.setProperties(vos, (List)sortedErrVOs, (v, r) -> v.setSubjectName(r == null ? null : r.getResourceName()));
    }

    private void saveSubject(Long arrangeId, Long subjectId, Long userId) {
        if (arrangeId == null) {
            return;
        }
        Long rtId = IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION");
        ExamResourceRelation examResourceRelation_Subject = new ExamResourceRelation();
        examResourceRelation_Subject.setRtId(rtId);
        examResourceRelation_Subject.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_SUBJECT.getValue());
        examResourceRelation_Subject.setResourceId(subjectId);
        examResourceRelation_Subject.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_EXAM.getValue());
        examResourceRelation_Subject.setExamresourceId(arrangeId);
        examResourceRelation_Subject.setCreatedate(new Date());
        examResourceRelation_Subject.setCreatorId(userId);
        ExamResourceRelationQuery query = new ExamResourceRelationQuery();
        query.setExamresourceId(examResourceRelation_Subject.getExamresourceId());
        query.setExamtype(examResourceRelation_Subject.getExamtype());
        query.setResourcetype(examResourceRelation_Subject.getResourcetype());
        this.examResourceRelationPlusService.deleteByQuery(query);
        if (subjectId != null) {
            this.examResourceRelationPlusService.insert((BaseEntity)examResourceRelation_Subject);
        }
    }

    @Override
    public int deleteExamArrange(Long arrangeId) {
        ExamArrange examArrange;
        ExamArrange examArrange2 = examArrange = arrangeId == null ? null : (ExamArrange)this.getById(arrangeId);
        if (examArrange == null) {
            return 0;
        }
        long count = this.examResultPlusService.countByExamId(arrangeId);
        if (count > 0L) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_DELETE_FAIL_USED);
            return 0;
        }
        this.examArrangePaperPlusService.deleteByArrangeId(arrangeId);
        this.examUserPlusService.deleteByArrangeId(arrangeId);
        int affectNum = this.deleteById(arrangeId);
        if (this.prdExamConfig.getMessageQ() == 1) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"businessId", (Object)arrangeId);
            jsonObject.put((Object)"businesstype", (Object)BusinessOrigin.EXAM.getIndex());
            MessageQHelper.send((String)"enroll", (Long)arrangeId, (String)"publishcancel", (Object)jsonObject);
            Integer seriestype = examArrange.getExamseriestype();
            if (seriestype != null && seriestype.intValue() == ExamSeriesTypeEnum.TYPE_SERIES.getValue()) {
                List<ExamSeriesPhaseMngVO> phases = ((IExamSeriesPhasePlusService)SpringUtil.getBean(IExamSeriesPhasePlusService.class)).findMngVOList(examArrange.getArrangeId());
                for (int i = 0; phases != null && i < phases.size(); ++i) {
                    ExamSeriesPhasecontentQueryBO examSeriesPhasecontentQueryBO = new ExamSeriesPhasecontentQueryBO();
                    examSeriesPhasecontentQueryBO.setPhaseId(phases.get(i).getPhaseId());
                    List<ExamSeriesPhasecontentMngVO> contents = ((IExamSeriesPhasecontentPlusService)SpringUtil.getBean(IExamSeriesPhasecontentPlusService.class)).findMngVOList(examSeriesPhasecontentQueryBO);
                    for (int j = 0; contents != null && j < contents.size(); ++j) {
                        Long contentId = contents.get(j).getContentId();
                        jsonObject = new JSONObject();
                        jsonObject.put((Object)"businessId", (Object)contentId);
                        jsonObject.put((Object)"businesstype", (Object)BusinessOrigin.EXAM.getIndex());
                        MessageQHelper.send((String)"enroll", (Long)arrangeId, (String)"publishcancel", (Object)jsonObject);
                    }
                }
            }
        }
        return affectNum;
    }

    @Override
    public int deleteRefExamArrange(Long arrangeId) {
        ExamArrange examArrange = (ExamArrange)this.getById(arrangeId);
        if (examArrange == null) {
            return 0;
        }
        if (examArrange.getRefobjtype() == null || examArrange.getRefobjtype() == 0) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_DELETE_FAIL_NOT_REF_EXAM);
            return 0;
        }
        return this.deleteExamArrange(arrangeId);
    }

    @Override
    @Cacheable
    public String getTitle(Long arrangeId) {
        ExamArrange exam = (ExamArrange)this.getById(arrangeId);
        if (exam == null) {
            return null;
        }
        return exam.getTitle();
    }

    @Override
    public Long txCopy(Long arrangeId, Long currUserId, Long currDomainId, String prj) {
        ExamArrangeCopyBO copyBO = new ExamArrangeCopyBO(arrangeId);
        copyBO.setCreatorId(currUserId);
        copyBO.setDomainId(currDomainId);
        return this.txCopy(copyBO, prj);
    }

    @Override
    public Long txCopy(ExamArrangeCopyBO copyBO, String prj) {
        Long arrangeId = copyBO.getArrangeId();
        ExamArrange examArrange = (ExamArrange)this.getById(arrangeId);
        if (examArrange == null) {
            return null;
        }
        if (examArrange.getExamseriestype() != null && examArrange.getExamseriestype().intValue() == ExamSeriesTypeEnum.TYPE_SERIES.getValue()) {
            return this.copySeries(examArrange, copyBO.getCreatorId(), copyBO.getDomainId(), prj);
        }
        return this.copyArrange(null, copyBO, prj, true);
    }

    private Long copySeries(ExamArrange examSeries, Long currUserId, Long currDomainId, String prj) {
        Date now = new Date();
        Long oldSeriesId = examSeries.getArrangeId();
        Long newSeriesId = IdUtil.getSequence((String)"EXAM_ARRANGE");
        ExamArrangeCopyBO copyBO = null;
        IExamSeriesPhasePlusService examSeriesPhasePlusService = (IExamSeriesPhasePlusService)SpringUtil.getBean(IExamSeriesPhasePlusService.class);
        IExamSeriesPhasecontentPlusService examSeriesPhasecontentPlusService = (IExamSeriesPhasecontentPlusService)SpringUtil.getBean(IExamSeriesPhasecontentPlusService.class);
        List<ExamSeriesPhaseMngVO> phaseVOs = examSeriesPhasePlusService.findMngVOList(oldSeriesId);
        for (int i = 0; phaseVOs != null && i < phaseVOs.size(); ++i) {
            ExamSeriesPhaseMngVO phaseMngVO = phaseVOs.get(i);
            ExamSeriesPhasecontentQueryBO contentQuery = new ExamSeriesPhasecontentQueryBO(phaseMngVO.getPhaseId());
            List<ExamSeriesPhasecontentMngVO> contentVOs = examSeriesPhasecontentPlusService.findMngVOList(contentQuery);
            Long newPhaseId = IdUtil.getSequence((String)"EXAM_SERIES_PHASE");
            for (int j = 0; contentVOs != null && j < contentVOs.size(); ++j) {
                ExamSeriesPhasecontentMngVO contentVO = contentVOs.get(j);
                copyBO = new ExamArrangeCopyBO(contentVO.getContentId(), currUserId, currDomainId);
                Long newContentId = this.copyArrange(null, copyBO, prj, false);
                ExamSeriesPhasecontent newContentModel = new ExamSeriesPhasecontent();
                newContentModel.setId(IdUtil.getSequence((String)"EXAM_SERIES_PHASECONTENT"));
                newContentModel.setPhaseId(newPhaseId);
                newContentModel.setContentId(newContentId);
                newContentModel.setDeleted(0);
                newContentModel.setCreateId(currUserId);
                newContentModel.setCreatedate(now);
                newContentModel.setOrdernum(contentVO.getOrdernum());
                examSeriesPhasecontentPlusService.insert((BaseEntity)newContentModel);
            }
            ExamSeriesPhase newPhaseModel = (ExamSeriesPhase)ConvertUtil.convert((Object)phaseMngVO, ExamSeriesPhase.class);
            newPhaseModel.setPhaseId(newPhaseId);
            newPhaseModel.setSeriesId(newSeriesId);
            newPhaseModel.setCreateId(currUserId);
            newPhaseModel.setCreatedate(now);
            newPhaseModel.setDeleted(0);
            examSeriesPhasePlusService.insert((BaseEntity)newPhaseModel);
        }
        copyBO = new ExamArrangeCopyBO(oldSeriesId, currUserId, currDomainId);
        this.copyArrange(newSeriesId, copyBO, prj, true);
        return newSeriesId;
    }

    private Long copyArrange(Long arrangeIdNew, ExamArrangeCopyBO copyBO, String prj, boolean rename) {
        Date now = new Date();
        Long arrangeIdOld = copyBO.getArrangeId();
        Long currUserId = copyBO.getCreatorId();
        Long currDomainId = copyBO.getDomainId();
        ExamArrange examArrange = (ExamArrange)this.getById(arrangeIdOld);
        if (examArrange == null) {
            return null;
        }
        if (arrangeIdNew == null) {
            arrangeIdNew = IdUtil.getSequence((String)"EXAM_ARRANGE");
        }
        examArrange.setArrangeId(arrangeIdNew);
        examArrange.setFromId("internal" + arrangeIdOld);
        examArrange.setCreatorId(currUserId);
        examArrange.setCreatedate(now);
        examArrange.setModifierId(currUserId);
        examArrange.setModifydate(now);
        examArrange.setStatus(0);
        examArrange.setGkey(IdUtil.getGkey());
        if (StringUtil.isNullorEmptyStr((String)copyBO.getRefobjtitle())) {
            examArrange.setTitle(rename ? examArrange.getTitle() + "_\u590d\u5236_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) : examArrange.getTitle());
        } else {
            examArrange.setTitle(copyBO.getRefobjtitle());
        }
        ExamArrangeMngVO mngVO = this.getExamArrangeMngVO(arrangeIdOld);
        examArrange.setRefobjtype(copyBO.getRefobjtype() == null ? Integer.valueOf(0) : copyBO.getRefobjtype());
        examArrange.setRefobjids(copyBO.getRefobjids());
        examArrange.setMarkverify(0);
        this.insert((BaseEntity)examArrange);
        this.saveSubject(examArrange.getArrangeId(), mngVO.getSubjectId(), currUserId);
        if ("spdb".equalsIgnoreCase(prj)) {
            this.copyArrangeDocuments(arrangeIdOld, arrangeIdNew, currUserId);
        } else {
            this.copyArrangePaper(arrangeIdOld, arrangeIdNew, currUserId);
        }
        if ("huaxia".equals(this.prdExamConfig.getPrj())) {
            IEnrollEnrollPlusService enrollEnrollPlusService = (IEnrollEnrollPlusService)SpringUtil.getBean(IEnrollEnrollPlusService.class);
            EnrollEnrollVO enrollVO = enrollEnrollPlusService.getInfo(arrangeIdOld, Integer.valueOf(BusinessOrigin.EXAM.getIndex()));
            if (enrollVO != null && enrollVO.getEnrollId() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("exam[" + arrangeIdOld + "] has enroll[" + enrollVO.getEnrollId() + "]");
                }
                Long newEnrollId = enrollEnrollPlusService.txCopy(enrollVO.getEnrollId(), arrangeIdNew, null, enrollVO.getStatus(), currUserId, currDomainId);
                if (log.isDebugEnabled()) {
                    log.debug("exam[old:" + arrangeIdOld + ", new:" + arrangeIdNew + "] copied enroll[old:" + enrollVO.getEnrollId() + ", new:" + newEnrollId + "]");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("exam[" + arrangeIdOld + "] has no enroll");
            }
        }
        return arrangeIdNew;
    }

    private void copyArrangeDocuments(Long arrangeId, Long arrangeIdNew, Long currUserId) {
        Date now = new Date();
        ExamDocumentsQuery examDocumentsQuery = new ExamDocumentsQuery();
        examDocumentsQuery.setArrangeId(arrangeId);
        List examDocuments = this.examDocumentsPlusService.findAll(examDocumentsQuery);
        for (int i = 0; examDocuments != null && i < examDocuments.size(); ++i) {
            ExamDocuments doc = (ExamDocuments)examDocuments.get(i);
            doc.setDocumentsId(IdUtil.getSequence((String)"EXAM_DOCUMENTS"));
            doc.setGkey(IdUtil.getGkey());
            doc.setArrangeId(arrangeIdNew);
            doc.setCreatorId(currUserId);
            doc.setCreatedate(now);
        }
        if (!CollectionUtils.isEmpty((Collection)examDocuments)) {
            this.examDocumentsPlusService.insert(examDocuments);
        }
        ExamDocumentsStateQuery examDocumentsStateQuery = new ExamDocumentsStateQuery();
        examDocumentsStateQuery.setArrangeId(arrangeId);
        List examDocumentsStates = this.examDocumentsStatePlusService.findAll(examDocumentsStateQuery);
        for (int i = 0; examDocumentsStates != null && i < examDocumentsStates.size(); ++i) {
            ExamDocumentsState documentsState = (ExamDocumentsState)examDocumentsStates.get(i);
            documentsState.setStateId(IdUtil.getSequence((String)"EXAM_DOCUMENTS_STATE"));
            documentsState.setGkey(IdUtil.getGkey());
            documentsState.setArrangeId(arrangeIdNew);
            documentsState.setCreatorId(currUserId);
            documentsState.setCreatedate(now);
        }
        if (!CollectionUtils.isEmpty((Collection)examDocumentsStates)) {
            this.examDocumentsStatePlusService.insert(examDocumentsStates);
        }
    }

    private void copyArrangePaper(Long arrangeId, Long arrangeIdNew, Long currUserId) {
        Date now = new Date();
        ExamArrangePaperQuery examArrangePaperQuery = new ExamArrangePaperQuery();
        examArrangePaperQuery.setArrangeId(arrangeId);
        List examArrangePapers = this.examArrangePaperPlusService.findAll(examArrangePaperQuery);
        for (int i = 0; examArrangePapers != null && i < examArrangePapers.size(); ++i) {
            ExamArrangePaper paper = (ExamArrangePaper)examArrangePapers.get(i);
            paper.setApId(IdUtil.getSequence((String)"EXAM_ARRANGE_PAPER"));
            paper.setArrangeId(arrangeIdNew);
            paper.setCreatorId(currUserId);
            paper.setCreatedate(now);
        }
        if (!CollectionUtils.isEmpty((Collection)examArrangePapers)) {
            this.examArrangePaperPlusService.insert(examArrangePapers);
        }
    }

    @Override
    public MyExamArrangeVO getMyAfterLessonExam(Long userId, Long lessonId) {
        if (userId == null || lessonId == null) {
            return null;
        }
        ExamArrange exam = ((ExamArrangePlusService)SpringUtil.getBean(ExamArrangePlusService.class)).getByRef(lessonId.toString(), 5, true);
        if (exam == null) {
            return null;
        }
        MyExamArrangeVO vo = ExamArrangeUtil.convert(exam, MyExamArrangeVO.class);
        List<ExamResult> results = this.examResultPlusService.getUserExamResultList(userId, Arrays.asList(exam.getArrangeId()));
        if (results != null && results.size() > 0) {
            ExamArrangeUtil.setPropertiesByExamResult(vo, results.get(0));
        }
        return vo;
    }

    @Override
    public LessonExamArrangeVO getAfterLessonExam(Long lessonId) {
        if (lessonId == null) {
            return null;
        }
        ExamArrange exam = ((ExamArrangePlusService)SpringUtil.getBean(ExamArrangePlusService.class)).getByRef(lessonId.toString(), 5, true);
        if (exam == null) {
            return null;
        }
        LessonExamArrangeVO examVO = ExamArrangeUtil.convert(exam, LessonExamArrangeVO.class);
        return examVO;
    }

    @Override
    public int getCachedAlluserExamCount() {
        boolean timeout;
        long nTimeout = System.currentTimeMillis() - this._cachedAlluserExamCount_ts;
        boolean bl = timeout = nTimeout > 900000L;
        if (timeout) {
            log.warn("getCachedAlluserExamCount cache timeout[{}], return -1", (Object)nTimeout);
            return -1;
        }
        return this._cachedAlluserExamCount;
    }

    @Override
    public boolean isUpSponsor(Long arrangeId, Long currMngDomainId) {
        if (arrangeId == null || currMngDomainId == null) {
            return false;
        }
        return this.examArrangePlusDao.isUpSponsor(arrangeId, currMngDomainId);
    }

    @Override
    public boolean isSeriesAndUnifyExam(Long examId) {
        if (examId == null) {
            return false;
        }
        ExamArrange examArrange = (ExamArrange)this.getById(examId);
        if (examArrange == null || examArrange.getExamseriestype() == null || examArrange.getExamseriestype().intValue() != ExamSeriesTypeEnum.TYPE_SERIES.getValue()) {
            return false;
        }
        return examArrange.getIndependuser() == null || examArrange.getIndependuser() == 0;
    }

    @Override
    public ExamArrangeSeriesTypeVO getExamArrangeSeriesTypeVO(List<Long> arrangeIds) {
        if (ListUtil.isNullorEmpty(arrangeIds)) {
            return null;
        }
        IExamSeriesPhasePlusService examSeriesPhasePlusService = (IExamSeriesPhasePlusService)SpringUtil.getBean(IExamSeriesPhasePlusService.class);
        ExamArrangeSeriesTypeVO ret = new ExamArrangeSeriesTypeVO();
        ArrayList<Long> normalExamIds = new ArrayList<Long>();
        ArrayList<Long> seriesExamIds = new ArrayList<Long>();
        ArrayList<Long> phaseExamIds = new ArrayList<Long>();
        ArrayList<Long> seriesExamIdsByPhaseExamIds = new ArrayList<Long>();
        List examArranges = this.examArrangePlusDao.getByIds(arrangeIds);
        for (int i = 0; examArranges != null && i < examArranges.size(); ++i) {
            ExamArrange arrange = (ExamArrange)examArranges.get(i);
            if (arrange.getExamseriestype() == null || arrange.getExamseriestype().intValue() == ExamSeriesTypeEnum.TYPE_NORMAL.getValue()) {
                normalExamIds.add(arrange.getArrangeId());
                continue;
            }
            if (arrange.getExamseriestype().intValue() == ExamSeriesTypeEnum.TYPE_SERIES.getValue()) {
                seriesExamIds.add(arrange.getArrangeId());
                continue;
            }
            if (arrange.getExamseriestype().intValue() != ExamSeriesTypeEnum.TYPE_PHASEEXAM.getValue()) continue;
            phaseExamIds.add(arrange.getArrangeId());
            Long seriesId = examSeriesPhasePlusService.getSeriesIdByPhasecontentId(arrange.getArrangeId());
            if (seriesId == null || seriesExamIdsByPhaseExamIds.contains(seriesId)) continue;
            seriesExamIdsByPhaseExamIds.add(seriesId);
        }
        ret.setNormalExamIds(normalExamIds);
        ret.setSeriesExamIds(seriesExamIds);
        ret.setPhaseExamIds(phaseExamIds);
        ret.setSeriesExamIdsByPhaseExamIds(seriesExamIdsByPhaseExamIds);
        return ret;
    }

    public void reloadAlluserExamCount() {
        ExamArrangeQuery query = new ExamArrangeQuery(1, 1);
        query.setIsalluser(1);
        query.setStatus(1);
        query.setColumns("status");
        List alluserExams = this.examArrangePlusDao.findList(query);
        this._cachedAlluserExamCount = ListUtil.isNullorEmpty((List)alluserExams) ? 0 : 1;
        this._cachedAlluserExamCount_ts = System.currentTimeMillis();
        log.info("reloadAlluserExamCount: {}", (Object)this._cachedAlluserExamCount);
    }

    public Object getVOById(Long arrangeId, Class clazz) {
        ExamArrange examArrange = (ExamArrange)((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).findById(arrangeId);
        ExamArrangeVO examArrangeVO = (ExamArrangeVO)ConvertUtil.convert((Object)examArrange, ExamArrangeVO.class);
        return examArrangeVO;
    }

    public List<ExamArrange> dataAuth(List<Long> arrangeIds, Long currUserId, Long curMngDomainId) {
        ArrayList<ExamArrange> arranges = new ArrayList<ExamArrange>();
        for (int i = 0; arrangeIds != null && i < arrangeIds.size(); ++i) {
            arranges.add(this.dataAuth(arrangeIds.get(i), currUserId, curMngDomainId));
        }
        return arranges;
    }

    public ExamArrange dataAuth(Long arrangeId, Long currUserId, Long curMngDomainId) {
        try {
            return (ExamArrange)super.dataAuth(arrangeId, currUserId, curMngDomainId);
        }
        catch (DataAuthException exception) {
            boolean isManager = this.examArrangeManagerPlusService.isManager(arrangeId, currUserId);
            if (!isManager) {
                boolean isSponsor = false;
                if ("spdb".equals(this.prdExamConfig.getPrj())) {
                    isSponsor = this.isUpSponsor(arrangeId, curMngDomainId);
                }
                if (!isSponsor) {
                    throw exception;
                }
            }
            return (ExamArrange)this.getById(arrangeId);
        }
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="'ExamArrangePlusService:' + #examId"), @CacheEvict(cacheNames={"exam"}, key="'ExamArrangePlusService:' + #examId"), @CacheEvict(key="'ExamArrangePlusService:getCacheExamSubjectVO:' + #arrangeId")})
    public void clearCache(Long examId) {
        ExamArrange examArrange = (ExamArrange)this.getById(examId);
        if (examArrange == null) {
            return;
        }
        Integer refobjtype = examArrange.getRefobjtype();
        String refobjids = examArrange.getRefobjids();
        if (refobjtype != null && refobjids != null && refobjids.length() > 0) {
            ((ExamArrangePlusService)SpringUtil.getBean(ExamArrangePlusService.class))._clearCache_getByRef(refobjids, refobjtype);
        }
        ((IExamplusService)SpringUtil.getBean(IExamplusService.class)).clearCache(examId);
        long redisSecondLife = 1200L;
        ((RedisService)SpringUtil.getBean(RedisService.class)).set(CLEAR_CACHE_REDIS_KEY_PREFIX + examId, Long.toString(System.currentTimeMillis()), redisSecondLife);
    }
}

