/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examarrange.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examarrange.bo.ExamRefStuQueryBO;
import com.peak.prd.exam.examarrange.dao.IExamArrangePlusDao;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.service.IExamRefArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeQuery;
import com.peak.prd.exam.examarrange.vo.ExamRefArrangeStuItemVO;
import com.peak.prd.exam.examarrange.vo.MyExamArrangeVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamRefArrangePlusService
extends PrdBaseService<ExamArrange, Long, ExamArrangeQuery>
implements IExamRefArrangePlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamRefArrangePlusService.class);
    @Resource
    private IExamArrangePlusDao examArrangePlusDao;
    @Resource
    private IExamArrangePlusService examArrangePlusService;

    @Override
    public Paging<ExamRefArrangeStuItemVO> getPaging(ExamRefStuQueryBO queryBO) {
        ExamArrangeQuery query = this._query(queryBO);
        if (query == null || query.getPage().getTotalCount() == 0) {
            return null;
        }
        List voList = ConvertUtil.convert((List)query.getPage().getClearResult(), ExamRefArrangeStuItemVO.class);
        return new Paging(query.getPage(), voList);
    }

    @Override
    public Paging<MyExamArrangeVO> getMyPaging(ExamRefStuQueryBO queryBO, Long currUserId) {
        ExamArrangeQuery query = this._query(queryBO);
        if (query == null || query.getPage().getTotalCount() == 0) {
            return null;
        }
        List<MyExamArrangeVO> myVOList = this.examArrangePlusService.getMyVOList(query.getPage().getResult(), currUserId);
        return new Paging(query.getPage(), myVOList);
    }

    private ExamArrangeQuery _query(ExamRefStuQueryBO queryBO) {
        if (queryBO.getRefobjtype() == null || queryBO.getRefobjids() == null || queryBO.getRefobjids().length() == 0) {
            return null;
        }
        Date now = new Date();
        ExamArrangeQuery query = (ExamArrangeQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamArrangeQuery.class);
        query.setStatus(1);
        query.getPage().setSortColumns("ea.createdate DESC, ea.arrangeid");
        if (queryBO.getScopeInt() == 2) {
            query.setEndtimeBegin(now);
        } else if (queryBO.getScopeInt() == 3) {
            query.setEndtimeEnd(now);
        }
        return (ExamArrangeQuery)this.examArrangePlusDao.findPage(query);
    }

    public IEntityDao<ExamArrange, Long, ExamArrangeQuery> getEntityDao() {
        return this.examArrangePlusDao;
    }
}

