/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examarrange.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.enums.ExamTchReadTypeEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeVO;
import com.peak.prd.exam.examarrange.vo.MyExamArrangeVO;
import com.peak.prd.exam.examresult.model.ExamResult;
import java.util.ArrayList;
import java.util.List;

public class ExamArrangeUtil {
    public static final int ANSWERMETHOD_MouseFocus = 0;
    public static final int ANSWERMETHOD_None = 1;
    public static final int ANSWERMETHOD_Exe = 2;
    public static final int ANSWERMETHOD_ActiveX = 3;
    public static final int WHENSEEMARK_NO = 3;
    public static final int WHENSEEMARK_AFTER_SUBMIT = 2;
    public static final int WHENSEEMARK_AFTER_VERIFY = 5;
    public static final int WHATSEEMARK_PASS = 1;
    public static final int WHATSEEMARK_MARK = 2;
    public static final int WHATSEEMARK_REPLY = 4;
    public static final int WHATSEEMARK_REPLY_CORRWRONG = 8;
    public static final int CALMARKRULE_HIGH = 1;
    public static final int CALMARKRULE_AVG = 0;
    public static final int CALMARKRULE_LAST = 2;
    public static Integer TCHREAD_WEIGHT_DEFAULT_VALUE = 1;

    public static boolean isResultPublished(ExamArrange examInfo) {
        if (examInfo == null) {
            return false;
        }
        return ExamArrangeUtil.isResultPublished(examInfo.getWhenseemark(), examInfo.getWhatseemark(), examInfo.getMarkverify());
    }

    public static boolean isResultPublished(Integer whenseemark, Integer whatseemark, Integer markverify) {
        int nMarkVerify;
        int n = nMarkVerify = markverify == null ? 0 : markverify;
        if (whenseemark == null || whatseemark == null || whatseemark <= 0) {
            return false;
        }
        if (whenseemark == 3) {
            return false;
        }
        return whenseemark != 5 || nMarkVerify != 0;
    }

    public static boolean canSeeMark(ExamArrange examInfo) {
        return ExamArrangeUtil.canSeeWhat(examInfo, 2);
    }

    public static boolean canSeePass(ExamArrange examInfo) {
        return ExamArrangeUtil.canSeeWhat(examInfo, 1);
    }

    public static boolean canSeeReview(ExamArrange examInfo) {
        return ExamArrangeUtil.canSeeWhat(examInfo, 4);
    }

    public static boolean canSeeWhat(ExamArrange examInfo, int what) {
        if (examInfo == null || examInfo.getWhatseemark() == null) {
            return false;
        }
        return (examInfo.getWhatseemark() & what) != 0;
    }

    public static <T extends ExamArrangeVO> T convert(ExamArrange examArrange, Class<T> targetClazz) {
        ExamArrangeVO examVO = (ExamArrangeVO)ConvertUtil.convert((Object)examArrange, targetClazz);
        if (examVO == null) {
            return null;
        }
        examVO.setResultPublished(ExamArrangeUtil.isResultPublished(examArrange));
        if (examVO.isResultPublished()) {
            examVO.setCanSeePass(ExamArrangeUtil.canSeePass(examArrange));
            examVO.setCanSeeMark(ExamArrangeUtil.canSeeMark(examArrange));
            examVO.setCanReview(ExamArrangeUtil.canSeeReview(examArrange));
        }
        return (T)examVO;
    }

    public static <T extends ExamArrangeVO> List<T> convert(List<ExamArrange> examArranges, Class<T> targetClazz) {
        if (examArranges == null) {
            return null;
        }
        ArrayList<T> newList = new ArrayList<T>();
        for (int i = 0; i < examArranges.size(); ++i) {
            newList.add(ExamArrangeUtil.convert(examArranges.get(i), targetClazz));
        }
        return newList;
    }

    public static void setPropertiesByExamResult(MyExamArrangeVO examVO, ExamResult result) {
        if (examVO == null || result == null) {
            return;
        }
        examVO.setAttend(true);
        examVO.setExamcount(result.getExamcount());
        examVO.setEnterdate(result.getEnterdate());
        examVO.setSubmitdate(result.getSubmitdate());
        examVO.setResultId(result.getResultId());
        if (!examVO.isResultPublished()) {
            return;
        }
        if (examVO.isCanSeeMark()) {
            examVO.setMark(result.getMark());
        }
        if (examVO.isCanSeePass() && examVO.getPassmark() != null && result.getMark() != null) {
            examVO.setPass(result.getMark() >= examVO.getPassmark());
        }
    }

    public static int getTchreadtypeInt(ExamArrange arrange) {
        if (arrange == null) {
            return -1;
        }
        return arrange.getTchreadtype() == null ? 0 : arrange.getTchreadtype();
    }

    public static int getTchreadtypeInt(Long arrangeId) {
        ExamArrange arrange = (ExamArrange)((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).getById(arrangeId);
        return ExamArrangeUtil.getTchreadtypeInt(arrange);
    }

    public static boolean isWeightTchreadtype(Long arrangeId) {
        return ExamArrangeUtil.getTchreadtypeInt(arrangeId) == ExamTchReadTypeEnum.TYPE_WEIGHT.getValue();
    }
}

