/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examarrange.vo;

import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.util.ExamArrangeUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="\u8003\u8bd5\u4fee\u6539\u524d\u540e\u53d8\u5316VO")
public class ExamArrangeUpdateChangeVO
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u5f71\u54cd\u884c\u6570")
    private int affectRows;
    @ApiModelProperty(value="\u66f4\u65b0\u524d")
    private ExamArrange oldExamArrange;
    @ApiModelProperty(value="\u66f4\u65b0\u540e")
    private ExamArrange newExamArrange;

    @ApiModelProperty(value="\u8003\u8bd5id")
    public Long getExamId() {
        return this.oldExamArrange == null ? null : this.oldExamArrange.getArrangeId();
    }

    public boolean isTriggerStudentPassInfoChanged() {
        if (this.affectRows <= 0 || this.oldExamArrange == null || this.newExamArrange == null) {
            return false;
        }
        boolean oldPublished = ExamArrangeUtil.isResultPublished(this.oldExamArrange);
        boolean newPublished = ExamArrangeUtil.isResultPublished(this.newExamArrange);
        boolean oldCanSeePass = ExamArrangeUtil.canSeePass(this.oldExamArrange);
        boolean newCanSeePass = ExamArrangeUtil.canSeePass(this.newExamArrange);
        Double oldPassmark = this.oldExamArrange.getPassmark();
        Double newPassmark = this.newExamArrange.getPassmark();
        if (!newPublished || !newCanSeePass || newPassmark == null) {
            return false;
        }
        if (!oldPublished || !oldCanSeePass) {
            return true;
        }
        if (oldPassmark == null) {
            return true;
        }
        return !(Math.abs(oldPassmark - newPassmark) < 0.01);
    }

    public int getAffectRows() {
        return this.affectRows;
    }

    public ExamArrange getOldExamArrange() {
        return this.oldExamArrange;
    }

    public ExamArrange getNewExamArrange() {
        return this.newExamArrange;
    }

    public void setAffectRows(int affectRows) {
        this.affectRows = affectRows;
    }

    public void setOldExamArrange(ExamArrange oldExamArrange) {
        this.oldExamArrange = oldExamArrange;
    }

    public void setNewExamArrange(ExamArrange newExamArrange) {
        this.newExamArrange = newExamArrange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExamArrangeUpdateChangeVO)) {
            return false;
        }
        ExamArrangeUpdateChangeVO other = (ExamArrangeUpdateChangeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAffectRows() != other.getAffectRows()) {
            return false;
        }
        ExamArrange this$oldExamArrange = this.getOldExamArrange();
        ExamArrange other$oldExamArrange = other.getOldExamArrange();
        if (this$oldExamArrange == null ? other$oldExamArrange != null : !((Object)this$oldExamArrange).equals(other$oldExamArrange)) {
            return false;
        }
        ExamArrange this$newExamArrange = this.getNewExamArrange();
        ExamArrange other$newExamArrange = other.getNewExamArrange();
        return !(this$newExamArrange == null ? other$newExamArrange != null : !((Object)this$newExamArrange).equals(other$newExamArrange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExamArrangeUpdateChangeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAffectRows();
        ExamArrange $oldExamArrange = this.getOldExamArrange();
        result = result * 59 + ($oldExamArrange == null ? 43 : ((Object)$oldExamArrange).hashCode());
        ExamArrange $newExamArrange = this.getNewExamArrange();
        result = result * 59 + ($newExamArrange == null ? 43 : ((Object)$newExamArrange).hashCode());
        return result;
    }

    public String toString() {
        return "ExamArrangeUpdateChangeVO(affectRows=" + this.getAffectRows() + ", oldExamArrange=" + this.getOldExamArrange() + ", newExamArrange=" + this.getNewExamArrange() + ")";
    }
}

