/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examcategory.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examcategoryitem.bo.ExamQuestionbankBO;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.org.vo.OrgVO;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.common.vo.UserMiniVO;
import com.peak.prd.exam.enums.ExamCategoryEnum;
import com.peak.prd.exam.exambank.model.ExamExamBankAuditor;
import com.peak.prd.exam.exambank.model.ExamExamBankMaintainer;
import com.peak.prd.exam.exambank.service.IExamExamBankAuditorPlusService;
import com.peak.prd.exam.exambank.service.IExamExamBankMaintainerPlusService;
import com.peak.prd.exam.exambank.vo.ExamExamBankAuditorQuery;
import com.peak.prd.exam.exambank.vo.ExamExamBankMaintainerQuery;
import com.peak.prd.exam.examcategory.dao.IExamCategoryItemPlusDao;
import com.peak.prd.exam.examcategory.model.ExamCategory;
import com.peak.prd.exam.examcategory.model.ExamCategoryItem;
import com.peak.prd.exam.examcategory.service.IExamCategoryItemPlusService;
import com.peak.prd.exam.examcategory.service.IExamCategoryPlusService;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemQuery;
import com.peak.prd.exam.examcategory.vo.ExamQuestionbankVO;
import com.peak.prd.exam.examcategory.vo.ExamSubjectMngVO;
import com.peak.prd.exam.examcategory.vo.ExerciseQuestionbankVO;
import com.peak.prd.exam.examquestion.service.IExamQuestionQbPlusService;
import com.peak.prd.exam.examquestion.vo.ExamQBankDetailVO;
import com.peak.prd.exam.examresourcerelation.model.ExamResourceRelation;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import com.peak.prd.exam.examshare.model.ExamShareresource;
import com.peak.prd.exam.examshare.service.IExamShareresourcePlusService;
import com.peak.prd.exam.examshare.vo.ExamShareresourceQuery;
import com.peak.prd.exam.examshare.vo.ExamShareresourceVO;
import com.peak.prd.exam.examsubject.bo.ExamSubjectBO;
import com.peak.prd.exception.DataAuthException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamCategoryItemPlusService
extends PrdBaseService<ExamCategoryItem, Long, ExamCategoryItemQuery>
implements IExamCategoryItemPlusService {
    @Autowired
    private IExamCategoryPlusService examCategoryPlusService;
    @Autowired
    private IExamResourceRelationPlusService examResourceRelationPlusService;
    @Autowired
    private IExamShareresourcePlusService examShareresourcePlusService;
    @Autowired
    private IExamExamBankAuditorPlusService examExamBankAuditorPlusService;
    @Autowired
    private IExamExamBankMaintainerPlusService examExamBankMaintainerPlusService;
    private IExamCategoryItemPlusDao examCategoryItemPlusDao;
    private final Long SUBJECT = 5L;

    public void setExamCategoryItemPlusDao(IExamCategoryItemPlusDao dao) {
        this.examCategoryItemPlusDao = dao;
    }

    public IExamCategoryItemPlusDao getExamCategoryItemPlusDao() {
        return this.examCategoryItemPlusDao;
    }

    public IEntityDao<ExamCategoryItem, Long, ExamCategoryItemQuery> getEntityDao() {
        return this.examCategoryItemPlusDao;
    }

    private Paging<ExamQuestionbankVO> _findExamQuestionbankVOPaging(ExamCategoryItemQuery query) {
        query = (ExamCategoryItemQuery)this.findPage(query);
        List vos = ConvertUtil.convert((List)query.getPage().getClearResult(), ExamQuestionbankVO.class);
        OrgUtil.setOrgName((List)vos, ExamQuestionbankVO::getDomainId, ExamQuestionbankVO::setDomainName);
        UserCoreUtil.setUserRealname((List)vos, ExamQuestionbankVO::getCreatorId, ExamQuestionbankVO::setCreatorName);
        List qbankIds = IdUtil.getIds((List)vos, e -> e.getItemId());
        List categories = this.getExamCategoryItemPlusDao().getQbankCategories(qbankIds);
        categories = ConvertUtil.refact((List)vos, categories, (vo, c) -> vo.getItemId().equals(c.getItemId()));
        ConvertUtil.setProperties((List)vos, (List)categories, (vo, c) -> vo.setCategoryId(c.getCategoryId()));
        ConvertUtil.setProperties((List)vos, (List)categories, (vo, c) -> vo.setCategoryName(c.getCategoryName()));
        IExamQuestionQbPlusService examQuestionQbPlusService = (IExamQuestionQbPlusService)SpringUtil.getBean((String)"examQuestionQbPlusService");
        List<ExamQBankDetailVO> qbankTypeVOs = examQuestionQbPlusService.findDetailVOById(qbankIds);
        Map mapQbankTypes = ConvertUtil.listToMap(qbankTypeVOs, q -> q.getQbankId());
        if (mapQbankTypes != null && vos != null) {
            for (ExamQuestionbankVO vo2 : vos) {
                vo2.setQtypes(((ExamQBankDetailVO)mapQbankTypes.get(vo2.getItemId())).getQtypes());
            }
        }
        return new Paging(query.getPage(), vos);
    }

    private ExamCategoryItemQuery buildQuery(ExamCategoryItemQuery query, Long currMngDomainId, boolean selector) {
        query.setCsId((long)ExamCategoryEnum.CATEGORY_QBANK.getValue() * 1L);
        query.setRootId((long)ExamCategoryEnum.CATEGORY_QBANK.getValue() * 1L);
        if (selector) {
            query.setIsvalId(1);
            if (query.getDomainId() == null) {
                query.setSelectDomainId(currMngDomainId);
                query.setIncludeShare(true);
            } else {
                query.setSelectDomainId(query.getDomainId());
                query.setIncludeShare(false);
            }
            query.setDomainId(null);
        } else if (query.getDomainId() == null && query.getMaintainerId() == null && query.getAuditorId() == null) {
            query.setDomainId(currMngDomainId);
        }
        return query;
    }

    @Override
    public Paging<ExamQuestionbankVO> findExamQuestionbankVOPaging(ExamCategoryItemQuery query, Long currMngDomainId, boolean selector) {
        query = this.buildQuery(query, currMngDomainId, selector);
        return this._findExamQuestionbankVOPaging(query);
    }

    @Override
    public ExamQuestionbankVO findExamQuestionbankVO(Long qbankId) {
        if (qbankId == null) {
            return null;
        }
        ExamCategoryItemQuery query = new ExamCategoryItemQuery();
        query.setItemId(qbankId);
        Paging<ExamQuestionbankVO> paging = this._findExamQuestionbankVOPaging(query);
        if (paging.getTotalCount() == 0L) {
            return null;
        }
        ExamQuestionbankVO vo = (ExamQuestionbankVO)paging.getList().get(0);
        ExamShareresourceQuery examShareresourceQuery = new ExamShareresourceQuery();
        examShareresourceQuery.setSharetype(1);
        examShareresourceQuery.setResourceId(qbankId);
        List shares = this.examShareresourcePlusService.findAll(examShareresourceQuery);
        List shareVOs = ConvertUtil.convert((List)shares, ExamShareresourceVO.class);
        ConvertUtil.setProperties((List)shareVOs, (List)shares, (v, s) -> v.setDomainId(s.getAcceptcorpId()));
        OrgUtil.setOrgName((List)shareVOs, ExamShareresourceVO::getDomainId, ExamShareresourceVO::setDomainName);
        vo.setShareVOs(shareVOs);
        ExamExamBankMaintainerQuery maintainerQuery = new ExamExamBankMaintainerQuery();
        maintainerQuery.setItemId(qbankId);
        List maintainerModels = this.examExamBankMaintainerPlusService.findAll(maintainerQuery);
        List maintainers = ConvertUtil.convert((List)maintainerModels, UserMiniVO.class);
        UserCoreUtil.setUserRealname((List)maintainers, UserMiniVO::getUserId, UserMiniVO::setRealname);
        vo.setMaintainers(maintainers);
        ExamExamBankAuditorQuery auditorQuery = new ExamExamBankAuditorQuery();
        auditorQuery.setItemId(qbankId);
        List auditorModels = this.examExamBankAuditorPlusService.findAll(auditorQuery);
        List auditors = ConvertUtil.convert((List)auditorModels, UserMiniVO.class);
        UserCoreUtil.setUserRealname((List)auditors, UserMiniVO::getUserId, UserMiniVO::setRealname);
        vo.setAuditors(auditors);
        return vo;
    }

    @Override
    public ExerciseQuestionbankVO findExerciseQuestionbankVO(Long itemId) {
        ExamCategoryItem item = (ExamCategoryItem)this.getById(itemId);
        if (item == null) {
            return null;
        }
        ExerciseQuestionbankVO vo = (ExerciseQuestionbankVO)ConvertUtil.convert((Object)item, ExerciseQuestionbankVO.class);
        User user = UserCoreUtil.getUser((Long)item.getCreatorId());
        vo.setCreatorName(user == null ? "" : user.getName());
        OrgVO orgVO = OrgUtil.getOrgVO((Long)item.getDomainId());
        vo.setDomainName(orgVO == null ? "" : orgVO.getOrgname());
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery();
        examResourceRelationQuery.setResourcetype(1);
        examResourceRelationQuery.setExamtype(1);
        examResourceRelationQuery.setExamresourceId(itemId);
        ExamResourceRelation examResourceRelation = (ExamResourceRelation)this.examResourceRelationPlusService.getPrdEntityDao().findOne((IQuery)examResourceRelationQuery);
        if (examResourceRelation != null) {
            Long categoryId = examResourceRelation.getResourceId();
            ExamCategory examCategory = (ExamCategory)this.examCategoryPlusService.findById(categoryId);
            vo.setCategoryTitle(examCategory == null ? "" : examCategory.getTitle());
        }
        return vo;
    }

    @Override
    public Long insertQbank(Long userId, Long domainId, ExamQuestionbankBO bo) {
        if (bo == null) {
            return null;
        }
        if (bo.getIssetshare() == null || bo.getIssetshare() == 0) {
            bo.setSharetosubcorp(0);
            bo.setShareToDomainIds(null);
        }
        Long qbankId = bo.getItemId() != null ? bo.getItemId() : IdUtil.getSequence((String)"EXAM_CATEGORY_ITEM");
        ExamCategoryItem eci = new ExamCategoryItem();
        ConvertUtil.copyProperties((Object)bo, (Object)eci);
        eci.setItemId(qbankId);
        eci.setCsId(1L);
        eci.setRootId(1L);
        eci.setDomainId(domainId);
        eci.setCreatorId(userId);
        eci.setCreatedate(new Date());
        if (bo.getIsvalId() == null) {
            eci.setIsvalId(1);
        }
        this.insert((BaseEntity)eci);
        ExamResourceRelation err = this.createQbankCategoryRelation(qbankId, bo.getCategoryId(), userId);
        if (err != null) {
            this.examResourceRelationPlusService.insert((BaseEntity)err);
        }
        this.saveShare(qbankId, userId, domainId, bo);
        this.saveMaintainers(qbankId, userId, domainId, bo.getMaintainerIds());
        this.saveAuditors(qbankId, userId, domainId, bo.getAuditorIds());
        return qbankId;
    }

    private void saveMaintainers(Long qbankId, Long currUserId, Long currMngDomainId, List<Long> maintainerUserIds) {
        if (qbankId == null) {
            return;
        }
        Date now = new Date();
        ExamExamBankMaintainerQuery query = new ExamExamBankMaintainerQuery();
        query.setItemId(qbankId);
        List oldMaintainers = this.examExamBankMaintainerPlusService.findAll(query);
        List oldUserIds = IdUtil.getIds((List)oldMaintainers, e -> e.getUserId());
        for (int i = 0; oldMaintainers != null && i < oldMaintainers.size(); ++i) {
            Long oldPkId = ((ExamExamBankMaintainer)oldMaintainers.get(i)).getMaintainerId();
            Long oldUserId = ((ExamExamBankMaintainer)oldMaintainers.get(i)).getUserId();
            if (oldUserId != null && maintainerUserIds != null && maintainerUserIds.contains(oldUserId)) continue;
            this.examExamBankMaintainerPlusService.deleteById(oldPkId);
        }
        ArrayList<ExamExamBankMaintainer> list = new ArrayList<ExamExamBankMaintainer>();
        for (int i = 0; maintainerUserIds != null && i < maintainerUserIds.size(); ++i) {
            boolean notExisted;
            ExamExamBankMaintainer sr = new ExamExamBankMaintainer(IdUtil.getSequence((String)"EXAM_BANK_MAINTAINER"));
            sr.setItemId(qbankId);
            sr.setUserId(maintainerUserIds.get(i));
            sr.setCreatorId(currUserId);
            sr.setCreatedate(now);
            boolean bl = notExisted = oldUserIds == null || oldUserIds.isEmpty() || !oldUserIds.contains(maintainerUserIds.get(i));
            if (!notExisted) continue;
            list.add(sr);
        }
        if (!list.isEmpty()) {
            this.examExamBankMaintainerPlusService.insertBatch(list);
        }
    }

    private void saveAuditors(Long qbankId, Long currUserId, Long currMngDomainId, List<Long> auditorUserIds) {
        if (qbankId == null) {
            return;
        }
        Date now = new Date();
        ExamExamBankAuditorQuery query = new ExamExamBankAuditorQuery();
        query.setItemId(qbankId);
        List oldAuditors = this.examExamBankAuditorPlusService.findAll(query);
        List oldUserIds = IdUtil.getIds((List)oldAuditors, e -> e.getUserId());
        for (int i = 0; oldAuditors != null && i < oldAuditors.size(); ++i) {
            Long oldPkId = ((ExamExamBankAuditor)oldAuditors.get(i)).getAuditorId();
            Long oldUserId = ((ExamExamBankAuditor)oldAuditors.get(i)).getUserId();
            if (oldUserId != null && auditorUserIds != null && auditorUserIds.contains(oldUserId)) continue;
            this.examExamBankAuditorPlusService.deleteById(oldPkId);
        }
        ArrayList<ExamExamBankAuditor> list = new ArrayList<ExamExamBankAuditor>();
        for (int i = 0; auditorUserIds != null && i < auditorUserIds.size(); ++i) {
            boolean notExisted;
            ExamExamBankAuditor sr = new ExamExamBankAuditor(IdUtil.getSequence((String)"EXAM_BANK_AUDITOR"));
            sr.setItemId(qbankId);
            sr.setUserId(auditorUserIds.get(i));
            sr.setCreatorId(currUserId);
            sr.setCreatedate(now);
            boolean bl = notExisted = oldUserIds == null || oldUserIds.isEmpty() || !oldUserIds.contains(auditorUserIds.get(i));
            if (!notExisted) continue;
            list.add(sr);
        }
        if (!list.isEmpty()) {
            this.examExamBankAuditorPlusService.insertBatch(list);
        }
    }

    private void saveShare(Long qbankId, Long currUserId, Long currMngDomainId, ExamQuestionbankBO qbankBO) {
        if (qbankId == null) {
            return;
        }
        List<Long> shareToDomainIds = qbankBO.getShareToDomainIds();
        Date now = new Date();
        boolean SHARETYPE = true;
        ExamShareresourceQuery query = new ExamShareresourceQuery();
        query.setSharetype(1);
        query.setResourceId(qbankId);
        this.examShareresourcePlusService.deleteByQuery(query);
        ArrayList<ExamShareresource> list = new ArrayList<ExamShareresource>();
        for (int i = 0; shareToDomainIds != null && i < shareToDomainIds.size(); ++i) {
            ExamShareresource sr = new ExamShareresource(IdUtil.getSequence((String)"EXAM_SHARERESOURCE"));
            sr.setSharetype(1);
            sr.setResourceId(qbankId);
            sr.setCreatorId(currUserId);
            sr.setCreatecorpId(currMngDomainId);
            sr.setAcceptcorpId(shareToDomainIds.get(i));
            sr.setCreatedate(now);
            sr.setPermit(0);
            list.add(sr);
        }
        this.examShareresourcePlusService.insertBatch(list);
    }

    private ExamResourceRelation createQbankCategoryRelation(Long qbankId, Long categoryId, Long userId) {
        if (qbankId == null || categoryId == null) {
            return null;
        }
        ExamResourceRelation relation = new ExamResourceRelation(IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION"));
        relation.setResourcetype(1);
        relation.setResourceId(categoryId);
        relation.setExamtype(1);
        relation.setExamresourceId(qbankId);
        relation.setCreatorId(userId);
        relation.setCreatedate(new Date());
        return relation;
    }

    @Override
    public void updateQbank(Long userId, Long domainId, ExamQuestionbankBO bo) {
        if (bo == null) {
            return;
        }
        if (bo.getIssetshare() == null || bo.getIssetshare() == 0) {
            bo.setSharetosubcorp(0);
            bo.setShareToDomainIds(null);
        }
        ExamCategoryItem eci = (ExamCategoryItem)ConvertUtil.convert((Object)bo, ExamCategoryItem.class);
        eci.setModifierId(userId);
        eci.setModifydate(new Date());
        this.updateSelective(eci);
        this.examResourceRelationPlusService.deleteQbankCategory(bo.getItemId());
        ExamResourceRelation err = this.createQbankCategoryRelation(bo.getItemId(), bo.getCategoryId(), userId);
        if (err != null) {
            this.examResourceRelationPlusService.insert((BaseEntity)err);
        }
        this.saveShare(bo.getItemId(), userId, domainId, bo);
        this.saveMaintainers(bo.getItemId(), userId, domainId, bo.getMaintainerIds());
        this.saveAuditors(bo.getItemId(), userId, domainId, bo.getAuditorIds());
    }

    @Override
    public void deleteQbank(Long qbankId) {
        this.examResourceRelationPlusService.deleteQbankCategory(qbankId);
        this.deleteById(qbankId);
    }

    @Override
    public Paging<ExamSubjectMngVO> findExamSubjectVOPaging(ExamCategoryItemQuery query) {
        query.setRootId(this.SUBJECT);
        query.setCsId(this.SUBJECT);
        if (StringUtil.isNullorEmptyStr((String)query.getPage().getSortColumns())) {
            query.getPage().setSortColumns("createdate DESC");
        }
        query = (ExamCategoryItemQuery)this.findPage(query);
        List vos = ConvertUtil.convert((List)query.getPage().getClearResult(), ExamSubjectMngVO.class);
        OrgUtil.setOrgName((List)vos, ExamSubjectMngVO::getDomainId, ExamSubjectMngVO::setDomainName);
        UserCoreUtil.setUserRealname((List)vos, ExamSubjectMngVO::getCreatorId, ExamSubjectMngVO::setCreatorName);
        return new Paging(query.getPage(), vos);
    }

    @Override
    public Long insertSubject(Long userId, Long domainId, ExamSubjectBO bo) {
        Long subjectId = IdUtil.getSequence((String)"EXAM_CATEGORY_ITEM");
        ExamCategoryItem eci = new ExamCategoryItem();
        ConvertUtil.copyProperties((Object)bo, (Object)eci);
        eci.setItemId(subjectId);
        eci.setCsId(this.SUBJECT);
        eci.setRootId(this.SUBJECT);
        eci.setDomainId(domainId);
        eci.setCreatorId(userId);
        eci.setCreatedate(new Date());
        this.insert((BaseEntity)eci);
        return subjectId;
    }

    @Override
    public boolean isSubjectUsed(Long subjectId) {
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery();
        examResourceRelationQuery.setResourcetype(this.SUBJECT.intValue());
        examResourceRelationQuery.setResourceId(subjectId);
        return this.examResourceRelationPlusService.count(examResourceRelationQuery) > 0L;
    }

    @Override
    public ExamCategoryItem getQbankByRef(Integer refobjtype, String refobjids) {
        if (refobjtype == null || refobjids == null || refobjids.isEmpty()) {
            return null;
        }
        ExamCategoryItemQuery query = new ExamCategoryItemQuery();
        query.setRefobjtype(refobjtype);
        query.setRefobjids(refobjids);
        query.setCsId(1L);
        query.setRootId(1L);
        return (ExamCategoryItem)this.examCategoryItemPlusDao.findOne(query);
    }

    public ExamCategoryItem dataAuth(Long itemId, Long currUserId, Long curMngDomainId) {
        try {
            return (ExamCategoryItem)super.dataAuth(itemId, currUserId, curMngDomainId);
        }
        catch (DataAuthException exception) {
            ExamCategoryItemQuery query = new ExamCategoryItemQuery(1, 1);
            query.setItemId(itemId);
            boolean selector = true;
            query = this.buildQuery(query, curMngDomainId, selector);
            ExamCategoryItem item = (ExamCategoryItem)this.examCategoryItemPlusDao.findOne(query);
            if (item == null) {
                throw exception;
            }
            return item;
        }
    }
}

