/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examcategory.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examcategory.bo.ExamCategoryBO;
import com.peak.mng.exam.examcategory.bo.ExamKnowledgeDimensionBO;
import com.peak.mng.exam.examcategory.bo.ExamKnowledgeDimensionBatchBO;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.ExamResourceRelationEnum;
import com.peak.prd.exam.enums.ExamCategoryEnum;
import com.peak.prd.exam.examcategory.dao.IExamCategoryPlusDao;
import com.peak.prd.exam.examcategory.model.ExamCategory;
import com.peak.prd.exam.examcategory.service.IExamCategoryPlusService;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.examcategory.vo.ExamCategoryQuery;
import com.peak.prd.exam.examcategory.vo.ExamKnowledgeDimensionVO;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class ExamCategoryPlusService
extends PrdBaseService<ExamCategory, Long, ExamCategoryQuery>
implements IExamCategoryPlusService {
    private IExamCategoryPlusDao examCategoryPlusDao;

    public void setExamCategoryPlusDao(IExamCategoryPlusDao dao) {
        this.examCategoryPlusDao = dao;
    }

    public IExamCategoryPlusDao getExamCategoryPlusDao() {
        return this.examCategoryPlusDao;
    }

    public IEntityDao<ExamCategory, Long, ExamCategoryQuery> getEntityDao() {
        return this.examCategoryPlusDao;
    }

    @Override
    public Long insert(ExamCategoryBO bo, Long currUserId, Long currMngDomainId) {
        ExamCategory category = new ExamCategory();
        ConvertUtil.copyProperties((Object)bo, (Object)category);
        category.setCategoryId(IdUtil.getSequence((String)"EXAM_CATEGORY"));
        category.setGkey(UUID.randomUUID().toString().replaceAll("-", ""));
        category.setCode(category.getCategoryId() + "");
        category.setRootId(bo.getRootId());
        category.setCsId(bo.getRootId());
        category.setDomainId(currMngDomainId);
        category.setCreatorId(currUserId);
        category.setCreatedate(new Date());
        category.setIsleaf(1);
        if (category.getParentId() == null) {
            category.setParentId(category.getRootId());
        }
        ExamCategory parent = (ExamCategory)this.examCategoryPlusDao.getById(category.getParentId());
        category.setFullpath(parent.getFullpath() + "," + category.getCategoryId());
        if (parent.getIsleaf() == null || parent.getIsleaf() == 1) {
            parent.setIsleaf(0);
            this.examCategoryPlusDao.update(parent);
        }
        this.examCategoryPlusDao.insert((BaseEntity)category);
        return category.getCategoryId();
    }

    @Override
    public ApiResult update(ExamCategoryBO bo) {
        ExamCategory examCategory = (ExamCategory)this.examCategoryPlusDao.getById(bo.getCategoryId());
        if (examCategory == null) {
            return ApiResult.errMsg((String)("\u5206\u7c7b\u672a\u627e\u5230[" + bo.getCategoryId() + "]"));
        }
        Long oldParentId = examCategory.getParentId();
        Long newParentId = bo.getParentId();
        if (bo.getCategoryId().equals(newParentId)) {
            return ApiResult.errMsg((String)"\u7236\u8282\u70b9\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        if (!oldParentId.equals(newParentId)) {
            ExamCategory newParent = (ExamCategory)this.examCategoryPlusDao.getById(newParentId);
            if (newParent.getFullpath().indexOf("," + bo.getCategoryId() + ",") >= 0) {
                return ApiResult.errMsg((String)"\u4e0d\u53ef\u4ee5\u8bbe\u7f6e\u5f53\u524d\u8282\u70b9\u7684\u5b50\u7ea7\u4e3a\u5f53\u524d\u8282\u70b9\u7684\u7236\u8282\u70b9");
            }
            String oldFullpath = examCategory.getFullpath();
            String newFullpath = newParent.getFullpath() + "," + bo.getCategoryId();
            this.updateFullPath(oldFullpath, newFullpath);
            examCategory.setFullpath(newFullpath);
        }
        ConvertUtil.copyProperties((Object)bo, (Object)examCategory);
        this.examCategoryPlusDao.updateSelective(examCategory);
        return ApiResult.ok();
    }

    @Override
    public ApiResult delete(Long categoryId) {
        ExamCategory examCategory = (ExamCategory)this.examCategoryPlusDao.getById(categoryId);
        if (examCategory == null) {
            return ApiResult.errMsg((String)("\u5206\u7c7b\u672a\u627e\u5230[" + categoryId + "]"));
        }
        int directChildNum = this.getDirectChildNum(categoryId);
        if (directChildNum > 0) {
            return ApiResult.errMsg((String)"\u8bf7\u5148\u5220\u9664\u5b50\u5206\u7c7b");
        }
        long contentNum = this.hasContent(examCategory.getCategoryId(), examCategory.getRootId());
        if (contentNum > 0L) {
            return ApiResult.errMsg((String)"\u4e0d\u5141\u8bb8\u5220\u9664\uff08\u5206\u7c7b\u4e0b\u5df2\u7ecf\u5305\u542b\u8d44\u6e90\uff09");
        }
        this.examCategoryPlusDao.deleteById(categoryId);
        return ApiResult.ok();
    }

    @Override
    public void saveAll(ExamKnowledgeDimensionBatchBO batchBO, Long currUserId, Long currMngDomainId) {
        Long arrangeId = batchBO.getArrangeId();
        if (arrangeId == null) {
            return;
        }
        List<ExamKnowledgeDimensionVO> oldDims = this.getKnowledgeDimensionListByGrouprootId(arrangeId);
        for (int i = 0; oldDims != null && i < oldDims.size(); ++i) {
            ExamKnowledgeDimensionVO dim = oldDims.get(i);
            List<Long> knowledgeIds = dim.getKnowledgeIds();
            if (dim.getCategoryId() == null || ListUtil.isNullorEmpty(knowledgeIds)) continue;
            ExamResourceRelationQuery errQuery = new ExamResourceRelationQuery();
            errQuery.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_CATEGORY.getValue());
            errQuery.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_KNOWLEDGE.getValue());
            errQuery.setResourceId(dim.getCategoryId());
            errQuery.setExamresourceIds(knowledgeIds);
            ((IExamResourceRelationPlusService)SpringUtil.getBean(IExamResourceRelationPlusService.class)).deleteByQuery(errQuery);
            this.examCategoryPlusDao.deleteById(dim.getCategoryId());
        }
        List<ExamKnowledgeDimensionBO> newDims = batchBO.getDimensions();
        for (int i = 0; newDims != null && i < newDims.size(); ++i) {
            ExamKnowledgeDimensionBO dim = newDims.get(i);
            ExamCategoryBO examCategoryBO = dim.convertToExamCategoryBO(batchBO.getArrangeId());
            Long categoryId = this.insert(examCategoryBO, currUserId, currMngDomainId);
            ((IExamResourceRelationPlusService)SpringUtil.getBean(IExamResourceRelationPlusService.class)).insertDimensionKnowledges(categoryId, dim.getKnowledgeIds(), currUserId);
        }
    }

    private int getDirectChildNum(Long categoryId) {
        ExamCategoryQuery query = new ExamCategoryQuery();
        query.setParentId(categoryId);
        return (int)this.examCategoryPlusDao.count(query);
    }

    @Override
    public void updateFullPath(String old_fullPath, String new_fullPath) {
        this.examCategoryPlusDao.updateFullPath(old_fullPath, new_fullPath);
    }

    @Override
    public Long hasContent(Long resourceId, Long resourceType) {
        return this.examCategoryPlusDao.hasContent(resourceId, resourceType);
    }

    @Override
    public List<ExamCategory> getQuesPropCategories() {
        ExamCategoryQuery examCategoryQuery = new ExamCategoryQuery();
        examCategoryQuery.setParentId((long)ExamCategoryEnum.CATEGORY_QUESPROP.getValue() * 1L);
        return this.examCategoryPlusDao.findAll(examCategoryQuery);
    }

    @Override
    public List<ExamKnowledgeDimensionVO> getKnowledgeDimensionListByGrouprootId(Long grouprootId) {
        if (grouprootId == null) {
            return null;
        }
        ExamCategoryQuery query = new ExamCategoryQuery(1, 99);
        query.setRootId((long)ExamCategoryEnum.CATEGORY_KNOWLEDGE.getValue() * 1L);
        query.setParentId(query.getRootId());
        query.setCsId(query.getRootId());
        query.getPage().setSortColumns("displayorder, createdate");
        query.setGrouprootId(grouprootId);
        List list = this.examCategoryPlusDao.findList(query);
        List vos = ConvertUtil.convert((List)list, ExamKnowledgeDimensionVO.class);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            List<ExamResourceRelationVO> errVOs = this.getKnowledgesByDemension(((ExamKnowledgeDimensionVO)vos.get(i)).getCategoryId());
            if (ListUtil.isNullorEmpty(errVOs)) continue;
            ArrayList<ExamCategoryItemVO> knowlegeVOs = new ArrayList<ExamCategoryItemVO>();
            for (ExamResourceRelationVO errVO : errVOs) {
                ExamCategoryItemVO itemVO = new ExamCategoryItemVO();
                itemVO.setItemId(errVO.getExamresourceId());
                itemVO.setTitle(errVO.getExamresourceName());
                knowlegeVOs.add(itemVO);
            }
            ((ExamKnowledgeDimensionVO)vos.get(i)).setKnowledgeVOs(knowlegeVOs);
        }
        return vos;
    }

    @Override
    public ExamCategory getEqualNameOne(String name, Long domainId, Long rootId) {
        if (StringUtil.isNullorEmptyStr((String)name) || domainId == null || rootId == null) {
            return null;
        }
        ExamCategoryQuery query = new ExamCategoryQuery();
        query.setEqualName(name.trim());
        query.setDomainId(domainId);
        query.setRootId(rootId);
        ExamCategory sample = (ExamCategory)this.examCategoryPlusDao.findOne(query);
        return sample;
    }

    private List<ExamResourceRelationVO> getKnowledgesByDemension(Long categoryId) {
        if (categoryId == null) {
            return null;
        }
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery(1, 100);
        examResourceRelationQuery.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_KNOWLEDGE.getValue());
        examResourceRelationQuery.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_CATEGORY.getValue());
        examResourceRelationQuery.setResourceId(categoryId);
        return ((IExamResourceRelationPlusService)SpringUtil.getBean(IExamResourceRelationPlusService.class)).getPrdEntityDao().findList((IQuery)examResourceRelationQuery, "findKnowledgeVOAll", ExamResourceRelationVO.class);
    }
}

