/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examclient.service.imple;

import com.peak.common.util.AppPathUtil;
import com.peak.common.util.DownloadFileUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.service.IOssService;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.config.AppCommonConfig;
import com.peak.prd.enums.ExamResponseStatusEnum;
import com.peak.prd.exam.datajoblog.model.ExamDatajobLog;
import com.peak.prd.exam.datajoblog.service.IExamDatajobLogPlusService;
import com.peak.prd.exam.enums.ExamMonitorFaceEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeQuery;
import com.peak.prd.exam.examclient.service.IExamClient3rdService;
import com.peak.prd.exam.examclient.service.IExamClientPlusService;
import com.peak.prd.exam.exammonitor.model.ExamMonitor;
import com.peak.prd.exam.exammonitor.model.ExamMonitorFace;
import com.peak.prd.exam.exammonitor.service.IExamMonitorFacePlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonitorPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorFaceQuery;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.util.CommonUtil;
import com.peak.prd.exam.util.FileUtil;
import com.peak.prd.exam.util.PrdExamCacheUtil;
import com.peak.prd.exam.util.PrdExamDateUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamClientPlusService
extends PrdBaseService
implements IExamClientPlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamClientPlusService.class);
    @Autowired
    private IExamArrangePlusService examArrangePlusService;
    @Autowired
    private IExamMonitorPlusService examMonitorPlusService;
    @Autowired
    private IExamMonitorFacePlusService examMonitorFacePlusService;
    @Autowired
    private IExamClient3rdService examClient3rdService;
    @Autowired
    private IExamDatajobLogPlusService examDatajobLogPlusService;
    @Autowired
    private IExamResultPlusService examResultPlusService;
    @Autowired
    private AppCommonConfig appCommonConfig;

    public IEntityDao getEntityDao() {
        return null;
    }

    private String getScreenshotUploadRelativePath(Long examId, Long userId, Long resultId, String captureType) {
        String filepath = "upload/examclient/" + examId + "/" + userId % 1000L + "/" + userId + "/" + resultId + "/" + captureType;
        return filepath;
    }

    @Override
    public void uploadShotPicture(Long userexamId, Long currUserId, boolean isMobile, String imgtype, String[] imgdataArray) {
        boolean allowExt;
        ExamResult examResult;
        Date timestamp = PrdExamDateUtil.truncMinute(new Date());
        if (currUserId == null) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_401);
            return;
        }
        if (userexamId == null) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_MISS_RESULT);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u5230\u5ba2\u6237\u7aef\u7684uploadPic\u8bf7\u6c42 by userexamId:{}, userId:{}", (Object)userexamId, (Object)currUserId);
        }
        ExamArrange examInfo = PrdExamCacheUtil.getExamArrange((examResult = (ExamResult)this.examResultPlusService.getById(userexamId)) == null ? null : examResult.getArrangeId());
        if (examResult == null) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_MISS_RESULT);
            return;
        }
        if (examInfo == null) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_MISS_ARRANGE);
            return;
        }
        if (!currUserId.equals(examResult.getStudentId())) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_403);
            return;
        }
        if (imgtype == null || imgtype.isEmpty()) {
            imgtype = "png";
        }
        boolean bl = allowExt = "jpeg".equals(imgtype) || "jpg".equals(imgtype) || "png".equals(imgtype);
        if (!allowExt) {
            ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_INVALID_UPLOAD_IMGTYPE);
            return;
        }
        if (!isMobile) {
            this.uploadPicByPC(examResult, examInfo, imgtype, imgdataArray, timestamp);
        } else {
            this.uploadPicByMobile(examResult, examInfo, imgtype, imgdataArray, timestamp);
        }
    }

    private void uploadPicByPC(ExamResult examResult, ExamArrange examInfo, String imgtype, String[] imgdataArray, Date timestamp) {
        Long currUserId = examResult.getStudentId();
        Long userexamId = examResult.getResultId();
        Long examId = examResult.getArrangeId();
        int faceenter = examInfo.getFaceenter() == null ? 0 : examInfo.getFaceenter();
        int faceminute = examInfo.getFaceminute() == null ? 0 : examInfo.getFaceminute();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String filename = sdf.format(timestamp) + "." + imgtype;
        String faceBase64 = null;
        boolean bFace = false;
        boolean bScreen = false;
        for (int i = 0; i < 2; ++i) {
            ExamMonitorFaceEnum captureType;
            String imgdata = imgdataArray[i];
            ExamMonitorFaceEnum examMonitorFaceEnum = captureType = i == 0 ? ExamMonitorFaceEnum.TYPE_CAMERA : ExamMonitorFaceEnum.TYPE_SCREEN;
            if (i == 1 && faceminute <= 0 || imgdata == null || imgdata.isEmpty()) continue;
            if (i == 0) {
                bFace = true;
            } else {
                bScreen = true;
            }
            if (ExamMonitorFaceEnum.TYPE_CAMERA.getCode().equals(captureType.getCode())) {
                faceBase64 = imgdata;
            }
            try {
                byte[] imageBytes = DatatypeConverter.parseBase64Binary((String)(imgdata.substring(imgdata.indexOf(",")) + 1));
                this.saveImgData(examId, currUserId, userexamId, imageBytes, captureType, filename);
                ExamMonitor monitor = new ExamMonitor(userexamId);
                monitor.setScreenshotdate(timestamp);
                this.examMonitorPlusService.updateSelective(monitor);
                continue;
            }
            catch (Exception ex) {
                log.error("uploadPicByPC error: {}, examId:{}, userId:{}", new Object[]{ex.getMessage(), examId, currUserId});
            }
        }
        Boolean isMatchFace = faceenter > 0 ? Boolean.valueOf(this.isMatchFace(currUserId, examId, userexamId, faceBase64)) : null;
        this.saveExamMonitorFace(userexamId, examId, examResult.getStudentId(), isMatchFace, bFace, bScreen, false, timestamp);
        this.updateExamMonitorByFaceMatch(isMatchFace, userexamId, 3);
    }

    private void uploadPicByMobile(ExamResult examResult, ExamArrange examInfo, String imgtype, String[] imgdataArray, Date timestamp) {
        int faceminute;
        Long currUserId = examResult.getStudentId();
        Long userexamId = examResult.getResultId();
        Long examId = examResult.getArrangeId();
        int n = faceminute = examInfo.getFaceminute() == null ? 0 : examInfo.getFaceminute();
        if (faceminute <= 0) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String filename = sdf.format(timestamp) + "." + imgtype;
        String imgdata = imgdataArray[0];
        ExamMonitorFaceEnum captureType = ExamMonitorFaceEnum.TYPE_PHONE;
        if (imgdata == null || imgdata.isEmpty()) {
            return;
        }
        try {
            byte[] imageBytes = DatatypeConverter.parseBase64Binary((String)(imgdata.substring(imgdata.indexOf(",")) + 1));
            this.saveImgData(examId, currUserId, userexamId, imageBytes, captureType, filename);
            ExamMonitor monitor = new ExamMonitor(userexamId);
            monitor.setScreenshotdate(timestamp);
            this.examMonitorPlusService.updateSelective(monitor);
        }
        catch (Exception ex) {
            log.error("uploadPicByMobile error: {}, examId:{}, userId:{}", new Object[]{ex.getMessage(), examId, currUserId});
        }
        boolean bPhone = true;
        this.saveExamMonitorFace(userexamId, examId, examResult.getStudentId(), null, false, false, bPhone, timestamp);
    }

    private void saveExamMonitorFace(Long resultId, Long arrangeId, Long studentId, Boolean bFaceMatch, boolean bFace, boolean bScreen, boolean bPhone, Date timestamp) {
        try {
            this._saveExamMonitorFace(resultId, arrangeId, studentId, bFaceMatch, bFace, bScreen, bPhone, timestamp);
        }
        catch (Exception ex) {
            try {
                Thread.sleep((int)(Math.random() * 100.0) + 100);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this._saveExamMonitorFace(resultId, arrangeId, studentId, bFaceMatch, bFace, bScreen, bPhone, timestamp);
        }
    }

    private void _saveExamMonitorFace(Long resultId, Long arrangeId, Long studentId, Boolean bFaceMatch, boolean bFace, boolean bScreen, boolean bPhone, Date timestamp) {
        int status;
        ExamMonitorFace examMonitorFace = this.examMonitorFacePlusService.getByParam(resultId, timestamp);
        int n = bFaceMatch == null ? 0 : (status = bFaceMatch != false ? 5 : 4);
        if (examMonitorFace == null) {
            examMonitorFace = new ExamMonitorFace(IdUtil.getSequence((String)"EXAM_MONITOR_FACE"));
            examMonitorFace.setExamId(arrangeId);
            examMonitorFace.setUserId(studentId);
            examMonitorFace.setResultId(resultId);
            examMonitorFace.setCreatedate(timestamp);
            examMonitorFace.setFaceshot(bFace ? 1 : 0);
            examMonitorFace.setScreenshot(bScreen ? 1 : 0);
            examMonitorFace.setStatus(status);
            this.examMonitorFacePlusService.insert((BaseEntity)examMonitorFace);
        } else {
            ExamMonitorFace updateModel = new ExamMonitorFace(examMonitorFace.getEmfId());
            if (!bPhone) {
                updateModel.setFaceshot(bFace ? 1 : 0);
                updateModel.setScreenshot(bScreen ? 1 : 0);
                updateModel.setStatus(status);
            }
            this.examMonitorFacePlusService.updateSelective(updateModel);
        }
    }

    @Override
    public void getShotPicture(Long emfId, Long resultId, String screenshotdate, ExamMonitorFaceEnum shotType, HttpServletResponse response) throws Exception {
        ExamMonitorFace examMonitorFace = this.examMonitorFacePlusService.getByParam(emfId, resultId, screenshotdate);
        if (examMonitorFace == null) {
            log.warn("getShotPic empty [emfId:{}][resultId:{}][shotdate:{}][shotType:{}]", new Object[]{emfId, resultId, screenshotdate, shotType.getCode()});
            return;
        }
        if (ExamMonitorFaceEnum.TYPE_CAMERA.getCode().equals(shotType.getCode())) {
            if (examMonitorFace.getFaceshot() == null || examMonitorFace.getFaceshot() <= 0) {
                return;
            }
        } else if (ExamMonitorFaceEnum.TYPE_SCREEN.getCode().equals(shotType.getCode())) {
            if (examMonitorFace.getScreenshot() == null || examMonitorFace.getScreenshot() <= 0) {
                return;
            }
        } else if (ExamMonitorFaceEnum.TYPE_PHONE.getCode().equals(shotType.getCode())) {
            // empty if block
        }
        String subPath = this.getScreenshotUploadRelativePath(examMonitorFace.getExamId(), examMonitorFace.getUserId(), examMonitorFace.getResultId(), shotType.getCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String key = subPath + "/" + sdf.format(examMonitorFace.getCreatedate()) + ".jpg";
        if (log.isDebugEnabled()) {
            log.debug("downloadKey:" + key);
        }
        DownloadFileUtil.downloadResourceFile((String)key, (String)"foo.jpg", (HttpServletResponse)response);
    }

    @Override
    public int deleteScreenshotFiles(Long examId) {
        String filepath = "upload/examclient/" + examId;
        String absfilepath = CommonUtil.formatByEndSlash(AppPathUtil.getResourceLocalPath()) + filepath;
        return FileUtil.clearDir(absfilepath);
    }

    @Override
    public int deleteOldExamScreenshotFiles(int beforeDays) {
        if (beforeDays <= 0) {
            return 0;
        }
        int totalDelNum = 0;
        Date enddate = new Date(System.currentTimeMillis() - 86400000L * (long)beforeDays);
        ExamArrangeQuery query = new ExamArrangeQuery();
        query.setFaceenter(1);
        query.setEndtimeEnd(enddate);
        query.getPage().setPageSize(100);
        query.getPage().setSortColumns("ea.ARRANGEID");
        for (int i = 0; i < 10000; ++i) {
            query.getPage().setPageNumber(i + 1);
            List exams = this.examArrangePlusService.getPrdEntityDao().findList((IQuery)query);
            if (CollectionUtils.isEmpty((Collection)exams)) break;
            for (ExamArrange exam : exams) {
                totalDelNum += this.deleteScreenshotFiles(exam.getArrangeId());
            }
        }
        return totalDelNum;
    }

    @Override
    public boolean isMatchFace(Long userId, Long examId, Long resultId, String faceBase64) {
        if (userId == null || faceBase64 == null || faceBase64.isEmpty()) {
            log.warn("invalid param[userId:{}, faceBase64:{}]", (Object)userId, (Object)faceBase64);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("userId:{}", (Object)userId);
            log.debug("faceBase64:{}---END---", (Object)faceBase64);
        }
        long startMs = System.currentTimeMillis();
        boolean bMatchFace = this.examClient3rdService.isMatchFace(userId, faceBase64);
        ExamDatajobLog logModel = this.examDatajobLogPlusService.newInstance("INFO");
        logModel.setUserId(userId);
        logModel.setArrangeId(examId);
        logModel.setResultId(resultId);
        logModel.setLogcontent("\u4eba\u8138\u5339\u914d\u7ed3\u679c[" + bMatchFace + "][spentms:" + (System.currentTimeMillis() - startMs) + "][faceBase64Len:" + faceBase64.length() + "]");
        logModel.setBiztypename("FACEMATCH");
        this.examDatajobLogPlusService.insertLog(logModel);
        return bMatchFace;
    }

    @Override
    public Integer updateExamMonitorByFaceMatch(Boolean isMatch, Long resultId, int allowMaxFailNum) {
        int status;
        if (isMatch == null) {
            return null;
        }
        Date now = new Date();
        ExamMonitor examMonitor = (ExamMonitor)this.examMonitorPlusService.getById(resultId);
        if (examMonitor == null) {
            return null;
        }
        int n = status = isMatch != false ? 5 : 4;
        if (isMatch.booleanValue()) {
            boolean faceFail;
            boolean bl = faceFail = examMonitor.getStatus() != null && examMonitor.getStatus() == 4;
            if (faceFail) {
                examMonitor.setStatus(status);
                ExamMonitor tmp = new ExamMonitor(resultId);
                tmp.setStatus(examMonitor.getStatus());
                tmp.setActivedate(now);
                this.examMonitorPlusService.updateSelective(tmp);
            }
        } else {
            ExamMonitorFaceQuery examMonitorFaceQuery = new ExamMonitorFaceQuery();
            examMonitorFaceQuery.setResultId(resultId);
            examMonitorFaceQuery.getPage().setSortColumns("createdate desc");
            examMonitorFaceQuery.getPage().setPageSize(allowMaxFailNum);
            List faceList = this.examMonitorFacePlusService.getPrdEntityDao().findList((IQuery)examMonitorFaceQuery);
            int errNum = 0;
            for (ExamMonitorFace face : faceList) {
                if (face.getStatus() == null || face.getStatus() != 4) continue;
                ++errNum;
            }
            if (errNum >= allowMaxFailNum) {
                boolean humanPass;
                boolean bl = humanPass = examMonitor.getStatus() != null && examMonitor.getStatus() == 2;
                if (!humanPass) {
                    examMonitor.setStatus(status);
                    ExamMonitor tmp = new ExamMonitor(resultId);
                    tmp.setStatus(examMonitor.getStatus());
                    tmp.setActivedate(now);
                    this.examMonitorPlusService.updateSelective(tmp);
                }
            }
        }
        return examMonitor.getStatus();
    }

    @Override
    public void saveImgData(Long examId, Long userId, Long resultId, byte[] imagedata, ExamMonitorFaceEnum captureType, String filename) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imagedata));
        String filepath = this.getScreenshotUploadRelativePath(examId, userId, resultId, captureType.getCode());
        String fileabspathname = CommonUtil.formatByEndSlash(AppPathUtil.getResourceLocalPath()) + filepath + "/" + filename;
        File dir = new File(CommonUtil.formatByEndSlash(AppPathUtil.getResourceLocalPath()) + filepath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ImageIO.write((RenderedImage)bufferedImage, filename.substring(filename.lastIndexOf(".") + 1), new File(fileabspathname));
        IOssService ossService = (IOssService)SpringUtil.getBean((String)this.appCommonConfig.getOssServiceName());
        ossService.uploadFile(AppPathUtil.getResourceLocalPath(), filepath + "/" + filename);
    }
}

