/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examdocuments.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examdocuments.bo.ExamDocumentsQueryBO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.common.model.ExamFiles;
import com.peak.prd.exam.common.service.IExamFilesPlusService;
import com.peak.prd.exam.examdocuments.dao.IExamDocumentsPlusDao;
import com.peak.prd.exam.examdocuments.enums.ExamDocumentsTypeEnum;
import com.peak.prd.exam.examdocuments.model.ExamDocuments;
import com.peak.prd.exam.examdocuments.service.IExamDocumentsPlusService;
import com.peak.prd.exam.examdocuments.vo.ExamDocumentsQuery;
import com.peak.prd.exam.examdocuments.vo.ExamDocumentsVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamDocumentsPlusService
extends PrdBaseService<ExamDocuments, Long, ExamDocumentsQuery>
implements IExamDocumentsPlusService {
    @Autowired
    private IExamFilesPlusService examFilesPlusService;
    private IExamDocumentsPlusDao examDocumentsPlusDao;

    public void setExamDocumentsPlusDao(IExamDocumentsPlusDao dao) {
        this.examDocumentsPlusDao = dao;
    }

    public IExamDocumentsPlusDao getExamDocumentsPlusDao() {
        return this.examDocumentsPlusDao;
    }

    public IEntityDao<ExamDocuments, Long, ExamDocumentsQuery> getEntityDao() {
        return this.examDocumentsPlusDao;
    }

    @Override
    public ExamDocumentsVO getDocVO(Long docId) {
        ExamDocuments doc = (ExamDocuments)this.getById(docId);
        if (doc == null) {
            return null;
        }
        ExamDocumentsVO vo = (ExamDocumentsVO)ConvertUtil.convert((Object)doc, ExamDocumentsVO.class);
        this.setProperties(Arrays.asList(vo));
        return vo;
    }

    private void setProperties(List<ExamDocumentsVO> vos) {
        UserCoreUtil.setUserProperties(vos, ExamDocumentsVO::getCreatorId, (BiConsumer[])new BiConsumer[]{(vo, u) -> vo.setCreatorName(u.getName())});
        List ids = IdUtil.getIds(vos, v -> v.getFileId());
        ConvertUtil.removeNull((List)ids);
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            List examFiles = this.examFilesPlusService.getByIds(ids);
            block0: for (int i = 0; examFiles != null && i < vos.size(); ++i) {
                Long fileId = vos.get(i).getFileId();
                if (fileId == null) continue;
                for (int j = 0; j < examFiles.size(); ++j) {
                    if (!fileId.equals(((ExamFiles)examFiles.get(j)).getFileId())) continue;
                    vos.get(i).setFilename(((ExamFiles)examFiles.get(j)).getSrcfilename());
                    continue block0;
                }
            }
        }
    }

    @Override
    public ExamDocumentsVO findNoticeVO(ExamDocumentsQueryBO bo) {
        if (bo.getArrangeId() == null) {
            return null;
        }
        ExamDocumentsQuery query = new ExamDocumentsQuery(1, 10);
        query.setArrangeId(bo.getArrangeId());
        query.setDocumentstype(ExamDocumentsTypeEnum.TYPE_NOTICE.getValue());
        query.getPage().setSortColumns("CREATEDATE desc");
        List models = this.examDocumentsPlusDao.findList(query, "findAll");
        List vos = ConvertUtil.convert((List)models, ExamDocumentsVO.class);
        this.setProperties(vos);
        return CollectionUtils.isEmpty((Collection)vos) ? null : (ExamDocumentsVO)vos.get(0);
    }

    @Override
    public List<ExamDocumentsVO> findOtherVOs(ExamDocumentsQueryBO bo) {
        if (bo.getArrangeId() == null) {
            return null;
        }
        ExamDocumentsQuery query = new ExamDocumentsQuery(1, 99);
        query.setArrangeId(bo.getArrangeId());
        query.setName(bo.getName());
        query.setDocumentstypes(Arrays.asList(ExamDocumentsTypeEnum.TYPE_DOC.getValue(), ExamDocumentsTypeEnum.TYPE_LINK_IN.getValue(), ExamDocumentsTypeEnum.TYPE_LINK_OUT.getValue()));
        query.getPage().setSortColumns("ordernum, CREATEDATE desc");
        List models = this.examDocumentsPlusDao.findList(query, "findAll");
        List vos = ConvertUtil.convert((List)models, ExamDocumentsVO.class);
        this.setProperties(vos);
        return vos;
    }

    @Override
    public int deleteExamDocuments(Long documentsId) {
        if (documentsId == null) {
            return 0;
        }
        return this.deleteById(documentsId);
    }
}

