/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exammonitor.service.imple;

import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.exammonitor.dao.IExamMonErrorPlusDao;
import com.peak.prd.exam.exammonitor.model.ExamMonError;
import com.peak.prd.exam.exammonitor.service.IExamMonErrorPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonErrorQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamMonErrorPlusService
extends PrdBaseService<ExamMonError, Map<String, Object>, ExamMonErrorQuery>
implements IExamMonErrorPlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamMonErrorPlusService.class);
    @Resource
    private IExamMonErrorPlusDao examMonErrorPlusDao;

    public IEntityDao<ExamMonError, Map<String, Object>, ExamMonErrorQuery> getEntityDao() {
        return this.examMonErrorPlusDao;
    }

    @Override
    public void insertError(Long resultId, Integer errorCount, Exception ex) {
        ExamMonError model = new ExamMonError(resultId, errorCount);
        model.setCreatedate(new Date());
        model.setContent(this.getErrorString(ex, 1000));
        this.insert((BaseEntity)model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorString(Exception ex, int limitChars) {
        ByteArrayOutputStream bos = null;
        StringBuilder sb = new StringBuilder();
        try {
            bos = new ByteArrayOutputStream(16384);
            try (PrintStream ps = new PrintStream(bos);){
                ex.printStackTrace(ps);
                sb.append(bos.toString());
            }
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        String str = sb.toString();
        if (str.length() > limitChars) {
            return str.substring(0, limitChars);
        }
        return str;
    }
}

