/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exammonitor.service.imple;

import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.exammonitor.dao.IExamMonPlusDao;
import com.peak.prd.exam.exammonitor.model.ExamMon;
import com.peak.prd.exam.exammonitor.service.IExamMonErrorPlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonQuery;
import com.peak.prd.exam.exammonitor.vo.ExamMonVO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamMonPlusService
extends PrdBaseService<ExamMon, Long, ExamMonQuery>
implements IExamMonPlusService {
    @Autowired
    private IExamMonErrorPlusService examMonErrorPlusService;
    private IExamMonPlusDao examMonPlusDao;

    public void setExamMonPlusDao(IExamMonPlusDao dao) {
        this.examMonPlusDao = dao;
    }

    public IExamMonPlusDao getExamMonPlusDao() {
        return this.examMonPlusDao;
    }

    public IEntityDao<ExamMon, Long, ExamMonQuery> getEntityDao() {
        return this.examMonPlusDao;
    }

    @Override
    public int resetRecentErrornum(int days) {
        return this.examMonPlusDao.resetRecentErrornum(days);
    }

    @Override
    public void addError(ExamMon examMon, Exception ex) {
        examMon.setErrornum(examMon.getErrornum() == null ? 1 : examMon.getErrornum() + 1);
        examMon.setTotalerrornum(examMon.getTotalerrornum() == null ? 1 : examMon.getTotalerrornum() + 1);
        examMon.setCreatedate(null);
        examMon.setErrordate(new Date());
        this.updateSelective(examMon);
        this.examMonErrorPlusService.insertError(examMon.getResultId(), examMon.getTotalerrornum(), ex);
    }

    @Override
    public Paging<ExamMonVO> findPaging(ExamMonQuery examMonQuery) {
        long totalCount = this.examMonPlusDao.findVOCount(examMonQuery);
        List<ExamMonVO> vos = this.examMonPlusDao.findVOList(examMonQuery);
        Paging paging = new Paging(examMonQuery.getPage().getPageNumber(), examMonQuery.getPage().getPageSize());
        paging.setTotalCount(totalCount);
        paging.setList(vos);
        return paging;
    }

    @Override
    public List<ExamMon> getScanListByResult(ExamMonQuery query) {
        return this.examMonPlusDao.findList(query, "getScanListByResult");
    }
}

