/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exammonitor.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.exammonitor.dao.IExamMonitorCheatPlusDao;
import com.peak.prd.exam.exammonitor.model.ExamMonitor;
import com.peak.prd.exam.exammonitor.model.ExamMonitorCheat;
import com.peak.prd.exam.exammonitor.service.IExamMonitorCheatPlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonitorPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorCheatQuery;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorCheatVO;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExamMonitorCheatPlusService
extends PrdBaseService<ExamMonitorCheat, Long, ExamMonitorCheatQuery>
implements IExamMonitorCheatPlusService {
    @Autowired
    private IExamMonitorPlusService examMonitorPlusService;
    private IExamMonitorCheatPlusDao examMonitorCheatPlusDao;

    public void setExamMonitorCheatPlusDao(IExamMonitorCheatPlusDao dao) {
        this.examMonitorCheatPlusDao = dao;
    }

    public IExamMonitorCheatPlusDao getExamMonitorCheatPlusDao() {
        return this.examMonitorCheatPlusDao;
    }

    public IEntityDao<ExamMonitorCheat, Long, ExamMonitorCheatQuery> getEntityDao() {
        return this.examMonitorCheatPlusDao;
    }

    @Override
    public Long insertCheat(ExamMonitorCheat cheat) {
        if (cheat == null || cheat.getResultId() == null) {
            return null;
        }
        this.insert((BaseEntity)cheat);
        this.updateMonitorCheatInfo(cheat.getResultId());
        return cheat.getMcId();
    }

    @Override
    public void insertCheatBatch(List<ExamMonitorCheat> cheatList) {
        if (cheatList == null || cheatList.isEmpty()) {
            return;
        }
        this.insertBatch(cheatList);
        List resultIds = IdUtil.getIds(cheatList, e -> e.getResultId());
        for (int i = 0; resultIds != null && i < resultIds.size(); ++i) {
            this.updateMonitorCheatInfo((Long)resultIds.get(i));
        }
    }

    @Override
    public List<ExamMonitorCheatVO> groupByArrangeUsers(Long arrangeId, List<Long> userIds) {
        return this.examMonitorCheatPlusDao.groupByArrangeUsers(arrangeId, userIds);
    }

    @Override
    public int deleteByResultAndType(Long resultId, int type) {
        return this.examMonitorCheatPlusDao.deleteByResultAndType(resultId, type);
    }

    @Override
    public void fillExamMonitorVOs(List<ExamMonitorVO> examMonitorVOs) {
        boolean hasCheat = this.hasCheat(examMonitorVOs);
        if (!hasCheat) {
            return;
        }
        List cheatList = null;
        List resultIds = IdUtil.getIds(examMonitorVOs, e -> e.getResultId());
        if (resultIds != null && resultIds.size() > 0) {
            ExamMonitorCheatQuery query = new ExamMonitorCheatQuery(1, 9999);
            query.setColumns("resultId, remark");
            query.setResultIds(resultIds);
            query.getPage().setSortColumns("resultId, createdate");
            cheatList = this.examMonitorCheatPlusDao.findList(query);
        }
        if (ListUtil.isNullorEmpty(cheatList)) {
            return;
        }
        for (int i = 0; i < examMonitorVOs.size(); ++i) {
            ExamMonitorVO examMonitorVO = examMonitorVOs.get(i);
            if (examMonitorVO.getResultId() == null) continue;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < cheatList.size(); ++j) {
                ExamMonitorCheat cheat = (ExamMonitorCheat)cheatList.get(j);
                if (examMonitorVO.getResultId().equals(cheat.getResultId())) {
                    sb.append(";").append(cheat.getRemark());
                    continue;
                }
                if (sb.length() > 0) break;
            }
            examMonitorVO.setCheatinfo(sb.length() == 0 ? "" : sb.substring(1));
        }
    }

    private void updateMonitorCheatInfo(Long resultId) {
        if (resultId == null) {
            return;
        }
        ExamMonitorCheatQuery query = new ExamMonitorCheatQuery();
        query.setResultId(resultId);
        long cheatNum = this.count(query);
        ExamMonitor tmp = new ExamMonitor(resultId);
        tmp.setCheatinfo(cheatNum + "");
        tmp.setCheatcount((int)cheatNum);
        this.examMonitorPlusService.updateSelective(tmp);
    }

    private boolean hasCheat(List<ExamMonitorVO> examMonitorVOs) {
        if (ListUtil.isNullorEmpty(examMonitorVOs)) {
            return false;
        }
        for (int i = 0; i < examMonitorVOs.size(); ++i) {
            ExamMonitorVO examMonitorVO = examMonitorVOs.get(i);
            if (examMonitorVO.getCheatcount() == null || examMonitorVO.getCheatcount() <= 0) continue;
            return true;
        }
        return false;
    }
}

