/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exammonitor.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.exammonitor.bo.ExamMonitorFaceQueryBO;
import com.peak.prd.exam.exammonitor.dao.IExamMonitorFacePlusDao;
import com.peak.prd.exam.exammonitor.model.ExamMonitorFace;
import com.peak.prd.exam.exammonitor.service.IExamMonitorFacePlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorFaceQuery;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorFaceVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamMonitorFacePlusService
extends PrdBaseService<ExamMonitorFace, Long, ExamMonitorFaceQuery>
implements IExamMonitorFacePlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamMonitorFacePlusService.class);
    private IExamMonitorFacePlusDao examMonitorFacePlusDao;

    public void setExamMonitorFacePlusDao(IExamMonitorFacePlusDao dao) {
        this.examMonitorFacePlusDao = dao;
    }

    public IExamMonitorFacePlusDao getExamMonitorFacePlusDao() {
        return this.examMonitorFacePlusDao;
    }

    public IEntityDao<ExamMonitorFace, Long, ExamMonitorFaceQuery> getEntityDao() {
        return this.examMonitorFacePlusDao;
    }

    @Override
    public Paging<ExamMonitorFaceVO> getPaging(ExamMonitorFaceQueryBO queryBO) {
        if (queryBO == null || queryBO.getResultId() == null) {
            return null;
        }
        ExamMonitorFaceQuery examMonitorFaceQuery = (ExamMonitorFaceQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamMonitorFaceQuery.class);
        examMonitorFaceQuery.getPage().setSortColumns("createdate desc");
        long totalCount = this.examMonitorFacePlusDao.count(examMonitorFaceQuery);
        List faceList = this.examMonitorFacePlusDao.findList(examMonitorFaceQuery);
        Paging paging = new Paging(queryBO.getPageNumber(), queryBO.getPageSize());
        paging.setTotalCount(totalCount);
        paging.setList(ConvertUtil.convert((List)faceList, ExamMonitorFaceVO.class));
        return paging;
    }

    @Override
    public ExamMonitorFace getByParam(Long emfId, Long resultId, String shotdate) {
        if (emfId != null) {
            return (ExamMonitorFace)this.getById(emfId);
        }
        if (resultId != null && !StringUtil.isNullorEmptyStr((String)shotdate)) {
            if (shotdate.replaceAll("[_\\d]", "").length() > 0) {
                log.warn("invalid shotdate[{}]", (Object)shotdate);
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
            Date dtShotdate = null;
            try {
                dtShotdate = sdf.parse(shotdate);
            }
            catch (ParseException e) {
                log.warn("invalid shotdate [{}]", (Object)shotdate);
                return null;
            }
            ExamMonitorFaceQuery query = new ExamMonitorFaceQuery(1, 1);
            query.setResultId(resultId);
            query.setCreatedate(dtShotdate);
            return (ExamMonitorFace)this.examMonitorFacePlusDao.findOne(query);
        }
        return null;
    }

    @Override
    public ExamMonitorFace getByParam(Long resultId, Date shotdate) {
        if (resultId == null || shotdate == null) {
            return null;
        }
        ExamMonitorFaceQuery query = new ExamMonitorFaceQuery(1, 1);
        query.setResultId(resultId);
        query.setCreatedate(shotdate);
        return (ExamMonitorFace)this.examMonitorFacePlusDao.findOne(query);
    }
}

