/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exammonitor.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.exammonitor.bo.ExamMonitorQueryBO;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.exammonitor.dao.IExamMonitorPlusDao;
import com.peak.prd.exam.exammonitor.model.ExamMonitor;
import com.peak.prd.exam.exammonitor.service.IExamMonitorCheatPlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonitorPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorQuery;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorSummaryVO;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorUserVO;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorVO;
import com.peak.prd.exam.examuser.model.ExamUser;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamMonitorPlusService
extends PrdBaseService<ExamMonitor, Long, ExamMonitorQuery>
implements IExamMonitorPlusService {
    @Autowired
    IExamArrangePlusService examArrangePlusService;
    private IExamMonitorPlusDao examMonitorPlusDao;

    public void setExamMonitorPlusDao(IExamMonitorPlusDao dao) {
        this.examMonitorPlusDao = dao;
    }

    public IExamMonitorPlusDao getExamMonitorPlusDao() {
        return this.examMonitorPlusDao;
    }

    public IEntityDao<ExamMonitor, Long, ExamMonitorQuery> getEntityDao() {
        return this.examMonitorPlusDao;
    }

    @Override
    public ExamMonitorSummaryVO getSummaryVO(ExamMonitorQuery examMonitorQuery) {
        if (CollectionUtils.isEmpty(examMonitorQuery.getArrangeIds())) {
            return null;
        }
        int allNum = this.examMonitorPlusDao.countAllExamUser(examMonitorQuery);
        int noEnterNum = this.examMonitorPlusDao.countNoEnterExamUser(examMonitorQuery);
        int ingNum = this.examMonitorPlusDao.countIngExamUser(examMonitorQuery);
        int completeNum = this.examMonitorPlusDao.countCompleteExamUser(examMonitorQuery);
        int suspendNum = this.examMonitorPlusDao.countSuspendExamUser(examMonitorQuery);
        int abnormalNum = this.examMonitorPlusDao.countAbnormalExamUser(examMonitorQuery);
        ExamMonitorSummaryVO vo = new ExamMonitorSummaryVO();
        vo.setAllNum(allNum);
        vo.setNoEnterNum(noEnterNum);
        vo.setIngNum(ingNum);
        vo.setCompleteNum(completeNum);
        vo.setSuspendNum(suspendNum);
        vo.setAbnormalNum(abnormalNum);
        return vo;
    }

    @Override
    public Paging<ExamMonitorUserVO> getAllExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countAllExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getAllExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public Paging<ExamMonitorUserVO> getNoEnterExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countNoEnterExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getNoEnterExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public Paging<ExamMonitorUserVO> getIngExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countIngExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getIngExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public Paging<ExamMonitorUserVO> getCompleteExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countCompleteExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getCompleteExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public Paging<ExamMonitorUserVO> getSuspendExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countSuspendExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getSuspendExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public Paging<ExamMonitorUserVO> getAbnormalExamUserPaging(ExamMonitorQuery examMonitorQuery) {
        int totalCount = this.examMonitorPlusDao.countAbnormalExamUser(examMonitorQuery);
        List<ExamUser> examUsers = this.examMonitorPlusDao.getAbnormalExamUsers(examMonitorQuery);
        return this._appendOtherProperties(totalCount, examUsers, examMonitorQuery);
    }

    @Override
    public long findVOCount(ExamMonitorQuery examMonitorQuery) {
        return this.examMonitorPlusDao.countVO(examMonitorQuery);
    }

    @Override
    public List<ExamMonitorVO> findVOList(ExamMonitorQuery examMonitorQuery) {
        List<ExamMonitorVO> vos = this.examMonitorPlusDao.findVOList(examMonitorQuery);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            String title = this.examArrangePlusService.getTitle(vos.get(i).getArrangeId());
            vos.get(i).setArrangeTitle(title);
        }
        UserCoreUtil.setUserProperties(vos, ExamMonitorVO::getUserId, (BiConsumer[])new BiConsumer[]{(vo, u) -> vo.setUsercode(u.getUsercode()), (vo, u) -> vo.setRealname(u.getName())});
        UserCoreUtil.setUserDeptId(vos, ExamMonitorVO::getUserId, ExamMonitorVO::setOrgId);
        OrgUtil.setOrgFullname(vos, ExamMonitorVO::getOrgId, ExamMonitorVO::setOrgFullname);
        ((IExamMonitorCheatPlusService)SpringUtil.getBean(IExamMonitorCheatPlusService.class)).fillExamMonitorVOs(vos);
        return vos;
    }

    @Override
    public List<ExamMonitorVO> findVOList(ExamMonitorQueryBO queryBO) {
        return this.findVOList((ExamMonitorQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamMonitorQuery.class));
    }

    private Paging<ExamMonitorUserVO> _appendOtherProperties(long totalCount, List<ExamUser> examUsers, ExamMonitorQuery examMonitorQuery) {
        List vos = ConvertUtil.convert(examUsers, ExamMonitorUserVO.class);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            String title = this.examArrangePlusService.getTitle(((ExamMonitorUserVO)vos.get(i)).getArrangeId());
            ((ExamMonitorUserVO)vos.get(i)).setArrangeTitle(title);
        }
        UserCoreUtil.setUserProperties((List)vos, ExamMonitorUserVO::getUserId, (BiConsumer[])new BiConsumer[]{(vo, u) -> vo.setUsercode(u.getUsercode()), (vo, u) -> vo.setRealname(u.getName())});
        UserCoreUtil.setUserDeptId((List)vos, ExamMonitorUserVO::getUserId, ExamMonitorUserVO::setOrgId);
        OrgUtil.setOrgFullname((List)vos, ExamMonitorUserVO::getOrgId, ExamMonitorUserVO::setOrgFullname);
        Paging paging = new Paging(examMonitorQuery.getPage());
        paging.setTotalCount(totalCount);
        paging.setList(vos);
        return paging;
    }

    @Override
    public Paging<ExamMonitorVO> findVOPaging(ExamMonitorQuery examMonitorQuery) {
        long totalCount = this.findVOCount(examMonitorQuery);
        List<ExamMonitorVO> vos = this.findVOList(examMonitorQuery);
        Paging paging = new Paging(examMonitorQuery.getPage().getPageNumber(), examMonitorQuery.getPage().getPageSize());
        paging.setTotalCount(totalCount);
        paging.setList(vos);
        return paging;
    }

    @Override
    public int delayTime(Integer delayTime, List<Long> resultIds) {
        return this.examMonitorPlusDao.delayTime(delayTime, resultIds);
    }

    @Override
    public int suspend(List<Long> resultIds) {
        return this.examMonitorPlusDao.suspend(resultIds);
    }

    @Override
    public int resume(List<Long> resultIds) {
        return this.examMonitorPlusDao.resume(resultIds);
    }

    @Override
    public int facePassByHuman(List<Long> resultIds) {
        return this.examMonitorPlusDao.facePassByHuman(resultIds);
    }

    @Override
    public int txForceSubmitPaper(List<Long> resultIds) {
        this.examMonitorPlusDao.forceMonitorSubmitPaper(resultIds);
        return this.examMonitorPlusDao.forceResultSubmitPaper(resultIds);
    }

    @Override
    public int batchDelayTime(Integer delayTime, List<Long> arrangeIds, Long orgId, Boolean includeSubOrg) {
        return this.examMonitorPlusDao.batchDelayTime(delayTime, arrangeIds, orgId, includeSubOrg);
    }

    @Override
    public int batchSuspend(List<Long> arrangeIds, Long orgId, Boolean includeSubOrg) {
        return this.examMonitorPlusDao.batchSuspend(arrangeIds, orgId, includeSubOrg);
    }

    @Override
    public int batchResume(List<Long> arrangeIds, Long orgId, Boolean includeSubOrg) {
        return this.examMonitorPlusDao.batchResume(arrangeIds, orgId, includeSubOrg);
    }

    @Override
    public int txBatchForceSubmitPaper(List<Long> arrangeIds, Long orgId, Boolean includeSubOrg) {
        this.examMonitorPlusDao.batchForceMonitorSubmitPaper(arrangeIds, orgId, includeSubOrg);
        return this.examMonitorPlusDao.batchForceResultSubmitPaper(arrangeIds, orgId, includeSubOrg);
    }
}

