/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exampaper.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.exampaper.bo.ExamPaperBO;
import com.peak.mng.exam.exampaper.vo.ExamPaperVO;
import com.peak.prd.appsecurity.org.service.IOrgPlusService;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.ExamResourceRelationEnum;
import com.peak.prd.enums.ExamResponseStatusEnum;
import com.peak.prd.exam.enums.ExamPapermethodEnum;
import com.peak.prd.exam.exampaper.dao.IExamPaperPlusDao;
import com.peak.prd.exam.exampaper.model.ExamPaper;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.model.ExamPaperType;
import com.peak.prd.exam.exampaper.service.IExamPaperPlusService;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.exampaper.service.IExamPaperTypePlusService;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuery;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionQuery;
import com.peak.prd.exam.exampaper.vo.ExamPaperTypeQuery;
import com.peak.prd.exam.examquestion.service.IExamQuestionClobPlusService;
import com.peak.prd.exam.examquestion.util.ExamQuestionClobUtil;
import com.peak.prd.exam.examresourcerelation.model.ExamResourceRelation;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationVO;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.examresult.vo.ExamResultQuery;
import com.peak.prd.exam.examshare.model.ExamShareresource;
import com.peak.prd.exam.examshare.service.IExamShareresourcePlusService;
import com.peak.prd.exam.examshare.vo.ExamShareresourceQuery;
import com.peak.prd.exam.examshare.vo.ExamShareresourceVO;
import com.peak.prd.exception.DataAuthException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperPlusService
extends PrdBaseService<ExamPaper, Long, ExamPaperQuery>
implements IExamPaperPlusService {
    private IExamPaperPlusDao examPaperPlusDao;
    @Autowired
    private IExamResultPlusService examResultPlusService;
    @Autowired
    private IExamPaperQuestionPlusService examPaperQuestionPlusService;
    @Autowired
    private IExamPaperTypePlusService examPaperTypePlusService;
    @Autowired
    private IExamQuestionClobPlusService examQuestionClobPlusService;
    @Autowired
    private IExamShareresourcePlusService examShareresourcePlusService;
    @Autowired
    private IExamResourceRelationPlusService examResourceRelationPlusService;
    @Autowired
    private IOrgPlusService orgPlusService;

    public void setExamPaperPlusDao(IExamPaperPlusDao dao) {
        this.examPaperPlusDao = dao;
    }

    public IExamPaperPlusDao getExamPaperPlusDao() {
        return this.examPaperPlusDao;
    }

    public IEntityDao<ExamPaper, Long, ExamPaperQuery> getEntityDao() {
        return this.examPaperPlusDao;
    }

    @Override
    public Long insertPaper(ExamPaperBO bo, Long userId, Long domainId) {
        bo = this.validPaperBO(bo);
        ExamPaper examPaper = new ExamPaper();
        ConvertUtil.copyProperties((Object)bo, (Object)examPaper);
        examPaper.setPaperId(IdUtil.getSequence((String)"EXAM_PAPER"));
        examPaper.setGkey(IdUtil.getGkey());
        examPaper.setStatus(0);
        examPaper.setCreatorId(userId);
        examPaper.setCreatedate(new Date());
        examPaper.setDomainId(domainId);
        examPaper.setPapertype(1);
        examPaper.setCreatebyarrangeId(bo.getArrangeIdLong());
        examPaper.setIstemplate(bo.getIstemplateInteger());
        this.insert((BaseEntity)examPaper);
        this.saveSubject(examPaper.getPaperId(), bo.getSubjectId(), userId);
        this.saveShare(examPaper.getPaperId(), userId, domainId, bo.getShareToDomainIds());
        return examPaper.getPaperId();
    }

    @Override
    public void updatePaper(ExamPaperBO bo, Long userId, Long domainId) {
        ExamPaper examPaper = (ExamPaper)this.getById((bo = this.validPaperBO(bo)).getPaperId());
        if (examPaper != null) {
            bo.setIstemplate(examPaper.getIstemplate());
        }
        ConvertUtil.copyProperties((Object)bo, (Object)examPaper);
        examPaper.setModifierId(userId);
        examPaper.setModifydate(new Date());
        this.update(examPaper);
        this.saveSubject(examPaper.getPaperId(), bo.getSubjectId(), userId);
        this.saveShare(examPaper.getPaperId(), userId, domainId, bo.getShareToDomainIds());
    }

    private void saveShare(Long paperId, Long currUserId, Long currMngDomainId, List<Long> shareToDomainIds) {
        if (paperId == null) {
            return;
        }
        Date now = new Date();
        ExamShareresourceQuery query = new ExamShareresourceQuery();
        query.setSharetype(2);
        query.setResourceId(paperId);
        this.examShareresourcePlusService.deleteByQuery(query);
        ArrayList<ExamShareresource> list = new ArrayList<ExamShareresource>();
        for (int i = 0; shareToDomainIds != null && i < shareToDomainIds.size(); ++i) {
            ExamShareresource sr = new ExamShareresource(IdUtil.getSequence((String)"EXAM_SHARERESOURCE"));
            sr.setSharetype(2);
            sr.setResourceId(paperId);
            sr.setCreatorId(currUserId);
            sr.setCreatecorpId(currMngDomainId);
            sr.setAcceptcorpId(shareToDomainIds.get(i));
            sr.setCreatedate(now);
            sr.setPermit(0);
            list.add(sr);
        }
        this.examShareresourcePlusService.insertBatch(list);
    }

    private void saveSubject(Long paperId, Long subjectId, Long userId) {
        if (paperId == null) {
            return;
        }
        Long rtId = IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION");
        ExamResourceRelation examResourceRelation_Subject = new ExamResourceRelation();
        examResourceRelation_Subject.setRtId(rtId);
        examResourceRelation_Subject.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_SUBJECT.getValue());
        examResourceRelation_Subject.setResourceId(subjectId);
        examResourceRelation_Subject.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_PAPER.getValue());
        examResourceRelation_Subject.setExamresourceId(paperId);
        examResourceRelation_Subject.setCreatedate(new Date());
        examResourceRelation_Subject.setCreatorId(userId);
        ExamResourceRelationQuery query = new ExamResourceRelationQuery();
        query.setExamresourceId(examResourceRelation_Subject.getExamresourceId());
        query.setExamtype(examResourceRelation_Subject.getExamtype());
        query.setResourcetype(examResourceRelation_Subject.getResourcetype());
        this.examResourceRelationPlusService.deleteByQuery(query);
        this.examResourceRelationPlusService.insert((BaseEntity)examResourceRelation_Subject);
    }

    @Override
    public <VO> void setPaperTitle(List<VO> vos, Function<VO, Long> getPaperIdFunc, BiConsumer<VO, String> setPaperTitleFunc) {
        List<ExamPaper> papers = this.getSortExamPapers(vos, getPaperIdFunc);
        if (papers == null || papers.isEmpty()) {
            return;
        }
        for (int i = 0; i < vos.size(); ++i) {
            VO vo = vos.get(i);
            ExamPaper examPaper = papers.get(i);
            if (vo == null || examPaper == null) continue;
            setPaperTitleFunc.accept(vo, examPaper.getTitle());
        }
    }

    @Override
    public <VO> void setPaperProperties(List<VO> vos, Function<VO, Long> getPaperIdFunc, BiConsumer<VO, ExamPaper> ... funcs) {
        List<ExamPaper> papers = this.getSortExamPapers(vos, getPaperIdFunc);
        if (papers == null || papers.isEmpty()) {
            return;
        }
        for (int i = 0; i < funcs.length; ++i) {
            ConvertUtil.setProperties(vos, papers, funcs[i]);
        }
    }

    private <T> List<ExamPaper> getSortExamPapers(List<T> vos, Function<T, Long> getPaperIdFunc) {
        if (vos == null) {
            return null;
        }
        List paperIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, vo -> (Long)getPaperIdFunc.apply(vo)));
        paperIds = ListUtil.removeDuplicate((List)paperIds);
        List papers = this.getByIds(paperIds);
        List sortedPapers = ConvertUtil.refact(vos, (List)papers, (vo, u) -> {
            Long voUid = (Long)getPaperIdFunc.apply(vo);
            return voUid != null && voUid.equals(u.getPaperId());
        });
        return sortedPapers;
    }

    private ExamPaperQuery buildQuery(ExamPaperQuery query, Long currMngDomainId, boolean selector) {
        query.setPapertype(1);
        query.setCreatebyarrangeId(0L);
        if (selector) {
            query.setStatus(1);
            if (query.getDomainId() == null) {
                query.setSelectDomainId(currMngDomainId);
                query.setIncludeShare(true);
            } else {
                query.setSelectDomainId(query.getDomainId());
                query.setIncludeShare(false);
            }
            query.setDomainId(null);
        } else if (query.getDomainId() == null) {
            query.setDomainId(currMngDomainId);
        }
        return query;
    }

    @Override
    public Paging<ExamPaperVO> findVOPaging(ExamPaperQuery query, Long currMngDomainId, boolean selector) {
        query = this.buildQuery(query, currMngDomainId, selector);
        return this._findVOPaging(query);
    }

    @Override
    public List<ExamPaperVO> getPaperTemplateList(Long domainId) {
        if (domainId == null) {
            return null;
        }
        ExamPaperQuery examPaperQuery = new ExamPaperQuery(1, 99);
        examPaperQuery.setDomainId(domainId);
        examPaperQuery.setDomainIdIncUp(false);
        examPaperQuery.setDomainIdIncSub(false);
        examPaperQuery.setIstemplate(1);
        examPaperQuery.getPage().setSortColumns("title");
        List papers = this.examPaperPlusDao.findList(examPaperQuery);
        List vos = ConvertUtil.convert((List)papers, ExamPaperVO.class);
        return vos;
    }

    @Override
    public ExamPaperVO findExamPaperVO(@NotNull Long paperId) {
        ExamPaperQuery query = new ExamPaperQuery();
        query.setPaperId(paperId);
        Paging<ExamPaperVO> paging = this._findVOPaging(query);
        if (paging.getTotalCount() == 0L) {
            return null;
        }
        ExamPaperVO vo = (ExamPaperVO)paging.getList().get(0);
        ExamShareresourceQuery examShareresourceQuery = new ExamShareresourceQuery();
        examShareresourceQuery.setSharetype(2);
        examShareresourceQuery.setResourceId(paperId);
        List shares = this.examShareresourcePlusService.findAll(examShareresourceQuery);
        List shareVOs = ConvertUtil.convert((List)shares, ExamShareresourceVO.class);
        ConvertUtil.setProperties((List)shareVOs, (List)shares, (v, s) -> v.setDomainId(s.getAcceptcorpId()));
        OrgUtil.setOrgName((List)shareVOs, ExamShareresourceVO::getDomainId, ExamShareresourceVO::setDomainName);
        vo.setShareVOs(shareVOs);
        return vo;
    }

    @Override
    public boolean isUsed(@NotNull Long paperId) {
        if (paperId == null) {
            return false;
        }
        ExamResultQuery examResultQuery = new ExamResultQuery();
        examResultQuery.setPaperId(paperId);
        return this.examResultPlusService.getPrdEntityDao().findOne((IQuery)examResultQuery) != null;
    }

    @Override
    public void deletePaper(@NotNull Long paperId) {
        if (paperId == null) {
            return;
        }
        ExamPaperQuestionQuery pqQuery = new ExamPaperQuestionQuery();
        pqQuery.setPaperId(paperId);
        this.examPaperQuestionPlusService.deleteByQuery(pqQuery);
        ExamPaperTypeQuery examPaperTypeQuery = new ExamPaperTypeQuery();
        examPaperTypeQuery.setPaperId(paperId);
        this.examPaperTypePlusService.deleteByQuery(examPaperTypeQuery);
        this.deleteById(paperId);
    }

    @Override
    public Long copyFixedPaper(Long paperId, Long currUserId, Long currDomainId) throws Exception {
        ExamPaper examPaper = (ExamPaper)this.getById(paperId);
        if (examPaper == null) {
            throw new RuntimeException("\u8bd5\u5377\u672a\u627e\u5230[" + paperId + "]");
        }
        if (examPaper.getPapermethod() == null) {
            throw new RuntimeException("\u8bd5\u5377\u7c7b\u578b\u7a7a[" + paperId + "]");
        }
        if (ExamPapermethodEnum.isFixed(examPaper.getPapermethod())) {
            return this.copyFixedPaper(examPaper, currUserId, currDomainId);
        }
        throw new RuntimeException("\u4e0d\u662f\u56fa\u5b9a\u8bd5\u5377[" + paperId + "]");
    }

    @Override
    public boolean fulfillPaperFullmark(Long paperId) {
        ExamPaper examPaper = (ExamPaper)this.getById(paperId);
        if (examPaper == null || examPaper.getFullmark() == null) {
            return false;
        }
        if (examPaper.getFullmark() <= 0) {
            return false;
        }
        Double questionSumScore = this.examPaperQuestionPlusService.getQuestionSumScore(paperId);
        if (questionSumScore == null) {
            return false;
        }
        double abs = Math.abs(examPaper.getFullmark().doubleValue() - questionSumScore);
        return abs < 0.01;
    }

    @Override
    public ExamPaperBO validPaperBO(ExamPaperBO bo) {
        if (bo.getIssetshare() == null || bo.getIssetshare() != 1) {
            bo.setSharetosubcorp(0);
            bo.setShareToDomainIds(null);
        } else {
            boolean b2;
            boolean b1 = bo.getSharetosubcorp() != null && bo.getSharetosubcorp() > 0;
            boolean bl = b2 = bo.getIssetsharedomain() != null && bo.getIssetsharedomain() > 0;
            if (!b1 && !b2) {
                ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_INVALID_PAPER_SETTING_SHARE_NONE);
                return null;
            }
            if (!b2) {
                bo.setShareToDomainIds(null);
            } else if (bo.getShareToDomainIds() == null || bo.getShareToDomainIds().isEmpty()) {
                ExceptionUtil.handle((IRespStatusEnum)ExamResponseStatusEnum.EXAM_INVALID_PAPER_SETTING_SHARE_NONE_DOMAIN);
                return null;
            }
        }
        return bo;
    }

    private Long copyFixedPaper(ExamPaper examPaper, Long currUserId, Long currDomainId) {
        Date now = new Date();
        Long newPaperId = IdUtil.getSequence((String)"EXAM_PAPER");
        HashMap<Long, Long> ptMap = new HashMap<Long, Long>();
        ExamPaperTypeQuery examPaperTypeQuery = new ExamPaperTypeQuery();
        examPaperTypeQuery.setPaperId(examPaper.getPaperId());
        List paperTypes = this.examPaperTypePlusService.findAll(examPaperTypeQuery);
        for (int i = 0; paperTypes != null && i < paperTypes.size(); ++i) {
            ((ExamPaperType)paperTypes.get(i)).setPaperId(newPaperId);
            Long oldPtId = ((ExamPaperType)paperTypes.get(i)).getPtId();
            Long newPtId = IdUtil.getSequence((String)"EXAM_PAPER_TYPE");
            ((ExamPaperType)paperTypes.get(i)).setPtId(newPtId);
            ptMap.put(oldPtId, newPtId);
        }
        ExamPaperQuestionQuery paperQuestionQuery = new ExamPaperQuestionQuery();
        paperQuestionQuery.setPaperId(examPaper.getPaperId());
        List paperQuestions = this.examPaperQuestionPlusService.findAll(paperQuestionQuery);
        for (int i = 0; paperQuestions != null && i < paperQuestions.size(); ++i) {
            ExamPaperQuestion pq = (ExamPaperQuestion)paperQuestions.get(i);
            if (pq.getUseclob() != null && pq.getUseclob() == 1) {
                pq = ExamQuestionClobUtil.loadPaperQuestionById(pq.getPqId());
                paperQuestions.set(i, pq);
            }
            pq.setPaperId(newPaperId);
            pq.setPqId(IdUtil.getSequence((String)"EXAM_PAPER_QUESTION"));
            Long oldPtId = pq.getPtId();
            if (oldPtId == null) continue;
            pq.setPtId((Long)ptMap.get(oldPtId));
        }
        ExamResourceRelationQuery rrQuery = new ExamResourceRelationQuery();
        rrQuery.setExamresourceId(examPaper.getPaperId());
        rrQuery.setExamtype(2);
        List rrs = this.examResourceRelationPlusService.findAll(rrQuery);
        for (int i = 0; rrs != null && i < rrs.size(); ++i) {
            ((ExamResourceRelation)rrs.get(i)).setExamresourceId(newPaperId);
            ((ExamResourceRelation)rrs.get(i)).setRtId(IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION"));
        }
        ExamPaper newPaper = examPaper;
        newPaper.setPaperId(newPaperId);
        newPaper.setTitle(examPaper.getTitle() + "_\u56fa\u5b9a\u526f\u672c_" + new SimpleDateFormat("yyyyMMddHHmmss").format(now));
        newPaper.setStatus(0);
        newPaper.setPapermethod(ExamPapermethodEnum.PAPERMETHOD_Fixed.getIndex());
        newPaper.setPapertype(1);
        newPaper.setCreatorId(currUserId);
        newPaper.setCreatedate(now);
        newPaper.setDomainId(currDomainId);
        newPaper.setContent(null);
        try {
            this.insert((BaseEntity)newPaper);
            if (paperQuestions != null && paperQuestions.size() > 0) {
                for (int i = 0; i < paperQuestions.size(); ++i) {
                    ExamPaperQuestion pq = (ExamPaperQuestion)paperQuestions.get(i);
                    if (pq.getUseclob() == null || pq.getUseclob() != 1) continue;
                    int useClob = this.examQuestionClobPlusService.saveLob(pq);
                    pq.setUseclob(useClob);
                }
                this.examPaperQuestionPlusService.insert(paperQuestions);
            }
            if (paperTypes != null && paperTypes.size() > 0) {
                this.examPaperTypePlusService.insert(paperTypes);
            }
            if (rrs != null && rrs.size() > 0) {
                this.examResourceRelationPlusService.insert(rrs);
            }
        }
        catch (Exception ex) {
            this.deleteById(newPaperId);
            throw ex;
        }
        return newPaperId;
    }

    private Paging<ExamPaperVO> _findVOPaging(ExamPaperQuery query) {
        query = (ExamPaperQuery)this.findPage(query);
        List vos = ConvertUtil.convert((List)query.getPage().getResult(), ExamPaperVO.class);
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery();
        examResourceRelationQuery.setExamtype(2);
        examResourceRelationQuery.setResourcetype(5);
        examResourceRelationQuery.getPage().setPageSize(100);
        List paperIds = IdUtil.getIds((List)vos, e -> e.getPaperId());
        examResourceRelationQuery.setExamresourceIds(paperIds);
        List errVOs = CollectionUtils.isEmpty((Collection)paperIds) ? null : this.examResourceRelationPlusService.getPrdEntityDao().findList((IQuery)examResourceRelationQuery, "findVOAll", ExamResourceRelationVO.class);
        List sortedErrVOs = ConvertUtil.refact((List)paperIds, errVOs, (p, r) -> r == null ? false : p.equals(r.getExamresourceId()));
        ConvertUtil.setProperties((List)vos, (List)sortedErrVOs, (v, r) -> v.setSubjectId(r == null ? null : r.getResourceId()));
        ConvertUtil.setProperties((List)vos, (List)sortedErrVOs, (v, r) -> v.setSubjectName(r == null ? null : r.getResourceName()));
        OrgUtil.setOrgName((List)vos, ExamPaperVO::getDomainId, ExamPaperVO::setDomainName);
        UserCoreUtil.setUserRealname((List)vos, ExamPaperVO::getCreatorId, ExamPaperVO::setCreatorName);
        return new Paging(query.getPage(), vos);
    }

    public ExamPaper dataAuth(Long paperId, Long currUserId, Long curMngDomainId) {
        try {
            return (ExamPaper)super.dataAuth(paperId, currUserId, curMngDomainId);
        }
        catch (DataAuthException exception) {
            ExamPaperQuery query = new ExamPaperQuery(1, 1);
            query.setPaperId(paperId);
            boolean selector = true;
            query = this.buildQuery(query, curMngDomainId, selector);
            ExamPaper examPaper = (ExamPaper)this.examPaperPlusDao.findOne(query);
            if (examPaper == null) {
                throw exception;
            }
            return examPaper;
        }
    }
}

