/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exampaper.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examquestion.vo.ExamQuestionExpVO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.exampaper.dao.IExamPaperQuestionPlusDao;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionQuery;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionVO;
import com.peak.prd.exam.examquestion.util.ExamQuestionClobUtil;
import com.peak.prd.exam.examquestion.util.ExamQuestionExpUtil;
import com.peak.prd.exam.examquestion.util.ExamQuestionUtil;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperQuestionPlusService
extends PrdBaseService<ExamPaperQuestion, Long, ExamPaperQuestionQuery>
implements IExamPaperQuestionPlusService {
    private IExamPaperQuestionPlusDao examPaperQuestionPlusDao;

    public void setExamPaperQuestionPlusDao(IExamPaperQuestionPlusDao dao) {
        this.examPaperQuestionPlusDao = dao;
    }

    public IExamPaperQuestionPlusDao getExamPaperQuestionPlusDao() {
        return this.examPaperQuestionPlusDao;
    }

    public IEntityDao<ExamPaperQuestion, Long, ExamPaperQuestionQuery> getEntityDao() {
        return this.examPaperQuestionPlusDao;
    }

    @Override
    public boolean correctOrderNum(List<ExamPaperQuestion> list) {
        int i;
        if (list == null || list.isEmpty()) {
            return false;
        }
        HashSet<Integer> orderNumSet = new HashSet<Integer>();
        for (i = 0; i < list.size(); ++i) {
            Integer orderNum = list.get(i).getSequence();
            if (orderNum == null) continue;
            orderNumSet.add(orderNum);
        }
        if (orderNumSet.size() == list.size()) {
            return false;
        }
        for (i = 0; i < list.size(); ++i) {
            ExamPaperQuestion pq = new ExamPaperQuestion(list.get(i).getPqId());
            pq.setSequence(i + 1);
            this.updateSelective(pq);
        }
        return true;
    }

    @Override
    public void moveUpDown(ExamPaperQuestion pq, boolean isMoveUp) {
        if (pq == null || pq.getPaperId() == null) {
            return;
        }
        ExamPaperQuestionQuery query = new ExamPaperQuestionQuery();
        query.setPaperId(pq.getPaperId());
        query.getPage().setSortColumns(isMoveUp ? "SEQUENCE" : "SEQUENCE DESC");
        List list = this.findAll(query);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamPaperQuestion item = (ExamPaperQuestion)list.get(i);
            if (!pq.getPqId().equals(item.getPqId())) continue;
            if (i == 0) break;
            ExamPaperQuestion item1 = new ExamPaperQuestion(((ExamPaperQuestion)list.get(i - 1)).getPqId());
            item1.setSequence(((ExamPaperQuestion)list.get(i)).getSequence());
            this.updateSelective(item1);
            ExamPaperQuestion item2 = new ExamPaperQuestion(((ExamPaperQuestion)list.get(i)).getPqId());
            item2.setSequence(((ExamPaperQuestion)list.get(i - 1)).getSequence());
            this.updateSelective(item2);
            break;
        }
    }

    @Override
    public void deleteByQuery(ExamPaperQuestionQuery query) {
        this.examPaperQuestionPlusDao.deleteByQuery(query);
    }

    @Override
    public long countByPtId(Long ptId) {
        if (ptId == null) {
            return 0L;
        }
        ExamPaperQuestionQuery paperQuestionQuery = new ExamPaperQuestionQuery();
        paperQuestionQuery.setPtId(ptId);
        return this.count(paperQuestionQuery);
    }

    @Override
    public List<ExamPaperQuestion> getChildren(Long paperId, Long parentId) {
        if (paperId == null || parentId == null) {
            return null;
        }
        ExamPaperQuestionQuery query = new ExamPaperQuestionQuery();
        query.setPaperId(paperId);
        query.setParentId(parentId);
        query.getPage().setSortColumns("sequence, createdate, pqid");
        return this.findAll(query);
    }

    @Override
    public ExamPaperQuestion getByQuestionId(Long paperId, Long questionId) {
        if (paperId == null || questionId == null) {
            return null;
        }
        ExamPaperQuestionQuery examPaperQuestionQuery = new ExamPaperQuestionQuery();
        examPaperQuestionQuery.setPaperId(paperId);
        examPaperQuestionQuery.setQuestionId(questionId);
        ExamPaperQuestion pq = (ExamPaperQuestion)this.getPrdEntityDao().findOne((IQuery)examPaperQuestionQuery);
        return pq;
    }

    @Override
    public List<ExamPaperQuestion> getPaperAllQuestions(Long paperId) {
        return this.getPaperAllQuestions(paperId, false);
    }

    private List<ExamPaperQuestion> getPaperAllQuestions(Long paperId, boolean withClob) {
        if (paperId == null) {
            return null;
        }
        List<ExamPaperQuestion> paperAllQuestions = this.examPaperQuestionPlusDao.getPaperAllQuestions(paperId);
        if (paperAllQuestions == null || !withClob) {
            return paperAllQuestions;
        }
        for (int i = 0; i < paperAllQuestions.size(); ++i) {
            ExamQuestionClobUtil.loadPaperQuestion(paperAllQuestions.get(i));
        }
        return paperAllQuestions;
    }

    @Override
    public List<ExamQuestionExpVO> getPaperAllQuestionExpVOs(Long paperId) {
        List<ExamPaperQuestion> questions = this.getPaperAllQuestions(paperId, true);
        List vos = ConvertUtil.convert(questions, ExamQuestionExpVO.class);
        for (int i = 0; questions != null && i < questions.size(); ++i) {
            ExamPaperQuestion q = questions.get(i);
            ExamQuestionExpVO expVO = (ExamQuestionExpVO)((Object)vos.get(i));
            expVO.setScore(q.getScore() + "");
            expVO.setQuestionId(q.getQuestionId() + "");
            expVO.setDifficultyInteger(q.getDifficulty());
            ExamPaperQuestionVO qvo = ExamQuestionUtil.getExamPaperQuestionVO(q);
            if (!ExamQuestionUtil.isChoiceQuestion(q.getTypeId())) continue;
            expVO.setChoices(qvo.getChoices().stream().map(e -> e.getTitle()).collect(Collectors.toList()));
        }
        ExamQuestionExpUtil.appendAttrs(vos);
        return vos;
    }

    @Override
    public ExamPaperQuestion getById(Long pqId, boolean withClob) {
        if (withClob) {
            return ExamQuestionClobUtil.loadPaperQuestionById(pqId);
        }
        return (ExamPaperQuestion)this.getById(pqId);
    }

    @Override
    public Double getQuestionSumScore(Long paperId) {
        List<Long> complexTypeIds = ((IExamQuestiontypePlusService)SpringUtil.getBean(IExamQuestiontypePlusService.class)).getCachedAllComplexTypeIdsIncludeInvalid();
        return this.examPaperQuestionPlusDao.getQuestionSumScore(paperId, complexTypeIds);
    }

    @Override
    public boolean hasEqualQues(Long paperId, String content, Long typeId) {
        List<ExamPaperQuestion> list = this.findEqualQues(paperId, content, typeId, 1);
        return !CollectionUtils.isEmpty(list);
    }

    @Override
    public List<ExamPaperQuestion> findEqualQues(Long paperId, String content, Long typeId, int findNum) {
        if (content == null || content.trim().isEmpty()) {
            return null;
        }
        if (paperId == null || findNum < 1) {
            return null;
        }
        int contentMaxLen = 512;
        String tmpContent = content.trim();
        if (tmpContent.length() > contentMaxLen) {
            tmpContent = tmpContent.substring(0, contentMaxLen).trim();
        }
        ExamPaperQuestionQuery query = new ExamPaperQuestionQuery();
        query.setPaperId(paperId);
        query.setEqualContent(tmpContent);
        query.setTypeId(typeId);
        query.getPage().setPageSize(Math.min(findNum, 99));
        List pqs = this.examPaperQuestionPlusDao.findList(query);
        return pqs;
    }
}

