/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.exampaper.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.exampaper.bo.ExamPaperQuestionBO;
import com.peak.mng.exam.exampaper.bo.ExamPaperTypeBO;
import com.peak.mng.exam.examquestion.bo.ExamQuesPropBO;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.exampaper.dao.IExamPaperTypePlusDao;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.model.ExamPaperType;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.exampaper.service.IExamPaperTypePlusService;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionQuery;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionVO;
import com.peak.prd.exam.exampaper.vo.ExamPaperTypeQuery;
import com.peak.prd.exam.examquestion.model.ExamQuestion;
import com.peak.prd.exam.examquestion.service.IExamQuestionClobPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionKnowledgePlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPropPlusService;
import com.peak.prd.exam.examquestion.util.ExamQuestionClobUtil;
import com.peak.prd.exam.examquestion.util.ExamQuestionUtil;
import com.peak.prd.exam.examquestion.vo.ExamQuesPropVO;
import com.peak.prd.exam.examquestion.vo.ExamQuestionQuery;
import com.peak.prd.exam.examquestion.vo.ExamQuestionVO;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examtag.service.IExamQuestionTagPlusService;
import com.peak.prd.exam.examtag.vo.ExamTagVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamPaperTypePlusService
extends PrdBaseService<ExamPaperType, Long, ExamPaperTypeQuery>
implements IExamPaperTypePlusService {
    @Autowired
    private IExamPaperQuestionPlusService examPaperQuestionPlusService;
    @Autowired
    private IExamQuestionPlusService examQuestionPlusService;
    @Autowired
    private IExamQuestionTagPlusService examQuestionTagPlusService;
    @Autowired
    private IExamQuestionKnowledgePlusService examQuestionKnowledgePlusService;
    @Autowired
    private IExamQuestionPropPlusService examQuestionPropPlusService;
    @Autowired
    private IExamQuestionClobPlusService examQuestionClobPlusService;
    private IExamPaperTypePlusDao examPaperTypePlusDao;

    public void setExamPaperTypePlusDao(IExamPaperTypePlusDao dao) {
        this.examPaperTypePlusDao = dao;
    }

    public IExamPaperTypePlusDao getExamPaperTypePlusDao() {
        return this.examPaperTypePlusDao;
    }

    public IEntityDao<ExamPaperType, Long, ExamPaperTypeQuery> getEntityDao() {
        return this.examPaperTypePlusDao;
    }

    @Override
    public void correctOrderNum(List<ExamPaperType> list) {
        int i;
        if (list == null || list.isEmpty()) {
            return;
        }
        HashSet<Integer> orderNumSet = new HashSet<Integer>();
        for (i = 0; i < list.size(); ++i) {
            Integer orderNum = list.get(i).getBigsequence();
            if (orderNum == null) continue;
            orderNumSet.add(orderNum);
        }
        if (orderNumSet.size() == list.size()) {
            return;
        }
        for (i = 0; i < list.size(); ++i) {
            ExamPaperType pt = new ExamPaperType(list.get(i).getPtId());
            pt.setBigsequence(i + 1);
            this.updateSelective(pt);
        }
    }

    @Override
    public void moveUpDown(ExamPaperType pt, boolean isMoveUp) {
        if (pt == null || pt.getPaperId() == null) {
            return;
        }
        ExamPaperTypeQuery query = new ExamPaperTypeQuery();
        query.setPaperId(pt.getPaperId());
        query.getPage().setSortColumns(isMoveUp ? "BIGSEQUENCE" : "BIGSEQUENCE DESC");
        List list = this.findAll(query);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamPaperType item = (ExamPaperType)list.get(i);
            if (!pt.getPtId().equals(item.getPtId())) continue;
            if (i == 0) break;
            ExamPaperType item1 = new ExamPaperType(((ExamPaperType)list.get(i - 1)).getPtId());
            item1.setBigsequence(((ExamPaperType)list.get(i)).getBigsequence());
            this.updateSelective(item1);
            ExamPaperType item2 = new ExamPaperType(((ExamPaperType)list.get(i)).getPtId());
            item2.setBigsequence(((ExamPaperType)list.get(i - 1)).getBigsequence());
            this.updateSelective(item2);
            break;
        }
    }

    @Override
    public void deleteByQuery(ExamPaperTypeQuery query) {
        this.examPaperTypePlusDao.deleteByQuery(query);
    }

    @Override
    public Long insertType(ExamPaperTypeBO bo) {
        int ordernum = 1;
        ExamPaperTypeQuery query = new ExamPaperTypeQuery(1, 1);
        query.setPaperId(bo.getPaperId());
        query.getPage().setSortColumns("BIGSEQUENCE DESC");
        List existedTypes = this.getPrdEntityDao().findList((IQuery)query);
        if (existedTypes != null && existedTypes.size() > 0 && ((ExamPaperType)existedTypes.get(0)).getBigsequence() != null) {
            ordernum = ((ExamPaperType)existedTypes.get(0)).getBigsequence() + 1;
        }
        ExamPaperType examPaperType = new ExamPaperType();
        ConvertUtil.copyProperties((Object)bo, (Object)examPaperType);
        examPaperType.setPtId(IdUtil.getSequence((String)"EXAM_PAPER_TYPE"));
        examPaperType.setCreatedate(new Date());
        examPaperType.setBigsequence(ordernum);
        this.insert((BaseEntity)examPaperType);
        return examPaperType.getPtId();
    }

    private int getNextOrdernum(Long paperId, Long ptId) {
        int ordernum = 1;
        ExamPaperQuestionQuery query = new ExamPaperQuestionQuery(1, 1);
        query.setPaperId(paperId);
        query.setPtId(ptId);
        query.getPage().setSortColumns("SEQUENCE DESC");
        List existedOnes = this.examPaperQuestionPlusService.getPrdEntityDao().findList((IQuery)query);
        if (existedOnes != null && existedOnes.size() > 0 && ((ExamPaperQuestion)existedOnes.get(0)).getSequence() != null) {
            ordernum = ((ExamPaperQuestion)existedOnes.get(0)).getSequence() + 1;
        }
        return ordernum;
    }

    @Override
    public ApiResult<ExamPaperQuestionVO> insertQuestion(ExamPaperQuestionBO bo) {
        ExamPaperQuestion examPaperQuestion;
        Long paperId;
        ExamPaperType pt = (ExamPaperType)this.getById(bo.getPtId());
        Long l = paperId = pt == null ? null : pt.getPaperId();
        if (pt == null || paperId == null) {
            return ApiResult.errMsg((String)"\u6570\u636e\u975e\u6cd5[pt|paperId empty]");
        }
        int ordernum = this.getNextOrdernum(paperId, pt.getPtId());
        ApiResult err = ExamQuestionUtil.validateExamQuestionBO(bo);
        if (err != null) {
            return err;
        }
        if (bo.getParentId() != null) {
            boolean isClozeType;
            ExamPaperQuestion parentQues = this.examPaperQuestionPlusService.getByQuestionId(paperId, bo.getParentId());
            if (parentQues == null) {
                return ApiResult.errMsg((String)("\u7236\u9898\u76ee\u672a\u627e\u5230[parentId:" + bo.getParentId() + "][paperId:" + paperId + "]"));
            }
            boolean bl = isClozeType = ExamQuestiontypeEnum.getBasicType(parentQues.getTypeId()) == 40;
            if (isClozeType) {
                boolean isSingleChoice;
                boolean bl2 = isSingleChoice = ExamQuestiontypeEnum.getBasicType(bo.getTypeId()) == 1;
                if (!isSingleChoice) {
                    return ApiResult.errMsg((String)"\u5b8c\u5f62\u586b\u7a7a\u4e0b\u9762\u53ea\u80fd\u5305\u542b\u5355\u9009\u7c7b\u578b\u7684\u5b50\u9898\u76ee");
                }
            }
        }
        if ((examPaperQuestion = (ExamPaperQuestion)ConvertUtil.convert((Object)bo, ExamPaperQuestion.class)).getContent() != null) {
            examPaperQuestion.setContent(examPaperQuestion.getContent().trim());
        }
        examPaperQuestion.setBriefcontent(bo.getContentText());
        examPaperQuestion.setPqId(IdUtil.getSequence((String)"EXAM_PAPER_QUESTION"));
        examPaperQuestion.setQuestionId(IdUtil.getSequence((String)"EXAM_QUESTION"));
        examPaperQuestion.setPaperId(pt.getPaperId());
        ExamQuestionUtil.doChoiceQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doFillQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doMatchQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doSortQuestion(bo, examPaperQuestion);
        examPaperQuestion.setParentId(bo.getParentId() == null ? Long.valueOf(0L) : bo.getParentId());
        examPaperQuestion.setSequence(ordernum);
        examPaperQuestion.setCreatedate(new Date());
        examPaperQuestion.setDisorder(bo.getIsdisorder());
        int hasClob = this.examQuestionClobPlusService.saveLob(examPaperQuestion);
        examPaperQuestion.setUseclob(hasClob);
        if (examPaperQuestion.getBriefcontent() != null && examPaperQuestion.getBriefcontent().length() > 100) {
            examPaperQuestion.setBriefcontent(examPaperQuestion.getBriefcontent().substring(0, 100));
        }
        this.examPaperQuestionPlusService.insert((BaseEntity)examPaperQuestion);
        this.updateFields(examPaperQuestion.getQuestionId(), bo);
        return ApiResult.okData((Object)ExamQuestionUtil.getExamPaperQuestionVO(examPaperQuestion));
    }

    @Override
    public ApiResult updateQuestion(ExamPaperQuestionBO bo) {
        ApiResult err = ExamQuestionUtil.validateExamQuestionBO(bo);
        if (err != null) {
            return err;
        }
        ExamPaperQuestion examPaperQuestion = (ExamPaperQuestion)ConvertUtil.convert((Object)bo, ExamPaperQuestion.class);
        if (examPaperQuestion.getContent() != null) {
            examPaperQuestion.setContent(examPaperQuestion.getContent().trim());
        }
        examPaperQuestion.setBriefcontent(bo.getContentText());
        ExamQuestionUtil.doChoiceQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doFillQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doMatchQuestion(bo, examPaperQuestion);
        ExamQuestionUtil.doSortQuestion(bo, examPaperQuestion);
        examPaperQuestion.setDisorder(bo.getIsdisorder());
        int hasClob = this.examQuestionClobPlusService.saveLob(examPaperQuestion);
        examPaperQuestion.setUseclob(hasClob);
        if (examPaperQuestion.getBriefcontent() != null && examPaperQuestion.getBriefcontent().length() > 100) {
            examPaperQuestion.setBriefcontent(examPaperQuestion.getBriefcontent().substring(0, 100));
        }
        this.examPaperQuestionPlusService.updateSelective(examPaperQuestion);
        this.updateFields(examPaperQuestion.getQuestionId(), bo);
        return ApiResult.ok();
    }

    private void updateFields(Long questionId, ExamPaperQuestionBO bo) {
        this.updateFields(questionId, bo.getKnowledgeIds(), bo.getTagIds(), bo.getProps());
    }

    private void updateFields(Long questionId, List<Long> knowledgeIds, List<Long> tagIds, List<ExamQuesPropBO> propBOs) {
        this.examQuestionKnowledgePlusService.update(questionId, knowledgeIds);
        this.examQuestionTagPlusService.update(questionId, tagIds);
        this.examQuestionPropPlusService.update(questionId, propBOs);
    }

    @Override
    public ApiResult<List<ExamPaperQuestionVO>> insertByQuestionIds(Long ptId, List<Long> questionIds) {
        Long paperId;
        if (CollectionUtils.isEmpty(questionIds)) {
            return ApiResult.errMsg((String)"questionIds empty");
        }
        ExamPaperType pt = (ExamPaperType)this.getById(ptId);
        Long l = paperId = pt == null ? null : pt.getPaperId();
        if (pt == null || paperId == null) {
            return ApiResult.errMsg((String)"\u6570\u636e\u975e\u6cd5[pt|paperId empty]");
        }
        int ordernum = this.getNextOrdernum(paperId, pt.getPtId());
        Date now = new Date();
        ArrayList<Long> newPqIds = new ArrayList<Long>();
        ArrayList<ExamPaperQuestion> newPQs = new ArrayList<ExamPaperQuestion>();
        for (int i = 0; i < questionIds.size(); ++i) {
            ExamQuestion ques = (ExamQuestion)this.examQuestionPlusService.getById(questionIds.get(i));
            if (ques == null || ques.getTypeId() == null || ques.getParentId() != null && ques.getParentId() != 0L || !ques.getTypeId().equals(pt.getTypeId())) continue;
            ExamPaperQuestion examPaperQuestion = this.insertPqByQuestion(pt, ques, null, ordernum, now);
            newPQs.add(examPaperQuestion);
            newPqIds.add(examPaperQuestion.getPqId());
            ++ordernum;
            if (!ExamQuestiontypeEnum.hasChildren(ExamQuestiontypeEnum.getBasicType(ques.getTypeId()))) continue;
            ExamQuestionQuery examQuestionQuery = new ExamQuestionQuery();
            examQuestionQuery.setParentId(ques.getQuestionId());
            examQuestionQuery.getPage().setSortColumns("createdate");
            List children = this.examQuestionPlusService.findAll(examQuestionQuery);
            for (int j = 0; children != null && j < children.size(); ++j) {
                ExamPaperQuestion examPaperQuestion2 = this.insertPqByQuestion(pt, (ExamQuestion)children.get(j), examPaperQuestion.getQuestionId(), j, new Date(now.getTime() + (long)(1000 * j)));
            }
        }
        if (newPqIds == null || newPqIds.isEmpty()) {
            return ApiResult.errMsg((String)"\u6dfb\u52a0\u5931\u8d25[0\u9053\u8bd5\u9898\u88ab\u6dfb\u52a0]");
        }
        return ApiResult.okData(ExamQuestionUtil.getExamPaperQuestionVOs(newPQs));
    }

    private ExamPaperQuestion insertPqByQuestion(ExamPaperType pt, ExamQuestion ques, Long parentId, int ordernum, Date now) {
        ques = ExamQuestionClobUtil.loadQuestionById(ques.getQuestionId());
        ExamPaperQuestion examPaperQuestion = (ExamPaperQuestion)ConvertUtil.convert((Object)ques, ExamPaperQuestion.class);
        examPaperQuestion.setPqId(IdUtil.getSequence((String)"EXAM_PAPER_QUESTION"));
        examPaperQuestion.setQuestionId(IdUtil.getSequence((String)"EXAM_QUESTION"));
        examPaperQuestion.setPaperId(pt.getPaperId());
        examPaperQuestion.setSequence(ordernum);
        examPaperQuestion.setDisorder(ques.getIsdisorder());
        examPaperQuestion.setCreatedate(now);
        examPaperQuestion.setPtId(pt.getPtId());
        examPaperQuestion.setParentId(parentId == null ? Long.valueOf(0L) : parentId);
        int hasClob = this.examQuestionClobPlusService.saveLob(examPaperQuestion);
        examPaperQuestion.setUseclob(hasClob);
        this.examPaperQuestionPlusService.insert((BaseEntity)examPaperQuestion);
        if (examPaperQuestion.getParentId().intValue() == 0) {
            ExamQuestionVO eqDetailVO = this.examQuestionPlusService.getExamQuestionDetailVO(ques.getQuestionId());
            this.updateFields(examPaperQuestion.getQuestionId(), eqDetailVO.getKnowledgeIds(), eqDetailVO.getTagIds(), eqDetailVO.getExamQuesPropBOs());
        }
        return examPaperQuestion;
    }

    @Override
    public List<ExamPaperQuestionVO> getQuestions(Long ptId) {
        ExamPaperType pt = (ExamPaperType)this.getById(ptId);
        Long paperId = pt == null ? null : pt.getPaperId();
        ExamPaperQuestionQuery query = new ExamPaperQuestionQuery();
        query.setPaperId(paperId);
        query.setPtId(ptId);
        query.getPage().setSortColumns("SEQUENCE");
        List listAll = this.examPaperQuestionPlusService.findAll(query);
        if (listAll == null) {
            return null;
        }
        for (int i = 0; i < listAll.size(); ++i) {
            ExamQuestionClobUtil.loadPaperQuestion((ExamPaperQuestion)listAll.get(i));
        }
        List list = listAll.stream().filter(item -> item.getParentId() == null || item.getParentId().intValue() == 0).collect(Collectors.toList());
        Set childQuestionIds = listAll.stream().filter(item -> item.getParentId() != null && item.getParentId().intValue() != 0).map(item -> item.getQuestionId()).collect(Collectors.toSet());
        if (this.examPaperQuestionPlusService.correctOrderNum(list)) {
            list = this.examPaperQuestionPlusService.findAll(query);
        }
        List<ExamPaperQuestionVO> vos = ExamQuestionUtil.getExamPaperQuestionVOs(list);
        List questionIds = IdUtil.getIds(vos, e -> e.getQuestionId());
        Map<Long, List<ExamCategoryItemVO>> knowledgesMap = this.examQuestionKnowledgePlusService.getKnowledges(questionIds);
        Map<Long, List<ExamTagVO>> tagsMap = this.examQuestionTagPlusService.getTags(questionIds);
        Map<Long, List<ExamQuesPropVO>> propsMap = this.examQuestionPropPlusService.getPropVOs(questionIds);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            ExamPaperQuestionVO vo = vos.get(i);
            vo.setKnowledges(knowledgesMap == null ? null : knowledgesMap.get(vo.getQuestionId()));
            vo.setTags(tagsMap == null ? null : tagsMap.get(vo.getQuestionId()));
            vo.setProps(propsMap == null ? null : propsMap.get(vo.getQuestionId()));
            if (!ExamQuestiontypeEnum.hasChildren(vo.getBasicType())) continue;
            List<ExamPaperQuestion> models = this.examPaperQuestionPlusService.getChildren(paperId, vo.getQuestionId());
            ArrayList<ExamPaperQuestionVO> children = new ArrayList<ExamPaperQuestionVO>();
            for (int j = 0; models != null && j < models.size(); ++j) {
                ExamPaperQuestionVO child = ExamQuestionUtil.getExamPaperQuestionVO(models.get(j));
                children.add(child);
                childQuestionIds.remove(child.getQuestionId());
            }
            vo.setChildren(children);
        }
        if (!CollectionUtils.isEmpty(childQuestionIds)) {
            block3: for (Long childQid : childQuestionIds) {
                for (int i = 0; i < listAll.size(); ++i) {
                    if (!childQid.equals(((ExamPaperQuestion)listAll.get(i)).getQuestionId())) continue;
                    ExamPaperQuestionVO childVO = ExamQuestionUtil.getExamPaperQuestionVO((ExamPaperQuestion)listAll.get(i));
                    vos.add(childVO);
                    continue block3;
                }
            }
        }
        return vos;
    }

    @Override
    public int updateBatchQuestionScore(ExamPaperTypeBO examPaperTypeBO) {
        List<Long> complexTypeIds = ((IExamQuestiontypePlusService)SpringUtil.getBean(IExamQuestiontypePlusService.class)).getCachedAllComplexTypeIdsIncludeInvalid();
        return this.examPaperTypePlusDao.updateBatchQuestionScore(examPaperTypeBO, complexTypeIds);
    }
}

