/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examcategory.service.IExamCategoryItemPlusService;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.examcategory.vo.ExamQuestionknowledgeVO;
import com.peak.prd.exam.examquestion.bo.ExamQuestionknowledgeQueryBO;
import com.peak.prd.exam.examquestion.dao.IExamQuestionKnowledgePlusDao;
import com.peak.prd.exam.examquestion.model.ExamQuestionKnowledge;
import com.peak.prd.exam.examquestion.service.IExamQuestionKnowledgePlusService;
import com.peak.prd.exam.examquestion.vo.ExamQuestionKnowledgeQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamQuestionKnowledgePlusService
extends PrdBaseService<ExamQuestionKnowledge, Long, ExamQuestionKnowledgeQuery>
implements IExamQuestionKnowledgePlusService {
    @Autowired
    private IExamCategoryItemPlusService examCategoryItemPlusService;
    private IExamQuestionKnowledgePlusDao examQuestionKnowledgePlusDao;

    public void setExamQuestionKnowledgePlusDao(IExamQuestionKnowledgePlusDao dao) {
        this.examQuestionKnowledgePlusDao = dao;
    }

    public IExamQuestionKnowledgePlusDao getExamQuestionKnowledgePlusDao() {
        return this.examQuestionKnowledgePlusDao;
    }

    public IEntityDao<ExamQuestionKnowledge, Long, ExamQuestionKnowledgeQuery> getEntityDao() {
        return this.examQuestionKnowledgePlusDao;
    }

    @Override
    public void update(Long questionId, List<Long> knowledgeIds) {
        this.examQuestionKnowledgePlusDao.deleteByQuestionId(questionId);
        Date now = new Date();
        ArrayList<ExamQuestionKnowledge> list = new ArrayList<ExamQuestionKnowledge>();
        for (int i = 0; knowledgeIds != null && i < knowledgeIds.size(); ++i) {
            ExamQuestionKnowledge item = new ExamQuestionKnowledge();
            item.setPkId(IdUtil.getSequence((String)"EXAM_QUESTION_KNOWLEDGE"));
            item.setQuestionId(questionId);
            item.setKnowledgeId(knowledgeIds.get(i));
            item.setCreatedate(now);
            list.add(item);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.insertBatch(list);
        }
    }

    @Override
    public void deleteByQuestionId(Long questionId) {
        this.examQuestionKnowledgePlusDao.deleteByQuestionId(questionId);
    }

    @Override
    public List<ExamCategoryItemVO> getKnowledges(Long questionId) {
        if (questionId == null) {
            return null;
        }
        ExamQuestionKnowledgeQuery query = new ExamQuestionKnowledgeQuery();
        query.setQuestionId(questionId);
        query.getPage().setSortColumns("createdate");
        List knowList = this.examQuestionKnowledgePlusDao.findAll(query);
        List knowIds = IdUtil.getIds((List)knowList, e -> e.getKnowledgeId());
        if (CollectionUtils.isEmpty((Collection)knowIds)) {
            return null;
        }
        List items = this.examCategoryItemPlusService.getByIds(knowIds);
        List vos = ConvertUtil.convert((List)items, ExamCategoryItemVO.class);
        return vos;
    }

    @Override
    public Map<Long, List<ExamCategoryItemVO>> getKnowledges(List<Long> questionIds) {
        List<ExamQuestionknowledgeVO> knowledges = this.getExamQuestionknowledgeVOs(questionIds);
        if (CollectionUtils.isEmpty(knowledges)) {
            return null;
        }
        HashMap<Long, List<ExamCategoryItemVO>> map = new HashMap<Long, List<ExamCategoryItemVO>>();
        for (int i = 0; i < knowledges.size(); ++i) {
            Long questionId = knowledges.get(i).getQuestionId();
            ArrayList<ExamQuestionknowledgeVO> knowVOs = (ArrayList<ExamQuestionknowledgeVO>)map.get(questionId);
            if (knowVOs == null) {
                knowVOs = new ArrayList<ExamQuestionknowledgeVO>();
                map.put(questionId, knowVOs);
            }
            knowVOs.add(knowledges.get(i));
        }
        return map;
    }

    @Override
    public List<ExamQuestionknowledgeVO> getExamQuestionknowledgeVOs(List<Long> questionIds) {
        if (CollectionUtils.isEmpty(questionIds)) {
            return null;
        }
        return this.examQuestionKnowledgePlusDao.getExamQuestionknowledgeVOs(questionIds);
    }

    @Override
    public Paging<ExamQuestionknowledgeVO> getKnowledgesByPaperIds(ExamQuestionknowledgeQueryBO queryBO) {
        if (queryBO == null || ListUtil.isNullorEmpty(queryBO.getPaperIds())) {
            return null;
        }
        ExamQuestionKnowledgeQuery query = (ExamQuestionKnowledgeQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamQuestionKnowledgeQuery.class);
        return this.examQuestionKnowledgePlusDao.getKnowledgesByPaperIds(query);
    }
}

