/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DBFunction;
import com.peak.common.util.IdUtil;
import com.peak.common.util.RedisService;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examquestion.bo.ExamQuestionBO;
import com.peak.mng.exam.examquestion.bo.ExamQuestionQueryBO;
import com.peak.mng.exam.examquestion.vo.ExamQuestionExpVO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.examquestion.dao.IExamQuestionPlusDao;
import com.peak.prd.exam.examquestion.model.ExamQuestion;
import com.peak.prd.exam.examquestion.model.ExamQuestionQb;
import com.peak.prd.exam.examquestion.service.IExamQuestionClobPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionKnowledgePlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPropPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionQbPlusService;
import com.peak.prd.exam.examquestion.util.ExamQuestionClobUtil;
import com.peak.prd.exam.examquestion.util.ExamQuestionExpUtil;
import com.peak.prd.exam.examquestion.util.ExamQuestionUtil;
import com.peak.prd.exam.examquestion.vo.ExamQuesPropVO;
import com.peak.prd.exam.examquestion.vo.ExamQuestionQbQuery;
import com.peak.prd.exam.examquestion.vo.ExamQuestionQuery;
import com.peak.prd.exam.examquestion.vo.ExamQuestionVO;
import com.peak.prd.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examtag.service.IExamQuestionTagPlusService;
import com.peak.prd.exam.examtag.vo.ExamTagVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExamQuestionPlusService
extends PrdBaseService<ExamQuestion, Long, ExamQuestionQuery>
implements IExamQuestionPlusService {
    @Autowired
    private RedisService redisService;
    @Autowired
    private IExamQuestionQbPlusService examQuestionQbPlusService;
    @Autowired
    private IExamQuestionClobPlusService examQuestionClobPlusService;
    private IExamQuestionPlusDao examQuestionPlusDao;
    @Autowired
    private IExamQuestiontypePlusService examQuestiontypePlusService;
    @Autowired
    private IExamPaperQuestionPlusService examPaperQuestionPlusService;
    @Autowired
    private IExamQuestionTagPlusService examQuestionTagPlusService;
    @Autowired
    private IExamQuestionKnowledgePlusService examQuestionKnowledgePlusService;
    @Autowired
    private IExamQuestionPropPlusService examQuestionPropPlusService;

    public void setExamQuestionPlusDao(IExamQuestionPlusDao dao) {
        this.examQuestionPlusDao = dao;
    }

    public IExamQuestionPlusDao getExamQuestionPlusDao() {
        return this.examQuestionPlusDao;
    }

    public IEntityDao<ExamQuestion, Long, ExamQuestionQuery> getEntityDao() {
        return this.examQuestionPlusDao;
    }

    @Override
    public Paging<ExamQuestionVO> findVOPaging(ExamQuestionQueryBO queryBO) {
        ExamQuestionQuery query = new ExamQuestionQuery(queryBO.getPageNumber(), queryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)queryBO), (Object)query);
        query.setLikeContentOrBriefContent(queryBO.getContent());
        query.setContent(null);
        if (queryBO.getOrderByRandom() != null && queryBO.getOrderByRandom() == 1) {
            query.getPage().setSortColumns(DBFunction.random());
        } else if (query.getPage().getSortColumns() == null) {
            query.getPage().setSortColumns("createdate DESC");
        }
        return this.findVOPaging(query);
    }

    @Override
    public Paging<ExamQuestionVO> findVOPaging(ExamQuestionQuery query) {
        query.setParentId(0L);
        query = (ExamQuestionQuery)this.findPage(query);
        List<ExamQuestionVO> vos = this.convertModelToVO(query.getPage().getResult());
        return new Paging(query.getPage(), vos);
    }

    @Override
    public ExamQuestionVO getExamQuestionVO(Long questionId) {
        ExamQuestion model = this.getById(questionId, true);
        if (model == null) {
            return null;
        }
        List<ExamQuestionVO> vos = this.convertModelToVO(Arrays.asList(model));
        return vos.get(0);
    }

    @Override
    public ExamQuestionVO getExamQuestionDetailVO(Long questionId) {
        ExamQuestion model = this.getById(questionId, true);
        if (model == null) {
            return null;
        }
        ExamQuestionVO vo = ExamQuestionUtil.getExamQuestionVO(model);
        List<ExamCategoryItemVO> knowledges = this.examQuestionKnowledgePlusService.getKnowledges(questionId);
        vo.setKnowledges(knowledges);
        List<ExamTagVO> tags = this.examQuestionTagPlusService.getTags(questionId);
        vo.setTags(tags);
        List<ExamQuesPropVO> props = this.examQuestionPropPlusService.getPropVOs(questionId);
        vo.setProps(props);
        if (ExamQuestiontypeEnum.hasChildren(vo.getBasicType())) {
            List<ExamQuestion> models = this.getChildren(vo.getQuestionId());
            ArrayList<ExamQuestionVO> children = new ArrayList<ExamQuestionVO>();
            for (int i = 0; models != null && i < models.size(); ++i) {
                ExamQuestionVO child = ExamQuestionUtil.getExamQuestionVO(models.get(i));
                children.add(child);
            }
            vo.setChildren(children);
        }
        return vo;
    }

    @Override
    public List<ExamQuestionVO> getExamQuestionVOs(List<Long> questionIds) {
        if (CollectionUtils.isEmpty(questionIds)) {
            return null;
        }
        List examQuestions = this.getByIds(questionIds);
        for (int i = 0; examQuestions != null && i < examQuestions.size(); ++i) {
            ExamQuestionClobUtil.loadQuestion((ExamQuestion)examQuestions.get(i), true);
        }
        List<ExamQuestionVO> vos = this.convertModelToVO(examQuestions);
        return vos;
    }

    private List<ExamQuestionVO> convertModelToVO(List<ExamQuestion> questions) {
        List vos = ConvertUtil.convert(questions, ExamQuestionVO.class);
        List typeIds = ConvertUtil.removeNull((List)IdUtil.getIds((List)vos, e -> e.getTypeId()));
        List qtypes = this.examQuestiontypePlusService.findByIds(typeIds);
        List sortedQtypes = ConvertUtil.refact((List)vos, (List)qtypes, (vo, qt) -> qt.getTypeId().equals(vo.getTypeId()));
        ConvertUtil.setProperties((List)vos, (List)sortedQtypes, (vo, qt) -> vo.setTypeName(qt.getTypename()));
        UserCoreUtil.setUserRealname((List)vos, ExamQuestionVO::getCreatorId, ExamQuestionVO::setCreatorName);
        return vos;
    }

    @Override
    public boolean isUsed(Long questionId) {
        return false;
    }

    @Override
    public List<ExamQuestion> getChildren(@NotNull Long parentId) {
        if (parentId == null) {
            return null;
        }
        ExamQuestionQuery query = new ExamQuestionQuery();
        query.setParentId(parentId);
        query.getPage().setSortColumns("createdate, questionid");
        List children = this.findAll(query);
        for (int i = 0; children != null && i < children.size(); ++i) {
            ExamQuestionClobUtil.loadQuestion((ExamQuestion)children.get(i));
        }
        return children;
    }

    private String getQuesCode(ExamQuestion examQuestion) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMM");
        ExamQuestiontype examQuestiontype = (ExamQuestiontype)this.examQuestiontypePlusService.findById(examQuestion.getTypeId());
        String typeCode = StringUtils.isEmpty((Object)examQuestiontype.getCode()) ? "" : examQuestiontype.getCode();
        String prefix = typeCode + sdf.format(new Date());
        long x = this.redisService.increment(prefix, 1L);
        String sn = String.format("%07d", x);
        return prefix + sn;
    }

    @Override
    public ApiResult insert(ExamQuestionBO bo, Long currUserId, Long currMngDomainId) {
        ExamQuestion examQuestion = (ExamQuestion)ConvertUtil.convert((Object)bo, ExamQuestion.class);
        examQuestion.setBriefcontent(bo.getContentText());
        examQuestion.setQuestionId(bo.getQuestionId() == null ? IdUtil.getSequence((String)"EXAM_QUESTION") : bo.getQuestionId());
        ApiResult err = ExamQuestionUtil.validateExamQuestionBO(bo);
        if (err != null) {
            return err;
        }
        String code = this.getQuesCode(examQuestion);
        examQuestion.setCode(code);
        ExamQuestionUtil.doChoiceQuestion(bo, examQuestion);
        ExamQuestionUtil.doFillQuestion(bo, examQuestion);
        ExamQuestionUtil.doMatchQuestion(bo, examQuestion);
        ExamQuestionUtil.doSortQuestion(bo, examQuestion);
        examQuestion.setCreatorId(currUserId);
        examQuestion.setCreatedate(new Date());
        examQuestion.setParentId(bo.getParentId() == null ? Long.valueOf(0L) : bo.getParentId());
        examQuestion.setIsvalId(bo.getIsvalId() == null ? Integer.valueOf(1) : bo.getIsvalId());
        int hasClob = this.examQuestionClobPlusService.saveLob(examQuestion);
        examQuestion.setUseclob(hasClob);
        if (examQuestion.getBriefcontent() != null && examQuestion.getBriefcontent().length() > 100) {
            examQuestion.setBriefcontent(examQuestion.getBriefcontent().substring(0, 100));
        }
        if (examQuestion.getEffectivedate() == null) {
            examQuestion.setEffectivedate(new Date(0L));
        }
        if (examQuestion.getExpirydate() == null) {
            examQuestion.setExpirydate(new Date(System.currentTimeMillis() + 1576800000000L));
        }
        this.insert((BaseEntity)examQuestion);
        ExamQuestionQb qqb = new ExamQuestionQb(IdUtil.getSequence((String)"EXAM_QUESTION_QB"));
        qqb.setQuestionId(examQuestion.getQuestionId());
        qqb.setQuesbankId(bo.getQbankId());
        qqb.setCreatorId(examQuestion.getCreatorId());
        qqb.setCreatedate(examQuestion.getCreatedate());
        this.examQuestionQbPlusService.insert((BaseEntity)qqb);
        this.examQuestionTagPlusService.update(examQuestion.getQuestionId(), bo.getTagIds());
        this.examQuestionKnowledgePlusService.update(examQuestion.getQuestionId(), bo.getKnowledgeIds());
        this.examQuestionPropPlusService.update(examQuestion.getQuestionId(), bo.getProps());
        return ApiResult.okData((Object)examQuestion.getQuestionId());
    }

    @Override
    public ApiResult update(ExamQuestionBO bo, Long currUserId, Long currMngDomainId) {
        ExamQuestion examQuestion = (ExamQuestion)ConvertUtil.convert((Object)bo, ExamQuestion.class);
        examQuestion.setBriefcontent(bo.getContentText());
        ApiResult err = ExamQuestionUtil.validateExamQuestionBO(bo);
        if (err != null) {
            return err;
        }
        ExamQuestionUtil.doChoiceQuestion(bo, examQuestion);
        ExamQuestionUtil.doFillQuestion(bo, examQuestion);
        ExamQuestionUtil.doMatchQuestion(bo, examQuestion);
        ExamQuestionUtil.doSortQuestion(bo, examQuestion);
        examQuestion.setModifierId(currUserId);
        examQuestion.setModifydate(new Date());
        int hasClob = this.examQuestionClobPlusService.saveLob(examQuestion);
        examQuestion.setUseclob(hasClob);
        if (examQuestion.getBriefcontent() != null && examQuestion.getBriefcontent().length() > 100) {
            examQuestion.setBriefcontent(examQuestion.getBriefcontent().substring(0, 100));
        }
        this.updateSelective(examQuestion);
        this.examQuestionKnowledgePlusService.update(examQuestion.getQuestionId(), bo.getKnowledgeIds());
        this.examQuestionTagPlusService.update(examQuestion.getQuestionId(), bo.getTagIds());
        this.examQuestionPropPlusService.update(examQuestion.getQuestionId(), bo.getProps());
        return ApiResult.ok();
    }

    @Override
    public List<ExamQuestionExpVO> findExpVOList(Long quesbankId, int pageNumber, int pageSize) {
        if (quesbankId == null) {
            return null;
        }
        ExamQuestionQuery examQuestionQuery = new ExamQuestionQuery(pageNumber, pageSize);
        examQuestionQuery.setQbankIds(Arrays.asList(quesbankId));
        examQuestionQuery.getPage().setSortColumns("typeId, questionId");
        examQuestionQuery.setParentId(0L);
        List questions = this.examQuestionPlusDao.findList(examQuestionQuery);
        ArrayList<ExamQuestionExpVO> expVOs = new ArrayList<ExamQuestionExpVO>();
        List vos = ConvertUtil.convert((List)questions, ExamQuestionExpVO.class);
        for (int i = 0; questions != null && i < questions.size(); ++i) {
            ExamQuestion q = (ExamQuestion)questions.get(i);
            ExamQuestionExpVO expVO = this.convertToExpVO((ExamQuestionExpVO)((Object)vos.get(i)), q);
            expVOs.add(expVO);
            boolean hasChildren = ExamQuestiontypeEnum.hasChildren(ExamQuestiontypeEnum.getBasicType(q.getTypeId()));
            if (!hasChildren) continue;
            ExamQuestionQuery childQuery = new ExamQuestionQuery(1, 999);
            childQuery.setParentId(q.getQuestionId());
            childQuery.getPage().setSortColumns("createdate, questionid");
            List childQuestions = this.examQuestionPlusDao.findList(childQuery);
            List childVOs = ConvertUtil.convert((List)childQuestions, ExamQuestionExpVO.class);
            for (int j = 0; childQuestions != null && j < childQuestions.size(); ++j) {
                ExamQuestion childQues = (ExamQuestion)childQuestions.get(j);
                ExamQuestionExpVO childExpVO = this.convertToExpVO((ExamQuestionExpVO)((Object)childVOs.get(j)), childQues);
                expVOs.add(childExpVO);
            }
        }
        ExamQuestionExpUtil.appendAttrs(expVOs);
        return expVOs;
    }

    @Override
    public List<ExamQuestionExpVO> findExpVOList(ExamQuestionQueryBO queryBO) {
        if (queryBO == null) {
            return null;
        }
        return this.findExpVOList(queryBO.getQbankId(), queryBO.getPageNumber(), queryBO.getPageSize());
    }

    private ExamQuestionExpVO convertToExpVO(ExamQuestionExpVO expVO, ExamQuestion q) {
        expVO.setScore(q.getScore() == null || Math.abs(q.getScore()) <= 0.001 ? "" : String.valueOf(q.getScore()));
        expVO.setQuestionId(q.getQuestionId() + "");
        expVO.setDifficultyInteger(q.getDifficulty());
        ExamQuestionVO qvo = ExamQuestionUtil.getExamQuestionVO(q);
        if (ExamQuestionUtil.isChoiceQuestion(q.getTypeId()) && qvo != null && qvo.getChoices() != null) {
            expVO.setChoices(qvo.getChoices().stream().map(e -> e.getTitle()).collect(Collectors.toList()));
        }
        return expVO;
    }

    @Override
    public ExamQuestion getById(Long questionId, boolean withClob) {
        if (withClob) {
            return ExamQuestionClobUtil.loadQuestionById(questionId);
        }
        return (ExamQuestion)this.getById(questionId);
    }

    @Override
    public long getQuestionNumByQbankId(Long qbankId) {
        if (qbankId == null) {
            return 0L;
        }
        ExamQuestionQuery query = new ExamQuestionQuery();
        query.setQbankIds(Arrays.asList(qbankId));
        query.setParentId(0L);
        return this.examQuestionPlusDao.count(query);
    }

    @Override
    public List<ExamQuestion> findRandomQuestions(ExamQuestionQuery query) {
        return this.examQuestionPlusDao.findList(query, "findRandomQuestions");
    }

    @Override
    public String deleteQuestion(Long questionId, Long deletorId) {
        if (questionId == null) {
            return null;
        }
        if (this.isUsed(questionId)) {
            return "\u8bd5\u9898\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u5220\u9664[id:" + questionId + "]";
        }
        ExamQuestion ques = (ExamQuestion)this.getById(questionId);
        this.log.info((Object)("ExamQuestion deleted[questionId:" + questionId + "][typeId:" + ques.getTypeId() + "][content:" + (ques.getContent() != null && ques.getContent().length() > 20 ? ques.getContent().substring(0, 20) + "..." : ques.getContent()) + "] by user[" + deletorId + "]"));
        this.examQuestionQbPlusService.deleteByQuestionId(questionId);
        this.examQuestionTagPlusService.deleteByQuestionId(questionId);
        this.examQuestionKnowledgePlusService.deleteByQuestionId(questionId);
        this.deleteById(questionId);
        return null;
    }

    @Override
    public String deleteByQuesBank(Long quesbankId, Long deletorId) {
        List list;
        if (quesbankId == null) {
            return null;
        }
        ExamQuestionQbQuery qbQuery = new ExamQuestionQbQuery(1, 100);
        qbQuery.setQuesbankId(quesbankId);
        this.log.info((Object)("ExamQuestion deleted[quesbankId:" + quesbankId + "] by user[" + deletorId + "]"));
        String delMessage = null;
        int totalDelNum = 0;
        for (int i = 0; i < 10000 && !CollectionUtils.isEmpty((Collection)(list = this.examQuestionQbPlusService.getPrdEntityDao().findList((IQuery)qbQuery))); ++i) {
            ExamQuestionQb qb;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (delMessage = this.deleteQuestion((qb = (ExamQuestionQb)iterator.next()).getQuestionId(), deletorId)) == null) {
                ++totalDelNum;
            }
        }
        if (delMessage == null) {
            this.log.info((Object)("ExamQuestion deleted[quesbankId:" + quesbankId + "] by user[" + deletorId + "][totalDelNum:" + totalDelNum + "]\u5b8c\u6210"));
        } else {
            this.log.info((Object)("ExamQuestion deleted[quesbankId:" + quesbankId + "] by user[" + deletorId + "][totalDelNum:" + totalDelNum + "]\u4e2d\u65ad\uff0c\u9519\u8bef\u6d88\u606f[" + delMessage + "]"));
        }
        return delMessage;
    }
}

