/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examquestion.bo.ExamQuesPropBO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examcategory.model.ExamCategory;
import com.peak.prd.exam.examcategory.service.IExamCategoryItemPlusService;
import com.peak.prd.exam.examcategory.service.IExamCategoryPlusService;
import com.peak.prd.exam.examcategory.vo.ExamCategoryItemVO;
import com.peak.prd.exam.examquestion.dao.IExamQuestionPropPlusDao;
import com.peak.prd.exam.examquestion.model.ExamQuestionProp;
import com.peak.prd.exam.examquestion.service.IExamQuestionPropPlusService;
import com.peak.prd.exam.examquestion.vo.ExamQuesPropVO;
import com.peak.prd.exam.examquestion.vo.ExamQuestionPropQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamQuestionPropPlusService
extends PrdBaseService<ExamQuestionProp, Long, ExamQuestionPropQuery>
implements IExamQuestionPropPlusService {
    @Autowired
    private IExamCategoryPlusService examCategoryPlusService;
    @Autowired
    private IExamCategoryItemPlusService examCategoryItemPlusService;
    private IExamQuestionPropPlusDao examQuestionPropPlusDao;

    public void setExamQuestionPropPlusDao(IExamQuestionPropPlusDao dao) {
        this.examQuestionPropPlusDao = dao;
    }

    public IExamQuestionPropPlusDao getExamQuestionPropPlusDao() {
        return this.examQuestionPropPlusDao;
    }

    public IEntityDao<ExamQuestionProp, Long, ExamQuestionPropQuery> getEntityDao() {
        return this.examQuestionPropPlusDao;
    }

    @Override
    public void update(Long questionId, List<ExamQuesPropBO> props) {
        if (questionId == null) {
            return;
        }
        this.examQuestionPropPlusDao.deleteByQuestionId(questionId);
        Date now = new Date();
        ArrayList<ExamQuestionProp> list = new ArrayList<ExamQuestionProp>();
        for (int i = 0; props != null && i < props.size(); ++i) {
            ExamQuesPropBO propBO = props.get(i);
            List<Long> propIds = propBO.getPropIds();
            for (int j = 0; propIds != null && j < propIds.size(); ++j) {
                ExamQuestionProp item = new ExamQuestionProp();
                item.setQuespropId(IdUtil.getSequence((String)"EXAM_QUESTION_PROP"));
                item.setQuestionId(questionId);
                item.setPropId(propIds.get(j));
                item.setCreatedate(now);
                list.add(item);
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.insertBatch(list);
        }
    }

    @Override
    public List<ExamQuesPropVO> getPropVOs(Long questionId) {
        if (questionId == null) {
            return null;
        }
        Map<Long, List<ExamQuesPropVO>> map = this.getPropVOs(Arrays.asList(questionId));
        return map == null ? null : map.get(questionId);
    }

    @Override
    public Map<Long, List<ExamQuesPropVO>> getPropVOs(List<Long> questionIds) {
        if (CollectionUtils.isEmpty(questionIds)) {
            return null;
        }
        List<ExamCategory> categories = this.examCategoryPlusService.getQuesPropCategories();
        if (CollectionUtils.isEmpty(categories)) {
            return null;
        }
        HashMap<Long, List<ExamQuesPropVO>> map = new HashMap<Long, List<ExamQuesPropVO>>();
        for (int i = 0; i < questionIds.size(); ++i) {
            map.put(questionIds.get(i), this.newProps(categories));
        }
        ExamQuestionPropQuery query = new ExamQuestionPropQuery();
        query.setQuestionIds(questionIds);
        query.getPage().setSortColumns("createdate");
        List propList = this.findAll(query);
        List propIds = IdUtil.getIds((List)propList, e -> e.getPropId());
        if (CollectionUtils.isEmpty((Collection)propIds)) {
            return map;
        }
        List items = this.examCategoryItemPlusService.getByIds(propIds);
        if (CollectionUtils.isEmpty((Collection)items)) {
            return map;
        }
        for (Map.Entry entry : map.entrySet()) {
            Long questionId = (Long)entry.getKey();
            List vos = (List)entry.getValue();
            for (int i = 0; i < vos.size(); ++i) {
                ExamQuesPropVO vo = (ExamQuesPropVO)vos.get(i);
                List subItems = items.stream().filter(e -> e.getCsId().equals(vo.getCategoryId())).collect(Collectors.toList());
                List itemVOs = ConvertUtil.convert(subItems, ExamCategoryItemVO.class);
                vo.setItems(itemVOs);
            }
        }
        return map;
    }

    private List<ExamQuesPropVO> newProps(List<ExamCategory> categories) {
        ArrayList<ExamQuesPropVO> vos = new ArrayList<ExamQuesPropVO>();
        for (int i = 0; categories != null && i < categories.size(); ++i) {
            ExamCategory category = categories.get(i);
            ExamQuesPropVO vo = new ExamQuesPropVO();
            vo.setCategoryId(category.getCategoryId());
            vo.setCategoryName(category.getTitle());
            vo.setItems(null);
            vos.add(vo);
        }
        return vos;
    }
}

