/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examcategory.model.ExamCategoryItem;
import com.peak.prd.exam.examcategory.service.IExamCategoryItemPlusService;
import com.peak.prd.exam.examquestion.dao.IExamQuestionQbPlusDao;
import com.peak.prd.exam.examquestion.model.ExamQuestionQb;
import com.peak.prd.exam.examquestion.service.IExamQuestionQbPlusService;
import com.peak.prd.exam.examquestion.vo.ExamQBankDetailVO;
import com.peak.prd.exam.examquestion.vo.ExamQTypeCountVO;
import com.peak.prd.exam.examquestion.vo.ExamQuestionQbQuery;
import com.peak.prd.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CacheConfig(cacheNames={"prd"})
public class ExamQuestionQbPlusService
extends PrdBaseService<ExamQuestionQb, Long, ExamQuestionQbQuery>
implements IExamQuestionQbPlusService {
    @Autowired
    private IExamCategoryItemPlusService examCategoryItemPlusService;
    @Autowired
    private IExamQuestiontypePlusService examQuestiontypePlusService;
    private IExamQuestionQbPlusDao examQuestionQbPlusDao;

    public void setExamQuestionQbPlusDao(IExamQuestionQbPlusDao dao) {
        this.examQuestionQbPlusDao = dao;
    }

    public IExamQuestionQbPlusDao getExamQuestionQbPlusDao() {
        return this.examQuestionQbPlusDao;
    }

    public IEntityDao<ExamQuestionQb, Long, ExamQuestionQbQuery> getEntityDao() {
        return this.examQuestionQbPlusDao;
    }

    @Override
    @Cacheable
    public ExamQBankDetailVO findDetailVOById(@NotNull Long qbankId) {
        List<ExamQBankDetailVO> list = this.findDetailVOById(Arrays.asList(qbankId));
        return CollectionUtils.isEmpty(list) ? null : list.get(0);
    }

    @Override
    @Cacheable
    public List<ExamQBankDetailVO> findDetailVOById(@NotNull List<Long> qbankIds) {
        List items = this.examCategoryItemPlusService.findByIds(qbankIds);
        List quesbankIds = IdUtil.getIds((List)(items = ConvertUtil.removeNull((List)items)), e -> e.getItemId());
        if (CollectionUtils.isEmpty((Collection)quesbankIds)) {
            return null;
        }
        HashMap mapQbankTypes = new HashMap();
        ArrayList<ExamQBankDetailVO> vos = new ArrayList<ExamQBankDetailVO>();
        for (ExamCategoryItem item : items) {
            ExamQBankDetailVO vo = new ExamQBankDetailVO();
            vo.setQbankId(item.getItemId());
            vo.setTitle(item.getTitle());
            vos.add(vo);
            mapQbankTypes.put(item.getItemId(), new ArrayList());
        }
        ExamQuestionQbQuery query = new ExamQuestionQbQuery();
        query.getPage().setPageSize(999);
        query.setQuesbankIds(quesbankIds);
        List qtypes = this.getPrdEntityDao().findList((IQuery)query, "getQTypeCountList", ExamQTypeCountVO.class);
        for (int i = 0; qtypes != null && i < qtypes.size(); ++i) {
            ExamQTypeCountVO typeCountVO = (ExamQTypeCountVO)qtypes.get(i);
            Long quesbankId = typeCountVO.getQuesbankId();
            Long typeId = typeCountVO.getTypeId();
            ExamQuestiontype typeModel = (ExamQuestiontype)this.examQuestiontypePlusService.findById(typeId);
            typeCountVO.setTypeName(typeModel == null ? "\u672a\u77e5" : typeModel.getTypename());
            ((List)mapQbankTypes.get(quesbankId)).add(typeCountVO);
        }
        for (ExamQBankDetailVO vo : vos) {
            vo.setQtypes((List)mapQbankTypes.get(vo.getQbankId()));
        }
        return vos;
    }

    @Override
    public int deleteByQuestionId(Long questionId) {
        return this.examQuestionQbPlusDao.deleteByQuestionId(questionId);
    }

    @Override
    public int deleteByQuesbankId(Long quesbankId) {
        return this.examQuestionQbPlusDao.deleteByQuesbankId(quesbankId);
    }

    @Override
    public int deleteByImportLog(Long quesbankId, Long importLogId) {
        return this.examQuestionQbPlusDao.deleteByImportLog(quesbankId, importLogId);
    }

    @Override
    public ExamQBankDetailVO findExamQBankDetailVOById(Long qbankId) {
        ExamQBankDetailVO vo = new ExamQBankDetailVO();
        ExamCategoryItem item = (ExamCategoryItem)this.examCategoryItemPlusService.findById(qbankId);
        if (item == null) {
            return null;
        }
        vo.setQbankId(qbankId);
        vo.setTitle(item.getTitle());
        List<ExamQTypeCountVO> qtypes = this.getQTypeCountListByQbankId(qbankId);
        vo.setQtypes(qtypes);
        return vo;
    }

    @Override
    public int getQuestionNum(Long quesbankId) {
        if (quesbankId == null) {
            return 0;
        }
        return this.examQuestionQbPlusDao.getQuestionNum(quesbankId);
    }

    @Override
    public List<ExamQTypeCountVO> getQTypeCountListByQbankId(Long quesbankId) {
        if (quesbankId == null) {
            return null;
        }
        ExamQuestionQbQuery query = new ExamQuestionQbQuery();
        query.getPage().setPageSize(999);
        query.setQuesbankId(quesbankId);
        List qtypes = this.examQuestionQbPlusDao.findList(query, "getQTypeCountList", ExamQTypeCountVO.class);
        if (CollectionUtils.isEmpty((Collection)qtypes)) {
            return null;
        }
        for (int i = 0; i < qtypes.size(); ++i) {
            Long typeId = ((ExamQTypeCountVO)qtypes.get(i)).getTypeId();
            ExamQuestiontype typeModel = (ExamQuestiontype)this.examQuestiontypePlusService.findById(typeId);
            ((ExamQTypeCountVO)qtypes.get(i)).setTypeName(typeModel == null ? "\u672a\u77e5" : typeModel.getTypename());
        }
        Collections.sort(qtypes, new Comparator<ExamQTypeCountVO>(){

            @Override
            public int compare(ExamQTypeCountVO o1, ExamQTypeCountVO o2) {
                return o1.getBasicType() - o2.getBasicType();
            }
        });
        return qtypes;
    }
}

