/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.util;

import com.peak.common.util.SpringUtil;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.service.IExamPaperQuestionPlusService;
import com.peak.prd.exam.examquestion.model.ExamQuestion;
import com.peak.prd.exam.examquestion.model.ExamQuestionClob;
import com.peak.prd.exam.examquestion.service.IExamQuestionClobPlusService;
import com.peak.prd.exam.examquestion.service.IExamQuestionPlusService;
import com.peak.prd.exam.examquestion.vo.ExamQuestionClobQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ExamQuestionClobUtil {
    public static final String LOB_CONTENT = "content";
    public static final String LOB_OPTIONS = "options";
    public static final String LOB_DETAILANSWER = "detailAnswer";
    public static final String LOB_ANSWER = "answer";
    public static final int BRIEFCONTENT_LENGTH = 100;

    public static ExamPaperQuestion loadPaperQuestion(ExamPaperQuestion pq) {
        String answer;
        if (pq == null) {
            return null;
        }
        Map<String, String> clobMap = ExamQuestionClobUtil.loadLobByPaperQuestion(pq);
        String content = clobMap == null ? null : clobMap.get(LOB_CONTENT);
        String options = clobMap == null ? null : clobMap.get(LOB_OPTIONS);
        String detailAnswer = clobMap == null ? null : clobMap.get(LOB_DETAILANSWER);
        String string = answer = clobMap == null ? null : clobMap.get(LOB_ANSWER);
        if (!StringUtils.isEmpty((Object)content)) {
            pq.setContent(content);
        }
        if (!StringUtils.isEmpty((Object)options)) {
            pq.setOptions(options);
        }
        if (!StringUtils.isEmpty((Object)detailAnswer)) {
            pq.setDetailanswer(detailAnswer);
        }
        if (!StringUtils.isEmpty((Object)answer)) {
            pq.setAnswer(answer);
        }
        return pq;
    }

    public static ExamPaperQuestion loadPaperQuestionById(Long pqId) {
        if (pqId == null) {
            return null;
        }
        IExamPaperQuestionPlusService examPaperQuestionPlusService = (IExamPaperQuestionPlusService)SpringUtil.getBean((String)"examPaperQuestionPlusService");
        ExamPaperQuestion pq = (ExamPaperQuestion)examPaperQuestionPlusService.getById(pqId);
        return ExamQuestionClobUtil.loadPaperQuestion(pq);
    }

    public static ExamQuestion loadQuestionById(Long questionId) {
        return ExamQuestionClobUtil.loadQuestionById(questionId, true);
    }

    public static ExamQuestion loadQuestionById(Long questionId, boolean isAdmin) {
        if (questionId == null) {
            return null;
        }
        IExamQuestionPlusService examQuestionService = (IExamQuestionPlusService)SpringUtil.getBean((String)"examQuestionPlusService");
        ExamQuestion eq = (ExamQuestion)examQuestionService.getById(questionId);
        return ExamQuestionClobUtil.loadQuestion(eq, isAdmin);
    }

    public static ExamQuestion loadQuestion(ExamQuestion eq) {
        return ExamQuestionClobUtil.loadQuestion(eq, true);
    }

    public static ExamQuestion loadQuestion(ExamQuestion eq, boolean isAdmin) {
        String answer;
        if (eq == null || eq.getQuestionId() == null) {
            return eq;
        }
        if (eq.getUseclob() == null || eq.getUseclob() != 1) {
            return eq;
        }
        Map<String, String> clobMap = ExamQuestionClobUtil.loadLobByQuestionId(eq.getQuestionId());
        String content = clobMap == null ? null : clobMap.get(LOB_CONTENT);
        String options = clobMap == null ? null : clobMap.get(LOB_OPTIONS);
        String detailAnswer = clobMap == null ? null : clobMap.get(LOB_DETAILANSWER);
        String string = answer = clobMap == null ? null : clobMap.get(LOB_ANSWER);
        if (!StringUtils.isEmpty((Object)content)) {
            eq.setContent(content);
        }
        if (!StringUtils.isEmpty((Object)options)) {
            eq.setOptions(options);
        }
        if (!isAdmin) {
            return eq;
        }
        if (!StringUtils.isEmpty((Object)answer)) {
            eq.setAnswer(answer);
        }
        if (!StringUtils.isEmpty((Object)detailAnswer)) {
            eq.setDetailanswer(detailAnswer);
        }
        return eq;
    }

    private static Map<String, String> loadLobByPaperQuestion(ExamPaperQuestion pq) {
        if (pq == null || pq.getPqId() == null) {
            return null;
        }
        if (pq.getUseclob() != null && pq.getUseclob() == 1) {
            Map<String, String> map = ExamQuestionClobUtil.loadLobByPaperQuestion(pq.getPqId());
            if (map != null) {
                return map;
            }
            return ExamQuestionClobUtil.loadLobByQuestionId(pq.getQuestionId());
        }
        return null;
    }

    public static Map<String, String> loadLobByPaperQuestion(Long pqId) {
        if (pqId == null) {
            return null;
        }
        IExamQuestionClobPlusService examQuestionClobService = (IExamQuestionClobPlusService)SpringUtil.getBean(IExamQuestionClobPlusService.class);
        ExamQuestionClobQuery clobQuery = new ExamQuestionClobQuery();
        clobQuery.setTablename("EXAM_PAPER_QUESTION");
        clobQuery.setTableId(pqId);
        List clobs = examQuestionClobService.findAll(clobQuery);
        if (clobs != null && clobs.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < clobs.size(); ++i) {
                map.put(((ExamQuestionClob)clobs.get(i)).getTablecolumn(), ((ExamQuestionClob)clobs.get(i)).getContent());
            }
            return map;
        }
        return null;
    }

    public static Map<String, String> loadLobByQuestionId(Long questionId) {
        if (questionId == null) {
            return null;
        }
        IExamQuestionClobPlusService examQuestionClobService = (IExamQuestionClobPlusService)SpringUtil.getBean(IExamQuestionClobPlusService.class);
        ExamQuestionClobQuery clobQuery = new ExamQuestionClobQuery();
        clobQuery.setTablename("EXAM_QUESTION");
        clobQuery.setTableId(questionId);
        List clobs = examQuestionClobService.findAll(clobQuery);
        if (clobs != null && clobs.size() > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < clobs.size(); ++i) {
                map.put(((ExamQuestionClob)clobs.get(i)).getTablecolumn(), ((ExamQuestionClob)clobs.get(i)).getContent());
            }
            return map;
        }
        return null;
    }
}

