/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.util;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.mng.exam.examquestion.vo.ExamQuestionExpVO;
import com.peak.prd.exam.enums.ExamQuestionDiffiEnum;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import com.peak.prd.exam.examcategory.vo.ExamQuestionknowledgeVO;
import com.peak.prd.exam.examquestion.service.IExamQuestionKnowledgePlusService;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examtag.service.IExamQuestionTagPlusService;
import com.peak.prd.exam.examtag.vo.ExamTagVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ExamQuestionExpUtil {
    public static void appendAttrs(List<ExamQuestionExpVO> vos) {
        IExamQuestiontypePlusService examQuestiontypePlusService = (IExamQuestiontypePlusService)SpringUtil.getBean(IExamQuestiontypePlusService.class);
        IExamQuestionTagPlusService examQuestionTagPlusService = (IExamQuestionTagPlusService)SpringUtil.getBean(IExamQuestionTagPlusService.class);
        IExamQuestionKnowledgePlusService examQuestionKnowledgePlusService = (IExamQuestionKnowledgePlusService)SpringUtil.getBean(IExamQuestionKnowledgePlusService.class);
        List typeIds = ConvertUtil.removeNull((List)IdUtil.getIds(vos, e -> e.getTypeId()));
        List qtypes = examQuestiontypePlusService.findByIds(typeIds);
        List sortedQtypes = ConvertUtil.refact(vos, (List)qtypes, (vo, qt) -> qt.getTypeId().equals(vo.getTypeId()));
        ConvertUtil.setProperties(vos, (List)sortedQtypes, (vo, qt) -> vo.setTypeName(qt.getTypename()));
        List questionIds = IdUtil.getIds(vos, q -> q.getLongOfQuestionId());
        List<ExamQuestionknowledgeVO> quesKnowVOs = examQuestionKnowledgePlusService.getExamQuestionknowledgeVOs(questionIds);
        Map<Long, List<ExamTagVO>> quesTagVOsMap = examQuestionTagPlusService.getTags(questionIds);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            ExamQuestionExpVO ques = vos.get(i);
            String answer = ExamQuestionExpUtil.getExpAnswer(ques.getAnswer(), ques.getTypeId());
            vos.get(i).setAnswer(answer);
            String diffi = ExamQuestionDiffiEnum.getNameByValue(ques.getDifficultyInteger());
            vos.get(i).setDifficulty(diffi);
            if (ques.getParentId() != null && ques.getParentId() != 0L) {
                vos.get(i).setDifficulty("");
            }
            vos.get(i).setKnowledges(ExamQuestionExpUtil.getKnows(ques.getLongOfQuestionId(), quesKnowVOs));
            vos.get(i).setTags(ExamQuestionExpUtil.getTagNames(ques.getLongOfQuestionId(), quesTagVOsMap));
        }
    }

    public static String getTagNames(Long questionId, Map<Long, List<ExamTagVO>> mapTags) {
        if (questionId == null || CollectionUtils.isEmpty(mapTags)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        List<ExamTagVO> list = mapTags.get(questionId);
        for (int i = 0; list != null && i < list.size(); ++i) {
            sb.append(list.get(i).getName());
            if (i >= list.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getKnows(Long questionId, List<ExamQuestionknowledgeVO> quesKnowVOs) {
        if (questionId == null || CollectionUtils.isEmpty(quesKnowVOs)) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ExamQuestionknowledgeVO vo : quesKnowVOs) {
            if (!questionId.equals(vo.getQuestionId())) continue;
            list.add(vo.getTitle());
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append((String)list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getExpAnswer(String answer, Long typeId) {
        if (StringUtils.isEmpty((Object)answer)) {
            return answer;
        }
        int basicType = ExamQuestiontypeEnum.getBasicType(typeId);
        if (basicType == 3 || basicType == 1) {
            int nAnswer = Integer.parseInt(answer);
            for (int i = 1; i <= 26; ++i) {
                if (nAnswer != i) continue;
                return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i - 1) + "";
            }
        } else {
            if (basicType == 2 || basicType == 10) {
                long nAnswer = Long.parseLong(answer);
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < 26; ++i) {
                    long tmp = (long)Math.pow(2.0, i);
                    if ((nAnswer & tmp) == 0L) continue;
                    str.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(i));
                }
                return str.toString();
            }
            if (basicType == 4) {
                StringBuilder strAnswer = new StringBuilder();
                JSONArray jsonArray = JSONArray.fromObject((Object)answer);
                for (int j = 0; j < jsonArray.size(); ++j) {
                    JSONArray jAry = jsonArray.getJSONArray(j);
                    for (int k = 0; k < jAry.size(); ++k) {
                        strAnswer.append(jAry.get(k));
                        if (k == jAry.size() - 1) continue;
                        strAnswer.append("|");
                    }
                    if (j == jsonArray.size() - 1) continue;
                    strAnswer.append("##");
                }
                return strAnswer.toString();
            }
        }
        return answer;
    }
}

