/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestion.util;

import com.alibaba.fastjson.JSON;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.SpringUtil;
import com.peak.mng.exam.examquestion.bo.ExamQuestionBO;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import com.peak.prd.exam.exampaper.model.ExamPaperQuestion;
import com.peak.prd.exam.exampaper.vo.ExamPaperQuestionVO;
import com.peak.prd.exam.examquestion.bean.ExamQuestionBlankDTO;
import com.peak.prd.exam.examquestion.bean.ExamQuestionChoiceDTO;
import com.peak.prd.exam.examquestion.bean.SortChoiceItem;
import com.peak.prd.exam.examquestion.model.ExamQuestion;
import com.peak.prd.exam.examquestion.vo.ExamQuestionVO;
import com.peak.prd.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exception.PrdBaseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExamQuestionUtil {
    private static final Logger log = LoggerFactory.getLogger(ExamQuestionUtil.class);

    public static boolean isChoiceQuestion(Long typeId) {
        if (typeId == null) {
            return false;
        }
        int basicType = (int)(typeId % 100L);
        return basicType == 1 || basicType == 2 || basicType == 3 || basicType == 10;
    }

    public static List<ExamPaperQuestionVO> getExamPaperQuestionVOs(List<ExamPaperQuestion> models) {
        ArrayList<ExamPaperQuestionVO> list = new ArrayList<ExamPaperQuestionVO>();
        for (int i = 0; models != null && i < models.size(); ++i) {
            list.add(ExamQuestionUtil.getExamPaperQuestionVO(models.get(i)));
        }
        return list;
    }

    public static ExamPaperQuestionVO getExamPaperQuestionVO(ExamPaperQuestion model) {
        if (model == null) {
            return null;
        }
        ExamPaperQuestionVO vo = (ExamPaperQuestionVO)ConvertUtil.convert((Object)model, ExamPaperQuestionVO.class);
        vo.setIsdisorder(model.getDisorder());
        return ExamQuestionUtil._getExamQuestionVO(model.getTypeId(), model.getOptions(), model.getAnswer(), vo);
    }

    public static ExamQuestionVO getExamQuestionVO(ExamQuestion model) {
        if (model == null) {
            return null;
        }
        ExamQuestionVO vo = (ExamQuestionVO)ConvertUtil.convert((Object)model, ExamQuestionVO.class);
        return ExamQuestionUtil._getExamQuestionVO(model.getTypeId(), model.getOptions(), model.getAnswer(), vo);
    }

    public static <T extends ExamQuestionVO> T _getExamQuestionVO(Long typeId, String options, String answer, T vo) {
        int basicType = (int)(typeId % 100L);
        boolean isChoiceQuestion = ExamQuestionUtil.isChoiceQuestion(vo.getTypeId());
        if (isChoiceQuestion) {
            boolean isSingle;
            ArrayList<ExamQuestionChoiceDTO> choices = null;
            try {
                choices = JSON.parseArray((String)options, ExamQuestionChoiceDTO.class);
            }
            catch (Exception ex) {
                log.warn("_getExamQuestionVO error[a]==={}==={}", (Object)options, (Object)ex.getMessage());
                try {
                    JSONArray jsonArray = JSONArray.fromObject((Object)options);
                    if (jsonArray != null && jsonArray.size() > 0) {
                        choices = new ArrayList<ExamQuestionChoiceDTO>(jsonArray.size());
                        for (int a = 0; a < jsonArray.size(); ++a) {
                            JSONObject jsonObject = jsonArray.getJSONObject(a);
                            ExamQuestionChoiceDTO dto = (ExamQuestionChoiceDTO)JSONObject.toBean((JSONObject)jsonObject, ExamQuestionChoiceDTO.class);
                            choices.add(dto);
                        }
                    }
                }
                catch (Exception ex2) {
                    log.warn("_getExamQuestionVO error[a2]==={}==={}", (Object)options, (Object)ex.getMessage());
                }
            }
            boolean bl = isSingle = basicType == 1 || basicType == 3;
            if (isSingle) {
                ExamQuestionUtil.setSingleChoiceQuestionAnswer(answer, (List<ExamQuestionChoiceDTO>)choices);
            } else {
                ExamQuestionUtil.setMultiChoiceQuestionAnswer(answer, (List<ExamQuestionChoiceDTO>)choices);
            }
            vo.setChoices((List<ExamQuestionChoiceDTO>)choices);
        } else if (basicType == 4) {
            List<ExamQuestionBlankDTO> blanks = ExamQuestionBlankDTO.parseAnswer(answer);
            vo.setBlanks(blanks);
        } else if (basicType == 6) {
            List<ExamQuestionChoiceDTO>[] choices = ExamQuestionChoiceDTO.parseMatchChoices(options, answer);
            if (choices != null) {
                vo.setChoiceABCs(choices.length > 0 ? choices[0] : null);
                vo.setChoice123s(choices.length > 1 ? choices[1] : null);
            }
        } else if (basicType == 12) {
            List choices = null;
            try {
                choices = JSON.parseArray((String)options, ExamQuestionChoiceDTO.class);
            }
            catch (Exception ex) {
                log.warn("_getExamQuestionVO error[b]==={}==={}", (Object)options, (Object)ex.getMessage());
            }
            try {
                JSONArray jsonArray = JSONArray.fromObject((Object)answer);
                for (int i = 0; choices != null && i < choices.size(); ++i) {
                    ((ExamQuestionChoiceDTO)choices.get(jsonArray.getInt(i))).setOrderNum(i);
                }
            }
            catch (Exception ex) {
                log.warn("_getExamQuestionVO error[c]==={}==={}", (Object)answer, (Object)ex.getMessage());
            }
            vo.setChoices(choices);
        }
        return vo;
    }

    public static void setSingleChoiceQuestionAnswer(String answer, List<ExamQuestionChoiceDTO> choices) {
        if (answer == null || answer.isEmpty() || choices == null || choices.isEmpty()) {
            return;
        }
        int nAnswer = Integer.parseInt(answer);
        for (int i = 0; i < choices.size(); ++i) {
            if (i + 1 != nAnswer) continue;
            choices.get(i).setChecked(true);
            break;
        }
    }

    public static void setMultiChoiceQuestionAnswer(String answer, List<ExamQuestionChoiceDTO> choices) {
        if (answer == null || answer.isEmpty() || choices == null || choices.isEmpty()) {
            return;
        }
        long nAnswer = Long.parseLong(answer);
        for (int i = 0; i < choices.size(); ++i) {
            long tmp = (long)Math.pow(2.0, i);
            if ((nAnswer & tmp) == 0L) continue;
            choices.get(i).setChecked(true);
        }
    }

    public static ApiResult validateExamQuestionBO(ExamQuestionBO bo) {
        boolean isChoiceQuestion;
        IExamQuestiontypePlusService examQuestiontypePlusService = (IExamQuestiontypePlusService)SpringUtil.getBean(IExamQuestiontypePlusService.class);
        ExamQuestiontype qtype = (ExamQuestiontype)examQuestiontypePlusService.findById(bo.getTypeId());
        if (qtype == null) {
            return ApiResult.errMsg((String)("\u9898\u578b\u4e0d\u5408\u6cd5[" + bo.getTypeId() + "]"));
        }
        int basicType = (int)(bo.getTypeId() % 100L);
        if (ExamQuestiontypeEnum.hasChildren(basicType)) {
            if (bo.getParentId() != null && bo.getParentId() != 0L) {
                return ApiResult.errMsg((String)(qtype.getTypename() + "\u4e0d\u80fd\u4f5c\u4e3a\u5b50\u9898\u76ee[" + bo.getTypeId() + "]"));
            }
            bo.setScore(0.0);
        }
        if (isChoiceQuestion = ExamQuestionUtil.isChoiceQuestion(bo.getTypeId())) {
            List<ExamQuestionChoiceDTO> choices = bo.getChoices();
            if (choices == null || choices.size() < 2) {
                return ApiResult.errMsg((String)"\u9009\u9879\u6570\u91cf\u4e0d\u8db3\uff08\u6700\u5c112\u4e2a\u9009\u9879\uff09");
            }
            if (choices.size() > 26) {
                return ApiResult.errMsg((String)"\u9009\u9879\u6570\u91cf\u592a\u591a\u5566\uff08\u6700\u591a26\u4e2a\u9009\u9879\uff09");
            }
            for (int i = 0; i < choices.size(); ++i) {
                if (choices.get(i).getTitle() != null && !StringUtils.isEmpty((Object)choices.get(i).getTitle().trim())) continue;
                return ApiResult.errMsg((String)"\u9009\u9879\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            }
            boolean isSingle = basicType == 1 || basicType == 3;
            long answer = isSingle ? ExamQuestionUtil.getSingleChoiceQuestionAnswer(bo) : ExamQuestionUtil.getMultiChoiceQuestionAnswer(bo);
            if (answer == 0L) {
                return ApiResult.errMsg((String)"\u6b63\u786e\u7b54\u6848\u4e0d\u5408\u6cd5");
            }
        } else if (basicType == 4) {
            List<ExamQuestionBlankDTO> blanks = bo.getBlanks();
            if (blanks == null || blanks.size() < 1) {
                return ApiResult.errMsg((String)"\u7a7a\u683c\u6570\u91cf\u4e0d\u8db3\uff08\u6700\u5c111\u4e2a\u7a7a\u683c\uff09");
            }
        } else if (basicType == 6) {
            List[] abc123 = new List[]{bo.getChoiceABCs(), bo.getChoice123s()};
            for (int i = 0; i < abc123.length; ++i) {
                List choices = abc123[i];
                if (choices == null || choices.size() < 2) {
                    return ApiResult.errMsg((String)"\u9009\u9879\u6570\u91cf\u4e0d\u8db3\uff08\u6700\u5c112\u4e2a\u9009\u9879\uff09");
                }
                if (choices.size() > 26) {
                    return ApiResult.errMsg((String)"\u9009\u9879\u6570\u91cf\u592a\u591a\u5566\uff08\u6700\u591a26\u4e2a\u9009\u9879\uff09");
                }
                for (int j = 0; j < choices.size(); ++j) {
                    if (((ExamQuestionChoiceDTO)choices.get(j)).getTitle() != null && !StringUtils.isEmpty((Object)((ExamQuestionChoiceDTO)choices.get(j)).getTitle().trim())) continue;
                    return ApiResult.errMsg((String)"\u9009\u9879\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            List<ExamQuestionChoiceDTO> choiceABCs = bo.getChoiceABCs();
            int linkNum = 0;
            for (int i = 0; i < choiceABCs.size(); ++i) {
                Integer abcMatch123 = choiceABCs.get(i).getAbcMatch123();
                if (abcMatch123 == null || abcMatch123 <= 0) continue;
                if (abcMatch123 > bo.getChoice123s().size()) {
                    return ApiResult.errMsg((String)"\u6b63\u786e\u7b54\u6848\u8bbe\u7f6e\u4e0d\u5408\u6cd5");
                }
                ++linkNum;
            }
            if (linkNum == 0) {
                return ApiResult.errMsg((String)"\u672a\u8bbe\u7f6e\u6b63\u786e\u7b54\u6848");
            }
        }
        return null;
    }

    private static long getSingleChoiceQuestionAnswer(ExamQuestionBO bo) {
        List<ExamQuestionChoiceDTO> choices = bo.getChoices();
        long answer = 0L;
        int checkedNum = 0;
        for (int i = 0; choices != null && i < choices.size(); ++i) {
            if (!choices.get(i).isChecked()) continue;
            ++checkedNum;
            answer = i + 1;
        }
        if (checkedNum > 1) {
            return 0L;
        }
        return answer;
    }

    private static long getMultiChoiceQuestionAnswer(ExamQuestionBO bo) {
        List<ExamQuestionChoiceDTO> choices = bo.getChoices();
        long answer = 0L;
        for (int i = 0; choices != null && i < choices.size(); ++i) {
            if (!choices.get(i).isChecked()) continue;
            answer = (long)((double)answer + Math.pow(2.0, i));
        }
        return answer;
    }

    public static void doChoiceQuestion(ExamQuestionBO bo, Object examPaperQuestionOrExamQuestion) {
        boolean isChoiceQuestion = ExamQuestionUtil.isChoiceQuestion(bo.getTypeId());
        if (!isChoiceQuestion) {
            return;
        }
        Method method = null;
        if (examPaperQuestionOrExamQuestion instanceof ExamQuestion) {
            try {
                method = ExamQuestion.class.getMethod("setOptions", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else if (examPaperQuestionOrExamQuestion instanceof ExamPaperQuestion) {
            try {
                method = ExamPaperQuestion.class.getMethod("setOptions", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new PrdBaseException("not ExamQuestion not ExamPaperQuestion");
        }
        try {
            method.invoke(examPaperQuestionOrExamQuestion, ExamQuestionUtil.getOptions(bo.getChoices()));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (examPaperQuestionOrExamQuestion instanceof ExamQuestion) {
            try {
                method = ExamQuestion.class.getMethod("setAnswer", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        if (examPaperQuestionOrExamQuestion instanceof ExamPaperQuestion) {
            try {
                method = ExamPaperQuestion.class.getMethod("setAnswer", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        int basicType = (int)(bo.getTypeId() % 100L);
        boolean isSingle = basicType == 1 || basicType == 3;
        try {
            method.invoke(examPaperQuestionOrExamQuestion, isSingle ? ExamQuestionUtil.getSingleChoiceQuestionAnswer(bo) + "" : ExamQuestionUtil.getMultiChoiceQuestionAnswer(bo) + "");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void doMatchQuestion(ExamQuestionBO bo, Object examPaperQuestionOrExamQuestion) {
        boolean isMatch;
        int basicType = (int)(bo.getTypeId() % 100L);
        boolean bl = isMatch = basicType == 6;
        if (!isMatch) {
            return;
        }
        List<ExamQuestionChoiceDTO> choiceABCs = bo.getChoiceABCs();
        com.alibaba.fastjson.JSONArray links = new com.alibaba.fastjson.JSONArray();
        for (int i = 0; i < choiceABCs.size(); ++i) {
            Integer abcMatch123 = choiceABCs.get(i).getAbcMatch123();
            if (abcMatch123 == null) continue;
            String line = (char)(65 + i) + "_" + abcMatch123;
            links.add((Object)line);
        }
        if (examPaperQuestionOrExamQuestion instanceof ExamQuestion) {
            ((ExamQuestion)examPaperQuestionOrExamQuestion).setOptions(ExamQuestionUtil.getMatchOptions(bo.getChoiceABCs(), bo.getChoice123s()));
            ((ExamQuestion)examPaperQuestionOrExamQuestion).setAnswer(links.toString());
        } else if (examPaperQuestionOrExamQuestion instanceof ExamPaperQuestion) {
            ((ExamPaperQuestion)examPaperQuestionOrExamQuestion).setOptions(ExamQuestionUtil.getMatchOptions(bo.getChoiceABCs(), bo.getChoice123s()));
            ((ExamPaperQuestion)examPaperQuestionOrExamQuestion).setAnswer(links.toString());
        }
    }

    public static void doSortQuestion(ExamQuestionBO bo, Object examPaperQuestionOrExamQuestion) {
        boolean isSort;
        int basicType = (int)(bo.getTypeId() % 100L);
        boolean bl = isSort = basicType == 12;
        if (!isSort) {
            return;
        }
        List<ExamQuestionChoiceDTO> choices = bo.getChoices();
        ArrayList<SortChoiceItem> sortArray = new ArrayList<SortChoiceItem>();
        for (int i = 0; i < choices.size(); ++i) {
            int choiceVal = i;
            Integer orderNum = choices.get(i).getOrderNum();
            sortArray.add(new SortChoiceItem(orderNum == null ? 0 : orderNum, choiceVal));
        }
        if (examPaperQuestionOrExamQuestion instanceof ExamQuestion) {
            ((ExamQuestion)examPaperQuestionOrExamQuestion).setOptions(ExamQuestionUtil.getOptions(bo.getChoices()));
            ((ExamQuestion)examPaperQuestionOrExamQuestion).setAnswer(SortChoiceItem.getAnswer(sortArray));
        } else if (examPaperQuestionOrExamQuestion instanceof ExamPaperQuestion) {
            ((ExamPaperQuestion)examPaperQuestionOrExamQuestion).setOptions(ExamQuestionUtil.getOptions(bo.getChoices()));
            ((ExamPaperQuestion)examPaperQuestionOrExamQuestion).setAnswer(SortChoiceItem.getAnswer(sortArray));
        }
    }

    public static void doFillQuestion(ExamQuestionBO bo, Object examPaperQuestionOrExamQuestion) {
        boolean isFill;
        int basicType = (int)(bo.getTypeId() % 100L);
        boolean bl = isFill = basicType == 4;
        if (!isFill) {
            return;
        }
        List<ExamQuestionBlankDTO> blanks = bo.getBlanks();
        Method method = null;
        if (examPaperQuestionOrExamQuestion instanceof ExamQuestion) {
            try {
                method = ExamQuestion.class.getMethod("setAnswer", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else if (examPaperQuestionOrExamQuestion instanceof ExamPaperQuestion) {
            try {
                method = ExamPaperQuestion.class.getMethod("setAnswer", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new PrdBaseException("not ExamQuestion not ExamPaperQuestion");
        }
        try {
            method.invoke(examPaperQuestionOrExamQuestion, ExamQuestionBlankDTO.getAnswerJSONString(blanks));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getOptions(List<ExamQuestionChoiceDTO> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        return ExamQuestionUtil.getChoicesJsonArray(choices).toString();
    }

    private static com.alibaba.fastjson.JSONArray getChoicesJsonArray(List<ExamQuestionChoiceDTO> choices) {
        if (choices == null || choices.isEmpty()) {
            return null;
        }
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        for (int i = 0; i < choices.size(); ++i) {
            com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
            jsonObject.put("title", (Object)choices.get(i).getTitle());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    private static String getMatchOptions(List<ExamQuestionChoiceDTO> choiceABCs, List<ExamQuestionChoiceDTO> choice123s) {
        com.alibaba.fastjson.JSONArray jsonArrayABC = ExamQuestionUtil.getChoicesJsonArray(choiceABCs);
        com.alibaba.fastjson.JSONArray jsonArray123 = ExamQuestionUtil.getChoicesJsonArray(choice123s);
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        jsonArray.add((Object)jsonArrayABC);
        jsonArray.add((Object)jsonArray123);
        return jsonArray.toString();
    }
}

