/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestionread.dao.imple;

import com.peak.mng.exam.examquestionread.bo.ReplyQueryBO;
import com.peak.prd.base.dao.imple.PrdBaseDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.exam.examquestionread.bean.ExamReplyReadDTO;
import com.peak.prd.exam.examquestionread.dao.IExamReplyReadPlusDao;
import com.peak.prd.exam.examquestionread.model.ExamReplyRead;
import com.peak.prd.exam.examquestionread.vo.ExamReplyReadQuery;
import com.peak.prd.exam.examquestionread.vo.ReplyReadNumVO;
import com.peak.prd.exam.examquestionread.vo.ReplyReadVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class ExamReplyReadPlusDao
extends PrdBaseDao<ExamReplyRead, Long, ExamReplyReadQuery>
implements IExamReplyReadPlusDao {
    @Override
    public Paging<ReplyReadVO> findNext(ReplyQueryBO queryBO, boolean weight) {
        Paging paging = new Paging();
        paging.setPageSize(queryBO.getPageSize());
        paging.setPageNumber(queryBO.getPageNumber());
        String countSql = weight ? ".findWeightNext.count" : ".findNext.count";
        String sql = weight ? ".findWeightNext" : ".findNext";
        long totalCount = (Long)this.getSqlSessionTemplate().selectOne(this.getNamespace() + countSql, (Object)queryBO);
        int offset = this.getThisPageFirstRowNumber(paging);
        int limit = paging.getPageSize();
        List list = this.getSqlSessionTemplate().selectList(this.getNamespace() + sql, (Object)queryBO, offset, limit);
        paging.setTotalCount(totalCount);
        paging.setList(list);
        return paging;
    }

    private int getThisPageFirstRowNumber(Paging paging) {
        int pageNumber = paging.getPageNumber();
        int pageSize = paging.getPageSize();
        if (pageSize <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        return (pageNumber - 1) * pageSize + 1;
    }

    @Override
    public void updateRead(ExamReplyReadDTO dto) {
        this.getSqlSessionTemplate().update(this.getNamespace() + ".updateRead", (Object)dto);
    }

    @Override
    public void updateReview(ExamReplyReadDTO dto) {
        this.getSqlSessionTemplate().update(this.getNamespace() + ".updateReview", (Object)dto);
    }

    @Override
    public void submitRead(Long readerId, Long arrangeId, Long questionId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("readerId", readerId);
        map.put("arrangeId", arrangeId);
        map.put("questionId", questionId);
        this.getSqlSessionTemplate().update(this.getNamespace() + ".submitRead", map);
    }

    @Override
    public boolean submitFullRead(Long resultId, Long readerId) {
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
        map.put("readerId", readerId);
        map.put("resultId", resultId);
        map.put("now", new Date());
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".submitFullRead", map) > 0;
    }

    @Override
    public void submitWeightRead(Long readerId, Long arrangeId, Long questionId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("readerId", readerId);
        map.put("arrangeId", arrangeId);
        map.put("questionId", questionId);
        this.getSqlSessionTemplate().update(this.getNamespace() + ".submitWeightRead", map);
    }

    @Override
    public int unlockByArrangeIdQuestionId(Long arrangeId, Long questionId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("questionId", questionId);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".unlockByArrangeIdQuestionId", map);
    }

    @Override
    public List<ReplyReadNumVO> getReplyReadNumVOs(Long arrangeId, List<Long> questionIds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arrangeId", arrangeId);
        map.put("questionIds", questionIds);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getReplyReadNumVOs", map);
    }

    @Override
    public List<ReplyReadNumVO> getReplyReadNumVOs(List<Long> arrangeIds, List<Long> questionIds, Long readerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arrangeIds", arrangeIds);
        map.put("questionIds", questionIds);
        map.put("readerId", readerId);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getReplyReadNumVOs", map);
    }

    @Override
    public List<ExamReplyRead> getListByReplyId(Long replyId) {
        if (replyId == null) {
            return null;
        }
        ExamReplyReadQuery tmpquery = new ExamReplyReadQuery();
        tmpquery.setReplyId(replyId);
        return this.findAll(tmpquery);
    }

    @Override
    public int deleteByExamQuesReader(Long arrangeId, Long questionId, Long readerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("questionId", questionId);
        map.put("readerId", readerId);
        return this.getSqlSessionTemplate().delete(this.getNamespace() + ".deleteByExamQuesReader", map);
    }

    @Override
    public int resetExamReplyByExamQuesReader(Long arrangeId, Long questionId, Long readerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("questionId", questionId);
        map.put("readerId", readerId);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".resetExamReplyByExamQuesReader", map);
    }
}

