/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestionread.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examquestionread.bo.ExamArrangeQuestionReaderBO;
import com.peak.mng.exam.examquestionread.bo.ExamArrangeQuestionReaderDeleteBO;
import com.peak.mng.exam.examquestionread.bo.ExamArrangeQuestionReaderDetailQueryBO;
import com.peak.mng.exam.examquestionread.bo.ExamArrangeQuestionReaderQuestionQueryBO;
import com.peak.mng.exam.examquestionread.bo.ExamQuestionReadQuestionQueryBO;
import com.peak.prd.appsecurity.user.model.User;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.util.ExamArrangeUtil;
import com.peak.prd.exam.examquestionread.dao.IExamArrangeQuestionReaderPlusDao;
import com.peak.prd.exam.examquestionread.enums.ExamReplyReadEnum;
import com.peak.prd.exam.examquestionread.model.ExamArrangeQuestionReader;
import com.peak.prd.exam.examquestionread.service.IExamArrangeQuestionReaderPlusService;
import com.peak.prd.exam.examquestionread.service.IExamReplyReadPlusService;
import com.peak.prd.exam.examquestionread.vo.ExamArrangeQuestionReaderDetailVO;
import com.peak.prd.exam.examquestionread.vo.ExamArrangeQuestionReaderExamVO;
import com.peak.prd.exam.examquestionread.vo.ExamArrangeQuestionReaderQuery;
import com.peak.prd.exam.examquestionread.vo.ExamArrangeQuestionReaderQuestionForTchVO;
import com.peak.prd.exam.examquestionread.vo.ExamArrangeQuestionReaderQuestionVO;
import com.peak.prd.exam.examquestionread.vo.ExamReplyReadQuery;
import com.peak.prd.exam.examquestionread.vo.ReaderVO;
import com.peak.prd.exam.examquestionread.vo.ReplyReadNumVO;
import com.peak.prd.exam.examquestionread.vo.ReplyReadVO;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examquestiontype.vo.ExamQuestiontypeVO;
import com.peak.prd.exam.examreply.model.ExamReply;
import com.peak.prd.exam.examreply.service.IExamReplyPlusService;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamArrangeQuestionReaderPlusService
extends PrdBaseService<ExamArrangeQuestionReader, Long, ExamArrangeQuestionReaderQuery>
implements IExamArrangeQuestionReaderPlusService {
    private IExamArrangeQuestionReaderPlusDao examArrangeQuestionReaderPlusDao;
    @Autowired
    private IExamQuestiontypePlusService examQuestiontypePlusService;
    @Autowired
    private IExamReplyReadPlusService examReplyReadPlusService;
    @Autowired
    private IExamArrangePlusService examArrangePlusService;
    @Autowired
    private IExamReplyPlusService examReplyPlusService;
    @Autowired
    private PrdExamConfig prdExamConfig;

    public void setExamArrangeQuestionReaderPlusDao(IExamArrangeQuestionReaderPlusDao dao) {
        this.examArrangeQuestionReaderPlusDao = dao;
    }

    public IExamArrangeQuestionReaderPlusDao getExamArrangeQuestionReaderPlusDao() {
        return this.examArrangeQuestionReaderPlusDao;
    }

    public IEntityDao<ExamArrangeQuestionReader, Long, ExamArrangeQuestionReaderQuery> getEntityDao() {
        return this.examArrangeQuestionReaderPlusDao;
    }

    private Paging<ExamArrangeQuestionReaderQuestionVO> findQuestionVOPaging(ExamArrangeQuestionReaderQuery query, Long typeId) {
        List<Object> typeIds;
        boolean includeFillType = this.prdExamConfig.isFillQuestionAsSubjective();
        if (typeId == null) {
            typeIds = this.examQuestiontypePlusService.getAllSubjectiveTypeIds(includeFillType);
        } else {
            typeIds = new ArrayList();
            typeIds.add(typeId);
        }
        query.setTypeIds(typeIds);
        Paging<ExamArrangeQuestionReaderQuestionVO> paging = this.examArrangeQuestionReaderPlusDao.findQuestionVOPaging(query);
        List list = paging.getList();
        List<ExamQuestiontypeVO> typeVOs = this.examQuestiontypePlusService.getAllSubjectiveTypes(includeFillType);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamArrangeQuestionReaderQuestionVO ques = (ExamArrangeQuestionReaderQuestionVO)list.get(i);
            Optional<ExamQuestiontypeVO> typeVO = typeVOs.stream().filter(item -> item.getTypeId().equals(ques.getTypeId())).findFirst();
            ques.setTypeName(typeVO.isPresent() ? typeVO.get().getTypename() : "\u672a\u77e5\u9898\u578b");
        }
        return paging;
    }

    @Override
    public Paging<ExamArrangeQuestionReaderQuestionVO> findQuestionVOPaging(ExamArrangeQuestionReaderQuestionQueryBO queryBO) {
        int j;
        ExamArrangeQuestionReaderQuestionVO vo;
        int i;
        if (queryBO.getArrangeId() == null) {
            return null;
        }
        ExamArrangeQuestionReaderQuery query = (ExamArrangeQuestionReaderQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamArrangeQuestionReaderQuery.class);
        Paging<ExamArrangeQuestionReaderQuestionVO> paging = this.findQuestionVOPaging(query, queryBO.getTypeId());
        List list = paging.getList();
        ExamArrangeQuestionReaderQuery readerQuery = new ExamArrangeQuestionReaderQuery();
        List questionIds = IdUtil.getIds((List)list, e -> e.getQuestionId());
        readerQuery.setArrangeId(queryBO.getArrangeId());
        readerQuery.setQuestionIds(questionIds);
        List readers = CollectionUtils.isEmpty((Collection)questionIds) ? null : this.findAll(readerQuery);
        boolean hasWeight = this.hasWeight(readers);
        HashMap<String, Long> weightReadNumMap = new HashMap<String, Long>();
        if (hasWeight) {
            List<ReplyReadNumVO> replyReadNumVOs = this.examReplyReadPlusService.getReplyReadNumVOs(queryBO.getArrangeId(), questionIds);
            for (int i2 = 0; replyReadNumVOs != null && i2 < replyReadNumVOs.size(); ++i2) {
                ReplyReadNumVO replyReadNumVO = replyReadNumVOs.get(i2);
                String key = replyReadNumVO.getQuestionId() + "_" + replyReadNumVO.getReaderId();
                weightReadNumMap.put(key, replyReadNumVO.getReadCount());
            }
        }
        HashMap readerCountMap = new HashMap();
        HashMap reviewCountMap = new HashMap();
        for (i = 0; list != null && i < list.size(); ++i) {
            vo = (ExamArrangeQuestionReaderQuestionVO)list.get(i);
            ArrayList<ReaderVO> readerVOs = new ArrayList<ReaderVO>();
            ArrayList<ReaderVO> reviewerVOs = new ArrayList<ReaderVO>();
            for (j = 0; readers != null && j < readers.size(); ++j) {
                ExamArrangeQuestionReader reader = (ExamArrangeQuestionReader)readers.get(j);
                if (reader.getQuestionId() == null || reader.getReaderflag() == null || reader.getReaderId() == null || !reader.getQuestionId().equals(vo.getQuestionId())) continue;
                if (ExamReplyReadEnum.isReader(reader.getReaderflag())) {
                    ReaderVO readerVO = new ReaderVO(reader.getAqrId(), reader.getReaderId(), reader.getReadername(), reader.getWeight());
                    readerVO.setTotalReplyCount(vo.getTotalReplyCount());
                    String key = vo.getQuestionId() + "_" + reader.getReaderId();
                    readerVO.setReadCount((Long)weightReadNumMap.get(key));
                    readerVOs.add(readerVO);
                    if (!readerCountMap.containsKey(reader.getReaderId())) {
                        readerCountMap.put(reader.getReaderId(), new HashSet());
                    }
                    ((Set)readerCountMap.get(reader.getReaderId())).add(reader.getQuestionId());
                    continue;
                }
                if (!ExamReplyReadEnum.isReviewer(reader.getReaderflag())) continue;
                reviewerVOs.add(new ReaderVO(reader.getAqrId(), reader.getReaderId(), reader.getReadername(), reader.getWeight()));
                if (!reviewCountMap.containsKey(reader.getReaderId())) {
                    reviewCountMap.put(reader.getReaderId(), new HashSet());
                }
                ((Set)reviewCountMap.get(reader.getReaderId())).add(reader.getQuestionId());
            }
            vo.setReaders(readerVOs);
            vo.setReviewers(reviewerVOs);
        }
        for (i = 0; list != null && i < list.size(); ++i) {
            vo = (ExamArrangeQuestionReaderQuestionVO)list.get(i);
            List<ReaderVO> voReaders = vo.getReaders();
            for (int j2 = voReaders.size() - 1; j2 >= 0; --j2) {
                Long uid;
                Set quesNum;
                voReaders.get(j2).setCommon((quesNum = (Set)readerCountMap.get(uid = voReaders.get(j2).getReaderId())) != null && quesNum.size() == list.size());
            }
            List<ReaderVO> voReviews = vo.getReviewers();
            for (j = voReviews.size() - 1; j >= 0; --j) {
                Long uid;
                Set quesNum;
                voReviews.get(j).setCommon((quesNum = (Set)reviewCountMap.get(uid = voReviews.get(j).getReaderId())) != null && quesNum.size() == list.size());
            }
        }
        return paging;
    }

    private boolean hasWeight(List<ExamArrangeQuestionReader> readers) {
        if (ListUtil.isNullorEmpty(readers)) {
            return false;
        }
        List list = readers.stream().filter(e -> e.getReaderflag() != null && e.getReaderflag() == 0 && e.getWeight() != null && e.getWeight() > 0).collect(Collectors.toList());
        return !ListUtil.isNullorEmpty(list);
    }

    @Override
    public Paging<ExamArrangeQuestionReaderQuestionForTchVO> findQuestionVOPagingForTeacher(ExamQuestionReadQuestionQueryBO queryBO) {
        if (queryBO.getReaderId() == null) {
            return null;
        }
        ExamArrangeQuestionReaderQuery query = (ExamArrangeQuestionReaderQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamArrangeQuestionReaderQuery.class);
        query.setByTeacher(true);
        Paging<ExamArrangeQuestionReaderQuestionVO> paging = this.findQuestionVOPaging(query, queryBO.getTypeId());
        List list = paging.getList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        List arrangeIds = IdUtil.getIds((List)list, e -> e.getArrangeId());
        List questionIds = IdUtil.getIds((List)list, e -> e.getQuestionId());
        List arranges = this.examArrangePlusService.getByIds(arrangeIds);
        list.forEach(item -> {
            Optional<ExamArrange> opt = arranges.stream().filter(a -> a.getArrangeId().equals(item.getArrangeId())).findFirst();
            item.setArrangeTitle(opt.isPresent() ? opt.get().getTitle() : "\u672a\u77e5\u8003\u8bd5");
        });
        ArrayList<Long> weightArrangeIds = new ArrayList<Long>();
        for (int i = 0; arranges != null && i < arranges.size(); ++i) {
            boolean isWeight = ExamArrangeUtil.isWeightTchreadtype(((ExamArrange)arranges.get(i)).getArrangeId());
            if (!isWeight) continue;
            weightArrangeIds.add(((ExamArrange)arranges.get(i)).getArrangeId());
        }
        HashSet setWeightArrangeId = new HashSet(weightArrangeIds);
        List<ReplyReadNumVO> replyReadNumVOs = this.examReplyReadPlusService.getReplyReadNumVOs(weightArrangeIds, questionIds, query.getReaderId());
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamArrangeQuestionReaderQuestionVO item_a = (ExamArrangeQuestionReaderQuestionVO)list.get(i);
            boolean isWeight = setWeightArrangeId.contains(item_a.getArrangeId());
            if (!isWeight) continue;
            item_a.setTotalReplyCount_weight(item_a.getTotalReplyCount());
            item_a.setNotReadCount_weight(item_a.getTotalReplyCount());
            for (int j = 0; replyReadNumVOs != null && j < replyReadNumVOs.size(); ++j) {
                ReplyReadNumVO item_b = replyReadNumVOs.get(j);
                if (!item_b.getArrangeId().equals(item_a.getArrangeId()) || !item_b.getQuestionId().equals(item_a.getQuestionId()) || item_b.getReadCount() == null || item_b.getReadCount().intValue() == 0 || item_a.getTotalReplyCount() == null) continue;
                long notReadNum = item_a.getTotalReplyCount() - item_b.getReadCount();
                item_a.setNotReadCount_weight(notReadNum);
            }
        }
        ExamArrangeQuestionReaderQuery readerQuery = new ExamArrangeQuestionReaderQuery();
        readerQuery.setArrangeIds(arrangeIds);
        readerQuery.setQuestionIds(questionIds);
        readerQuery.setReaderId(queryBO.getReaderId());
        List readers = CollectionUtils.isEmpty((Collection)questionIds) || CollectionUtils.isEmpty((Collection)arrangeIds) ? null : this.findAll(readerQuery);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamArrangeQuestionReaderQuestionVO vo = (ExamArrangeQuestionReaderQuestionVO)list.get(i);
            for (int j = 0; readers != null && j < readers.size(); ++j) {
                ExamArrangeQuestionReader reader = (ExamArrangeQuestionReader)readers.get(j);
                if (reader.getArrangeId() == null || reader.getQuestionId() == null || reader.getReaderflag() == null || !reader.getQuestionId().equals(vo.getQuestionId()) || !reader.getArrangeId().equals(vo.getArrangeId())) continue;
                if (reader.getReaderflag() == 0) {
                    vo.setReader(true);
                    continue;
                }
                if (reader.getReaderflag() != 1) continue;
                vo.setReviewer(true);
            }
            if (!vo.isReviewer() || vo.isReader()) continue;
            vo.setTotalReplyCount_weight(null);
            vo.setLockReadCount_weight(null);
            vo.setNotReadCount_weight(null);
        }
        Paging ret = new Paging(paging.getPageNumber(), paging.getPageSize());
        ret.setTotalCount(paging.getTotalCount());
        ret.setList(ConvertUtil.convert((List)list, ExamArrangeQuestionReaderQuestionForTchVO.class));
        return ret;
    }

    @Override
    public Paging<ExamArrangeQuestionReaderExamVO> findExamVOPagingByTeacherId(ExamArrangeQuestionReaderQuery query) {
        Paging<ExamArrangeQuestionReaderExamVO> paging = this.examArrangeQuestionReaderPlusDao.findExamVOPagingByTeacherId(query);
        if (!paging.isListNullOrEmpty()) {
            List list = paging.getList();
            this.fetchSubjectInfo(list);
        }
        return paging;
    }

    private void fetchSubjectInfo(List<ExamArrangeQuestionReaderExamVO> vos) {
        IExamResourceRelationPlusService examResourceRelationPlusService = (IExamResourceRelationPlusService)SpringUtil.getBean(IExamResourceRelationPlusService.class);
        ExamResourceRelationQuery examResourceRelationQuery = new ExamResourceRelationQuery();
        examResourceRelationQuery.setExamtype(4);
        examResourceRelationQuery.setResourcetype(5);
        List arrangeIds = IdUtil.getIds(vos, e -> e.getArrangeId());
        examResourceRelationQuery.setExamresourceIds(arrangeIds);
        List errVOs = CollectionUtils.isEmpty((Collection)arrangeIds) ? null : examResourceRelationPlusService.getPrdEntityDao().findList((IQuery)examResourceRelationQuery, "findVOAll", ExamResourceRelationVO.class);
        List sortedErrVOs = ConvertUtil.refact((List)arrangeIds, (List)errVOs, (p, r) -> r == null ? false : p.equals(r.getExamresourceId()));
        ConvertUtil.setProperties(vos, (List)sortedErrVOs, (v, r) -> v.setSubjectName(r == null ? null : r.getResourceName()));
    }

    @Override
    public void insertBatch(Long creatorId, ExamArrangeQuestionReaderBO bo) {
        Date now = new Date();
        boolean isWeight = ExamArrangeUtil.isWeightTchreadtype(bo.getArrangeId());
        for (int j = 0; bo.getReaderIds() != null && j < bo.getReaderIds().size(); ++j) {
            Long userId = bo.getReaderIds().get(j);
            User user = UserCoreUtil.getUser((Long)userId);
            if (user == null) continue;
            for (int i = 0; bo.getQuestionIds() != null && i < bo.getQuestionIds().size(); ++i) {
                boolean isExisted;
                ExamArrangeQuestionReader model = new ExamArrangeQuestionReader(IdUtil.getSequence((String)"EXAM_ARRANGE_QUESTION_READER"));
                model.setArrangeId(bo.getArrangeId());
                model.setQuestionId(bo.getQuestionIds().get(i));
                model.setReaderId(userId);
                model.setReaderflag(bo.getReaderflag());
                model.setCreatorId(creatorId);
                model.setCreatedate(now);
                model.setReadername(user.getName());
                if (isWeight && model.getWeight() == null) {
                    model.setWeight(ExamArrangeUtil.TCHREAD_WEIGHT_DEFAULT_VALUE);
                }
                boolean bl = isExisted = this.getReader(model.getArrangeId(), model.getQuestionId(), model.getReaderId(), model.getReaderflag()) != null;
                if (isExisted) continue;
                this.examArrangeQuestionReaderPlusDao.insert((BaseEntity)model);
            }
        }
    }

    private ExamArrangeQuestionReader getReader(Long arrangeId, Long questionId, Long userId, Integer flag) {
        if (arrangeId == null || questionId == null || userId == null || flag == null) {
            return null;
        }
        ExamArrangeQuestionReaderQuery query = new ExamArrangeQuestionReaderQuery();
        query.setArrangeId(arrangeId);
        query.setQuestionId(questionId);
        query.setReaderId(userId);
        query.setReaderflag(flag);
        return (ExamArrangeQuestionReader)this.examArrangeQuestionReaderPlusDao.findOne(query);
    }

    @Override
    public int deleteBatch(Long currUserId, ExamArrangeQuestionReaderDeleteBO bo) {
        if (bo.getArrangeId() == null || CollectionUtils.isEmpty(bo.getQuestionIds())) {
            return 0;
        }
        if (CollectionUtils.isEmpty(bo.getReaderIds())) {
            return this.examArrangeQuestionReaderPlusDao.deleteByArrangeQuestion(bo.getArrangeId(), bo.getQuestionIds());
        }
        int num = 0;
        for (int i = 0; bo.getQuestionIds() != null && i < bo.getQuestionIds().size(); ++i) {
            for (int j = 0; j < bo.getReaderIds().size(); ++j) {
                ExamArrangeQuestionReader aqr = this.getReader(bo.getArrangeId(), bo.getQuestionIds().get(i), bo.getReaderIds().get(j), bo.getReaderflag());
                if (aqr == null) continue;
                this.deleteById(aqr.getAqrId());
                ++num;
            }
        }
        return num;
    }

    @Override
    public Paging<ExamArrangeQuestionReaderDetailVO> findDetailVOPaging(ExamArrangeQuestionReaderDetailQueryBO queryBO) {
        ArrayList<Long> typeIds;
        if (queryBO.getArrangeId() == null) {
            return null;
        }
        ExamArrange examArrange = (ExamArrange)this.examArrangePlusService.getById(queryBO.getArrangeId());
        boolean includeFillType = this.prdExamConfig.isFillQuestionAsSubjective();
        ExamArrangeQuestionReaderQuery query = (ExamArrangeQuestionReaderQuery)ConvertUtil.convert((Object)((Object)queryBO), ExamArrangeQuestionReaderQuery.class);
        if (queryBO.getTypeId() == null) {
            typeIds = this.examQuestiontypePlusService.getAllSubjectiveTypeIds(includeFillType);
            query.setTypeIds(typeIds);
        } else {
            typeIds = new ArrayList();
            typeIds.add(queryBO.getTypeId());
            query.setTypeIds(typeIds);
        }
        Paging<ExamArrangeQuestionReaderDetailVO> paging = this.examArrangeQuestionReaderPlusDao.findDetailVOPaging(query);
        List list = paging.getList();
        List<ExamQuestiontypeVO> typeVOs = this.examQuestiontypePlusService.getAllSubjectiveTypes(includeFillType);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamArrangeQuestionReaderDetailVO ques = (ExamArrangeQuestionReaderDetailVO)list.get(i);
            Optional<ExamQuestiontypeVO> typeVO = typeVOs.stream().filter(item -> item.getTypeId().equals(ques.getTypeId())).findFirst();
            ques.setTypeName(typeVO.isPresent() ? typeVO.get().getTypename() : "\u672a\u77e5\u9898\u578b");
        }
        ExamReplyReadQuery replyReadQuery = new ExamReplyReadQuery();
        List replyIds = IdUtil.getIds((List)list, e -> e.getReplyId());
        replyReadQuery.setArrangeId(queryBO.getArrangeId());
        replyReadQuery.setReplyIds(replyIds);
        List replyReads = CollectionUtils.isEmpty((Collection)replyIds) ? null : this.examReplyReadPlusService.findAll(replyReadQuery);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamArrangeQuestionReaderDetailVO vo = (ExamArrangeQuestionReaderDetailVO)list.get(i);
            vo.setTchreadtype(examArrange.getTchreadtype());
            List filterReads = replyReads.stream().filter(item -> item.getReplyId().equals(vo.getReplyId())).collect(Collectors.toList());
            List readerVOs = ConvertUtil.convert(filterReads, ReplyReadVO.class);
            UserCoreUtil.setUserRealname((List)readerVOs, ReplyReadVO::getReaderId, ReplyReadVO::setReadername);
            vo.setReaders(readerVOs);
        }
        return paging;
    }

    @Override
    public boolean isReaderOrReviewerByPqId(Long userId, Long pqId) {
        return this.examArrangeQuestionReaderPlusDao.isReaderOrReviewerByPqId(userId, pqId);
    }

    @Override
    public boolean isReaderByArrangeQuestionId(Long userId, Long arrangeId, Long questionId) {
        return this.isReaderOrReviewerByArrangeQuestionId(userId, arrangeId, questionId, true);
    }

    @Override
    public ExamArrangeQuestionReader getReaderByArrangeQuestionId(Long userId, Long arrangeId, Long questionId) {
        return this.getReaderByArrangeQuestionId(userId, arrangeId, questionId, 0);
    }

    @Override
    public ExamArrangeQuestionReader getReviewerByArrangeQuestionId(Long userId, Long arrangeId, Long questionId) {
        return this.getReaderByArrangeQuestionId(userId, arrangeId, questionId, 1);
    }

    private ExamArrangeQuestionReader getReaderByArrangeQuestionId(Long userId, Long arrangeId, Long questionId, int flag) {
        if (userId == null || arrangeId == null || questionId == null) {
            return null;
        }
        ExamArrangeQuestionReaderQuery query = new ExamArrangeQuestionReaderQuery();
        query.setArrangeId(arrangeId);
        query.setQuestionId(questionId);
        query.setReaderId(userId);
        query.setReaderflag(flag);
        return (ExamArrangeQuestionReader)this.examArrangeQuestionReaderPlusDao.findOne(query);
    }

    @Override
    public List<ExamArrangeQuestionReader> getAllReaders(Long arrangeId, Long questionId) {
        return this._getAllReaders(arrangeId, questionId, 0);
    }

    @Override
    public List<ExamArrangeQuestionReader> getAllReviewers(Long arrangeId, Long questionId) {
        return this._getAllReaders(arrangeId, questionId, 1);
    }

    private List<ExamArrangeQuestionReader> _getAllReaders(Long arrangeId, Long questionId, int readerflag) {
        if (arrangeId == null || questionId == null) {
            return null;
        }
        ExamArrangeQuestionReaderQuery query = new ExamArrangeQuestionReaderQuery(1, 999);
        query.setArrangeId(arrangeId);
        query.setQuestionId(questionId);
        query.setReaderflag(readerflag);
        return this.examArrangeQuestionReaderPlusDao.findList(query);
    }

    @Override
    public boolean isReviewerByArrangeQuestionId(Long userId, Long arrangeId, Long questionId) {
        return this.isReaderOrReviewerByArrangeQuestionId(userId, arrangeId, questionId, false);
    }

    private boolean isReaderOrReviewerByArrangeQuestionId(Long userId, Long arrangeId, Long questionId, boolean isReader) {
        if (userId == null || arrangeId == null || questionId == null) {
            return false;
        }
        ExamArrangeQuestionReaderQuery query = new ExamArrangeQuestionReaderQuery();
        query.setArrangeId(arrangeId);
        query.setQuestionId(questionId);
        query.setReaderId(userId);
        query.setReaderflag(isReader ? 0 : 1);
        return this.examArrangeQuestionReaderPlusDao.findOne(query) != null;
    }

    @Override
    public boolean isReaderByReplyId(Long userId, Long replyId) {
        return this.isReaderOrReviewerByReplyId(userId, replyId, true);
    }

    @Override
    public ExamArrangeQuestionReader getReaderByReplyId(Long userId, Long replyId) {
        if (userId == null || replyId == null) {
            return null;
        }
        ExamReply examReply = (ExamReply)this.examReplyPlusService.getById(replyId);
        if (examReply == null) {
            return null;
        }
        return this.getReaderByArrangeQuestionId(userId, examReply.getArrangeId(), examReply.getQuestionId());
    }

    @Override
    public boolean isReviewerByReplyId(Long userId, Long replyId) {
        return this.isReaderOrReviewerByReplyId(userId, replyId, false);
    }

    private boolean isReaderOrReviewerByReplyId(Long userId, Long replyId, boolean isReader) {
        if (userId == null || replyId == null) {
            return false;
        }
        ExamReply examReply = (ExamReply)this.examReplyPlusService.getById(replyId);
        if (examReply == null) {
            return false;
        }
        return this.isReaderOrReviewerByArrangeQuestionId(userId, examReply.getArrangeId(), examReply.getQuestionId(), isReader);
    }
}

