/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examquestiontype.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examquestiontype.bo.ExamQuestiontypeInsertBO;
import com.peak.mng.exam.examquestiontype.bo.ExamQuestiontypeQueryBO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.enums.ExamQuestiontypeEnum;
import com.peak.prd.exam.examquestiontype.dao.IExamQuestiontypePlusDao;
import com.peak.prd.exam.examquestiontype.model.ExamQuestiontype;
import com.peak.prd.exam.examquestiontype.service.IExamQuestiontypePlusService;
import com.peak.prd.exam.examquestiontype.vo.ExamQuestiontypeQuery;
import com.peak.prd.exam.examquestiontype.vo.ExamQuestiontypeVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@CacheConfig(cacheNames={"exam"})
public class ExamQuestiontypePlusService
extends PrdBaseService<ExamQuestiontype, Long, ExamQuestiontypeQuery>
implements IExamQuestiontypePlusService {
    private IExamQuestiontypePlusDao examQuestiontypePlusDao;

    public void setExamQuestiontypePlusDao(IExamQuestiontypePlusDao dao) {
        this.examQuestiontypePlusDao = dao;
    }

    public IExamQuestiontypePlusDao getExamQuestiontypePlusDao() {
        return this.examQuestiontypePlusDao;
    }

    public IEntityDao<ExamQuestiontype, Long, ExamQuestiontypeQuery> getEntityDao() {
        return this.examQuestiontypePlusDao;
    }

    @Override
    public Paging<ExamQuestiontypeVO> findVOPaging(ExamQuestiontypeQueryBO bo) {
        ExamQuestiontypeQuery query = (ExamQuestiontypeQuery)ConvertUtil.convert((Object)((Object)bo), ExamQuestiontypeQuery.class);
        query.getPage().setSortColumns("createdate DESC");
        query = (ExamQuestiontypeQuery)this.findPage(query);
        List vos = ConvertUtil.convert((List)query.getPage().getResult(), ExamQuestiontypeVO.class);
        UserCoreUtil.setUserRealname((List)vos, ExamQuestiontypeVO::getCreatorId, ExamQuestiontypeVO::setCreatorName);
        return new Paging(query.getPage(), vos);
    }

    @Override
    public Long insert(Long creatorId, ExamQuestiontypeInsertBO bo) {
        Long typeId = IdUtil.getSequence((String)"EXAM_QUESTIONTYPE");
        typeId = typeId * 100L + (long)bo.getBasicType();
        typeId = typeId % 1000000000L;
        ExamQuestiontype examQuestiontype = new ExamQuestiontype(typeId);
        examQuestiontype.setTypename(bo.getTypename());
        examQuestiontype.setCode(bo.getCode());
        examQuestiontype.setOuttype(bo.getBasicType() + "");
        examQuestiontype.setValId(bo.getValId());
        examQuestiontype.setNote(bo.getNote());
        examQuestiontype.setCreatedate(new Date());
        examQuestiontype.setCreatorId(creatorId);
        this.insert((BaseEntity)examQuestiontype);
        return typeId;
    }

    @Override
    public List<Long> getAllSubjectiveTypeIds(boolean includeFillType) {
        List<ExamQuestiontypeVO> vos = this.getAllSubjectiveTypes(includeFillType);
        return vos.stream().map(item -> item.getTypeId()).collect(Collectors.toList());
    }

    @Override
    public List<ExamQuestiontypeVO> getAllSubjectiveTypes(boolean includeFillType) {
        return this.getAllSubjectiveTypes(includeFillType, null);
    }

    @Override
    public List<ExamQuestiontypeVO> getAllSubjectiveTypes(boolean includeFillType, Integer valid) {
        List all = this.findAll(null);
        ArrayList<ExamQuestiontypeVO> subjectiveTypes = new ArrayList<ExamQuestiontypeVO>();
        for (int i = 0; i < all.size(); ++i) {
            Long typeId = ((ExamQuestiontype)all.get(i)).getTypeId();
            boolean isSubjective = ExamQuestiontypeEnum.isSubjective(typeId, includeFillType);
            if (!isSubjective || valid != null && !valid.equals(((ExamQuestiontype)all.get(i)).getValId())) continue;
            subjectiveTypes.add((ExamQuestiontypeVO)ConvertUtil.convert(all.get(i), ExamQuestiontypeVO.class));
        }
        return subjectiveTypes;
    }

    @Override
    @Cacheable
    public String getTypename(Long typeId) {
        ExamQuestiontype qt = (ExamQuestiontype)this.getById(typeId);
        if (qt == null) {
            return null;
        }
        return qt.getTypename();
    }

    @Override
    @Cacheable
    public Long getTypeid(String typename) {
        if (StringUtils.isEmpty((Object)typename)) {
            return null;
        }
        ExamQuestiontypeQuery query = new ExamQuestiontypeQuery();
        query.setEqualTypename(typename);
        List list = this.findAll(query);
        return CollectionUtils.isEmpty((Collection)list) ? null : ((ExamQuestiontype)list.get(0)).getTypeId();
    }

    @Override
    public boolean orExisted(String code, String name, Long exceptQtypeId) {
        return this.examQuestiontypePlusDao.orExistedNum(code, name, exceptQtypeId) > 0L;
    }

    @Override
    @Cacheable
    public List<ExamQuestiontypeVO> getCachedAllTypesIncludeInvalid() {
        return this._getAllTypes(null);
    }

    @Override
    @Cacheable
    public List<ExamQuestiontypeVO> getCachedAllTypesExcludeInvalid() {
        return this._getAllTypes(1);
    }

    @Override
    @Cacheable
    public List<Long> getCachedAllComplexTypeIdsIncludeInvalid() {
        ArrayList<ExamQuestiontypeVO> ret = new ArrayList<ExamQuestiontypeVO>();
        List<ExamQuestiontypeVO> allTypes = this.getCachedAllTypesIncludeInvalid();
        for (int i = 0; i < allTypes.size(); ++i) {
            if (!ExamQuestiontypeEnum.hasChildren(allTypes.get(i).getBasicType())) continue;
            ret.add(allTypes.get(i));
        }
        return IdUtil.getIds(ret, v -> v.getTypeId());
    }

    private List<ExamQuestiontypeVO> _getAllTypes(Integer valid) {
        ExamQuestiontypeQuery query = new ExamQuestiontypeQuery();
        query.getPage().setSortColumns("createdate DESC");
        query.setValId(valid);
        List allTypes = this.findAll(query);
        List vos = ConvertUtil.convert((List)allTypes, ExamQuestiontypeVO.class);
        return vos;
    }
}

