/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examreply.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.ExamMonitorCheatEnum;
import com.peak.prd.enums.ExamPauseEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.exammonitor.model.ExamMonitor;
import com.peak.prd.exam.exammonitor.model.ExamMonitorCheat;
import com.peak.prd.exam.exammonitor.service.IExamMonitorCheatPlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonitorPlusService;
import com.peak.prd.exam.examreply.dao.IExamPausePlusDao;
import com.peak.prd.exam.examreply.model.ExamPause;
import com.peak.prd.exam.examreply.service.IExamPausePlusService;
import com.peak.prd.exam.examreply.vo.ExamPauseQuery;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExamPausePlusService
extends PrdBaseService<ExamPause, Map<String, Object>, ExamPauseQuery>
implements IExamPausePlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamPausePlusService.class);
    @Resource
    private IExamArrangePlusService examArrangePlusService;
    @Resource
    private IExamResultPlusService examResultPlusService;
    @Resource
    private IExamMonitorPlusService examMonitorPlusService;
    @Resource
    private IExamMonitorCheatPlusService examMonitorCheatPlusService;
    private IExamPausePlusDao examPausePlusDao;

    public void setExamPausePlusDao(IExamPausePlusDao dao) {
        this.examPausePlusDao = dao;
    }

    public IExamPausePlusDao getExamPausePlusDao() {
        return this.examPausePlusDao;
    }

    public IEntityDao<ExamPause, Map<String, Object>, ExamPauseQuery> getEntityDao() {
        return this.examPausePlusDao;
    }

    @Override
    public Integer getTotalSpentSeconds(Long resultId) {
        return this.examPausePlusDao.getTotalSpentSeconds(resultId);
    }

    @Override
    public int getToggleOutCount(Long resultId) {
        if (resultId == null) {
            return 0;
        }
        ExamPauseQuery examPauseQuery = new ExamPauseQuery();
        examPauseQuery.setResultId(resultId);
        examPauseQuery.setOperatetype(ExamPauseEnum.OPERATETYPE_OUT.getValue());
        return (int)this.examPausePlusDao.count(examPauseQuery);
    }

    @Override
    public void toggle(Long resultId, Long studentId, Integer operateType, Integer useragentType) {
        boolean isSubmitted;
        if (resultId == null || studentId == null || operateType == null) {
            log.warn("empty param[resultId{}, studentId{}, type{}] by toggle", new Object[]{resultId, studentId, operateType});
            return;
        }
        ExamResult examResult = (ExamResult)this.examResultPlusService.getById(resultId);
        if (examResult == null) {
            log.warn("ExamResult[{}] not found by toggle", (Object)resultId);
            return;
        }
        if (!studentId.equals(examResult.getStudentId())) {
            log.warn("invalid call[403][resultId{}, studentId{}, type{}] by toggle", new Object[]{resultId, studentId, operateType});
            return;
        }
        boolean bl = isSubmitted = examResult.getUsersubmit() != null && examResult.getUsersubmit() != 0L;
        if (isSubmitted) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            log.info("ignore call[submitted:{}][resultId{}, studentId{}, type{}] by toggle", new Object[]{sdf.format(examResult.getSubmitdate()), resultId, studentId, operateType});
            return;
        }
        ExamArrange examArrange = this.examArrangePlusService.safeFindById(examResult.getArrangeId());
        int canexit = this.getCanexit(examArrange);
        if (canexit <= 0) {
            if (log.isDebugEnabled()) {
                log.debug("ignore call[canexit:{}][resultId{}, studentId{}, type{}] by toggle", new Object[]{canexit, resultId, studentId, operateType});
            }
            return;
        }
        ExamPause examPause = new ExamPause(resultId, new Date());
        examPause.setArrangeId(examResult.getArrangeId());
        examPause.setStudentId(studentId);
        examPause.setOperatetype(operateType);
        examPause.setUseragenttype(useragentType);
        this.examPausePlusDao.insertSelective((BaseEntity)examPause);
        if (operateType.intValue() == ExamPauseEnum.OPERATETYPE_OUT.getValue()) {
            int toggleOutCount = this.getToggleOutCount(resultId);
            ExamMonitor examMonitor = new ExamMonitor(resultId);
            examMonitor.setJumpreply(toggleOutCount);
            this.examMonitorPlusService.updateSelective(examMonitor);
            if (toggleOutCount > canexit) {
                this.examMonitorCheatPlusService.deleteByResultAndType(resultId, ExamMonitorCheatEnum.TYPE_TOGGLE_OUT.getValue());
                ExamMonitorCheat examMonitorCheat = new ExamMonitorCheat();
                examMonitorCheat.setMcId(IdUtil.getSequence((String)"EXAM_MONITOR_CHEAT"));
                examMonitorCheat.setResultId(resultId);
                examMonitorCheat.setStudentId(studentId);
                examMonitorCheat.setCreatorId(studentId);
                examMonitorCheat.setCreatedate(new Date());
                examMonitorCheat.setType(ExamMonitorCheatEnum.TYPE_TOGGLE_OUT.getValue());
                examMonitorCheat.setRemark("\u624b\u673a\u7aef\u8003\u8bd5\u9650\u5236\u5207\u5c4f" + canexit + "\u6b21\uff0c\u5b9e\u9645\u5207\u5c4f" + toggleOutCount + "\u6b21");
                this.examMonitorCheatPlusService.insertCheat(examMonitorCheat);
            }
        }
    }

    private int getCanexit(ExamArrange examArrange) {
        if (examArrange == null) {
            return -1;
        }
        if (examArrange.getCanexit() == null) {
            return 0;
        }
        return examArrange.getCanexit();
    }
}

