/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examreply.service.imple;

import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examreply.dao.IExamReplyHelperDao;
import com.peak.prd.exam.examreply.model.ExamReply;
import com.peak.prd.exam.examreply.service.IExamReplyHelperService;
import com.peak.prd.exam.examreply.vo.ExamReplyQuery;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPlusService;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseByUserVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentByUserVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesStuVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamReplyHelperService
extends PrdBaseService<ExamReply, Long, ExamReplyQuery>
implements IExamReplyHelperService {
    @Autowired
    private IExamSeriesPlusService examSeriesPlusService;
    @Autowired
    private IExamSeriesPhasePlusService examSeriesPhasePlusService;
    @Autowired
    private IExamReplyHelperDao examReplyHelperDao;

    public IEntityDao<ExamReply, Long, ExamReplyQuery> getEntityDao() {
        return this.examReplyHelperDao;
    }

    @Override
    public ApiResult canEnterPhaseExam(Long phaseExamId, Long studentId) {
        Long seriesId = this.examSeriesPhasePlusService.getSeriesIdByPhasecontentId(phaseExamId);
        ExamSeriesStuVO examSeriesStuVO = this.examSeriesPlusService.getExamSeriesStuVO(seriesId);
        if (examSeriesStuVO == null) {
            return ApiResult.errMsg((String)("\u591a\u573a\u6b21\u8003\u8bd5\u672a\u627e\u5230[\u573a\u6b21\u8003\u8bd5id:" + phaseExamId + "]"));
        }
        List<ExamSeriesPhaseByUserVO> phaseByUserVOs = this.examSeriesPhasePlusService.getPhaseByUserVOs(seriesId, studentId);
        if (CollectionUtils.isEmpty(phaseByUserVOs)) {
            return ApiResult.errMsg((String)("\u591a\u573a\u6b21\u8003\u8bd5--\u6211\u7684\u9636\u6bb5\u7a7a[seriesId:" + seriesId + ", studentId:" + studentId + "]"));
        }
        Long phaseId = this.examSeriesPhasePlusService.getPhaseIdByPhasecontentId(phaseExamId);
        if (phaseId == null) {
            return ApiResult.errMsg((String)("\u591a\u573a\u6b21\u8003\u8bd5-\u9636\u6bb5\u672a\u627e\u5230[\u573a\u6b21\u8003\u8bd5id:" + phaseExamId + "]"));
        }
        if (!examSeriesStuVO.getIsorderphaseBool()) {
            for (int i = 0; i < phaseByUserVOs.size(); ++i) {
                if (!phaseId.equals(phaseByUserVOs.get(i).getPhaseId())) continue;
                return this.canEnterPhaseExam_checkPhaseExam(phaseByUserVOs.get(i), phaseExamId);
            }
        } else {
            for (int i = 0; i < phaseByUserVOs.size(); ++i) {
                if (phaseId.equals(phaseByUserVOs.get(i).getPhaseId())) {
                    return this.canEnterPhaseExam_checkPhaseExam(phaseByUserVOs.get(i), phaseExamId);
                }
                if (phaseByUserVOs.get(i).isPassed()) continue;
                return ApiResult.errMsg((String)"\u9700\u8981\u5b8c\u6210\u524d\u7f6e\u9636\u6bb5\u540e\uff0c\u518d\u8fdb\u5165\u672c\u9636\u6bb5\u5185\u7684\u8003\u8bd5");
            }
        }
        return ApiResult.errMsg((String)"\u672a\u77e5");
    }

    @Override
    public boolean canEnterExamByBranch(Long arrangeId, Long deptId) {
        return this.examReplyHelperDao.canEnterExamByBranch(arrangeId, deptId);
    }

    private ApiResult canEnterPhaseExam_checkPhaseExam(ExamSeriesPhaseByUserVO phaseByUserVO, Long examId) {
        if (!phaseByUserVO.getIsorderBool()) {
            return ApiResult.ok();
        }
        List<ExamSeriesPhasecontentByUserVO> contents = phaseByUserVO.getContents();
        for (int i = 0; contents != null && i < contents.size(); ++i) {
            if (examId.equals(contents.get(i).getContentId())) {
                return ApiResult.ok();
            }
            if (contents.get(i).getCompletedBool()) continue;
            return ApiResult.errMsg((String)"\u9700\u8981\u5b8c\u6210\u524d\u7f6e\u8003\u8bd5\u540e\uff0c\u518d\u8fdb\u5165\u672c\u8003\u8bd5");
        }
        return ApiResult.errMsg((String)("\u672a\u77e5[phase][examId:" + examId + "]"));
    }
}

