/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examresourcerelation.service.imple;

import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.ExamResourceRelationEnum;
import com.peak.prd.exam.examresourcerelation.dao.IExamResourceRelationPlusDao;
import com.peak.prd.exam.examresourcerelation.model.ExamResourceRelation;
import com.peak.prd.exam.examresourcerelation.service.IExamResourceRelationPlusService;
import com.peak.prd.exam.examresourcerelation.vo.ExamResourceRelationQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class ExamResourceRelationPlusService
extends PrdBaseService<ExamResourceRelation, Long, ExamResourceRelationQuery>
implements IExamResourceRelationPlusService {
    private IExamResourceRelationPlusDao examResourceRelationPlusDao;

    public void setExamResourceRelationPlusDao(IExamResourceRelationPlusDao dao) {
        this.examResourceRelationPlusDao = dao;
    }

    public IExamResourceRelationPlusDao getExamResourceRelationPlusDao() {
        return this.examResourceRelationPlusDao;
    }

    public IEntityDao<ExamResourceRelation, Long, ExamResourceRelationQuery> getEntityDao() {
        return this.examResourceRelationPlusDao;
    }

    @Override
    public int deleteQbankCategory(@NotNull Long qbankId) {
        ExamResourceRelationQuery query = new ExamResourceRelationQuery();
        query.setResourcetype(1);
        query.setExamtype(1);
        query.setExamresourceId(qbankId);
        return this.examResourceRelationPlusDao.deleteByQuery(query);
    }

    @Override
    public int deleteByQuery(ExamResourceRelationQuery query) {
        return this.examResourceRelationPlusDao.deleteByQuery(query);
    }

    @Override
    public void insertDimensionKnowledges(Long categoryId, List<Long> knowledgeIds, Long operatorId) {
        if (categoryId == null || ListUtil.isNullorEmpty(knowledgeIds)) {
            return;
        }
        ArrayList<ExamResourceRelation> examResourceRelations = new ArrayList<ExamResourceRelation>();
        for (Long knowledgeId : knowledgeIds) {
            ExamResourceRelation rr = this.createRelation_byDimensionKnowledge(categoryId, knowledgeId, operatorId);
            examResourceRelations.add(rr);
        }
        this.examResourceRelationPlusDao.insertBatch(examResourceRelations);
    }

    private ExamResourceRelation createRelation_byDimensionKnowledge(Long categoryId, Long knowledgeId, Long operatorId) {
        if (categoryId == null || knowledgeId == null) {
            return null;
        }
        ExamResourceRelation relation = new ExamResourceRelation(IdUtil.getSequence((String)"EXAM_RESOURCE_RELATION"));
        relation.setResourcetype(ExamResourceRelationEnum.RESOURCE_TYPE_CATEGORY.getValue());
        relation.setResourceId(categoryId);
        relation.setExamtype(ExamResourceRelationEnum.EXAM_TYPE_KNOWLEDGE.getValue());
        relation.setExamresourceId(knowledgeId);
        relation.setCreatorId(operatorId);
        relation.setCreatedate(new Date());
        return relation;
    }
}

