/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examresult.dao.imple;

import com.peak.prd.base.dao.imple.PrdBaseDao;
import com.peak.prd.exam.examarrange.vo.ExamArrangeMiniVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.examresult.dao.IExamResultPlusDao;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.vo.ExamResultPassNumVO;
import com.peak.prd.exam.examresult.vo.ExamResultQuery;
import com.peak.prd.exam.examresult.vo.ExamResultScoreRangeVO;
import com.peak.prd.exam.examresult.vo.ExamResultStatisticVO;
import com.peak.prd.exam.examresult.vo.ExamResultVO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class ExamResultPlusDao
extends PrdBaseDao<ExamResult, Long, ExamResultQuery>
implements IExamResultPlusDao {
    private static final Logger log = LoggerFactory.getLogger(ExamResultPlusDao.class);

    @Override
    public long findVOCount(ExamResultQuery query) {
        return (Long)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".findVOList.count", (Object)query);
    }

    @Override
    public ExamResultPassNumVO getPassPercent(Long arrangeId, Double passmark) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("arrangeId", arrangeId);
        map.put("passmark", passmark);
        return (ExamResultPassNumVO)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getPassPercent", map);
    }

    @Override
    public List<ExamResultScoreRangeVO> getExamResultScoreRangeVOs(Long arrangeId, Long domainIdByScoreRange) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("domainIdByScoreRange", domainIdByScoreRange);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getExamResultScoreRangeVOs", map);
    }

    @Override
    public void updateFinalMark(Long arrangeId, Long userId, Double dFinalMark, Long resultIdOfSelect) {
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        map.put("now", new Date());
        map.put("arrangeId", arrangeId);
        map.put("userId", userId);
        if (dFinalMark != null && !dFinalMark.isNaN()) {
            map.put("mark", dFinalMark);
        }
        if (resultIdOfSelect != null) {
            map.put("resultIdOfSelect", resultIdOfSelect);
        }
        if (log.isDebugEnabled()) {
            log.debug("updateFinalMark: {}, {}, {}, {}", new Object[]{arrangeId, userId, dFinalMark, resultIdOfSelect});
        }
        this.getSqlSessionTemplate().update(this.getNamespace() + ".updateFinalMark", map);
    }

    @Override
    public List<Long> getUserSubmittedArrangeIds(Long userId, List<Long> arrangeIds) {
        ExamResultQuery examResultQuery = new ExamResultQuery();
        examResultQuery.setArrangeIds(arrangeIds);
        examResultQuery.setStudentId(userId);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserSubmittedArrangeIds", (Object)examResultQuery);
    }

    @Override
    public List<ExamArrangeMiniVO> getUserPassedArrangeMiniVOs(Long userId, List<Long> arrangeIds) {
        ExamResultQuery examResultQuery = new ExamResultQuery();
        examResultQuery.setArrangeIds(arrangeIds);
        examResultQuery.setStudentId(userId);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getUserPassedArrangeMiniVOs", (Object)examResultQuery);
    }

    @Override
    public ExamResultStatisticVO getExamResultStatistic(ExamResultQuery examResultQuery) {
        List list = this.getSqlSessionTemplate().selectList(this.getNamespace() + ".getExamResultStatistic", (Object)examResultQuery);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return (ExamResultStatisticVO)list.get(0);
    }

    @Override
    public List<ExamResultVO> findVOList_attendNum(ExamResultQuery query) {
        List vos = this.findList(query, "findVOList_attendNum", ExamResultVO.class);
        return vos;
    }

    @Override
    public List<ExamResultVO> findVOList_maxMinAvgMark(ExamResultQuery query) {
        List vos = this.findList(query, "findVOList_maxMinAvgMark", ExamResultVO.class);
        return vos;
    }

    @Override
    public int resetSelectstatus(Long arrangeId, Long userId, Long resultIdOfSelect) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("userId", userId);
        map.put("resultIdOfSelect", resultIdOfSelect);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".resetSelectstatus", map);
    }

    @Override
    public int setSelectstatus(Long arrangeId, Long userId, Long resultIdOfSelect) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("userId", userId);
        map.put("resultIdOfSelect", resultIdOfSelect);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".setSelectstatus", map);
    }

    @Override
    public List<ExamArrangeNumVO> groupByArrangeIds(List<Long> arrangeIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("arrangeIds", arrangeIds);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".groupByArrangeIds", map);
    }
}

