/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examresult.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DBFunction;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examresult.bo.ExamResultQueryBO;
import com.peak.prd.appsecurity.org.util.OrgUtil;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.enums.ExamPassStatusEnum;
import com.peak.prd.enums.ExamSeriesTypeEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeMiniVO;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.exammonitor.model.ExamMonitor;
import com.peak.prd.exam.exammonitor.service.IExamMonitorCheatPlusService;
import com.peak.prd.exam.exammonitor.service.IExamMonitorPlusService;
import com.peak.prd.exam.exammonitor.vo.ExamMonitorCheatVO;
import com.peak.prd.exam.examresult.bo.PassUserQueryBO;
import com.peak.prd.exam.examresult.dao.IExamResultPlusDao;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.examresult.vo.ExamResultByArrangemarkVO;
import com.peak.prd.exam.examresult.vo.ExamResultCleanLastVO;
import com.peak.prd.exam.examresult.vo.ExamResultPassNumVO;
import com.peak.prd.exam.examresult.vo.ExamResultQuery;
import com.peak.prd.exam.examresult.vo.ExamResultScoreRangeVO;
import com.peak.prd.exam.examresult.vo.ExamResultStatisticVO;
import com.peak.prd.exam.examresult.vo.ExamResultVO;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPlusService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExamResultPlusService
extends PrdBaseService<ExamResult, Long, ExamResultQuery>
implements IExamResultPlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamResultPlusService.class);
    @Autowired
    private PrdExamConfig prdExamConfig;
    private IExamResultPlusDao examResultPlusDao;

    public void setExamResultPlusDao(IExamResultPlusDao dao) {
        this.examResultPlusDao = dao;
    }

    public IExamResultPlusDao getExamResultPlusDao() {
        return this.examResultPlusDao;
    }

    public IEntityDao<ExamResult, Long, ExamResultQuery> getEntityDao() {
        return this.examResultPlusDao;
    }

    @Override
    public List<ExamResult> getUserExamResultList(Long userId, List<Long> arrangeIds) {
        return this.getUserExamResultList(userId, arrangeIds, true);
    }

    @Override
    public List<ExamResult> getUserExamResultList(Long userId, List<Long> arrangeIds, boolean isQueryExamCount) {
        if (userId == null || arrangeIds == null || arrangeIds.isEmpty()) {
            return null;
        }
        ExamResultQuery query = new ExamResultQuery();
        query.setSelectstatus(1L);
        query.setStudentId(userId);
        query.setArrangeIds(arrangeIds);
        if (isQueryExamCount) {
            query.setExamcount(1);
        }
        return this.examResultPlusDao.findAll(query, "getUserExamResultList");
    }

    @Override
    public List<ExamResult> getUserExamSubmittedResultList(Long userId, Long arrangeId, int pageNumber, int pageSize) {
        return this.getUserExamResultList(userId, arrangeId, true, pageNumber, pageSize);
    }

    @Override
    public List<ExamResultByArrangemarkVO> getExamResultByArrangemarkVOs(Long userId, Long arrangeId, int pageNumber, int pageSize) {
        List<ExamResult> results = this.getUserExamResultList(userId, arrangeId, null, pageNumber, pageSize);
        return ConvertUtil.convert(results, ExamResultByArrangemarkVO.class);
    }

    private List<ExamResult> getUserExamResultList(Long userId, Long arrangeId, Boolean submitted, int pageNumber, int pageSize) {
        if (userId == null || arrangeId == null) {
            return null;
        }
        ExamResultQuery query = new ExamResultQuery(pageNumber, pageSize);
        query.setStudentId(userId);
        query.setArrangeId(arrangeId);
        if (submitted != null) {
            query.setSubmitted(submitted);
        }
        if (this.prdExamConfig.getLoadrunner() == 0) {
            query.getPage().setSortColumns("createdate desc");
        }
        return this.examResultPlusDao.findList(query);
    }

    @Override
    public int getUserExamSubmittedResultCount(Long userId, Long arrangeId) {
        if (userId == null || arrangeId == null) {
            return 0;
        }
        ExamResultQuery query = new ExamResultQuery();
        query.setStudentId(userId);
        query.setArrangeId(arrangeId);
        query.setSubmitted(true);
        return (int)this.examResultPlusDao.count(query);
    }

    @Override
    public long findVOCount(ExamResultQueryBO bo) {
        ExamArrange examArrange;
        if (bo.getArrangeId() == null && CollectionUtils.isEmpty(bo.getArrangeIds()) && bo.getHasCheat() == null) {
            return 0L;
        }
        if (bo.getBranchDomainId() != null && ((examArrange = (ExamArrange)((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).getById(bo.getArrangeId())) == null || examArrange.getWhatseemark2() == null || examArrange.getWhatseemark2() == 0)) {
            return 0L;
        }
        ExamResultQuery query = this._getQuery(bo);
        return this.examResultPlusDao.findVOCount(query);
    }

    @Override
    public List<ExamResultVO> findVOList(ExamResultQueryBO bo) {
        String sortColumns = "resultId";
        sortColumns = this.prdExamConfig.getResultListMode() == 1 ? (DBFunction.isOracle() ? "eu.arrangeId, r.submitdate desc nulls last, r.enterdate desc nulls last, eu.userId" : "eu.arrangeId, eu.userId, r.submitdate desc") : "eu.arrangeId, r.enterdate desc, r.resultid";
        if (log.isDebugEnabled()) {
            log.debug("sort: " + sortColumns);
        }
        return this.findVOList(bo, sortColumns);
    }

    @Override
    public List<ExamResultVO> findVOList(ExamResultQueryBO bo, String sortColumns) {
        if (bo.getArrangeId() == null && CollectionUtils.isEmpty(bo.getArrangeIds()) && bo.getHasCheat() == null) {
            return null;
        }
        Map<Long, boolean[]> branchSeeWhat = bo.getBranchDomainId() != null ? this.getBranchSeeWhat(bo) : null;
        ExamResultQuery query = this._getQuery(bo);
        query.getPage().setSortColumns(sortColumns);
        List<ExamResultVO> vos = this.examResultPlusDao.findList(query, "findVOList", ExamResultVO.class);
        vos = this.doSubQuery(vos, query);
        vos = this.setExtendProperties(vos);
        if (bo.getBranchDomainId() != null && !CollectionUtils.isEmpty(vos) && branchSeeWhat != null) {
            for (ExamResultVO vo : vos) {
                boolean canBranchSeeMark;
                boolean[] canSeeWhat = branchSeeWhat.get(vo.getArrangeId());
                boolean canBranchSeePass = canSeeWhat == null ? false : canSeeWhat[0];
                boolean bl = canBranchSeeMark = canSeeWhat == null ? false : canSeeWhat[1];
                if (!canBranchSeePass) {
                    vo.setPassInteger(null);
                }
                if (canBranchSeeMark) continue;
                vo.setArrangemark(null);
                vo.setMark(null);
                vo.setObjectivescore(null);
                vo.setMaxMark(null);
                vo.setMinMark(null);
                vo.setAvgMark(null);
            }
        }
        return vos;
    }

    private Map<Long, boolean[]> getBranchSeeWhat(ExamResultQueryBO bo) {
        HashMap<Long, boolean[]> map = new HashMap<Long, boolean[]>();
        if (bo.getArrangeId() == null && CollectionUtils.isEmpty(bo.getArrangeIds())) {
            return map;
        }
        IExamArrangePlusService examArrangePlusService = (IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class);
        ArrayList<Long> arrangeIds = new ArrayList<Long>();
        if (bo.getArrangeId() != null) {
            arrangeIds.add(bo.getArrangeId());
        }
        if (!ListUtil.isNullorEmpty(bo.getArrangeIds())) {
            arrangeIds.addAll(bo.getArrangeIds());
        }
        for (int i = 0; i < arrangeIds.size(); ++i) {
            Long examId = (Long)arrangeIds.get(i);
            boolean canBranchSeePass = false;
            boolean canBranchSeeMark = false;
            ExamArrange examArrange = (ExamArrange)examArrangePlusService.getById(examId);
            if (examArrange != null && examArrange.getWhatseemark2() != null && examArrange.getWhatseemark2() != 0) {
                canBranchSeePass = (examArrange.getWhatseemark2() & 1) != 0;
                canBranchSeeMark = (examArrange.getWhatseemark2() & 2) != 0;
            }
            map.put(examId, new boolean[]{canBranchSeePass, canBranchSeeMark});
        }
        return map;
    }

    private List<ExamResultVO> doSubQuery(List<ExamResultVO> vos, ExamResultQuery query) {
        ExamResultVO subVO;
        Map mapSubVO;
        List<ExamResultVO> voList_maxMinAvgMark;
        if (CollectionUtils.isEmpty(vos)) {
            return vos;
        }
        ExamResultQuery subQuery = new ExamResultQuery(1, Integer.MAX_VALUE);
        subQuery.setExamId(query.getExamId());
        subQuery.setExamIds(query.getExamIds());
        subQuery.setUserIds(IdUtil.getIds(vos, e -> e.getUserId()));
        boolean isScopeAll = query.getScope() != null && query.getScope().intValue() == ExamResultQueryBO.SCOPE_ALL.intValue();
        List<ExamResultVO> voList_attendNum = isScopeAll ? null : this.examResultPlusDao.findVOList_attendNum(subQuery);
        List<ExamResultVO> list = voList_maxMinAvgMark = isScopeAll ? null : this.examResultPlusDao.findVOList_maxMinAvgMark(subQuery);
        if (!CollectionUtils.isEmpty(voList_attendNum)) {
            mapSubVO = ConvertUtil.listToMap(voList_attendNum, e -> e.getUserId());
            Iterator<ExamResultVO> iterator = vos.iterator();
            while (iterator.hasNext()) {
                ExamResultVO vo;
                subVO = (ExamResultVO)mapSubVO.get((vo = iterator.next()).getUserId());
                vo.setAttendNum(subVO == null ? Integer.valueOf(0) : subVO.getAttendNum());
            }
        }
        if (!CollectionUtils.isEmpty(voList_maxMinAvgMark)) {
            mapSubVO = ConvertUtil.listToMap(voList_maxMinAvgMark, e -> e.getUserId());
            for (ExamResultVO vo : vos) {
                subVO = (ExamResultVO)mapSubVO.get(vo.getUserId());
                if (subVO == null) continue;
                vo.setMaxMark(this.formatMark(subVO.getMaxMark()));
                vo.setMinMark(this.formatMark(subVO.getMinMark()));
                vo.setAvgMark(this.formatMark(subVO.getAvgMark()));
            }
        }
        return vos;
    }

    private Double formatMark(Double mark) {
        if (mark == null) {
            return null;
        }
        long round = Math.round(mark * 100.0);
        return (double)round / 100.0;
    }

    private boolean isSeriesAndUnifyExam(Long examId) {
        return ((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).isSeriesAndUnifyExam(examId);
    }

    private Long getParentSeriesAndUnifyExam(Long phaseexamId) {
        if (phaseexamId == null) {
            return null;
        }
        ExamArrange examArrange = (ExamArrange)((IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class)).getById(phaseexamId);
        if (examArrange == null || examArrange.getExamseriestype() == null || examArrange.getExamseriestype().intValue() != ExamSeriesTypeEnum.TYPE_PHASEEXAM.getValue()) {
            return null;
        }
        Long seriesId = ((IExamSeriesPhasePlusService)SpringUtil.getBean(IExamSeriesPhasePlusService.class)).getSeriesIdByPhasecontentId(phaseexamId);
        return this.isSeriesAndUnifyExam(seriesId) ? seriesId : null;
    }

    private ExamResultQuery _getQuery(ExamResultQueryBO bo) {
        ExamResultQuery query = new ExamResultQuery(bo.getPageNumber(), bo.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)bo), (Object)query);
        query.setResultListMode(bo.getResultListMode() != null ? bo.getResultListMode().intValue() : this.prdExamConfig.getResultListMode());
        query.setExamId(query.getArrangeId());
        query.setArrangeId(null);
        query.setExamIds(query.getArrangeIds());
        query.setArrangeIds(null);
        Long idOfParentSeriesAndUnifyExam = this.getParentSeriesAndUnifyExam(query.getExamId());
        if (idOfParentSeriesAndUnifyExam != null) {
            query.setArrangeId(null);
            query.setArrangeIds(null);
            query.setExamIds(Arrays.asList(query.getExamId()));
            query.setExamId(null);
            query.setUnifySeriesId(idOfParentSeriesAndUnifyExam);
            return query;
        }
        IExamSeriesPlusService examSeriesPlusService = (IExamSeriesPlusService)SpringUtil.getBean(IExamSeriesPlusService.class);
        List<Long> allPhaseContentIds = examSeriesPlusService.getAllPhaseContentIds(bo.getArrangeId());
        if (!CollectionUtils.isEmpty(allPhaseContentIds)) {
            query.setArrangeId(null);
            query.setArrangeIds(null);
            query.setExamId(null);
            query.setExamIds(allPhaseContentIds);
            if (this.isSeriesAndUnifyExam(bo.getArrangeId())) {
                query.setUnifySeriesId(bo.getArrangeId());
            }
        }
        return query;
    }

    @Override
    public Paging<ExamResultVO> findVOPaging(ExamResultQueryBO bo) {
        long totalCount = this.findVOCount(bo);
        List<ExamResultVO> list = this.findVOList(bo);
        Paging paging = new Paging(bo.getPageNumber(), bo.getPageSize());
        paging.setTotalCount(totalCount);
        paging.setList(list);
        return paging;
    }

    @Override
    public ExamResultPassNumVO getPassPercent(Long arrangeId, Double passmark) {
        return this.examResultPlusDao.getPassPercent(arrangeId, passmark);
    }

    @Override
    public List<ExamResultScoreRangeVO> getExamResultScoreRangeVOs(Long arrangeId, Long domainIdByScoreRange) {
        return this.examResultPlusDao.getExamResultScoreRangeVOs(arrangeId, domainIdByScoreRange);
    }

    @Override
    public void updateFinalMark(Long arrangeId, Long userId, Double dFinalMark, Long resultIdOfSelect) {
        boolean isMysql = DBFunction.isMysql();
        this.examResultPlusDao.updateFinalMark(arrangeId, userId, dFinalMark, isMysql ? null : resultIdOfSelect);
        if (isMysql) {
            ((ExamResultPlusService)SpringUtil.getBean((String)"examResultPlusService")).doSelectStatus(arrangeId, userId, resultIdOfSelect);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void doSelectStatus(Long arrangeId, Long userId, Long resultIdOfSelect) {
        if (arrangeId == null || userId == null || resultIdOfSelect == null) {
            return;
        }
        this.examResultPlusDao.resetSelectstatus(arrangeId, userId, resultIdOfSelect);
        this.examResultPlusDao.setSelectstatus(arrangeId, userId, resultIdOfSelect);
    }

    @Override
    public List<Long> getUserSubmittedArrangeIds(Long userId, List<Long> arrangeIds) {
        if (userId == null || CollectionUtils.isEmpty(arrangeIds)) {
            return null;
        }
        return this.examResultPlusDao.getUserSubmittedArrangeIds(userId, arrangeIds);
    }

    @Override
    public List<ExamArrangeMiniVO> getUserPassedArrangeMiniVOs(Long userId, List<Long> arrangeIds) {
        if (userId == null || CollectionUtils.isEmpty(arrangeIds)) {
            return null;
        }
        return this.examResultPlusDao.getUserPassedArrangeMiniVOs(userId, arrangeIds);
    }

    @Override
    public ExamResultStatisticVO getExamResultStatistic(ExamResultQuery examResultQuery) {
        if (examResultQuery == null || examResultQuery.getArrangeId() == null) {
            return null;
        }
        return this.examResultPlusDao.getExamResultStatistic(examResultQuery);
    }

    @Override
    public long getAttendUserCountByAnyExam(PassUserQueryBO passUserQueryBO) {
        if (CollectionUtils.isEmpty(passUserQueryBO.getArrangeIds())) {
            return 0L;
        }
        ExamResultQuery query = (ExamResultQuery)ConvertUtil.convert((Object)((Object)passUserQueryBO), ExamResultQuery.class);
        return Long.parseLong(this.examResultPlusDao.selectOne(query, "getAttendUserIdsByAnyExam.count").toString());
    }

    @Override
    public long getPassUserCountByAnyExam(PassUserQueryBO passUserQueryBO) {
        if (CollectionUtils.isEmpty(passUserQueryBO.getArrangeIds())) {
            return 0L;
        }
        ExamResultQuery query = (ExamResultQuery)ConvertUtil.convert((Object)((Object)passUserQueryBO), ExamResultQuery.class);
        return Long.parseLong(this.examResultPlusDao.selectOne(query, "getPassUserIdsByAnyExam.count").toString());
    }

    @Override
    public Paging<Long> getPassUserIdsByAnyExam(PassUserQueryBO passUserQueryBO) {
        if (CollectionUtils.isEmpty(passUserQueryBO.getArrangeIds())) {
            return null;
        }
        ExamResultQuery query = (ExamResultQuery)ConvertUtil.convert((Object)((Object)passUserQueryBO), ExamResultQuery.class);
        long count = Long.parseLong(this.examResultPlusDao.selectOne(query, "getPassUserIdsByAnyExam.count").toString());
        List userIds = this.examResultPlusDao.findList(query, "getPassUserIdsByAnyExam", Long.class);
        Paging paging = new Paging(passUserQueryBO.getPageNumber(), passUserQueryBO.getPageSize());
        paging.setTotalCount(count);
        paging.setList(userIds);
        return paging;
    }

    @Override
    public Paging<Long> getPassUserIdsByAllExam(PassUserQueryBO passUserQueryBO) {
        if (CollectionUtils.isEmpty(passUserQueryBO.getArrangeIds())) {
            return null;
        }
        ExamResultQuery query = (ExamResultQuery)ConvertUtil.convert((Object)((Object)passUserQueryBO), ExamResultQuery.class);
        long count = Long.parseLong(this.examResultPlusDao.selectOne(query, "getPassUserIdsByAllExam.count").toString());
        List userIds = this.examResultPlusDao.findList(query, "getPassUserIdsByAllExam", Long.class);
        Paging paging = new Paging(passUserQueryBO.getPageNumber(), passUserQueryBO.getPageSize());
        paging.setTotalCount(count);
        paging.setList(userIds);
        return paging;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExamResultCleanLastVO cleanLastExamResult(Long arrangeId, Long studentId, Long operatorId) {
        if (arrangeId == null || studentId == null || operatorId == null) {
            return null;
        }
        log.info("cleanLastExamResult[arrangeId:{}, studentId:{}, operatorId:{}] start", new Object[]{arrangeId, studentId, operatorId});
        ExamResultQuery examResultQuery = new ExamResultQuery();
        examResultQuery.setArrangeId(arrangeId);
        examResultQuery.setStudentId(studentId);
        examResultQuery.getPage().setSortColumns("examcount desc");
        List examResults = this.examResultPlusDao.findAll(examResultQuery);
        if (ListUtil.isNullorEmpty((List)examResults)) {
            log.info("cleanLastExamResult finish by emtpy");
            return null;
        }
        ExamResultCleanLastVO ret = new ExamResultCleanLastVO();
        ExamResult lastOne = (ExamResult)examResults.get(0);
        ((IExamMonitorPlusService)SpringUtil.getBean(IExamMonitorPlusService.class)).deleteById(lastOne.getResultId());
        this.examResultPlusDao.deleteById(lastOne.getResultId());
        ret.setCleanResultId(lastOne.getResultId());
        if (examResults.size() > 1) {
            ExamResult focusOne = this.getBySelectstatus(examResults);
            if (focusOne == null || focusOne.getResultId().equals(lastOne.getResultId())) {
                focusOne = (ExamResult)examResults.get(1);
                ExamResult tmp = new ExamResult(focusOne.getResultId());
                tmp.setSelectstatus(1L);
                this.examResultPlusDao.updateSelective(tmp);
            }
            ret.setSelectResultId(focusOne.getResultId());
        }
        log.info("cleanLastExamResult finish [{}, {}]", (Object)ret.getCleanResultId(), (Object)ret.getSelectResultId());
        return ret;
    }

    @Override
    public List<ExamResult> findList(ExamResultQuery examResultQuery) {
        return this.examResultPlusDao.findList(examResultQuery);
    }

    @Override
    public List<ExamArrangeNumVO> groupByArrangeIds(List<Long> arrangeIds) {
        if (CollectionUtils.isEmpty(arrangeIds)) {
            return null;
        }
        return this.examResultPlusDao.groupByArrangeIds(arrangeIds);
    }

    @Override
    public long countByExamId(Long examId) {
        if (examId == null) {
            return 0L;
        }
        ExamResultQuery examResultQuery = new ExamResultQuery();
        examResultQuery.setArrangeId(examId);
        return this.examResultPlusDao.count(examResultQuery);
    }

    private ExamResult getBySelectstatus(List<ExamResult> examResults) {
        for (ExamResult result : examResults) {
            if (result.getSelectstatus() == null || result.getSelectstatus() != 1L) continue;
            return result;
        }
        return null;
    }

    private List<ExamResultVO> setExtendProperties(List<ExamResultVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            return vos;
        }
        UserCoreUtil.setUserDeptId(vos, ExamResultByArrangemarkVO::getUserId, ExamResultVO::setOrgId);
        OrgUtil.setOrgFullname(vos, ExamResultVO::getOrgId, ExamResultVO::setOrgFullname);
        for (int i = 0; i < vos.size(); ++i) {
            if (vos.get(i).getMark() == null || vos.get(i).getPassmark() == null) continue;
            vos.get(i).setPassInteger(vos.get(i).getMark() >= vos.get(i).getPassmark() ? ExamPassStatusEnum.PASS_YES.getValue() : ExamPassStatusEnum.PASS_NOT.getValue());
        }
        List resultIds = IdUtil.getIds(vos, e -> e.getResultId());
        IExamMonitorPlusService examMonitorPlusService = (IExamMonitorPlusService)SpringUtil.getBean(IExamMonitorPlusService.class);
        List examMonitors = examMonitorPlusService.getByIds(resultIds);
        if (!CollectionUtils.isEmpty((Collection)examMonitors)) {
            Map monitorMap = ConvertUtil.listToMap((List)examMonitors, e -> e.getResultId());
            for (ExamResultVO vo : vos) {
                ExamMonitor m = (ExamMonitor)monitorMap.get(vo.getResultId());
                if (m == null || m.getCheatcount() == null || m.getCheatcount() <= 0) continue;
                vo.setCheat(true);
            }
        }
        if ("huaxia".equals(this.prdExamConfig.getPrj())) {
            for (int i = 0; i < vos.size(); ++i) {
                String orgFullname = vos.get(i).getOrgFullname();
                if (orgFullname == null || !orgFullname.startsWith("\u6839\u673a\u6784 / ")) continue;
                vos.get(i).setOrgFullname(orgFullname.substring("\u6839\u673a\u6784 / ".length()));
            }
        }
        if ("huaxia".equals(this.prdExamConfig.getPrj())) {
            IExamMonitorCheatPlusService examMonitorCheatPlusService = (IExamMonitorCheatPlusService)SpringUtil.getBean(IExamMonitorCheatPlusService.class);
            List<ExamMonitorCheatVO> cheatVOs = examMonitorCheatPlusService.groupByArrangeUsers(vos.get(0).getArrangeId(), IdUtil.getIds(vos, v -> v.getUserId()));
            Map cheatVOMap = ConvertUtil.listToMap(cheatVOs, v -> v.getArrangeId() + ":" + v.getStudentId());
            for (int i = 0; i < vos.size() && cheatVOMap != null; ++i) {
                ExamResultVO examResultVO = vos.get(i);
                String mapKey = examResultVO.getArrangeId() + ":" + examResultVO.getUserId();
                ExamMonitorCheatVO cheat = (ExamMonitorCheatVO)cheatVOMap.get(mapKey);
                if (cheat != null && cheat.getCheatNum() != null && cheat.getCheatNum() > 0) {
                    examResultVO.setCheat(true);
                    examResultVO.setCheatNum(cheat.getCheatNum());
                    continue;
                }
                examResultVO.setCheat(false);
            }
        }
        return vos;
    }
}

