/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examresult.util;

import com.peak.common.util.ConvertUtil;
import com.peak.prd.enums.ExamMethodEnum;
import com.peak.prd.enums.ExamPassStatusEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.util.ExamArrangeUtil;
import com.peak.prd.exam.examresult.model.ExamResult;
import com.peak.prd.exam.examresult.vo.ExamResultVO;

public class ExamResultUtil {
    public static ExamResultVO narrow(ExamResult examResultModel, ExamArrange examArrange) {
        ExamResultVO examResultVO = (ExamResultVO)ConvertUtil.convert((Object)examResultModel, ExamResultVO.class);
        if (examResultVO == null || examArrange == null) {
            return examResultVO;
        }
        boolean isOffline = examArrange.getExammethod() != null && examArrange.getExammethod().intValue() == ExamMethodEnum.METHOD_OFFLINE.getValue();
        boolean published = ExamArrangeUtil.isResultPublished(examArrange);
        boolean canSeeMark = ExamArrangeUtil.canSeeMark(examArrange);
        boolean canSeePass = ExamArrangeUtil.canSeePass(examArrange);
        boolean canSeeReview = ExamArrangeUtil.canSeeReview(examArrange);
        examResultVO.setMark(null);
        examResultVO.setPassInteger(null);
        examResultVO.setCanSeeReview(false);
        if (!published) {
            return ExamResultUtil._narrow(examResultVO, canSeeMark);
        }
        if (isOffline) {
            if (canSeeMark) {
                examResultVO.setMark(examResultModel.getOperatmark());
            }
            if (canSeePass && examArrange.getPassmark() != null && examResultModel.getOperatmark() != null) {
                examResultVO.setPassInteger(examResultModel.getOperatmark() >= (double)examArrange.getPassmark().intValue() ? ExamPassStatusEnum.PASS_YES.getValue() : ExamPassStatusEnum.PASS_NOT.getValue());
            }
        } else {
            if (canSeeMark) {
                examResultVO.setMark(examResultModel.getArrangemark());
            }
            if (canSeePass && examArrange.getPassmark() != null) {
                if (examResultModel.getArrangemark() != null) {
                    examResultVO.setPassInteger(examResultModel.getArrangemark() >= (double)examArrange.getPassmark().intValue() ? ExamPassStatusEnum.PASS_YES.getValue() : ExamPassStatusEnum.PASS_NOT.getValue());
                } else if (examResultVO.getObjectivescore() != null) {
                    examResultVO.setPassInteger(ExamPassStatusEnum.PASS_WAIT_SUBJECT.getValue());
                }
            }
            examResultVO.setCanSeeReview(canSeeReview);
            if (canSeeReview && "6".equals(examResultModel.getHistorymark())) {
                examResultVO.setCanSeeReview(false);
            }
        }
        return ExamResultUtil._narrow(examResultVO, canSeeMark);
    }

    private static ExamResultVO _narrow(ExamResultVO examResultVO, boolean canSeeMark) {
        if (!canSeeMark) {
            examResultVO.setMark(null);
            examResultVO.setArrangemark(null);
            examResultVO.setObjectivescore(null);
        }
        return examResultVO;
    }

    public static int getSubjectreplystatus(boolean hasFillQues, boolean hasTextQues) {
        int status = 0;
        if (hasFillQues) {
            ++status;
        }
        if (hasTextQues) {
            status += 2;
        }
        return status;
    }
}

