/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examseries.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examseries.bo.ExamSeriesPhaseBO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examresult.service.IExamResultPlusService;
import com.peak.prd.exam.examseries.dao.IExamSeriesPhasePlusDao;
import com.peak.prd.exam.examseries.model.ExamSeriesPhase;
import com.peak.prd.exam.examseries.model.ExamSeriesPhasecontent;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasecontentPlusService;
import com.peak.prd.exam.examseries.service.imple.ExamSeriesPlusService;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseByUserVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseMngVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseQuery;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseStuVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentByUserVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentMiniVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentQuery;
import com.peak.prd.exam.examseries.vo.ExamSeriesStuVO;
import com.peak.prd.exam.examuser.service.IExamUserPlusService;
import com.peak.prd.exam.examuser.vo.ExamUserQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CacheConfig(cacheNames={"exam"})
public class ExamSeriesPhasePlusService
extends PrdBaseService<ExamSeriesPhase, Long, ExamSeriesPhaseQuery>
implements IExamSeriesPhasePlusService {
    @Autowired
    private IExamArrangePlusService examArrangePlusService;
    @Autowired
    private IExamResultPlusService examResultPlusService;
    @Autowired
    private IExamSeriesPhasecontentPlusService examSeriesPhasecontentPlusService;
    @Autowired
    private IExamUserPlusService examUserPlusService;
    private IExamSeriesPhasePlusDao examSeriesPhasePlusDao;

    public void setExamSeriesPhasePlusDao(IExamSeriesPhasePlusDao dao) {
        this.examSeriesPhasePlusDao = dao;
    }

    public IExamSeriesPhasePlusDao getExamSeriesPhasePlusDao() {
        return this.examSeriesPhasePlusDao;
    }

    public IEntityDao<ExamSeriesPhase, Long, ExamSeriesPhaseQuery> getEntityDao() {
        return this.examSeriesPhasePlusDao;
    }

    @Override
    public List<ExamSeriesPhaseMngVO> findMngVOList(Long seriesId) {
        if (seriesId == null) {
            return null;
        }
        ExamSeriesPhaseQuery query = new ExamSeriesPhaseQuery();
        query.setSeriesId(seriesId);
        query.setDeleted(0);
        query.getPage().setSortColumns("ordernum, createdate");
        List models = this.examSeriesPhasePlusDao.findAll(query);
        if (this.correctOrderNum(models)) {
            models = this.examSeriesPhasePlusDao.findAll(query);
        }
        List vos = ConvertUtil.convert((List)models, ExamSeriesPhaseMngVO.class);
        return vos;
    }

    @Override
    public Long insert(ExamSeriesPhaseBO examSeriesPhaseBO, Long currUserId, Long domainId) {
        ExamSeriesPhase model = (ExamSeriesPhase)ConvertUtil.convert((Object)examSeriesPhaseBO, ExamSeriesPhase.class);
        model.setPhaseId(IdUtil.getSequence((String)"EXAM_SERIES_PHASE"));
        model.setCreateId(currUserId);
        model.setCreatedate(new Date());
        model.setDeleted(0);
        model.setOrdernum(this.getNextOrdernum(examSeriesPhaseBO.getSeriesId()));
        this.examSeriesPhasePlusDao.insert((BaseEntity)model);
        return model.getPhaseId();
    }

    @Override
    public void update(ExamSeriesPhaseBO examSeriesPhaseBO, Long currUserId, Long domainId) {
        ExamSeriesPhase model = (ExamSeriesPhase)ConvertUtil.convert((Object)examSeriesPhaseBO, ExamSeriesPhase.class);
        this.examSeriesPhasePlusDao.updateSelective(model);
    }

    @Override
    public void delete(Long phaseId, Long currUserId) {
        ExamSeriesPhase model = new ExamSeriesPhase(phaseId);
        model.setDeleted(1);
        model.setDeleteId(currUserId);
        model.setDeletedate(new Date());
        this.examSeriesPhasePlusDao.updateSelective(model);
    }

    @Override
    public ExamArrange getParentExam(Long phaseId) {
        ExamSeriesPhase phase = (ExamSeriesPhase)this.getById(phaseId);
        if (phase == null) {
            return null;
        }
        Long arrangeId = phase.getSeriesId();
        return (ExamArrange)this.examArrangePlusService.getById(arrangeId);
    }

    @Override
    @Cacheable
    public List<ExamSeriesPhaseStuVO> getPhaseStuVOs(Long seriesId) {
        return this.loadPhaseStuVOs(seriesId);
    }

    @Override
    public List<ExamSeriesPhaseStuVO> loadPhaseStuVOs(Long seriesId) {
        if (seriesId == null) {
            return null;
        }
        ExamSeriesPhaseQuery query = new ExamSeriesPhaseQuery();
        query.setSeriesId(seriesId);
        query.setDeleted(0);
        query.getPage().setSortColumns("ordernum, createdate");
        List models = this.examSeriesPhasePlusDao.findAll(query);
        List vos = ConvertUtil.convert((List)models, ExamSeriesPhaseStuVO.class);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return null;
        }
        List<ExamSeriesPhasecontentMiniVO> contents = this.examSeriesPhasecontentPlusService.getPhasecontentMiniVOs(IdUtil.getIds((List)vos, e -> e.getPhaseId()));
        for (int i = 0; i < vos.size(); ++i) {
            ArrayList<ExamSeriesPhasecontentMiniVO> children = new ArrayList<ExamSeriesPhasecontentMiniVO>();
            for (int j = 0; contents != null && j < contents.size(); ++j) {
                ExamSeriesPhasecontentMiniVO contentMiniVO = contents.get(j);
                if (!((ExamSeriesPhaseStuVO)vos.get(i)).getPhaseId().equals(contentMiniVO.getPhaseId())) continue;
                children.add(contentMiniVO);
            }
            ((ExamSeriesPhaseStuVO)vos.get(i)).setContents(children);
        }
        return vos;
    }

    @Override
    public List<ExamSeriesPhaseByUserVO> getPhaseByUserVOs(Long seriesId, Long studentId) {
        List<Long> completedExamIds;
        if (seriesId == null || studentId == null) {
            return null;
        }
        ExamSeriesStuVO examSeriesStuVO = ((ExamSeriesPlusService)SpringUtil.getBean(ExamSeriesPlusService.class)).getExamSeriesStuVO(seriesId);
        List<ExamSeriesPhaseStuVO> stuVOs = ((ExamSeriesPhasePlusService)SpringUtil.getBean(ExamSeriesPhasePlusService.class)).getPhaseStuVOs(seriesId);
        if (stuVOs == null || stuVOs.isEmpty()) {
            return null;
        }
        ArrayList<ExamSeriesPhaseByUserVO> vos = new ArrayList<ExamSeriesPhaseByUserVO>();
        for (int i = 0; i < stuVOs.size(); ++i) {
            ExamSeriesPhaseByUserVO vo = new ExamSeriesPhaseByUserVO(stuVOs.get(i));
            vos.add(vo);
        }
        if (examSeriesStuVO.getIndependuserBool()) {
            ExamUserQuery examUserQuery = new ExamUserQuery();
            examUserQuery.setUserId(studentId);
            examUserQuery.setArrangeIds(ExamSeriesPhaseByUserVO.getAllContentIds(vos));
            List examUsers = this.examUserPlusService.findAll(examUserQuery);
            List myExamIds = IdUtil.getIds((List)examUsers, e -> e.getArrangeId());
            if (CollectionUtils.isEmpty((Collection)myExamIds)) {
                return null;
            }
            HashSet myExamSet = new HashSet(myExamIds);
            for (int i = vos.size() - 1; i >= 0; --i) {
                List<ExamSeriesPhasecontentByUserVO> contents = ((ExamSeriesPhaseByUserVO)vos.get(i)).getContents();
                if (CollectionUtils.isEmpty(contents)) {
                    vos.remove(i);
                    continue;
                }
                for (int j = contents.size() - 1; j >= 0; --j) {
                    boolean contain = myExamSet.contains(contents.get(j).getContentId());
                    if (contain) continue;
                    contents.remove(j);
                }
                if (!CollectionUtils.isEmpty(contents)) continue;
                vos.remove(i);
            }
        }
        if (!CollectionUtils.isEmpty(completedExamIds = this.examResultPlusService.getUserSubmittedArrangeIds(studentId, ExamSeriesPhaseByUserVO.getAllContentIds(vos)))) {
            HashSet<Long> completedExamSet = new HashSet<Long>(completedExamIds);
            for (int i = 0; i < vos.size(); ++i) {
                List<ExamSeriesPhasecontentByUserVO> contents = ((ExamSeriesPhaseByUserVO)vos.get(i)).getContents();
                for (int j = 0; contents != null && j < contents.size(); ++j) {
                    ExamSeriesPhasecontentByUserVO content;
                    content.setCompleted(completedExamSet.contains((content = contents.get(j)).getContentId()) ? 1 : 0);
                }
            }
        }
        return vos;
    }

    @Override
    @Cacheable
    public Long getSeriesIdByPhasecontentId(Long contentId) {
        if (contentId == null) {
            return null;
        }
        ExamSeriesPhasecontentQuery examSeriesPhasecontentQuery = new ExamSeriesPhasecontentQuery();
        examSeriesPhasecontentQuery.setContentId(contentId);
        ExamSeriesPhasecontent content = (ExamSeriesPhasecontent)this.examSeriesPhasecontentPlusService.getPrdEntityDao().findOne((IQuery)examSeriesPhasecontentQuery);
        if (content == null) {
            return null;
        }
        ExamSeriesPhase phase = (ExamSeriesPhase)this.getById(content.getPhaseId());
        if (phase == null) {
            return null;
        }
        return phase.getSeriesId();
    }

    @Override
    @Cacheable
    public Long getPhaseIdByPhasecontentId(Long contentId) {
        if (contentId == null) {
            return null;
        }
        ExamSeriesPhasecontentQuery examSeriesPhasecontentQuery = new ExamSeriesPhasecontentQuery();
        examSeriesPhasecontentQuery.setContentId(contentId);
        ExamSeriesPhasecontent content = (ExamSeriesPhasecontent)this.examSeriesPhasecontentPlusService.getPrdEntityDao().findOne((IQuery)examSeriesPhasecontentQuery);
        if (content == null) {
            return null;
        }
        return content.getPhaseId();
    }

    @Override
    public boolean moveUpDown(ExamSeriesPhase phase, boolean isMoveUp) {
        if (phase == null || phase.getSeriesId() == null) {
            return false;
        }
        ExamSeriesPhaseQuery query = new ExamSeriesPhaseQuery();
        query.setSeriesId(phase.getSeriesId());
        query.getPage().setSortColumns(isMoveUp ? "ORDERNUM" : "ORDERNUM DESC");
        List list = this.findAll(query);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamSeriesPhase item = (ExamSeriesPhase)list.get(i);
            if (!phase.getPhaseId().equals(item.getPhaseId())) continue;
            if (i == 0) {
                return false;
            }
            ExamSeriesPhase item1 = new ExamSeriesPhase(((ExamSeriesPhase)list.get(i - 1)).getPhaseId());
            item1.setOrdernum(((ExamSeriesPhase)list.get(i)).getOrdernum());
            this.updateSelective(item1);
            ExamSeriesPhase item2 = new ExamSeriesPhase(((ExamSeriesPhase)list.get(i)).getPhaseId());
            item2.setOrdernum(((ExamSeriesPhase)list.get(i - 1)).getOrdernum());
            this.updateSelective(item2);
            return true;
        }
        return false;
    }

    private int getNextOrdernum(Long seriesId) {
        int ordernum = 1;
        ExamSeriesPhaseQuery query = new ExamSeriesPhaseQuery(1, 1);
        query.setSeriesId(seriesId);
        query.getPage().setSortColumns("ORDERNUM DESC");
        ExamSeriesPhase lastPhase = (ExamSeriesPhase)this.getPrdEntityDao().findOne((IQuery)query);
        if (lastPhase != null && lastPhase.getOrdernum() != null) {
            ordernum = lastPhase.getOrdernum() + 1;
        }
        return ordernum;
    }

    private boolean correctOrderNum(List<ExamSeriesPhase> list) {
        int i;
        if (list == null || list.isEmpty()) {
            return false;
        }
        HashSet<Integer> orderNumSet = new HashSet<Integer>();
        for (i = 0; i < list.size(); ++i) {
            Integer orderNum = list.get(i).getOrdernum();
            if (orderNum == null) continue;
            orderNumSet.add(orderNum);
        }
        if (orderNumSet.size() == list.size()) {
            return false;
        }
        for (i = 0; i < list.size(); ++i) {
            ExamSeriesPhase model = new ExamSeriesPhase(list.get(i).getPhaseId());
            model.setOrdernum(i + 1);
            this.updateSelective(model);
        }
        return true;
    }
}

