/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examseries.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.mng.exam.examseries.bo.ExamSeriesPhasecontentBO;
import com.peak.mng.exam.examseries.bo.ExamSeriesPhasecontentQueryBO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeMngVO;
import com.peak.prd.exam.examseries.dao.IExamSeriesPhasecontentPlusDao;
import com.peak.prd.exam.examseries.model.ExamSeriesPhasecontent;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasecontentPlusService;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentMiniVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentMngVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamSeriesPhasecontentPlusService
extends PrdBaseService<ExamSeriesPhasecontent, Long, ExamSeriesPhasecontentQuery>
implements IExamSeriesPhasecontentPlusService {
    @Autowired
    private IExamArrangePlusService examArrangePlusService;
    private IExamSeriesPhasecontentPlusDao examSeriesPhasecontentPlusDao;

    public void setExamSeriesPhasecontentPlusDao(IExamSeriesPhasecontentPlusDao dao) {
        this.examSeriesPhasecontentPlusDao = dao;
    }

    public IExamSeriesPhasecontentPlusDao getExamSeriesPhasecontentPlusDao() {
        return this.examSeriesPhasecontentPlusDao;
    }

    public IEntityDao<ExamSeriesPhasecontent, Long, ExamSeriesPhasecontentQuery> getEntityDao() {
        return this.examSeriesPhasecontentPlusDao;
    }

    @Override
    public List<ExamSeriesPhasecontentMngVO> findMngVOList(ExamSeriesPhasecontentQueryBO queryBO) {
        if (queryBO.getPhaseId() == null) {
            return null;
        }
        ExamSeriesPhasecontentQuery examSeriesPhasecontentQuery = (ExamSeriesPhasecontentQuery)ConvertUtil.convert((Object)queryBO, ExamSeriesPhasecontentQuery.class);
        examSeriesPhasecontentQuery.setDeleted(0);
        examSeriesPhasecontentQuery.getPage().setSortColumns("ordernum, createdate");
        List models = this.examSeriesPhasecontentPlusDao.findAll(examSeriesPhasecontentQuery);
        if (this.correctOrderNum(models)) {
            models = this.examSeriesPhasecontentPlusDao.findAll(examSeriesPhasecontentQuery);
        }
        List arrangeIds = IdUtil.getIds((List)models, e -> e.getContentId());
        List<ExamArrangeMngVO> arrangeMngVOs = this.examArrangePlusService.findMngVOs(arrangeIds);
        List vos = ConvertUtil.convert((List)models, ExamSeriesPhasecontentMngVO.class);
        block0: for (int i = 0; vos != null && i < vos.size(); ++i) {
            Long contentId = ((ExamSeriesPhasecontentMngVO)vos.get(i)).getContentId();
            for (int j = 0; contentId != null && arrangeMngVOs != null && j < arrangeMngVOs.size(); ++j) {
                if (!contentId.equals(arrangeMngVOs.get(j).getArrangeId())) continue;
                ConvertUtil.copyProperties((Object)arrangeMngVOs.get(j), vos.get(i));
                continue block0;
            }
        }
        return vos;
    }

    @Override
    public ExamSeriesPhasecontent txInsert(ExamSeriesPhasecontentBO bo, Long currUserId, Long domainId) {
        Long arrangeId = this.examArrangePlusService.insert(currUserId, domainId, bo);
        ExamSeriesPhasecontent model = (ExamSeriesPhasecontent)ConvertUtil.convert((Object)bo, ExamSeriesPhasecontent.class);
        model.setId(IdUtil.getSequence((String)"EXAM_SERIES_PHASECONTENT"));
        model.setContentId(arrangeId);
        model.setDeleted(0);
        model.setCreateId(currUserId);
        model.setCreatedate(new Date());
        model.setOrdernum(this.getNextOrdernum(bo.getPhaseId()));
        this.examSeriesPhasecontentPlusDao.insert((BaseEntity)model);
        return model;
    }

    @Override
    public void txUpdate(ExamSeriesPhasecontentBO bo, Long currUserId, Long domainId) {
        this.examArrangePlusService.update(currUserId, domainId, bo);
    }

    @Override
    public void delete(Long id, Long currUserId) {
        ExamSeriesPhasecontent model = new ExamSeriesPhasecontent();
        model.setId(id);
        model.setDeleted(1);
        model.setDeleteId(currUserId);
        model.setDeletedate(new Date());
        this.examSeriesPhasecontentPlusDao.updateSelective(model);
    }

    @Override
    public List<ExamSeriesPhasecontentMiniVO> getPhasecontentMiniVOs(Long phaseId) {
        if (phaseId == null) {
            return null;
        }
        return this.getPhasecontentMiniVOs(Arrays.asList(phaseId));
    }

    @Override
    public List<ExamSeriesPhasecontentMiniVO> getPhasecontentMiniVOs(List<Long> phaseIds) {
        if (CollectionUtils.isEmpty(phaseIds)) {
            return null;
        }
        ExamSeriesPhasecontentQuery examSeriesPhasecontentQuery = new ExamSeriesPhasecontentQuery();
        examSeriesPhasecontentQuery.setPhaseIds(phaseIds);
        examSeriesPhasecontentQuery.setDeleted(0);
        examSeriesPhasecontentQuery.getPage().setSortColumns("phaseid, ordernum, createdate");
        List contentModels = this.examSeriesPhasecontentPlusDao.findAll(examSeriesPhasecontentQuery);
        if (CollectionUtils.isEmpty((Collection)contentModels)) {
            return null;
        }
        List arrangeIds = IdUtil.getIds((List)contentModels, e -> e.getContentId());
        List arranges = this.examArrangePlusService.getByIds(arrangeIds);
        List vos = ConvertUtil.convert((List)contentModels, ExamSeriesPhasecontentMiniVO.class);
        for (int i = 0; vos != null && i < vos.size(); ++i) {
            ExamArrange arrange = null;
            for (int j = 0; arranges != null && j < arranges.size(); ++j) {
                arrange = (ExamArrange)arranges.get(j);
                if (!arrange.getArrangeId().equals(((ExamSeriesPhasecontentMiniVO)vos.get(i)).getContentId())) continue;
                ((ExamSeriesPhasecontentMiniVO)vos.get(i)).setTitle(arrange.getTitle());
            }
        }
        return vos;
    }

    @Override
    public boolean moveUpDown(ExamSeriesPhasecontent phasecontent, boolean isMoveUp) {
        if (phasecontent == null || phasecontent.getPhaseId() == null) {
            return false;
        }
        ExamSeriesPhasecontentQuery query = new ExamSeriesPhasecontentQuery();
        query.setPhaseId(phasecontent.getPhaseId());
        query.getPage().setSortColumns(isMoveUp ? "ORDERNUM" : "ORDERNUM DESC");
        List list = this.findAll(query);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ExamSeriesPhasecontent item = (ExamSeriesPhasecontent)list.get(i);
            if (!phasecontent.getId().equals(item.getId())) continue;
            if (i == 0) {
                return false;
            }
            ExamSeriesPhasecontent item1 = new ExamSeriesPhasecontent(((ExamSeriesPhasecontent)list.get(i - 1)).getId());
            item1.setOrdernum(((ExamSeriesPhasecontent)list.get(i)).getOrdernum());
            this.updateSelective(item1);
            ExamSeriesPhasecontent item2 = new ExamSeriesPhasecontent(((ExamSeriesPhasecontent)list.get(i)).getId());
            item2.setOrdernum(((ExamSeriesPhasecontent)list.get(i - 1)).getOrdernum());
            this.updateSelective(item2);
            return true;
        }
        return false;
    }

    private int getNextOrdernum(Long phaseId) {
        int ordernum = 1;
        ExamSeriesPhasecontentQuery query = new ExamSeriesPhasecontentQuery(1, 1);
        query.setPhaseId(phaseId);
        query.getPage().setSortColumns("ORDERNUM DESC");
        ExamSeriesPhasecontent lastPhasecontent = (ExamSeriesPhasecontent)this.getPrdEntityDao().findOne((IQuery)query);
        if (lastPhasecontent != null && lastPhasecontent.getOrdernum() != null) {
            ordernum = lastPhasecontent.getOrdernum() + 1;
        }
        return ordernum;
    }

    private boolean correctOrderNum(List<ExamSeriesPhasecontent> list) {
        int i;
        if (list == null || list.isEmpty()) {
            return false;
        }
        HashSet<Integer> orderNumSet = new HashSet<Integer>();
        for (i = 0; i < list.size(); ++i) {
            Integer orderNum = list.get(i).getOrdernum();
            if (orderNum == null) continue;
            orderNumSet.add(orderNum);
        }
        if (orderNumSet.size() == list.size()) {
            return false;
        }
        for (i = 0; i < list.size(); ++i) {
            ExamSeriesPhasecontent model = new ExamSeriesPhasecontent(list.get(i).getId());
            model.setOrdernum(i + 1);
            this.updateSelective(model);
        }
        return true;
    }
}

