/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examseries.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examseries.bo.ExamSeriesPhasecontentQueryBO;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.enums.ExamSeriesTypeEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasePlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPhasecontentPlusService;
import com.peak.prd.exam.examseries.service.IExamSeriesPlusService;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseMngVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentMngVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesStuVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@CacheConfig(cacheNames={"exam"})
public class ExamSeriesPlusService
extends PrdBaseService
implements IExamSeriesPlusService {
    @Autowired
    private IExamArrangePlusService examArrangePlusService;

    public IEntityDao getEntityDao() {
        return null;
    }

    @Override
    @Cacheable
    public ExamSeriesStuVO getExamSeriesStuVO(Long seriesId) {
        if (seriesId == null) {
            return null;
        }
        ExamArrange examArrange = (ExamArrange)this.examArrangePlusService.getById(seriesId);
        return (ExamSeriesStuVO)ConvertUtil.convert((Object)examArrange, ExamSeriesStuVO.class);
    }

    @Override
    public List<Long> getAllPhaseContentIds(Long seriesId) {
        ExamArrange examArrange = (ExamArrange)this.examArrangePlusService.getById(seriesId);
        if (examArrange == null || examArrange.getExamseriestype() == null || examArrange.getExamseriestype().intValue() != ExamSeriesTypeEnum.TYPE_SERIES.getValue()) {
            return null;
        }
        IExamSeriesPhasePlusService examSeriesPhasePlusService = (IExamSeriesPhasePlusService)SpringUtil.getBean(IExamSeriesPhasePlusService.class);
        IExamSeriesPhasecontentPlusService examSeriesPhasecontentPlusService = (IExamSeriesPhasecontentPlusService)SpringUtil.getBean(IExamSeriesPhasecontentPlusService.class);
        ArrayList<Long> allContentIds = new ArrayList<Long>();
        List<ExamSeriesPhaseMngVO> phases = examSeriesPhasePlusService.findMngVOList(examArrange.getArrangeId());
        for (int i = 0; phases != null && i < phases.size(); ++i) {
            ExamSeriesPhasecontentQueryBO examSeriesPhasecontentQueryBO = new ExamSeriesPhasecontentQueryBO();
            examSeriesPhasecontentQueryBO.setPhaseId(phases.get(i).getPhaseId());
            List<ExamSeriesPhasecontentMngVO> contents = examSeriesPhasecontentPlusService.findMngVOList(examSeriesPhasecontentQueryBO);
            if (CollectionUtils.isEmpty(contents)) continue;
            allContentIds.addAll(IdUtil.getIds(contents, c -> c.getContentId()));
        }
        return allContentIds;
    }
}

