/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examseries.vo;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhaseStuVO;
import com.peak.prd.exam.examseries.vo.ExamSeriesPhasecontentByUserVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.CollectionUtils;

@ApiModel(value="\u7cfb\u5217\u8003\u8bd5\uff08\u591a\u573a\u6b21\uff09\u8003\u8bd5-\u9636\u6bb5VO-\u4f9bStu\u7528")
public class ExamSeriesPhaseByUserVO
implements Serializable {
    @ApiModelProperty(value="\u9636\u6bb5id")
    private Long phaseId;
    @ApiModelProperty(value="\u9636\u6bb5\u540d\u79f0")
    private String phasename;
    @ApiModelProperty(value="\u6240\u5c5e\u7cfb\u5217\u8003\u8bd5id")
    private Long seriesId;
    @ApiModelProperty(value="\u8981\u6c42\u987a\u5e8f\u53c2\u52a0\u8003\u8bd5")
    private Integer isorder;
    @ApiModelProperty(value="\u8981\u6c42\u901a\u8fc7\u6570\u91cf")
    private Integer passnum;
    @ApiModelProperty(value="\u9636\u6bb5\u4e0b\u7684\u5b50\u8003\u8bd5s")
    private List<ExamSeriesPhasecontentByUserVO> contents;

    public ExamSeriesPhaseByUserVO() {
    }

    public ExamSeriesPhaseByUserVO(ExamSeriesPhaseStuVO stuVO) {
        this.phaseId = stuVO.getPhaseId();
        this.phasename = stuVO.getPhasename();
        this.seriesId = stuVO.getSeriesId();
        this.isorder = stuVO.getIsorder();
        this.passnum = stuVO.getPassnum();
        if (!CollectionUtils.isEmpty(stuVO.getContents())) {
            this.contents = ConvertUtil.convert(stuVO.getContents(), ExamSeriesPhasecontentByUserVO.class);
        }
    }

    public boolean isPassed() {
        if (this.passnum == null) {
            return false;
        }
        if (this.passnum < 0) {
            return this.isAllContentsCompleted();
        }
        return this.getContentsCompletedNum() >= this.passnum;
    }

    public boolean isAllContentsCompleted() {
        if (this.contents == null || this.contents.isEmpty()) {
            return false;
        }
        int num = this.getContentsCompletedNum();
        return num == this.contents.size();
    }

    public int getContentsCompletedNum() {
        int num = 0;
        for (int i = 0; this.contents != null && i < this.contents.size(); ++i) {
            if (!this.contents.get(i).getCompletedBool()) continue;
            ++num;
        }
        return num;
    }

    public static List<Long> getAllContentIds(List<ExamSeriesPhaseByUserVO> vos) {
        if (vos == null || vos.isEmpty()) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < vos.size(); ++i) {
            List<ExamSeriesPhasecontentByUserVO> contents = vos.get(i).getContents();
            if (contents == null || contents.isEmpty()) continue;
            ids.addAll(IdUtil.getIds(contents, c -> c.getContentId()));
        }
        return ids;
    }

    public boolean getIsorderBool() {
        return this.isorder != null && this.isorder == 1;
    }

    public Long getPhaseId() {
        return this.phaseId;
    }

    public String getPhasename() {
        return this.phasename;
    }

    public Long getSeriesId() {
        return this.seriesId;
    }

    public Integer getIsorder() {
        return this.isorder;
    }

    public Integer getPassnum() {
        return this.passnum;
    }

    public List<ExamSeriesPhasecontentByUserVO> getContents() {
        return this.contents;
    }

    public void setPhaseId(Long phaseId) {
        this.phaseId = phaseId;
    }

    public void setPhasename(String phasename) {
        this.phasename = phasename;
    }

    public void setSeriesId(Long seriesId) {
        this.seriesId = seriesId;
    }

    public void setIsorder(Integer isorder) {
        this.isorder = isorder;
    }

    public void setPassnum(Integer passnum) {
        this.passnum = passnum;
    }

    public void setContents(List<ExamSeriesPhasecontentByUserVO> contents) {
        this.contents = contents;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExamSeriesPhaseByUserVO)) {
            return false;
        }
        ExamSeriesPhaseByUserVO other = (ExamSeriesPhaseByUserVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$phaseId = this.getPhaseId();
        Long other$phaseId = other.getPhaseId();
        if (this$phaseId == null ? other$phaseId != null : !((Object)this$phaseId).equals(other$phaseId)) {
            return false;
        }
        Long this$seriesId = this.getSeriesId();
        Long other$seriesId = other.getSeriesId();
        if (this$seriesId == null ? other$seriesId != null : !((Object)this$seriesId).equals(other$seriesId)) {
            return false;
        }
        Integer this$isorder = this.getIsorder();
        Integer other$isorder = other.getIsorder();
        if (this$isorder == null ? other$isorder != null : !((Object)this$isorder).equals(other$isorder)) {
            return false;
        }
        Integer this$passnum = this.getPassnum();
        Integer other$passnum = other.getPassnum();
        if (this$passnum == null ? other$passnum != null : !((Object)this$passnum).equals(other$passnum)) {
            return false;
        }
        String this$phasename = this.getPhasename();
        String other$phasename = other.getPhasename();
        if (this$phasename == null ? other$phasename != null : !this$phasename.equals(other$phasename)) {
            return false;
        }
        List<ExamSeriesPhasecontentByUserVO> this$contents = this.getContents();
        List<ExamSeriesPhasecontentByUserVO> other$contents = other.getContents();
        return !(this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExamSeriesPhaseByUserVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $phaseId = this.getPhaseId();
        result = result * 59 + ($phaseId == null ? 43 : ((Object)$phaseId).hashCode());
        Long $seriesId = this.getSeriesId();
        result = result * 59 + ($seriesId == null ? 43 : ((Object)$seriesId).hashCode());
        Integer $isorder = this.getIsorder();
        result = result * 59 + ($isorder == null ? 43 : ((Object)$isorder).hashCode());
        Integer $passnum = this.getPassnum();
        result = result * 59 + ($passnum == null ? 43 : ((Object)$passnum).hashCode());
        String $phasename = this.getPhasename();
        result = result * 59 + ($phasename == null ? 43 : $phasename.hashCode());
        List<ExamSeriesPhasecontentByUserVO> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        return result;
    }

    public String toString() {
        return "ExamSeriesPhaseByUserVO(phaseId=" + this.getPhaseId() + ", phasename=" + this.getPhasename() + ", seriesId=" + this.getSeriesId() + ", isorder=" + this.getIsorder() + ", passnum=" + this.getPassnum() + ", contents=" + this.getContents() + ")";
    }
}

