/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examtag.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.exam.examtag.dao.IExamQuestionTagPlusDao;
import com.peak.prd.exam.examtag.model.ExamQuestionTag;
import com.peak.prd.exam.examtag.service.IExamQuestionTagPlusService;
import com.peak.prd.exam.examtag.service.IExamTagTagPlusService;
import com.peak.prd.exam.examtag.vo.ExamQuestionTagQuery;
import com.peak.prd.exam.examtag.vo.ExamTagVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamQuestionTagPlusService
extends PrdBaseService<ExamQuestionTag, Long, ExamQuestionTagQuery>
implements IExamQuestionTagPlusService {
    private IExamQuestionTagPlusDao examQuestionTagPlusDao;
    @Autowired
    private IExamTagTagPlusService examTagTagPlusService;

    public void setExamQuestionTagPlusDao(IExamQuestionTagPlusDao dao) {
        this.examQuestionTagPlusDao = dao;
    }

    public IExamQuestionTagPlusDao getExamQuestionTagPlusDao() {
        return this.examQuestionTagPlusDao;
    }

    public IEntityDao<ExamQuestionTag, Long, ExamQuestionTagQuery> getEntityDao() {
        return this.examQuestionTagPlusDao;
    }

    @Override
    public void update(Long questionId, List<Long> tagIds) {
        this.examQuestionTagPlusDao.deleteByQuestionId(questionId);
        Date now = new Date();
        ArrayList<ExamQuestionTag> list = new ArrayList<ExamQuestionTag>();
        for (int i = 0; tagIds != null && i < tagIds.size(); ++i) {
            ExamQuestionTag item = new ExamQuestionTag();
            item.setQuestagId(IdUtil.getSequence((String)"EXAM_QUESTION_TAG"));
            item.setQuestionId(questionId);
            item.setTagId(tagIds.get(i));
            item.setCreatedate(now);
            list.add(item);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.insertBatch(list);
        }
    }

    @Override
    public void deleteByQuestionId(Long questionId) {
        this.examQuestionTagPlusDao.deleteByQuestionId(questionId);
    }

    @Override
    public List<ExamTagVO> getTags(Long questionId) {
        if (questionId == null) {
            return null;
        }
        ExamQuestionTagQuery query = new ExamQuestionTagQuery();
        query.setQuestionId(questionId);
        query.getPage().setSortColumns("createdate");
        List examTagList = this.examQuestionTagPlusDao.findAll(query);
        List tagIds = IdUtil.getIds((List)examTagList, e -> e.getTagId());
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            return null;
        }
        List tagTags = this.examTagTagPlusService.getByIds(tagIds);
        List vos = ConvertUtil.convert((List)tagTags, ExamTagVO.class);
        return vos;
    }

    @Override
    public Map<Long, List<ExamTagVO>> getTags(List<Long> questionIds) {
        if (CollectionUtils.isEmpty(questionIds)) {
            return null;
        }
        ExamQuestionTagQuery query = new ExamQuestionTagQuery();
        query.setQuestionIds(questionIds);
        query.getPage().setSortColumns("createdate");
        List examTagList = this.examQuestionTagPlusDao.findAll(query);
        List tagIds = IdUtil.getIds((List)examTagList, e -> e.getTagId());
        if (CollectionUtils.isEmpty((Collection)tagIds)) {
            return null;
        }
        List tagTags = this.examTagTagPlusService.getByIds(tagIds);
        List tagVOs = ConvertUtil.convert((List)tagTags, ExamTagVO.class);
        HashMap mapTags = new HashMap();
        for (int i = 0; tagVOs != null && i < tagVOs.size(); ++i) {
            mapTags.put(((ExamTagVO)tagVOs.get(i)).getTagId(), tagVOs.get(i));
        }
        HashMap<Long, List<ExamTagVO>> map = new HashMap<Long, List<ExamTagVO>>();
        for (int i = 0; i < examTagList.size(); ++i) {
            ExamTagVO tmp;
            Long questionId = ((ExamQuestionTag)examTagList.get(i)).getQuestionId();
            Long tagId = ((ExamQuestionTag)examTagList.get(i)).getTagId();
            ArrayList<ExamTagVO> quesTagVOs = (ArrayList<ExamTagVO>)map.get(questionId);
            if (quesTagVOs == null) {
                quesTagVOs = new ArrayList<ExamTagVO>();
                map.put(questionId, quesTagVOs);
            }
            if ((tmp = (ExamTagVO)mapTags.get(tagId)) == null) continue;
            quesTagVOs.add(tmp);
        }
        return map;
    }
}

