/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examuser.dao.imple;

import com.peak.prd.base.dao.imple.PrdBaseDao;
import com.peak.prd.exam.enums.ExamUserTypeEnum;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.examuser.dao.IExamUserPlusDao;
import com.peak.prd.exam.examuser.model.ExamUser;
import com.peak.prd.exam.examuser.vo.ExamUserQuery;
import com.peak.prd.exam.examuser.vo.ExamUserVO;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ExamUserPlusDao
extends PrdBaseDao<ExamUser, Map<String, Object>, ExamUserQuery>
implements IExamUserPlusDao {
    @Override
    public int getCompleteNum(Long arrangeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        return (Integer)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getCompleteNum", map);
    }

    @Override
    public int getAttendNum(Long arrangeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        return (Integer)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getAttendNum", map);
    }

    @Override
    public int getIngNum(Long arrangeId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        return (Integer)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".getIngNum", map);
    }

    @Override
    public void deleteByArrangeId(Long arrangeId) {
        this.getSqlSessionTemplate().update(this.getNamespace() + ".deleteByArrangeId", (Object)arrangeId);
    }

    @Override
    public int deleteNormalArrangeUser(Long arrangeId, Long userId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("userId", userId);
        return this.getSqlSessionTemplate().update(this.getNamespace() + ".deleteNormalArrangeUser", map);
    }

    @Override
    public long findVOCount(ExamUserQuery examUserQuery) {
        return (Long)this.getSqlSessionTemplate().selectOne(this.getNamespace() + ".findVOCount", (Object)examUserQuery);
    }

    @Override
    public List<ExamUserVO> findVOList(ExamUserQuery examUserQuery) {
        int offset = (examUserQuery.getPage().getPageNumber() - 1) * examUserQuery.getPage().getPageSize() + 1;
        int limit = examUserQuery.getPage().getPageSize();
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".findVOList", (Object)examUserQuery, offset, limit);
    }

    @Override
    public List<ExamArrangeNumVO> groupArrangeUserNums(List<Long> arrangeIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("arrangeIds", arrangeIds);
        return this.getSqlSessionTemplate().selectList(this.getNamespace() + ".groupArrangeUserNums", map);
    }

    @Override
    public int insertByOrgAudience(Long arrangeId, Long orgId) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("arrangeId", arrangeId);
        map.put("audienceId", orgId);
        map.put("audienceType", Integer.valueOf(ExamUserTypeEnum.TYPE_AUDIENCE_ORG.getValue()));
        map.put("now", new Date());
        return this.getSqlSessionTemplate().insert(this.getNamespace() + ".insertByOrgAudience", map);
    }

    @Override
    public int insertByDomainAudience(Long arrangeId, Long domainId) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("arrangeId", arrangeId);
        map.put("audienceId", domainId);
        map.put("audienceType", Integer.valueOf(ExamUserTypeEnum.TYPE_AUDIENCE_DOMAIN.getValue()));
        map.put("now", new Date());
        return this.getSqlSessionTemplate().insert(this.getNamespace() + ".insertByDomainAudience", map);
    }

    @Override
    public int insertByEnrollAudience(Long arrangeId, Long enrollId) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("arrangeId", arrangeId);
        map.put("audienceId", enrollId);
        map.put("audienceType", Integer.valueOf(ExamUserTypeEnum.TYPE_AUDIENCE_ENROLL.getValue()));
        map.put("now", new Date());
        return this.getSqlSessionTemplate().insert(this.getNamespace() + ".insertByEnrollAudience", map);
    }

    @Override
    public int deleteByAudience(Long arrangeId, int audienceType, Long audienceId) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("arrangeId", arrangeId);
        map.put("audienceType", audienceType);
        map.put("audienceId", audienceId);
        return this.getSqlSessionTemplate().delete(this.getNamespace() + ".deleteByAudience", map);
    }

    @Override
    public List<ExamUser> getCanEnterButNotEnterOrNotPassList(ExamUserQuery examUserQuery) {
        return this.findList(examUserQuery, "getCanEnterButNotEnterOrNotPassList");
    }
}

