/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.examuser.service.imple;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.ConvertUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.mng.exam.examuser.bo.ExamUserQueryBO;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.config.PrdExamConfig;
import com.peak.prd.enroll.user.service.IEnrollUserPlusService;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.enums.EnrollEnum;
import com.peak.prd.exam.enums.ExamUserTypeEnum;
import com.peak.prd.exam.examarrange.model.ExamArrange;
import com.peak.prd.exam.examarrange.service.IExamArrangePlusService;
import com.peak.prd.exam.examarrange.vo.ExamArrangeNumVO;
import com.peak.prd.exam.examuser.dao.IExamUserPlusDao;
import com.peak.prd.exam.examuser.model.ExamUser;
import com.peak.prd.exam.examuser.service.IExamUserPlusService;
import com.peak.prd.exam.examuser.vo.ExamUserQuery;
import com.peak.prd.exam.examuser.vo.ExamUserSummaryVO;
import com.peak.prd.exam.examuser.vo.ExamUserVO;
import com.peak.prd.exam.util.ExamOrgUtil;
import com.peak.prd.messageq.util.MessageQHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExamUserPlusService
extends PrdBaseService<ExamUser, Map<String, Object>, ExamUserQuery>
implements IExamUserPlusService {
    private static final Logger log = LoggerFactory.getLogger(ExamUserPlusService.class);
    @Autowired
    private IEnrollUserPlusService enrollUserPlusService;
    @Autowired
    private PrdExamConfig prdExamConfig;
    private IExamUserPlusDao examUserPlusDao;

    public void setExamUserPlusDao(IExamUserPlusDao dao) {
        this.examUserPlusDao = dao;
    }

    public IExamUserPlusDao getExamUserPlusDao() {
        return this.examUserPlusDao;
    }

    public IEntityDao<ExamUser, Map<String, Object>, ExamUserQuery> getEntityDao() {
        return this.examUserPlusDao;
    }

    @Override
    public ExamUserSummaryVO getSummary(Long examId) {
        if (examId == null) {
            return null;
        }
        ExamUserSummaryVO summary = new ExamUserSummaryVO();
        ExamUserQuery query = new ExamUserQuery();
        query.setArrangeId(examId);
        summary.setTotalNum((int)this.count(query));
        summary.setCompleteNum(this.examUserPlusDao.getCompleteNum(examId));
        summary.setAttendNum(this.examUserPlusDao.getAttendNum(examId));
        summary.setIngNum(this.examUserPlusDao.getIngNum(examId));
        return summary;
    }

    @Override
    public Paging<ExamUserVO> findVOPaging(ExamUserQueryBO bo) {
        long totalCount = this.findVOCount(bo);
        List<ExamUserVO> vos = this.findVOList(bo);
        Paging paging = new Paging(bo.getPageNumber(), bo.getPageSize());
        paging.setTotalCount(totalCount);
        paging.setList(vos);
        return paging;
    }

    @Override
    public long findVOCount(ExamUserQueryBO bo) {
        ExamUserQuery query = new ExamUserQuery(bo.getPageNumber(), bo.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)bo), (Object)query);
        query.setPrj(this.prdExamConfig.getPrj());
        return this.examUserPlusDao.findVOCount(query);
    }

    @Override
    public List<ExamUserVO> findVOList(ExamUserQueryBO bo) {
        ExamUserQuery query = new ExamUserQuery(bo.getPageNumber(), bo.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)bo), (Object)query);
        query.setPrj(this.prdExamConfig.getPrj());
        query.getPage().setSortColumns("eu.createdate desc");
        query.getPage().setTotalCount(Integer.MAX_VALUE);
        List<ExamUserVO> vos = this.examUserPlusDao.findVOList(query);
        UserCoreUtil.setUserProperties(vos, ExamUserVO::getUserId, (BiConsumer[])new BiConsumer[]{(vo, u) -> vo.setUsercode(u.getUsercode()), (vo, u) -> vo.setRealname(u.getName())});
        UserCoreUtil.setUserDeptId(vos, ExamUserVO::getUserId, ExamUserVO::setOrgId);
        ExamOrgUtil.setOrgFullname(vos, ExamUserVO::getOrgId, ExamUserVO::setOrgFullname);
        ExamOrgUtil.setOrgFullnameByTrimPrefix(vos, ExamUserVO::getOrgId, ExamUserVO::setOrgFullnameByTrimPrefix);
        return vos;
    }

    @Override
    public void deleteByArrangeId(Long arrangeId) {
        this.examUserPlusDao.deleteByArrangeId(arrangeId);
    }

    @Override
    public int deleteNormalArrangeUser(Long arrangeId, Long userId) {
        int affectNum = this.examUserPlusDao.deleteNormalArrangeUser(arrangeId, userId);
        if (affectNum > 0) {
            this.innerSendMq(arrangeId, userId, "deleteexamuser");
        }
        return affectNum;
    }

    @Override
    public int insertExamUser(Long arrangeId, Long userId, ExamUserTypeEnum examUserType) {
        ExamUser eu = new ExamUser(arrangeId, userId);
        eu.setUsertype(examUserType.getValue());
        eu.setCreatedate(new Date());
        int affectNum = this.examUserPlusDao.insert((BaseEntity)eu);
        if (affectNum > 0) {
            this.innerSendMq(arrangeId, userId, "insertexamuser");
        }
        return affectNum;
    }

    @Override
    public int insertBatchExamUser(List<ExamUser> examUsers) {
        if (ListUtil.isNullorEmpty(examUsers)) {
            return 0;
        }
        int affectNum = this.examUserPlusDao.insertBatch(examUsers);
        if (affectNum > 0) {
            for (int i = 0; i < examUsers.size(); ++i) {
                Long arrangeId = examUsers.get(i).getArrangeId();
                Long userId = examUsers.get(i).getUserId();
                this.innerSendMq(arrangeId, userId, "insertexamuser");
            }
        }
        return affectNum;
    }

    @Override
    public boolean isExisted(Long arrangeId, Long userId) {
        if (arrangeId == null || userId == null) {
            return false;
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("arrangeId", arrangeId);
        map.put("userId", userId);
        return this.getById(map) != null;
    }

    @Override
    public List<ExamArrangeNumVO> groupArrangeUserNums(List<Long> arrangeIds) {
        if (CollectionUtils.isEmpty(arrangeIds)) {
            return null;
        }
        return this.examUserPlusDao.groupArrangeUserNums(arrangeIds);
    }

    @Override
    public List<ExamUser> getListByArrangeId(Long arrangeId, int pageNumber, int pageSize) {
        if (arrangeId == null) {
            return null;
        }
        ExamUserQuery examUserQuery = new ExamUserQuery(pageNumber, pageSize);
        examUserQuery.setArrangeId(arrangeId);
        List examUserList = this.examUserPlusDao.findList(examUserQuery);
        if (examUserList == null || examUserList.isEmpty()) {
            return null;
        }
        return examUserList;
    }

    @Override
    public List<Long> getAttendedDistinctUserListByArrangeIds(List<Long> arrangeIds, int pageNumber, int pageSize) {
        if (ListUtil.isNullorEmpty(arrangeIds)) {
            return null;
        }
        ExamUserQuery examUserQuery = new ExamUserQuery(pageNumber, pageSize);
        examUserQuery.setArrangeIds(arrangeIds);
        examUserQuery.getPage().setSortColumns("userId");
        List examUserList = this.examUserPlusDao.findList(examUserQuery, "getAttendedDistinctUserListByArrangeIds", Long.class);
        if (examUserList == null || examUserList.isEmpty()) {
            return null;
        }
        return examUserList;
    }

    @Override
    public long getAttendedDistinctUserCountByArrangeIds(List<Long> arrangeIds) {
        if (ListUtil.isNullorEmpty(arrangeIds)) {
            return 0L;
        }
        ExamUserQuery examUserQuery = new ExamUserQuery();
        examUserQuery.setArrangeIds(arrangeIds);
        return (Long)this.examUserPlusDao.selectOne(examUserQuery, "getAttendedDistinctUserCountByArrangeIds");
    }

    @Override
    public int insertByOrgAudience(Long arrangeId, Long orgId) {
        return this.examUserPlusDao.insertByOrgAudience(arrangeId, orgId);
    }

    @Override
    public int insertByDomainAudience(Long arrangeId, Long domainId) {
        return this.examUserPlusDao.insertByDomainAudience(arrangeId, domainId);
    }

    @Override
    public int insertByEnrollAudience(Long arrangeId, Long enrollId) {
        return this.examUserPlusDao.insertByEnrollAudience(arrangeId, enrollId);
    }

    @Override
    public int deleteByAudience(Long exerciseId, int audienceType, Long audienceId) {
        return this.examUserPlusDao.deleteByAudience(exerciseId, audienceType, audienceId);
    }

    @Override
    public Integer txEnroll(Long arrangeId, Long userId) {
        Integer status = this.enrollUserPlusService.insert(userId, arrangeId, Integer.valueOf(BusinessOrigin.EXAM.getIndex()));
        if (status != null && status.intValue() == EnrollEnum.USER_AUDIT_STATUS_ENROLLSUCCESS.getValue() && !this.isExisted(arrangeId, userId)) {
            this.insertExamUser(arrangeId, userId, ExamUserTypeEnum.TYPE_ENROLL_PERSONAL);
            log.info("\u8003\u751f\u76f4\u63a5\u62a5\u540d\u6210\u529f[examId:{}, userId:{}]", (Object)arrangeId, (Object)userId);
        }
        return status;
    }

    @Override
    public List<ExamUser> getCanEnterButNotEnterOrNotPassList(ExamUserQuery examUserQuery) {
        if (examUserQuery == null || examUserQuery.getArrangeId() == null) {
            return null;
        }
        IExamArrangePlusService examArrangePlusService = (IExamArrangePlusService)SpringUtil.getBean(IExamArrangePlusService.class);
        ExamArrange exam = (ExamArrange)examArrangePlusService.getById(examUserQuery.getArrangeId());
        if (exam == null) {
            return null;
        }
        examUserQuery.setPassmark(exam.getPassmark());
        examUserQuery.setAllowExamCount(this.getAllowExamCount(exam.getAttendtimes()));
        return this.examUserPlusDao.getCanEnterButNotEnterOrNotPassList(examUserQuery);
    }

    private int getAllowExamCount(Integer allowExamCount) {
        return allowExamCount == null || allowExamCount <= 0 ? 99999 : allowExamCount;
    }

    private void innerSendMq(Long arrangeId, Long userId, String action) {
        if (arrangeId == null || userId == null) {
            return;
        }
        JSONObject msgData = new JSONObject();
        msgData.put("examId", (Object)arrangeId);
        msgData.put("userId", (Object)userId);
        try {
            log.info("topic:exam, action:" + action + ", data:" + msgData.toString());
            MessageQHelper.send((String)"exam", (Long)arrangeId, (String)action, (Object)msgData);
        }
        catch (Exception e) {
            log.error("exam user send messageQ error[examId:" + arrangeId + "][userId:" + userId + "]", (Throwable)e);
        }
    }
}

