/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.exam.file.controller;

import com.peak.prd.base.model.ApiResult;
import com.peak.prd.exam.common.service.IExamFilesPlusService;
import com.peak.prd.exam.file.util.QuesFileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8bd5\u9898\u9644\u4ef6(\u56fe\u7247/\u6587\u6863\u7b49)"})
@RestController
@RequestMapping(value={"/exam/file"}, produces={"application/json;charset=UTF-8"})
public class QuesFileController {
    private static final Logger log = LoggerFactory.getLogger(QuesFileController.class);
    @Autowired
    private IExamFilesPlusService examFilesPlusService;

    @ApiOperation(value="\u8bd5\u9898\u9644\u4ef6")
    @RequestMapping(value={"/quesfile/{fileInfo}"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getFile(@PathVariable(required=true) String fileInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int pos = fileInfo.indexOf("_");
        if (pos <= 0) {
            log.error("quesfile not found[" + fileInfo + "]");
            return;
        }
        String fileId = fileInfo.substring(0, pos);
        String fileGkey = fileInfo.substring(pos + 1);
        QuesFileUtil.getFile(new Long(fileId), fileGkey, request, response);
    }

    @ApiOperation(value="\u8bd5\u9898\u9644\u4ef6OSS\u5168\u8def\u5f84")
    @RequestMapping(value={"/quesfileoss/{fileInfo}"}, method={RequestMethod.GET, RequestMethod.POST})
    public ApiResult<String> getFileOssPath(@PathVariable(required=true) String fileInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int pos = fileInfo.indexOf("_");
        if (pos <= 0) {
            log.error("quesfile not found[" + fileInfo + "]");
            return ApiResult.errMsg((String)("quesfile not found[" + fileInfo + "]"));
        }
        String fileId = fileInfo.substring(0, pos);
        String fileGkey = fileInfo.substring(pos + 1);
        String fileOssPath = QuesFileUtil.getFileOssPath(new Long(fileId), fileGkey);
        if (log.isDebugEnabled()) {
            log.debug("fileOssPath:{}, by {}", (Object)fileOssPath, (Object)fileInfo);
        }
        return ApiResult.okData((Object)fileOssPath);
    }
}

